/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SetPropagationRequestID
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$SetPropagationRequestID == null ? (class$com$tssap$dtr$client$commandline$SetPropagationRequestID = SetPropagationRequestID.class$("com.tssap.dtr.client.commandline.SetPropagationRequestID")) : class$com$tssap$dtr$client$commandline$SetPropagationRequestID));
    private String _propagationListName;
    private String _propRequestID;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$SetPropagationRequestID;

    public SetPropagationRequestID(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.PROPAGATION_LIST);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Sets the propagation request id for the given propagation list";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            String resourceID = this.getResourceID();
            IPropagatable propagatable = this._propManager.getPropagatable(resourceID);
            propagatable.setPropagationRequestId(this._propRequestID);
            this.writeMessage("Set propagation request id to \"" + this._propRequestID + "\"");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException occurred while setting propagation ID.");
            this.writeMessage("Could not set propagation ID to " + this._propRequestID + ". " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException occurred while setting propagation ID.");
            this.writeMessage("Could not set propagation ID to " + this._propRequestID + ". " + ex.getMessage());
        }
        return false;
    }

    public boolean validateArguments() {
        boolean isValidArguments = true;
        if (this._resourcePath == null) {
            this.writeMessage("Must specify url.");
            isValidArguments = false;
        }
        if (this._propRequestID == null) {
            this.writeMessage("Must specify propagation request id.");
            isValidArguments = false;
        }
        if (!isValidArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidArguments;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        String proplistShortOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, true);
        String proplistLongOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, false);
        String propValueLong = NameConfig.getOption(OptionName.PROP_VALUE, false);
        String propValueShort = NameConfig.getOption(OptionName.PROP_VALUE, true);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (proplistShortOptName.compareToIgnoreCase(currentArg) == 0 || proplistLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._propagationListName = (String)listIterator.next();
                listIterator.remove();
                continue;
            }
            if (propValueLong.compareToIgnoreCase(currentArg) != 0 && propValueShort.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._propRequestID = (String)listIterator.next();
            listIterator.remove();
        }
        super.setArguments(arguments);
    }

    public CommandName getCommandName() {
        return CommandName.SETPROPREQID;
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.SETPROPREQID, false) + " url " + NameConfig.getOption(OptionName.PROP_VALUE, true) + " \"propagation request id\" ");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "sets the propagation request id for the given activity, propagationlist, or workspace. The propagation request id can only be set once.", false);
        this.writeMessage("");
        this.printOptionHelp(null, 1, "URL is the absolute remote path of the resource whose propagation request id needs to be set.", false);
        this.printOptionHelp(null, 1, " Ex: In order to set the propagation request id of an activity named 'testActivity', the url  specified should be '/act/testActivity' ", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.PROP_VALUE, 1, "The propagation request id that needs to be set.", true);
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new SetPropagationRequestID(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

