/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.LoginParamsInput;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ProppatchRequest;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.util.ArrayList;

class SetPasswordCommand
extends ResourceCommand {
    private String _userName;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$SetPasswordCommand == null ? (class$com$tssap$dtr$client$commandline$SetPasswordCommand = SetPasswordCommand.class$("com.tssap.dtr.client.commandline.SetPasswordCommand")) : class$com$tssap$dtr$client$commandline$SetPasswordCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$SetPasswordCommand;

    public SetPasswordCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.USER);
        this._userName = "";
        this.setArguments(arguments);
    }

    public CommandName getCommandName() {
        return CommandName.SETP;
    }

    public String getDescription() {
        return "Set the password for the user on the server and locally";
    }

    public boolean execute() {
        String userName;
        String[] userNameAndPwds = new String[3];
        if (this.getFileSystemManager() == null) {
            this._exitCode = 3;
            return false;
        }
        int connTmplID = -1;
        try {
            IVfsRemoteLocator locator = this.getFileSystemManager().getCurrentContext().getRemoteLocatorFromUrl(this.getFileSystemManager().getRootFolder().getUrl());
            if (locator != null) {
                connTmplID = locator.getConnectionTemplateId();
            }
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting connection template id.");
            Command.getOut().println("Getting connection template ID failed. " + e.getMessage());
            this._exitCode = 4;
            return false;
        }
        if (this._userName.equals("")) {
            IConnectionTemplate template;
            try {
                template = Command.getConnectionTemplate(connTmplID);
            }
            catch (InvalidTemplateIDException invalidTemplateID) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)invalidTemplateID), "InvalidTemplateIDException occurred while getting connection template for id " + connTmplID);
                this._exitCode = 4;
                Command.getOut().println(invalidTemplateID.getMessage());
                return false;
            }
            userName = template.getSessionContext().getUser();
        } else {
            userName = this._userName;
        }
        try {
            userNameAndPwds = new LoginParamsInput().getInput("Change Password", userName, true, false);
        }
        catch (IOException e) {
            Logger.traceSystemError(LOCATION, e, "IOException occurred while getting password.");
            Command.getOut().println("Could not get password. " + e.getMessage());
            this._exitCode = 96;
            return false;
        }
        String password = userNameAndPwds[1];
        if (!password.equals(userNameAndPwds[2])) {
            Command.getOut().println("The two passwords typed by you are not the same.");
            this._exitCode = 97;
            return false;
        }
        try {
            this._exitCode = 0;
            if (this._userName.equals("")) {
                this.setUserPassword(connTmplID, password);
            } else {
                this.setPasswordOnServer(connTmplID, password, this._userName);
            }
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while changing password.");
            Command.getOut().println(e.getMessage());
        }
        return true;
    }

    private void setUserPassword(int connectionTemplateId, String password) throws VfsException {
        IConnectionTemplate template;
        try {
            template = Command.getConnectionTemplate(connectionTemplateId);
        }
        catch (InvalidTemplateIDException invalidTemplateID) {
            LogUtil.logException((Location)LOCATION, (Throwable)invalidTemplateID);
            this._exitCode = 4;
            throw new VfsException("Invalid connection template ID");
        }
        String userName = template.getSessionContext().getUser();
        this.setPasswordOnServer(connectionTemplateId, password, userName);
        SessionContext sc = (SessionContext)template.getSessionContext();
        sc.setPassword(password);
        try {
            this.getCacheConfiguration().saveAll();
        }
        catch (IOException e) {
            this._exitCode = 76;
            throw new VfsException("Could not set password on client");
        }
    }

    private void setPasswordOnServer(int connectionTemplateId, String password, String userName) throws VfsException {
        IConnectionTemplate template;
        try {
            template = Command.getConnectionTemplate(connectionTemplateId);
        }
        catch (InvalidTemplateIDException invalidTemplateID) {
            LogUtil.logException((Location)LOCATION, (Throwable)invalidTemplateID);
            this._exitCode = 4;
            throw new VfsException("Invalid connection template ID");
        }
        ProppatchRequest ppatch = new ProppatchRequest(template.getBasePath() + "principals/" + userName);
        ppatch.addNamespace("DAV", "DAV:");
        ppatch.addNamespace(XCM.NAMESPACE_PREFIX, XCM.NAMESPACE_URI);
        ppatch.addPropertySet(XCM.NAMESPACE_PREFIX + ":password", password);
        try {
            DeltavCommand.execute((int)connectionTemplateId, (IRequest)ppatch);
        }
        catch (VcmFailure e) {
            this._exitCode = 75;
            throw new VfsException("Setting password on server failed");
        }
    }

    public boolean validateArguments() {
        return this._resourcePaths == null || this._resourcePaths.length <= 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.SETP, false) + " [ " + NameConfig.getOption(OptionName.USER, true) + " userName ]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the new password to be set as input from the user using a pop up where the password has to be entered in a masked input field.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "If specified the password of the specified user will be changed provided the user currently logged in has the required rights.", true);
        Command.getOut().println();
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new SetPasswordCommand(arguments);
    }

    public void setArguments(ArrayList Arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < Arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)Arguments.get(i);
            String uShort = NameConfig.getOption(OptionName.USER, true);
            String uLong = NameConfig.getOption(OptionName.USER, false);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                if (currArg.startsWith(uShort) || lowerCaseArg.startsWith(uLong)) {
                    String userName = Command.getActualArgument(currArg, uShort, uLong).toLowerCase();
                    if ("".equals(userName) && i + 1 < Arguments.size()) {
                        userName = (String)Arguments.get(i + 1);
                        Arguments.remove(i + 1);
                    }
                    this._userName = userName;
                    Arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        super.setArguments(Arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

