/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.DTRShell;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.ResourceCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

class ScriptCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ScriptCommand == null ? (class$com$tssap$dtr$client$commandline$ScriptCommand = ScriptCommand.class$("com.tssap.dtr.client.commandline.ScriptCommand")) : class$com$tssap$dtr$client$commandline$ScriptCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ScriptCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ScriptCommand(arguments);
    }

    ScriptCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "takes commands as input from a file";
    }

    public CommandName getCommandName() {
        return CommandName.SCRIPT;
    }

    public boolean execute() {
        int i = 0;
        while (i < this._resourcePaths.length) {
            block9: {
                String absolutePath = Command.getAbsolutePath(this._resourcePaths[i]);
                File file = new File(absolutePath);
                if (!file.exists()) {
                    Command.getOut().println("Script file " + this._resourcePaths[i] + " does not exist.");
                    this._exitCode = 73;
                } else if (!file.isFile()) {
                    Command.getOut().println("Specified path " + this._resourcePaths[i] + " is not a file.");
                    this._exitCode = 73;
                } else if (!file.getName().endsWith(".dtr")) {
                    Command.getOut().println("Incorrect script file " + this._resourcePaths[i] + ", expected extension .dtr");
                    this._exitCode = 73;
                } else {
                    FileInputStream fis;
                    try {
                        fis = new FileInputStream(file);
                    }
                    catch (IOException exp) {
                        Logger.traceSystemError(LOCATION, exp, "IOException while trying to read script file.");
                        this._exitCode = 74;
                        break block9;
                    }
                    DTRShell.executeCommands(fis);
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        if (this._resourcePaths == null || this._resourcePaths.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this._resourceBranchSeqNums.length) {
            if (-1 != this._resourceBranchSeqNums[i]) {
                return false;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this._resourceRevisions.length) {
            if (-1 != this._resourceRevisions[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.SCRIPT, false) + " FileName");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes as input the file from which commands have to be read", false);
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

