/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRevision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsVersionRelation;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsVersionRelationType;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

class RevisionHistoryCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$RevisionHistoryCommand == null ? (class$com$tssap$dtr$client$commandline$RevisionHistoryCommand = RevisionHistoryCommand.class$("com.tssap.dtr.client.commandline.RevisionHistoryCommand")) : class$com$tssap$dtr$client$commandline$RevisionHistoryCommand));
    boolean _showRevisionHistoryOnly;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$RevisionHistoryCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new RevisionHistoryCommand(arguments);
    }

    RevisionHistoryCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.WORKSPACE);
        this.addSupportedOption(OptionName.REVISION_HISTORY);
        this._showRevisionHistoryOnly = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "prints the version graph or revision history of the file/folder";
    }

    public CommandName getCommandName() {
        return CommandName.HISTORY;
    }

    public boolean execute() {
        if (this._resourcePaths == null) {
            return true;
        }
        int i = 0;
        while (i < this._resourcePaths.length) {
            block22: {
                if (this._resourcePaths[i] != null) {
                    IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                    if (folderItem == null) {
                        Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                    } else {
                        IVfsActivityRecordedFolderItem activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                        if (activityRecordedFolderItem == null) {
                            Command.getOut().println("Cannot get revision history for the given resource" + this._resourcePaths[i]);
                            this._exitCode = 71;
                        } else {
                            IVfsVersion version;
                            try {
                                version = activityRecordedFolderItem.refreshAndGetVersion();
                            }
                            catch (VfsException x) {
                                Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred while getting version for folder item " + activityRecordedFolderItem.getLocalPath());
                                Command.getOut().println("Getting version for folder item failed. " + x.getMessage());
                                break block22;
                            }
                            if (version == null) {
                                Command.getOut().println("Could not get the corresponding version for the given resource" + this._resourcePaths[i]);
                                this._exitCode = 29;
                            } else {
                                IVfsVersionHistory versionHistroy = version.getVersionHistory();
                                if (versionHistroy == null) {
                                    Command.getOut().println("Could not get the revision history for the given resource" + this._resourcePaths[i]);
                                    this._exitCode = 72;
                                } else {
                                    IVfsWorkspace workspaceForRevNumber;
                                    IVfsWorkspace workspace = activityRecordedFolderItem.getWorkspace();
                                    Command.getOut().println("Folder Item : " + version.toString(workspace));
                                    Command.getOut().println();
                                    Command.getOut().println("Author      : " + version.getAuthor());
                                    if (this._workspacePaths != null && !this._workspacePaths[0].equals("") && (workspaceForRevNumber = this.getWorkspace()) != null) {
                                        workspace = workspaceForRevNumber;
                                    }
                                    if (this._showRevisionHistoryOnly) {
                                        IVfsRevision[] vfsRevisions = versionHistroy.getRevisionsInWorkspace(workspace.getAbsoluteRemotePath());
                                        int j = 0;
                                        while (j < vfsRevisions.length) {
                                            this.displayRevision(vfsRevisions[j], versionHistroy, workspace);
                                            ++j;
                                        }
                                    } else {
                                        VfsVersionGraph versionGraph = new VfsVersionGraph(versionHistroy);
                                        HashMap linesOfDecentMap = versionGraph.getDescentLines();
                                        IVfsVersionGraph.IVfsLineOfDescent curWSLine = versionGraph.getDescentLine(version.getCreatorWorkspaceName());
                                        if (curWSLine != null) {
                                            this.displayDecentLine(curWSLine, versionHistroy, workspace);
                                        }
                                        Collection linesOfDecentColl = linesOfDecentMap.values();
                                        Object[] linesOfDecent = linesOfDecentColl.toArray();
                                        int j = 0;
                                        while (j < linesOfDecent.length) {
                                            if (curWSLine != null) {
                                                if (!linesOfDecent[j].equals(curWSLine)) {
                                                    this.displayDecentLine((IVfsVersionGraph.IVfsLineOfDescent)linesOfDecent[j], versionHistroy, workspace);
                                                }
                                            } else {
                                                this.displayDecentLine((IVfsVersionGraph.IVfsLineOfDescent)linesOfDecent[j], versionHistroy, workspace);
                                            }
                                            ++j;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void displayRevision(IVfsRevision revision, IVfsVersionHistory versionHistory, IVfsWorkspace workspace) {
        IVfsVersion version = revision.getVersion();
        Command.getOut().println();
        String prefix = "";
        if (version.isOpen()) {
            prefix = "Open ";
        }
        if (version.isDeleted()) {
            prefix = version.isOpen() ? prefix + "deletion " : prefix + "Deleted";
        }
        int revisionNumber = versionHistory.getRevisionNumber(version, workspace.getAbsoluteRemotePath());
        if (version.isVirtual()) {
            prefix = prefix + "Virtual ";
        }
        Command.getOut().println(prefix + "Revision Number : @" + revisionNumber);
        IVfsActivity activity = version.getCreatingActivity();
        if (activity != null) {
            this.displayActivityDetails(activity);
        } else {
            Command.getOut().println();
            Command.getOut().println("Creating activity details not available.");
            Command.getOut().println("Version was last modified on " + this.getFormattedDate(version.getLastModifiedDate()));
        }
        IVfsActivity[] activities = version.getActivitySet();
        if (this._expertMode && activities.length > 1) {
            Command.getOut().println();
            Command.getOut().println("Other activities in which this version participates :");
            int i = 0;
            while (i < activities.length) {
                if (activity.getName().compareTo(activities[i].getName()) != 0) {
                    this.displayActivityDetails(activities[i]);
                }
                ++i;
            }
        }
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HISTORY, false) + " [" + NameConfig.getOption(OptionName.REVISION_HISTORY, true) + "] FolderItempath...  [ " + NameConfig.getOption(OptionName.WORKSPACE, true) + " ]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Shows the version graph or revision history of the folder item specified. By default the version graph is shown.", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.REVISION_HISTORY, 1, "If this option is specified then only the revision history of the folderitem in the specified workspace is shown.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace path to specify the workspace for which the revision numbers of versions in the workspace will be shown in case version graph is shown. In case revision history is shown (when using " + NameConfig.getOption(OptionName.REVISION_HISTORY, true) + " option) this specifies the workspace for which the " + "revision history has to be shown. If this is not " + "specified then the workspace of the folderitem will be used.", true);
    }

    private void displayDecentLine(IVfsVersionGraph.IVfsLineOfDescent wsLine, IVfsVersionHistory versionHistory, IVfsWorkspace workspace) {
        int i;
        Command.getOut().println();
        Command.getOut().println();
        Command.getOut().println("============================================================");
        Command.getOut().println("Workspace Name : " + wsLine.getWorkspaceName());
        IVfsVersionGraph.IVfsLineOfDescent parentLine = wsLine.getParentLine();
        if (parentLine != null) {
            int sourceVerSeqNum = 0;
            IVfsVersionGraph.IVfsBranchPoint[] branchPointsFromParentLine = parentLine.getBranchPoints();
            i = 0;
            while (i < branchPointsFromParentLine.length) {
                if (branchPointsFromParentLine[i].getTargetLineOfDescent().equals(wsLine)) {
                    sourceVerSeqNum = branchPointsFromParentLine[i].getSourceLevel();
                    break;
                }
                ++i;
            }
            Command.getOut().println("Branch originated from version " + sourceVerSeqNum + " in workspace " + parentLine.getWorkspaceName());
        }
        Command.getOut().println("============================================================");
        IVfsVersionGraph.IVfsVersionElement element = null;
        IVfsVersionGraph.IVfsVersionElement[] elements = wsLine.getRootElements();
        i = 0;
        while (i < elements.length) {
            if (elements[i].getVersion().isOpen()) {
                this.displayElement(elements[i], versionHistory, workspace);
            } else {
                element = elements[i];
            }
            ++i;
        }
        if (element != null) {
            this.displayElement(element, versionHistory, workspace);
            ArrayList successors = element.getLineSuccessors();
            while (successors.size() != 0) {
                IVfsVersionGraph.IVfsVersionElement nextElement = null;
                int succCount = 0;
                while (succCount < successors.size()) {
                    element = (IVfsVersionGraph.IVfsVersionElement)successors.get(succCount);
                    this.displayElement(element, versionHistory, workspace);
                    if (!element.getVersion().isOpen()) {
                        nextElement = element;
                    }
                    ++succCount;
                }
                if (nextElement == null) break;
                successors = nextElement.getLineSuccessors();
            }
        }
        Command.getOut().println();
    }

    private void displayElement(IVfsVersionGraph.IVfsVersionElement element, IVfsVersionHistory versionHistory, IVfsWorkspace workspace) {
        IVfsActivity activity;
        IVfsVersion version = element.getVersion();
        Command.getOut().println();
        String prefix = "";
        if (version.isOpen()) {
            prefix = "Open ";
        }
        if (version.isDeleted()) {
            prefix = version.isOpen() ? prefix + "deletion " : prefix + "Deleted";
        }
        if (version.isVirtual()) {
            prefix = prefix + "Virtual ";
        }
        Command.getOut().println(prefix + "Version : @" + version.getBranchSequenceNumber());
        int revisionNumber = 0;
        revisionNumber = versionHistory.getRevisionNumber(version, workspace.getAbsoluteRemotePath());
        if (revisionNumber > 0) {
            Command.getOut().println(prefix + "Revision Number : @" + revisionNumber);
        }
        if ((activity = version.getCreatingActivity()) != null) {
            this.displayActivityDetails(activity);
        } else {
            Command.getOut().println();
            Command.getOut().println("Creating activity details not available.");
            Command.getOut().println("Version was last modified on " + this.getFormattedDate(version.getLastModifiedDate()));
        }
        IVfsActivity[] activities = version.getActivitySet();
        if (this._expertMode && activities.length > 1) {
            Command.getOut().println();
            Command.getOut().println("Other activities in which this version participates :");
            int i = 0;
            while (i < activities.length) {
                if (activity.getName().compareTo(activities[i].getName()) != 0) {
                    this.displayActivityDetails(activities[i]);
                }
                ++i;
            }
        }
        this.displaySuccesorsOtherThanLineSuccesor(element);
    }

    private void displayActivityDetails(IVfsActivity activity) {
        String displayName = "";
        try {
            displayName = activity.getDisplayName();
        }
        catch (VfsException x) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred during retrieving display name.");
            displayName = "<getting display name failed>";
        }
        String description = "";
        try {
            description = activity.getDescription();
            if (description == null) {
                description = "<no description specified>";
            }
        }
        catch (VfsException x) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred during retrieving description.");
            description = "<getting description failed>";
        }
        String dateMessage = "";
        boolean isOpen = true;
        try {
            isOpen = activity.getState() == VfsActivityState.OPEN;
        }
        catch (VfsException x) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred during retrieving activity state.");
        }
        if (!isOpen) {
            Date cInD = null;
            try {
                cInD = activity.getCheckedInDate();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving checkin date.");
                cInD = null;
            }
            dateMessage = cInD != null ? "Checked In Date : " + this.getFormattedDate(cInD) : "Checked In Date : <getting Checked In Date failed>";
        } else {
            Date cD = null;
            try {
                cD = activity.getCreationDate();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving creation date.");
                cD = null;
            }
            dateMessage = cD != null ? "Created On      : " + this.getFormattedDate(cD) : "Created On      : <getting Created On Date failed>";
        }
        String author = "";
        try {
            author = activity.getAuthor();
        }
        catch (VfsException x) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred during retrieving author.");
            author = "<getting author failed>";
        }
        Command.getOut().println();
        Command.getOut().println("Activity Name : " + displayName);
        Command.getOut().println(dateMessage);
        Command.getOut().println("Description   : " + description);
        Command.getOut().println("author\t\t  : " + author);
    }

    private void displaySuccesorsOtherThanLineSuccesor(IVfsVersionGraph.IVfsVersionElement element) {
        ArrayList successors = element.getSuccessors();
        ArrayList lineSuccessors = element.getLineSuccessors();
        IVfsVersionGraph.IVfsVersionElement lineSuccEle = null;
        if (lineSuccessors.size() > 0) {
            lineSuccEle = (IVfsVersionGraph.IVfsVersionElement)lineSuccessors.get(0);
        }
        if (successors.size() > 0) {
            int i = 0;
            while (i < successors.size()) {
                IVfsVersionGraph.IVfsVersionElement succEle = (IVfsVersionGraph.IVfsVersionElement)successors.get(i);
                if (lineSuccEle == null || !succEle.equals(lineSuccEle)) {
                    IVfsVersion succVer = succEle.getVersion();
                    IVfsVersionRelation[] verRels = succVer.getPredecessorRelations(element.getVersion());
                    int j = 0;
                    while (j < verRels.length) {
                        VfsVersionRelationType relType = verRels[j].getRelationType();
                        String output = "";
                        if (relType.equals(VfsVersionRelationType.BRANCH)) {
                            output = "Version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName() + " branches out from this version";
                        } else if (relType.equals(VfsVersionRelationType.COPY_MERGE)) {
                            output = "A copy merge was done from this version to version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        } else if (relType.equals(VfsVersionRelationType.DISCARD_MERGE)) {
                            output = "A discard merge was done from this version to version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        } else if (relType.equals(VfsVersionRelationType.EDIT_MERGE)) {
                            output = "A edit merge was done from this version to version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        } else if (relType.equals(VfsVersionRelationType.MERGE)) {
                            output = "A merge was done from this version to version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        } else if (relType.equals(VfsVersionRelationType.CYCLIC_MERGE_COLLISION)) {
                            output = "A cyclic merge conflict exists between this version and version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        } else if (relType.equals(VfsVersionRelationType.PRED_SUCC_COLLISION)) {
                            output = "A predessesor successor conflict exists between this version and version @" + succVer.getBranchSequenceNumber() + " in workspace " + succVer.getCreatorWorkspaceName();
                        }
                        if (!"".equals(output)) {
                            Command.getOut().println();
                            Command.getOut().println("      " + output);
                            Command.getOut().println();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String revShort = NameConfig.getOption(OptionName.REVISION_HISTORY, true);
                String revLong = NameConfig.getOption(OptionName.REVISION_HISTORY, false);
                String wsShort = NameConfig.getOption(OptionName.WORKSPACE, true);
                String wsLong = NameConfig.getOption(OptionName.WORKSPACE, false);
                String lowerCaseArg = currArg.toLowerCase();
                if (lowerCaseArg.equals(revShort) || lowerCaseArg.equals(revLong)) {
                    this._showRevisionHistoryOnly = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if ((lowerCaseArg.startsWith(wsShort) || lowerCaseArg.startsWith(wsLong)) && (this._workspacePaths.length == 0 || this._workspacePaths[0].equals(""))) {
                    String wsName = Command.getActualArgument(currArg, wsShort, wsLong);
                    if ("".equals(wsName) && i + 1 < arguments.size()) {
                        wsName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._workspacePaths = null;
                    this._workspacePaths = new String[1];
                    this._workspacePaths[0] = wsName;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        super.setArguments(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

