/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;
import java.util.Arrays;

class RevertCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$RevertCommand == null ? (class$com$tssap$dtr$client$commandline$RevertCommand = RevertCommand.class$("com.tssap.dtr.client.commandline.RevertCommand")) : class$com$tssap$dtr$client$commandline$RevertCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$RevertCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new RevertCommand(arguments);
    }

    RevertCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "discards the changes made to a file/folder";
    }

    public CommandName getCommandName() {
        return CommandName.REVERT;
    }

    public boolean execute() {
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            IVfsFolderItem folderItem;
            if (this._resourcePaths[i] != null && (folderItem = this.getResource(this._resourcePaths[i])) != null) {
                activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                if (activityRecordedFolderItem != null) {
                    VfsActionOnFolderItem[] actionsPoss = activityRecordedFolderItem.getActionsForCurrentState();
                    if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.UNCHECKOUT)) {
                        try {
                            activityRecordedFolderItem.uncheckout();
                        }
                        catch (VfsException exp) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while reverting folder item " + this._resourcePaths[i]);
                            Command.getOut().println("Could not revert file " + this._resourcePaths[i] + ". " + exp.getMessage());
                            this._exitCode = 15;
                        }
                    } else {
                        String mes = "";
                        if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is local only. ";
                        } else if (activityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                            mes = "Folder item is not checked out. ";
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                            mes = "Folder item is not present locally. ";
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                        }
                        Command.getOut().println(mes + "Cannot revert folder item " + this._resourcePaths[i]);
                        this._exitCode = 14;
                    }
                } else {
                    Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                    this._exitCode = 88;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.REVERT, false) + " FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Discards the changes made to the folder item", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

