/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FieldDescriptor;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

class ResourceStateCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ResourceStateCommand == null ? (class$com$tssap$dtr$client$commandline$ResourceStateCommand = ResourceStateCommand.class$("com.tssap.dtr.client.commandline.ResourceStateCommand")) : class$com$tssap$dtr$client$commandline$ResourceStateCommand));
    private static final FieldDescriptor LOCAL_PATH = new FieldDescriptor(ResourceStateCommand.getFieldLength("LocalPath", 100), "LocalPath", "LP");
    private static final FieldDescriptor REMOTE_PATH = new FieldDescriptor(ResourceStateCommand.getFieldLength("RemotePath", 100), "RemotePath", "RP");
    private static final FieldDescriptor BROWSE_PATH = new FieldDescriptor(ResourceStateCommand.getFieldLength("BrowsePath", 51), "BrowsePath", "BP");
    private static final FieldDescriptor CREATED_ON = new FieldDescriptor(ResourceStateCommand.getFieldLength("CreatedOn", 35), "CreatedOn", "COn");
    private static final FieldDescriptor CREATED_BY = new FieldDescriptor(ResourceStateCommand.getFieldLength("CreatedBy", 20), "CreatedBy", "CBy");
    private static final FieldDescriptor STATE = new FieldDescriptor(ResourceStateCommand.getFieldLength("State", 23), "State", "St");
    private static final FieldDescriptor LAST_MODIFIED_DATE = new FieldDescriptor(ResourceStateCommand.getFieldLength("LastModifiedDate", 35), "LastModifiedDate", "LMD");
    private static final FieldDescriptor LAST_MODIFIED_BY = new FieldDescriptor(ResourceStateCommand.getFieldLength("LastModifiedBy", 20), "LastModifiedBy", "LMBy");
    private static final FieldDescriptor LOCATION_STATE = new FieldDescriptor(ResourceStateCommand.getFieldLength("LocationState", 20), "LocationState", "LSt");
    private static final FieldDescriptor REVISION_NUMBER = new FieldDescriptor(ResourceStateCommand.getFieldLength("BranchSequenceNumber", 5), "BranchSequenceNumber", "BSN");
    private static final FieldDescriptor SOMETHING_CHECKED_OUT_UNDER_FOLDER = new FieldDescriptor(ResourceStateCommand.getFieldLength("SomethingCheckedOutUnderFolder", 20), "SomethingCheckedOutUnderFolder", "SCOUF");
    private static final String ALL = "All";
    private boolean _recurse;
    private boolean _localOnly;
    private boolean _sortSpecified;
    private boolean _fieldsSpecifiedInArgs;
    private ArrayList _displayFiledsOrdered;
    private Field _sortField;
    private int _sortKeyType;
    private boolean _descendingOrder;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ResourceStateCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ResourceStateCommand(arguments);
    }

    ResourceStateCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FIELD);
        this.addSupportedOption(OptionName.SORT);
        this.addSupportedOption(OptionName.UNFORMATTED);
        this.addSupportedOption(OptionName.DESCENDING);
        this.addSupportedOption(OptionName.LOCAL);
        this._displayFiledsOrdered = new ArrayList();
        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, ResourceStateCommand.BROWSE_PATH.fieldName));
        this._displayFiledsOrdered.add(new Field(STATE, ResourceStateCommand.STATE.fieldName));
        this._displayFiledsOrdered.add(new Field(REVISION_NUMBER, ResourceStateCommand.REVISION_NUMBER.fieldName));
        this._fieldsSpecifiedInArgs = false;
        this._recurse = false;
        this._localOnly = false;
        this._sortField = null;
        this._sortSpecified = false;
        this._descendingOrder = false;
        this.setArguments(arguments);
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String descShort = NameConfig.getOption(OptionName.DESCENDING, true);
            String descLong = NameConfig.getOption(OptionName.DESCENDING, false);
            String fShort = NameConfig.getOption(OptionName.FIELD, true);
            String fLong = NameConfig.getOption(OptionName.FIELD, false);
            String sShort = NameConfig.getOption(OptionName.SORT, true);
            String sLong = NameConfig.getOption(OptionName.SORT, false);
            String unShort = NameConfig.getOption(OptionName.UNFORMATTED, true);
            String unLong = NameConfig.getOption(OptionName.UNFORMATTED, false);
            String rShort = NameConfig.getOption(OptionName.RECURSE, true);
            String rLong = NameConfig.getOption(OptionName.RECURSE, false);
            String lShort = NameConfig.getOption(OptionName.LOCAL, true);
            String lLong = NameConfig.getOption(OptionName.LOCAL, false);
            if (currArg != null) {
                String fieldName;
                String lowerCaseArg = currArg.toLowerCase();
                if (rShort.equals(lowerCaseArg) || rLong.equals(lowerCaseArg)) {
                    this._recurse = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lShort.equals(lowerCaseArg) || lLong.equals(lowerCaseArg)) {
                    this._localOnly = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (descShort.equals(lowerCaseArg) || descLong.equals(lowerCaseArg)) {
                    this._descendingOrder = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (unShort.equals(currArg) || unLong.equals(lowerCaseArg)) {
                    this._unformattedOutput = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    fieldName = Command.getActualArgument(currArg, fShort, fLong).toLowerCase();
                    if ("".equals(fieldName) && i + 1 < arguments.size()) {
                        fieldName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    if (!"".equals(fieldName) && !this._fieldsSpecifiedInArgs) {
                        this._displayFiledsOrdered = null;
                        this._displayFiledsOrdered = new ArrayList();
                        this._fieldsSpecifiedInArgs = true;
                    }
                    if (LOCAL_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                    } else if (REMOTE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                    } else if (BROWSE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                    } else if (CREATED_ON.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CREATED_ON, fieldName));
                    } else if (CREATED_BY.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CREATED_BY, fieldName));
                    } else if (STATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(STATE, fieldName));
                    } else if (LAST_MODIFIED_DATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LAST_MODIFIED_DATE, fieldName));
                    } else if (LAST_MODIFIED_BY.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LAST_MODIFIED_BY, fieldName));
                    } else if (REVISION_NUMBER.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(REVISION_NUMBER, fieldName));
                    } else if (LOCATION_STATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LOCATION_STATE, fieldName));
                    } else if (SOMETHING_CHECKED_OUT_UNDER_FOLDER.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(SOMETHING_CHECKED_OUT_UNDER_FOLDER, fieldName));
                    } else if (fieldName.startsWith(ALL.toLowerCase())) {
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(LAST_MODIFIED_BY, fieldName));
                        this._displayFiledsOrdered.add(new Field(CREATED_BY, fieldName));
                        this._displayFiledsOrdered.add(new Field(CREATED_ON, fieldName));
                        this._displayFiledsOrdered.add(new Field(STATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(LOCATION_STATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(LAST_MODIFIED_DATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(REVISION_NUMBER, fieldName));
                        this._displayFiledsOrdered.add(new Field(SOMETHING_CHECKED_OUT_UNDER_FOLDER, fieldName));
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(sShort) || lowerCaseArg.startsWith(sLong)) {
                    fieldName = Command.getActualArgument(currArg, sShort, sLong).toLowerCase();
                    if (!this._sortSpecified) {
                        if (LOCAL_PATH.matches(fieldName)) {
                            this._sortField = new Field(LOCAL_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (REMOTE_PATH.matches(fieldName)) {
                            this._sortField = new Field(REMOTE_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (BROWSE_PATH.matches(fieldName)) {
                            this._sortField = new Field(BROWSE_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (CREATED_ON.matches(fieldName)) {
                            this._sortField = new Field(CREATED_ON, fieldName);
                            this._sortKeyType = 2;
                        } else if (CREATED_BY.matches(fieldName)) {
                            this._sortField = new Field(CREATED_BY, fieldName);
                            this._sortKeyType = 1;
                        } else if (STATE.matches(fieldName)) {
                            this._sortField = new Field(STATE, fieldName);
                            this._sortKeyType = 1;
                        } else if (LAST_MODIFIED_DATE.matches(fieldName)) {
                            this._sortField = new Field(LAST_MODIFIED_DATE, fieldName);
                            this._sortKeyType = 2;
                        } else if (LAST_MODIFIED_BY.matches(fieldName)) {
                            this._sortField = new Field(LAST_MODIFIED_BY, fieldName);
                            this._sortKeyType = 1;
                        } else if (REVISION_NUMBER.matches(fieldName)) {
                            this._sortField = new Field(REVISION_NUMBER, fieldName);
                            this._sortKeyType = 0;
                        } else if (LOCATION_STATE.matches(fieldName)) {
                            this._sortField = new Field(LOCATION_STATE, fieldName);
                            this._sortKeyType = 1;
                        } else if (SOMETHING_CHECKED_OUT_UNDER_FOLDER.matches(fieldName)) {
                            this._sortField = new Field(SOMETHING_CHECKED_OUT_UNDER_FOLDER, fieldName);
                            this._sortKeyType = 1;
                        }
                        if (this._sortField != null) {
                            this._sortSpecified = true;
                        }
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (this._displayFiledsOrdered.size() == 0) {
            this._displayFiledsOrdered.add(new Field(BROWSE_PATH, ResourceStateCommand.BROWSE_PATH.fieldName));
            this._displayFiledsOrdered.add(new Field(STATE, ResourceStateCommand.STATE.fieldName));
            this._displayFiledsOrdered.add(new Field(REVISION_NUMBER, ResourceStateCommand.REVISION_NUMBER.fieldName));
        }
        if (this._sortSpecified) {
            boolean sortFieldAdded = false;
            int i = 0;
            while (i < this._displayFiledsOrdered.size()) {
                if (this._sortField.isIt(((Field)this._displayFiledsOrdered.get((int)i)).fieldName)) {
                    sortFieldAdded = true;
                    break;
                }
                ++i;
            }
            if (!sortFieldAdded) {
                this._displayFiledsOrdered.add(this._sortField);
            }
        } else {
            this._sortField = (Field)this._displayFiledsOrdered.get(0);
            this._sortKeyType = 1;
        }
    }

    public String getDescription() {
        return "gives information about the folder item";
    }

    public CommandName getCommandName() {
        return CommandName.STATUS;
    }

    public boolean execute() {
        if (this._resourcePaths == null) {
            return true;
        }
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        if (fileSystemManager == null) {
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
            this._exitCode = 3;
            return false;
        }
        this.displayHeader(this._displayFiledsOrdered);
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(this._sortField, this._sortKeyType);
        int i = 0;
        while (i < this._resourcePaths.length) {
            if (this._resourcePaths[i] != null) {
                IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                if (folderItem == null) {
                    Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                } else {
                    this.displayResource(folderItem, dh);
                }
            }
            ++i;
        }
        dh.endDisplay(this._descendingOrder);
        return true;
    }

    private void displayResource(IVfsFolderItem folderItem, DisplayHelper displayHelper) {
        File localFile;
        IVfsActivityRecordedFolderItem activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
        IVfsFolder folder = folderItem.asFolder();
        String localPath = folderItem.getLocalPath();
        boolean fileExists = false;
        if (localPath != null && (localFile = new File(localPath)) != null && localFile.exists()) {
            fileExists = true;
        }
        if (!fileExists && this._localOnly) {
            return;
        }
        if (this._recurse && folder != null) {
            IVfsFolderItem[] folderItems = null;
            try {
                folderItems = folder.getFolderItems();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting children for folder item " + folder.getLocalPath() + ". Will continue with the next folder item.");
                Command.getOut().println("Getting children for folder " + folder.getLocalPath() + " failed. " + exp.getMessage() + ". Will continue with the next folder item.");
            }
            if (folderItems != null) {
                DisplayHelper dh1 = new DisplayHelper(this._unformattedOutput);
                dh1.startDisplay();
                dh1.setKeyField(this._sortField, this._sortKeyType);
                int i = 0;
                while (i < folderItems.length) {
                    this.displayResource(folderItems[i], dh1);
                    ++i;
                }
                dh1.endDisplay(this._descendingOrder);
            }
        }
        DisplayHelper.Row row = displayHelper.newRow();
        int j = 0;
        while (j < this._displayFiledsOrdered.size()) {
            Field field = (Field)this._displayFiledsOrdered.get(j);
            try {
                String strDate;
                IVfsVersion version;
                if (field.isIt(ResourceStateCommand.LOCAL_PATH.fieldName)) {
                    if (localPath == null) {
                        localPath = "Not Mounted";
                    }
                    row.addField(field, localPath);
                } else if (field.isIt(ResourceStateCommand.REMOTE_PATH.fieldName)) {
                    row.addField(field, folderItem.getAbsoluteRemotePath());
                } else if (field.isIt(ResourceStateCommand.BROWSE_PATH.fieldName)) {
                    row.addField(field, "/" + folderItem.getBrowsePath());
                } else if (field.isIt(ResourceStateCommand.CREATED_BY.fieldName)) {
                    String authorName = "";
                    if (activityRecordedFolderItem != null) {
                        authorName = activityRecordedFolderItem.getAuthor();
                    }
                    row.addField(field, authorName);
                } else if (field.isIt(ResourceStateCommand.CREATED_ON.fieldName)) {
                    version = null;
                    if (activityRecordedFolderItem != null) {
                        version = activityRecordedFolderItem.refreshAndGetVersion();
                    }
                    strDate = "";
                    if (version != null) {
                        strDate = version.getProperty("DAV:creationdate").getValue();
                    }
                    row.addField(field, strDate);
                } else if (field.isIt(ResourceStateCommand.STATE.fieldName)) {
                    String currState = "";
                    if (activityRecordedFolderItem != null) {
                        currState = activityRecordedFolderItem.getActivityState().toString();
                    }
                    row.addField(field, currState);
                } else if (field.isIt(ResourceStateCommand.LAST_MODIFIED_DATE.fieldName)) {
                    Date lmdate = null;
                    if (activityRecordedFolderItem != null) {
                        lmdate = activityRecordedFolderItem.getLastModifiedDate();
                    }
                    strDate = "";
                    if (lmdate != null) {
                        strDate = lmdate.toString();
                    }
                    row.addField(field, strDate);
                } else if (field.isIt(ResourceStateCommand.REVISION_NUMBER.fieldName)) {
                    version = null;
                    if (activityRecordedFolderItem != null) {
                        version = activityRecordedFolderItem.refreshAndGetVersion();
                    }
                    String revNum = "";
                    if (version == null) {
                        revNum = "";
                    } else if (activityRecordedFolderItem.asFolder() == null) {
                        revNum = String.valueOf(version.getBranchSequenceNumber());
                    }
                    row.addField(field, revNum);
                } else if (field.isIt(ResourceStateCommand.LAST_MODIFIED_BY.fieldName)) {
                    String lastModifier = "";
                    if (activityRecordedFolderItem != null) {
                        lastModifier = activityRecordedFolderItem.getLastModifier();
                    }
                    if (lastModifier == null) {
                        lastModifier = "";
                    }
                    row.addField(field, lastModifier);
                } else if (field.isIt(ResourceStateCommand.LOCATION_STATE.fieldName)) {
                    row.addField(field, folderItem.getLocationState().toString());
                } else if (field.isIt(ResourceStateCommand.SOMETHING_CHECKED_OUT_UNDER_FOLDER.fieldName)) {
                    String result = "";
                    if (activityRecordedFolderItem != null && activityRecordedFolderItem.asFolder() != null && this.getFileSystemManager().isSomethingCheckedOutUnderFolder(activityRecordedFolderItem.asFolder())) {
                        result = "True";
                    }
                    row.addField(field, result);
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting field " + field.fieldName);
                row.addField(field, "<could not get " + field.fieldName + ">");
            }
            ++j;
        }
        row.end();
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.STATUS, false) + " [" + NameConfig.getOption(OptionName.RECURSE, true) + " " + NameConfig.getOption(OptionName.LOCAL, true) + "] [" + NameConfig.getOption(OptionName.FIELD, true) + "Fields] FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Displays the state folder item", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "If this option is specified and one of the path(s) is a folder then the items under the folder will be visited recursively and the information on there state will be displayed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.LOCAL, 1, "If this option is specified then only the files which are on the local file system will be considered", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Using this option you can specify the properties of the folder item(s) that have to be displayed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Example:", false);
        this.printOptionHelp(OptionName.FIELD, 1, NameConfig.getCommandName(CommandName.STATUS, false) + " " + NameConfig.getOption(OptionName.FIELD, true) + "Localpath " + NameConfig.getOption(OptionName.FIELD, true) + "BranchSequenceNumber <Path>", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "The fields that can be specified are:", false);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "LocalPath/LP", "Absolute local path of the folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "RemotePath/RP", "Absolute remote path of the folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "BrowsePath/BP", "Browse path of the folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CreatedOn/COn", "Creation date of folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CreatedBy/CBy", "Name of the user who created the folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "State/St", "Current state of folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "LocationState/LSt", "Location state of folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "LastModifiedDate/LMD", "Date when the folderitem was last modified", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "LastModifiedBy/LMBy", "The user who modified the folderitem last", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "BranchSequenceNumber/BSN", "Branch sequence number of folderitem", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "SomethingCheckedoutUnderFolder/SCOUF", "True if there is some folderitem under this folder which is checked out", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, ALL, "Prints all the above fields", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "For more information on the use of " + NameConfig.getOption(OptionName.FIELD, true) + " option see usage", false);
        this.printOptionHelp(OptionName.FIELD, 1, "dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " Usage", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SORT, 1, "Using this option you can specify the field based on which sorting of the output has to be done. The fields that can be specified are the ones listed above. Sorting is in ascending order by default", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DESCENDING, 1, "Specify this option along with sort to sort output in descending order.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "If this is specified then the field values will not be truncated to fit into a given space. But it might lead to output that is not easy to read.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "It is recommended that this be used only for scripting.", false);
        Command.getOut().println();
    }

    private static int getFieldLength(String field, int defVal) {
        return CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.field.resource." + field.toLowerCase(), defVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

