/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollisionQuery;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsCollisionState;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsCollisionQuery;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class ResolveCommand
extends ActivityCommand {
    private String[] _resourcePaths;
    private boolean _discardActive;
    private boolean _resolveAllIntegrateCollisions;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ResolveCommand == null ? (class$com$tssap$dtr$client$commandline$ResolveCommand = ResolveCommand.class$("com.tssap.dtr.client.commandline.ResolveCommand")) : class$com$tssap$dtr$client$commandline$ResolveCommand));
    private boolean _integrateCollisions;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ResolveCommand;

    public ResolveCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.INT_COLLS);
        this.addSupportedOption(OptionName.ALL);
        this.addSupportedOption(OptionName.INT_DISCARD_ACTIVE);
        this._resolveAllIntegrateCollisions = false;
        this._discardActive = false;
        this.setArguments(arguments);
    }

    public CommandName getCommandName() {
        return CommandName.RESOLVE;
    }

    public String getDescription() {
        return "resolve the checkin/integrate conflicts";
    }

    public boolean execute() {
        if (this._integrateCollisions) {
            IVfsWorkspace workspace = this.getWorkspace();
            if (workspace == null) {
                if (this._exitCode != 3) {
                    this._exitCode = 30;
                }
                return false;
            }
            VfsCollisionQuery collisionQuery = new VfsCollisionQuery();
            collisionQuery.setCollisionState(VfsCollisionState.OPEN);
            collisionQuery.setWorkspace(workspace.getAbsoluteRemotePath());
            try {
                workspace.getRepository().refreshIntegrateCollisions((IVfsCollisionQuery)collisionQuery);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting integrate collisions.");
                Command.getOut().println("Could not get integrate conflicts. " + e.getMessage());
                this._exitCode = 51;
                return false;
            }
            if (this._resolveAllIntegrateCollisions) {
                ArrayList<String> lstResourceRemotePaths = null;
                if (this._resourcePaths != null && this._resourcePaths.length != 0) {
                    lstResourceRemotePaths = new ArrayList<String>();
                    int i = 0;
                    while (i < this._resourcePaths.length) {
                        IVfsFolderItem fi = this.getResource(this._resourcePaths[i]);
                        if (fi == null || fi.asActivityRecordedFolderItem() == null) {
                            Command.getOut().println("Skipping path as the corresponing folder item could not be retrieved : " + this._resourcePaths[i]);
                        } else {
                            try {
                                lstResourceRemotePaths.add(fi.asActivityRecordedFolderItem().getActiveVersion().toString(workspace));
                            }
                            catch (VfsException e1) {
                                Command.getOut().println("Skipping path as the corresponing remote path could not be retrieved : " + this._resourcePaths[i]);
                            }
                        }
                        ++i;
                    }
                    if (lstResourceRemotePaths.size() == 0) {
                        Command.getOut().println("Skipped all paths specified(specific reasons mentioned above). Will not continue with resolution. Please check the paths specified and try again");
                        this._exitCode = 5;
                        return false;
                    }
                }
                Object act = null;
                IVfsIntegrateCollision[] integrateCollisions = workspace.getIntegrateCollisions();
                ArrayList<IVfsIntegrateCollision> collList = new ArrayList<IVfsIntegrateCollision>();
                int i = 0;
                while (i < integrateCollisions.length) {
                    IVfsIntegrateCollision integrateCollision = integrateCollisions[i].getAsIntegrateCollision();
                    IVfsVersion activeVersion = integrateCollision.getActiveVersion();
                    if (activeVersion != null) {
                        IVfsVersion version = integrateCollision.getValidSourceVersion();
                        String remotePathAct = activeVersion.toString(workspace);
                        if (lstResourceRemotePaths == null || this.remotePathSpecified(lstResourceRemotePaths, remotePathAct)) {
                            if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN)) {
                                Command.getOut().println("Discard  already  performed   on  file : " + remotePathAct);
                            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT)) {
                                Command.getOut().println("Merge version already present for file : " + remotePathAct);
                            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN)) {
                                Command.getOut().println("Merge arrow  already  present for file : " + remotePathAct);
                            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN)) {
                                collList.add(integrateCollision);
                            }
                        }
                    }
                    ++i;
                }
                if (collList.size() > 0) {
                    IVfsIntegrateCollision[] colls = new IVfsIntegrateCollision[collList.size()];
                    colls = collList.toArray(colls);
                    try {
                        if (this._discardActive) {
                            workspace.immediateMassDiscardActiveVersion(colls, this._activityName, this._description);
                        } else {
                            workspace.immediateMassDiscardCollidingVersion(colls, this._activityName, this._description);
                        }
                    }
                    catch (VfsException e) {
                        Command.getOut().println("Collision resolution failed.");
                        this._exitCode = 100;
                        return false;
                    }
                    Command.getOut().println("Collision resolution succeeded.");
                } else {
                    Command.getOut().println("No collisions found to be resolved.");
                }
            } else {
                IVfsIntegrateCollision[] integrateCollisions = workspace.getIntegrateCollisions();
                int i = 0;
                while (i < integrateCollisions.length) {
                    Command.getOut().println();
                    IVfsIntegrateCollision integrateCollision = integrateCollisions[i];
                    IVfsVersion collidingVersion = integrateCollision.getCollidingVersion();
                    if (collidingVersion != null) {
                        String remotePathColl = collidingVersion.getDisplayName();
                        IVfsVersion activeVersion = integrateCollision.getActiveVersion();
                        if (activeVersion != null) {
                            IVfsVersion version = integrateCollision.getValidSourceVersion();
                            String remotePathAct = activeVersion.toString(workspace);
                            String remotePath = version.toString(workspace);
                            Command.getOut().println("Folder item is " + remotePath);
                            Command.getOut().println("Conflict type is " + integrateCollision.getCollisionType());
                            Command.getOut().println("Active version is " + remotePathAct + " @" + activeVersion.getBranchSequenceNumber());
                            if (!integrateCollision.getCollisionType().equals(VfsCollisionType.NAME_CLASH)) {
                                Command.getOut().println("Coflicting version is " + remotePathColl + " @" + collidingVersion.getBranchSequenceNumber());
                            }
                        }
                    }
                    ++i;
                }
                if (integrateCollisions.length > 0) {
                    Command.getOut().println();
                    this.resolveCollisions((IVfsCollision[])integrateCollisions, null, workspace);
                }
            }
        } else {
            IVfsCheckinCollision[] checkinCollisions;
            IVfsActivity activity = this.getActivity(false, true);
            if (activity == null) {
                Command.getOut().println("The given activity does not exist.");
                return false;
            }
            try {
                checkinCollisions = activity.getCheckinCollisions();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting checkin collisions.");
                Command.getOut().println("Could not get the checkin conflicts in the activity." + e.getMessage());
                this._exitCode = 52;
                return false;
            }
            int i = 0;
            while (i < checkinCollisions.length) {
                Command.getOut().println();
                IVfsCheckinCollision checkinCollision = checkinCollisions[i];
                IVfsVersion version = checkinCollision.getValidSourceVersion();
                if (version != null) {
                    IVfsWorkspace workspaceOfActivity = activity.getWorkspace();
                    String remotePath = version.toString(workspaceOfActivity);
                    Command.getOut().println("Folder item " + remotePath + " must be resolved before check in.");
                    Command.getOut().println("Active version is " + remotePath + " @" + version.getBranchSequenceNumber());
                }
                ++i;
            }
            if (checkinCollisions.length > 0) {
                Command.getOut().println();
                this.resolveCollisions((IVfsCollision[])checkinCollisions, activity, activity.getWorkspace());
            }
        }
        return true;
    }

    private boolean remotePathSpecified(ArrayList lstResourceRemotePaths, String remotePathAct) {
        Iterator iter = ((AbstractList)lstResourceRemotePaths).iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (!remotePathAct.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public boolean validateArguments() {
        return !this._resolveAllIntegrateCollisions || this._activityName != null && !this._activityName.equals("") && this._description != null && !this._description.equals("");
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.RESOLVE, false) + " [" + NameConfig.getOption(OptionName.INT_COLLS, true) + " [" + NameConfig.getOption(OptionName.ALL, false) + " [" + NameConfig.getOption(OptionName.INT_DISCARD_ACTIVE, true) + "] [" + NameConfig.getOption(OptionName.COMMENTS, true) + "] [Folderpath...] ] ] [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName ] [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " workspace ]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Resolves the conflicts that exist", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INT_COLLS, 1, "To specify that integrate conflicts have to be resolved.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INT_DISCARD_ACTIVE, 1, "In case option " + NameConfig.getOption(OptionName.ALL, false) + " is specified this is to specify that all integrate conflicts have to be resolved by discarding active versions. By default colliding versions will be discarded", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ALL, 1, "To specify that all integrate conflicts have to be resolved in the same activity. The activity will be checked in automatically.", true);
        this.printOptionHelp(OptionName.ALL, 1, "Folder paths can be specified along with this option to limit the resolution to folderitems which are below one of the specified folder paths", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "To specify the activity if checkin conflicts are to be resolved or the activity in which all integrate conflicts will be resolved.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.COMMENTS, 1, "In case option " + NameConfig.getOption(OptionName.ALL, false) + " is specified this is to specify the description of the activity in which collision resolution will be done.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "To specify the workspace if integrate conflicts are to be resolved", true);
        Command.getOut().println();
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ResolveCommand(arguments);
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        if (arguments.size() > 0) {
            while (indexOfArgs < arguments.size()) {
                int i;
                String currArg;
                String allLong = NameConfig.getOption(OptionName.ALL, false);
                if ((currArg = (String)arguments.get(i = indexOfArgs--)) != null) {
                    String lowerCaseArg = currArg.toLowerCase();
                    if (allLong.equalsIgnoreCase(currArg)) {
                        this._resolveAllIntegrateCollisions = true;
                        arguments.remove(i);
                    }
                }
                ++indexOfArgs;
            }
            super.setArguments(arguments);
            indexOfArgs = 0;
            ArrayList<String> arrResourcePaths = new ArrayList<String>();
            while (indexOfArgs < arguments.size()) {
                String iShort = NameConfig.getOption(OptionName.INT_COLLS, true);
                String iLong = NameConfig.getOption(OptionName.INT_COLLS, false);
                String daShort = NameConfig.getOption(OptionName.INT_DISCARD_ACTIVE, true);
                String daLong = NameConfig.getOption(OptionName.INT_DISCARD_ACTIVE, false);
                int i = indexOfArgs;
                String currArg = (String)arguments.get(i);
                if (currArg != null) {
                    String lowerCaseArg = currArg.toLowerCase();
                    if (iShort.equals(lowerCaseArg) || iLong.equals(lowerCaseArg)) {
                        this._integrateCollisions = true;
                        arguments.remove(i);
                        --indexOfArgs;
                    } else if (daShort.equals(currArg) || daLong.equals(lowerCaseArg)) {
                        this._discardActive = true;
                        arguments.remove(i);
                        --indexOfArgs;
                    } else if (!currArg.startsWith("-")) {
                        if (currArg.lastIndexOf(42) > currArg.lastIndexOf(File.separatorChar)) {
                            String[] arrPaths = this.getResourcesForWildCardArgument(currArg);
                            int j = 0;
                            while (j < arrPaths.length) {
                                arrResourcePaths.add(arrPaths[j]);
                                ++j;
                            }
                        } else {
                            arrResourcePaths.add(currArg);
                        }
                        arguments.remove(i);
                        --indexOfArgs;
                    }
                }
                ++indexOfArgs;
            }
            if (arrResourcePaths.size() > 0) {
                this._resourcePaths = new String[arrResourcePaths.size()];
                arrResourcePaths.toArray(this._resourcePaths);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

