/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ReopenWSCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ReopenWSCommand == null ? (class$com$tssap$dtr$client$commandline$ReopenWSCommand = ReopenWSCommand.class$("com.tssap.dtr.client.commandline.ReopenWSCommand")) : class$com$tssap$dtr$client$commandline$ReopenWSCommand));
    private boolean _forceReopenWorkspace = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ReopenWSCommand;

    public ReopenWSCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Re-opens the given workspace for editing";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            String resourceID = null;
            IVfsFolderItem folderItem = this.getResource(this._workspacePaths[0]);
            if (folderItem == null) {
                Command.getOut().println("Could not retrive folder item " + this._workspacePaths[0]);
                return false;
            }
            IVfsWorkspace workspace = folderItem.asWorkspace();
            if (workspace == null) {
                Command.getOut().println("Folder item " + this._workspacePaths[0] + " is not a workspace ");
                return false;
            }
            try {
                resourceID = workspace.getObjectID();
            }
            catch (VfsException ex) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VfsException occured during retrieving workspaceID.");
                this.writeMessage("Could not retrieve workspaceID. " + ex.getMessage());
            }
            this.openVersionSet("/nonvresbyid/" + resourceID);
            this.writeMessage("Reopened \"" + this._workspacePaths[0] + "\"");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException occured during reopening of workspace.");
            this.writeMessage("Could not reopen workspace \"" + this._workspacePaths[0] + "\". " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException occured during reopening of workspace.");
            this.writeMessage("Could not reopen workspace. " + ex.getMessage());
        }
        return retVal;
    }

    public boolean validateArguments() {
        boolean validateArguments = true;
        if (this._workspacePaths.length != 1 || this._workspacePaths.length == 1 && this._workspacePaths[0].trim().length() == 0) {
            this.writeMessage("Must specify workspace path.");
            validateArguments = false;
        }
        if (this._description.trim().length() == 0) {
            this.writeMessage("Must specify a reason for re-opening the workspace.");
            validateArguments = false;
        }
        if (!validateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return validateArguments;
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.REOPENWS, false) + " " + NameConfig.getOption(OptionName.WORKSPACE, true) + " \"workspace path\" " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"comments\" [ " + NameConfig.getOption(OptionName.FORCE, true) + " ]");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "reopens the given workspace.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace path of the workspace that needs to be reopened.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.COMMENTS, 1, "A short note specifying why the action was performed.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.FORCE, 1, "If this option is specified then the workspace will re-opened even if the workspace is not owned.", true);
        this.printOptionHelp(null, 5, "Re-opening a workspace that is not owned will result in the workspace being modifiable in more than one repository and will cause severe problems if they connected in the same landscape.", true);
        this.writeMessage("");
    }

    public CommandName getCommandName() {
        return CommandName.REOPENWS;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ReopenWSCommand(arguments);
    }

    protected void openVersionSet(String url) throws PropagationException {
        this._propManager.reopenWorkspace(this.removeLeadingSlash(url), this._forceReopenWorkspace, this._description);
    }

    public void setArguments(ArrayList arguments) {
        String forceShortOptionName = NameConfig.getOption(OptionName.FORCE, true);
        String forceLongOptName = NameConfig.getOption(OptionName.FORCE, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null || forceShortOptionName.compareToIgnoreCase(currentArg) != 0 && forceLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._forceReopenWorkspace = true;
        }
        super.setArguments(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

