/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.ArrayList;

class RemoveCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$RemoveCommand == null ? (class$com$tssap$dtr$client$commandline$RemoveCommand = RemoveCommand.class$("com.tssap.dtr.client.commandline.RemoveCommand")) : class$com$tssap$dtr$client$commandline$RemoveCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$RemoveCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new RemoveCommand(arguments);
    }

    RemoveCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "removes the file/folder from the local file system";
    }

    public CommandName getCommandName() {
        return CommandName.REMOVE;
    }

    public boolean execute() {
        int i = 0;
        while (i < this._resourcePaths.length) {
            if (this._resourcePaths[i] != null) {
                IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                if (folderItem == null) {
                    Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                } else {
                    try {
                        VfsFolderItemLocationState locationState = folderItem.getLocationState();
                        if (VfsFolderItemLocationState.SYNCED_TO_FORMER == locationState || VfsFolderItemLocationState.SYNCED_TO_LATEST == locationState || VfsFolderItemLocationState.MOUNTED == locationState || VfsFolderItemLocationState.PARTLY_MOUNTED == locationState) {
                            folderItem.removeFromClient();
                        } else {
                            String mes = "";
                            if (folderItem.asActivityRecordedFolderItem() != null && folderItem.asActivityRecordedFolderItem().getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                                mes = "Folder item is checked out. ";
                            } else if (folderItem.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                                mes = "Folder item is not present locally. ";
                            } else if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                                mes = "Folder item is not mounted. ";
                            } else if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                                mes = "Folder item is local only. ";
                            }
                            Command.getOut().println(mes + "Cannot remove folder item " + this._resourcePaths[i] + " from client");
                            this._exitCode = 16;
                        }
                    }
                    catch (VfsException exp) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while removing folder item " + this._resourcePaths[i]);
                        Command.getOut().println("Could not remove folder item " + this._resourcePaths[i] + " from client" + exp.getMessage());
                        this._exitCode = 17;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.REMOVE, false) + " FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Removes the specified folder item from the local file system", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "NOTE: If a folder item is writable then it will not be removed and a warning will be given to say that the writable file cant be clobbered", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Any non empty folder due to the above would also be not removed from the file system", false);
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

