/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.factory.PropertyFactoryAccess;
import com.tssap.dtr.client.lib.deltavlib.factory.ResourceFactoryManager;
import com.tssap.dtr.client.lib.deltavlib.properties.IElement;
import com.tssap.dtr.client.lib.deltavlib.properties.IMutableProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.IProperty;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixBindingException;
import com.tssap.dtr.client.lib.deltavlib.properties.NSPrefixToUriMap;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import java.util.ArrayList;

class PropertyCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$PropertyCommand == null ? (class$com$tssap$dtr$client$commandline$PropertyCommand = PropertyCommand.class$("com.tssap.dtr.client.commandline.PropertyCommand")) : class$com$tssap$dtr$client$commandline$PropertyCommand));
    private static final int NO_PROPERTY = 0;
    private static final int GET_PROPERTY = 1;
    private static final int REMOVE_PROPERTY = 2;
    private static final int SET_PROPERTY = 3;
    private int _actionSpecified;
    private String _propertyName;
    private String _propertyValue;
    private boolean _showAllProps;
    private String _nsURI;
    private boolean _register;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$PropertyCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new PropertyCommand(arguments);
    }

    PropertyCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.ALL);
        this.addSupportedOption(OptionName.PROP_GET);
        this.addSupportedOption(OptionName.PROP_NAME);
        this.addSupportedOption(OptionName.PROP_REGISTER);
        this.addSupportedOption(OptionName.PROP_REMOVE);
        this.addSupportedOption(OptionName.PROP_SET);
        this.addSupportedOption(OptionName.PROP_VALUE);
        this.addSupportedOption(OptionName.NURI);
        this._actionSpecified = 0;
        this._propertyName = "";
        this._propertyValue = "";
        this._nsURI = "";
        this._showAllProps = false;
        this._register = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "adds/sets/removes/gets properties for non-versioned resources";
    }

    public CommandName getCommandName() {
        return CommandName.PROPERTY;
    }

    /*
     * Unable to fully structure code
     */
    public boolean execute() {
        retVal = true;
        i = 0;
        while (i < this._resourcePaths.length) {
            block83: {
                block84: {
                    if (this._resourcePaths[i].startsWith("URL:")) break block84;
                    folderItem = this.getResource(this._resourcePaths[i]);
                    if (folderItem == null) break block83;
                    if (!this._showAllProps) {
                        nsPrefix = this._propertyName.substring(0, this._propertyName.indexOf(58));
                        if (this.getFileSystemManager().getPrefixForNamespaceUri(this._nsURI) == null || !this.getFileSystemManager().getPrefixForNamespaceUri(this._nsURI).equals(nsPrefix)) {
                            if (!this._register) {
                                Command.getOut().println("Namespace " + this._nsURI + " is not registered.");
                                this._exitCode = 84;
                                return false;
                            }
                            try {
                                this.getFileSystemManager().registerNamespace(nsPrefix, this._nsURI);
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VfsException occurred while registering namespace: prefix '" + nsPrefix + "', uri '" + this._nsURI + "'");
                                Command.getOut().println("Register namespace failed: prefix '" + nsPrefix + "', uri '" + this._nsURI + "'");
                                this._exitCode = 85;
                            }
                        }
                    }
                    switch (this._actionSpecified) {
                        case 1: {
                            if (!this._showAllProps) ** GOTO lbl39
                            try {
                                properties = folderItem.getAllProperties();
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VfsException occurred while getting all properties" + this._propertyName);
                                Command.getOut().println("Could not get the properties. " + e.getMessage());
                                this._exitCode = 53;
                                break;
                            }
                            j = 0;
                            while (j < properties.length) {
                                this.displayProperty(properties[j], "");
                                Command.getOut().println();
                                ++j;
                            }
                            break block83;
lbl39:
                            // 1 sources

                            try {
                                property = folderItem.getProperty(this._propertyName);
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VfsException occurred while getting property" + this._propertyName + ". Could be because of user error too.");
                                Command.getOut().println("Could not get the property " + this._propertyName + ". " + e.getMessage());
                                this._exitCode = 53;
                                break;
                            }
                            if (property != null) {
                                this.displayProperty(property, "");
                            } else {
                                Command.getOut().println("Could not get the property " + this._propertyName + ".");
                                this._exitCode = 53;
                                retVal = false;
                            }
                            Command.getOut().println();
                            break;
                        }
                        case 3: {
                            try {
                                if (folderItem.asRoot() != null) {
                                    folderItem.asRoot().setProperty(this._propertyName, this._propertyValue);
                                    break;
                                }
                                if (folderItem.asWorkspace() != null) {
                                    folderItem.asWorkspace().setProperty(this._propertyName, this._propertyValue);
                                    break;
                                }
                                if (folderItem.asWorkspaceFolder() != null) {
                                    folderItem.asWorkspaceFolder().setProperty(this._propertyName, this._propertyValue);
                                    break;
                                }
                                if (folderItem.asActivityRecordedFolderItem() != null) {
                                    actRecFI = folderItem.asActivityRecordedFolderItem();
                                    activity = null;
                                    if (actRecFI.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                                        if (this._activityName != null && !"".equals(this._activityName)) {
                                            activity = this.getOrCreateActivity(folderItem.asActivityRecordedFolderItem().getWorkspace());
                                        } else {
                                            if (this._useCurrentActivity) {
                                                activity = folderItem.asActivityRecordedFolderItem().getWorkspace().getCurrentActivity();
                                            }
                                            if (activity == null) {
                                                activity = folderItem.asActivityRecordedFolderItem().getWorkspace().getDefaultActivity();
                                            }
                                        }
                                    } else {
                                        activities = actRecFI.getOpenActivities();
                                        if (activities.length == 1) {
                                            activity = activities[0];
                                        } else if (activities.length == 0) {
                                            activity = null;
                                        } else {
                                            activity = this.getUserSelectedActivity(activities, this.getOutputDatePattern());
                                            if (activity == null) {
                                                Command.getOut().println("The operation has been canceled by you.");
                                            }
                                        }
                                        if (activity == null) {
                                            this._exitCode = 54;
                                            return false;
                                        }
                                    }
                                    folderItem.asActivityRecordedFolderItem().setProperty(this._propertyName, this._propertyValue, activity);
                                }
                                break block83;
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VfsException occurred while setting property " + this._propertyName + ". Could be because of user error too.");
                                Command.getOut().println("Could not set the property " + this._propertyName + ". " + e.getMessage());
                                this._exitCode = 54;
                                retVal = false;
                            }
                            break block83;
                        }
                        case 2: {
                            try {
                                if (folderItem.asRoot() != null) {
                                    folderItem.asRoot().removeProperty(this._propertyName);
                                    break;
                                }
                                if (folderItem.asWorkspace() != null) {
                                    folderItem.asWorkspace().removeProperty(this._propertyName);
                                    break;
                                }
                                if (folderItem.asWorkspaceFolder() != null) {
                                    folderItem.asWorkspaceFolder().removeProperty(this._propertyName);
                                    break;
                                }
                                if (folderItem.asActivityRecordedFolderItem() != null) {
                                    activity = null;
                                    if (this._activityName != null && !"".equals(this._activityName)) {
                                        activity = this.getOrCreateActivity(folderItem.asActivityRecordedFolderItem().getWorkspace());
                                    } else {
                                        if (this._useCurrentActivity) {
                                            activity = folderItem.asActivityRecordedFolderItem().getWorkspace().getCurrentActivity();
                                        }
                                        if (activity == null) {
                                            activity = folderItem.asActivityRecordedFolderItem().getWorkspace().getDefaultActivity();
                                        }
                                    }
                                    folderItem.asActivityRecordedFolderItem().removeProperty(this._propertyName, activity);
                                    break;
                                }
                                break block83;
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VfsException occurred while removing property " + this._propertyName + ". Could be because of user error too.");
                                Command.getOut().println("Could not remove the property " + this._propertyName + ". " + e.getMessage());
                                this._exitCode = 55;
                                retVal = false;
                            }
                        }
                    }
                    break block83;
                }
                resURL = this._resourcePaths[i].substring(4);
                remLoc = Command.getContext(this._clientName).getRemoteLocatorFromUrl(resURL);
                if (remLoc == null) {
                    Command.getOut().println("Could not find resource");
                    this._exitCode = 95;
                    return false;
                }
                factMgr = ResourceFactoryManager.getInstance();
                resFact = factMgr.getLocatorFactory();
                try {
                    dvResource = resFact.createResource(remLoc.getConnectionTemplateId(), remLoc.getAbsoluteRemotePath());
                }
                catch (VcmFailure e) {
                    if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                        Logger.traceUserError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting resource " + resURL);
                    } else {
                        Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting resource " + resURL);
                    }
                    Command.getOut().println("Could not find resource. " + e.getMessage());
                    this._exitCode = 95;
                    return false;
                }
                dvImmutableProperty = null;
                if (!this._showAllProps) {
                    nsPrefix = this._propertyName.substring(0, this._propertyName.indexOf(58));
                    if (NSPrefixToUriMap.getPrefixForUri((String)this._nsURI) == null || !NSPrefixToUriMap.getPrefixForUri((String)this._nsURI).equals(nsPrefix)) {
                        if (!this._register) {
                            Command.getOut().println("Namespace " + this._nsURI + " is not registered.");
                            this._exitCode = 84;
                            return false;
                        }
                        try {
                            NSPrefixToUriMap.bindPrefixToNamespace((String)nsPrefix, (String)this._nsURI);
                        }
                        catch (NSPrefixBindingException e) {
                            Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "NSPrefixBindingException occurred while registering namespace: prefix '" + nsPrefix + "', uri '" + this._nsURI + "'");
                            Command.getOut().println("Register namespace failed: prefix '" + nsPrefix + "', uri '" + this._nsURI + "'");
                            this._exitCode = 85;
                        }
                    }
                }
                switch (this._actionSpecified) {
                    case 1: {
                        if (!this._showAllProps) {
                            try {
                                dvImmutableProperty = dvResource.getProperty(this._propertyName);
                            }
                            catch (VcmFailure e) {
                                if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                                    Logger.traceUserError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting property " + this._propertyName);
                                } else {
                                    Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting property " + this._propertyName);
                                }
                                Command.getOut().println("Could not get the property " + this._propertyName + ". " + e.getMessage());
                                this._exitCode = 53;
                                retVal = false;
                                break;
                            }
                            if (dvImmutableProperty == null) {
                                Command.getOut().println("Could not get the property " + this._propertyName + ".");
                                this._exitCode = 53;
                                retVal = false;
                                break;
                            }
                            this.displayProperty(dvImmutableProperty, "");
                            break;
                        }
                        try {
                            properties = dvResource.getPropertySet(dvResource.getPropertyNames());
                        }
                        catch (VcmFailure e) {
                            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                                Logger.traceUserError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting properties");
                            } else {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting properties");
                            }
                            Command.getOut().println("Could not get the properties. " + e.getMessage());
                            this._exitCode = 53;
                            retVal = false;
                            break;
                        }
                        j = 0;
                        while (j < properties.length) {
                            this.displayProperty(properties[j], "");
                            ++j;
                        }
                        break;
                    }
                    case 3: {
                        nsPrefix = this._propertyName.substring(0, this._propertyName.indexOf(58));
                        try {
                            dvImmutableProperty = dvResource.getProperty(this._propertyName);
                        }
                        catch (VcmFailure e) {
                            if (e.getStatusCode() == 404) ** GOTO lbl212
                            Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure occurred while getting property " + this._propertyName + " on resource " + resURL);
                        }
lbl212:
                        // 3 sources

                        dvProperty = dvImmutableProperty == null || dvImmutableProperty instanceof IMutableProperty == false ? PropertyFactoryAccess.getFactory().createProperty(nsPrefix, this._propertyName.substring(this._propertyName.indexOf(58) + 1)) : (IMutableProperty)dvImmutableProperty;
                        dvProperty.setValue(this._propertyValue);
                        try {
                            dvResource.setProperties(new IProperty[]{dvProperty});
                        }
                        catch (VcmFailure e) {
                            if (e.getStatusCode() == 404) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure while setting property " + this._propertyName + ". Creation tried earlier must have failed.");
                                cause = "Property ( name '" + this._propertyName + "', value '" + this._propertyValue + "' ) was not found";
                            } else if (e.getStatusCode() == 403) {
                                Logger.traceUserError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure while setting property " + this._propertyName);
                                cause = "Not allowed to change/add the property ( name '" + this._propertyName + "', value '" + this._propertyValue + "' )";
                            } else {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure while setting property " + this._propertyName);
                                cause = e.getMessage();
                            }
                            Command.getOut().println("Could not set the property " + this._propertyName + ". " + cause);
                            this._exitCode = 54;
                            retVal = false;
                        }
                        break;
                    }
                    case 2: {
                        try {
                            dvResource.removeProperties(new String[]{this._propertyName});
                            break;
                        }
                        catch (VcmFailure e) {
                            if (e.getStatusCode() != 404) {
                                Logger.traceInternalError(PropertyCommand.LOCATION, (Exception)e, "VcmFailure while removing property " + this._propertyName);
                            }
                            Command.getOut().println("Could not remove the property " + this._propertyName + ". " + e.getMessage());
                            this._exitCode = 55;
                            retVal = false;
                        }
                    }
                }
            }
            ++i;
        }
        return retVal;
    }

    public boolean validateArguments() {
        if (this._resourcePaths == null || this._resourcePaths.length == 0) {
            return false;
        }
        if ("".equals(this._propertyName) && !this._showAllProps || this._actionSpecified == 3 && "".equals(this._propertyValue)) {
            Command.getOut().println("Property Name or Value is not specified. Please try again.");
            return false;
        }
        if (!this._propertyName.equals("")) {
            int indexOfColon = this._propertyName.indexOf(58);
            if (indexOfColon < 0) {
                Command.getOut().println("Property Name is not specified correctly. Please try again.");
                return false;
            }
            String nsPrefix = this._propertyName.substring(0, this._propertyName.indexOf(58));
            if (nsPrefix.equals(XCM.NAMESPACE_PREFIX)) {
                this._nsURI = XCM.NAMESPACE_URI;
            } else if (nsPrefix.equals("DAV")) {
                this._nsURI = "DAV:";
            }
        }
        if (this._showAllProps && this._actionSpecified != 1 || !this._showAllProps && this._nsURI.equals("")) {
            Command.getOut().println("The options are not correctly specified. Please refer to help for correct specification of options.");
            return false;
        }
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.PROPERTY, false) + " resourcePaths... " + NameConfig.getOption(OptionName.PROP_NAME, true) + " propertyName [ " + NameConfig.getOption(OptionName.PROP_SET, true) + " [" + NameConfig.getOption(OptionName.PROP_VALUE, true) + " propertyValue] " + NameConfig.getOption(OptionName.PROP_GET, true) + " [" + NameConfig.getOption(OptionName.ALL, true) + "] " + NameConfig.getOption(OptionName.PROP_REMOVE, true) + " " + NameConfig.getOption(OptionName.ACTIVITY, true) + " [ " + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + " ] ]");
        Command.getOut().println();
        Command.getOut().println("    Adds/Sets/Gets/Removes a property ");
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_SET, 1, "Adds/Sets(if property already exists) the property with the given name with the given value.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_GET, 1, "Displays the property and its value for the property with the given name.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ALL, 1, "If specified with " + NameConfig.getOption(OptionName.PROP_GET, true) + "/" + NameConfig.getOption(OptionName.PROP_GET, false) + " all properties are shown.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_REMOVE, 1, "Removes the property with the given name", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name of the activity to be used to check out the folder item in case it is activity recorded and is not already checked out. The activity will be created is it does not exist.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name. This is only in case to specify to use an already existing activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_NAME, 1, "To specify the name of the property", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_NAME, 1, "Property name should be specified in the following format", false);
        this.printOptionHelp(OptionName.PROP_NAME, 1, "namespacePrefix:name", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_NAME, 1, "Specifying the namespace is mandatory.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.NURI, 1, "To specify the namespace URI to be used to set/get/remove a property. If the namespace specified is not registered for the given prefix then set/get/remove will fail. In case you want to get all properties then properties for all registered namespaces are only shown.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_REGISTER, 1, "Registers the namespace URI if it is not already registered.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROP_VALUE, 1, "To specify the value of the property", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "In case " + NameConfig.getOption(OptionName.PROP_GET, true) + "/" + NameConfig.getOption(OptionName.PROP_REMOVE, true) + "/" + NameConfig.getOption(OptionName.PROP_SET, true) + " is not specified the default action is get(" + NameConfig.getOption(OptionName.PROP_GET, true) + ")", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If more than one resource is specified together then the other options will be applicable to each one of them", false);
        this.printOptionHelp(null, 1, "If the resource is not a folderitem then the URL of the resource should be specified", false);
        this.printOptionHelp(null, 1, "Example : URL:http://.....", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i;
            String currArg;
            if ((currArg = (String)arguments.get(i = indexOfArgs--)) != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String gShort = NameConfig.getOption(OptionName.PROP_GET, true);
                String gLong = NameConfig.getOption(OptionName.PROP_GET, false);
                String rShort = NameConfig.getOption(OptionName.PROP_REMOVE, true);
                String rLong = NameConfig.getOption(OptionName.PROP_REMOVE, false);
                String sShort = NameConfig.getOption(OptionName.PROP_SET, true);
                String sLong = NameConfig.getOption(OptionName.PROP_SET, false);
                String regShort = NameConfig.getOption(OptionName.PROP_REGISTER, true);
                String regLong = NameConfig.getOption(OptionName.PROP_REGISTER, false);
                String nShort = NameConfig.getOption(OptionName.PROP_NAME, true);
                String nLong = NameConfig.getOption(OptionName.PROP_NAME, false);
                String vShort = NameConfig.getOption(OptionName.PROP_VALUE, true);
                String vLong = NameConfig.getOption(OptionName.PROP_VALUE, false);
                String nsShort = NameConfig.getOption(OptionName.NURI, true);
                String nsLong = NameConfig.getOption(OptionName.NURI, false);
                String allLong = NameConfig.getOption(OptionName.ALL, false);
                if (gShort.equals(lowerCaseArg) || gLong.equals(lowerCaseArg)) {
                    if (this._actionSpecified == 0) {
                        this._actionSpecified = 1;
                        arguments.remove(i);
                        --indexOfArgs;
                    }
                } else if (rShort.equals(currArg) || rLong.equals(lowerCaseArg)) {
                    if (this._actionSpecified == 0) {
                        this._actionSpecified = 2;
                        arguments.remove(i);
                        --indexOfArgs;
                    }
                } else if (sShort.equals(currArg) || sLong.equals(lowerCaseArg)) {
                    if (this._actionSpecified == 0) {
                        this._actionSpecified = 3;
                        arguments.remove(i);
                        --indexOfArgs;
                    }
                } else if (regShort.equals(currArg) || regLong.equals(lowerCaseArg)) {
                    this._register = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(nShort) || lowerCaseArg.startsWith(nLong)) {
                    String propName = Command.getActualArgument(currArg, nShort, nLong);
                    if ("".equals(propName) && i + 1 < arguments.size()) {
                        propName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._propertyName = propName;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(nsShort) || lowerCaseArg.startsWith(nsLong)) {
                    String nsURI = Command.getActualArgument(currArg, nsShort, nsLong);
                    if ("".equals(nsURI) && i + 1 < arguments.size()) {
                        nsURI = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._nsURI = nsURI;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(vShort) || lowerCaseArg.startsWith(vLong)) {
                    String propValue = Command.getActualArgument(currArg, vShort, vLong);
                    if ("".equals(propValue) && i + 1 < arguments.size()) {
                        propValue = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._propertyValue = propValue;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (allLong.equalsIgnoreCase(currArg)) {
                    this._showAllProps = true;
                    arguments.remove(i);
                }
            }
            ++indexOfArgs;
        }
        if (this._actionSpecified == 0) {
            this._actionSpecified = 1;
        }
        super.setArguments(arguments);
    }

    private void displayProperty(IVfsProperty property, String indent) {
        Command.getOut().println(indent + property.getNamespace() + ":" + property.getName() + " : " + property.getValue());
        IVfsProperty[] properties = property.getChildren();
        if (properties.length > 0) {
            int i = 0;
            while (i < properties.length) {
                this.displayProperty(properties[i], indent + "    ");
                ++i;
            }
        }
    }

    private void displayProperty(IProperty property, String indent) {
        Command.getOut().println(indent + property.getNamespace() + ":" + property.getName() + " : " + property.getValue());
        ArrayList<IElement> children = new ArrayList<IElement>();
        IElement child = property.getFirstChild();
        while (child != null) {
            children.add(child);
            child = child.getNext();
        }
        if (children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                this.displayProperty((IElement)children.get(i), indent + "    ");
                ++i;
            }
        }
    }

    private void displayProperty(IElement property, String indent) {
        Command.getOut().println(indent + property.getNamespace() + ":" + property.getName() + " : " + property.getValue());
        ArrayList<IElement> children = new ArrayList<IElement>();
        IElement child = property.getFirstChild();
        while (child != null) {
            children.add(child);
            child = child.getNext();
        }
        if (children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                this.displayProperty((IElement)children.get(i), indent + "    ");
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

