/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.propagation.PropagationManager;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public abstract class PropagationCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$PropagationCommand == null ? (class$com$tssap$dtr$client$commandline$PropagationCommand = PropagationCommand.class$("com.tssap.dtr.client.commandline.PropagationCommand")) : class$com$tssap$dtr$client$commandline$PropagationCommand));
    protected String _fileName;
    protected PropagationManager _propManager;
    protected String _resourcePath;
    protected static final String RESOURCE_OID = XCM.OID.localName;
    protected static final String RESOURCE_PATH = XCM.PATH.localName;
    protected static final String VERSION_SET_STATE = XCM.VERSION_SET_STATE.localName;
    protected static final String VERSION_SET_STATE_OPEN = "open";
    protected static final String VERSION_SET_STATE_CLOSED = "closed";
    protected static final String PROPLIST_BASE_URL = "/prop/";
    protected static final String NONVRESBYID_BASE_URL = "/nonvresbyid/";
    protected String _currentUserName;
    protected static final String MAX_REQUEST_CONTENT_LENGTH = "max-request-content-length";
    private static Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$PropagationCommand;

    public PropagationCommand(ArrayList arguments) {
        super(arguments);
    }

    protected boolean initializePropagationManager() {
        try {
            IVersionedFileSystemManager vfsManager = this.getFileSystemManager();
            if (vfsManager != null && this._propManager == null) {
                String url = this.getFileSystemManager().getRootFolder().getUrl();
                IVfsRemoteLocator locator = this.getActiveContext().getRemoteLocatorFromUrl(url);
                if (locator != null) {
                    int connectionTemplateId = locator.getConnectionTemplateId();
                    IConnectionTemplate template = Command.getConnectionTemplate(connectionTemplateId);
                    this._propManager = new PropagationManager(template);
                }
            }
        }
        catch (InvalidTemplateIDException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "InvalidTemplateIDException occurred while initializing propagation manager.");
        }
        catch (VfsException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VfsException occurred while initializing propagation manager.");
        }
        return this._propManager != null;
    }

    protected boolean pingServer() {
        return this.getFileSystemManager() != null;
    }

    protected void writeMessage(String message) {
        Command.getOut().println(message);
    }

    public boolean validateArguments() {
        boolean isValidArguments = true;
        if (this._resourcePath == null) {
            isValidArguments = false;
        }
        if (this._fileName != null) {
            File file = new File(this._fileName);
            File fullPathFile = new File(file.getAbsolutePath());
            isValidArguments = false;
            if (fullPathFile.getParentFile() != null) {
                isValidArguments = fullPathFile.getParentFile().exists();
            }
        }
        return isValidArguments;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        this.setSuperArguments(arguments);
        String fileShortOptName = NameConfig.getOption(OptionName.EXPORTFILE, true);
        String fileLongOptName = NameConfig.getOption(OptionName.EXPORTFILE, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (!currentArg.startsWith("-")) {
                if (this._resourcePath != null) continue;
                this._resourcePath = currentArg;
                listIterator.remove();
                continue;
            }
            if (fileShortOptName.compareToIgnoreCase(currentArg) != 0 && fileLongOptName.compareToIgnoreCase(currentArg) != 0 || !listIterator.hasNext()) continue;
            listIterator.remove();
            this._fileName = (String)listIterator.next();
            listIterator.remove();
        }
    }

    protected final void setSuperArguments(ArrayList arguments) {
        super.setArguments(arguments);
    }

    protected String getPath(String resourceID) throws PropagationException {
        if (!resourceID.startsWith(NONVRESBYID_BASE_URL)) {
            resourceID = NONVRESBYID_BASE_URL + resourceID;
        }
        String remotePath = this._propManager.getProperty(this.removeLeadingSlash(resourceID), RESOURCE_PATH);
        return remotePath;
    }

    protected String getResourceID() throws PropagationException {
        String resourceID = this._resourcePath.startsWith(NONVRESBYID_BASE_URL) ? this._resourcePath.substring(this._resourcePath.lastIndexOf("/") + 1) : this._propManager.getProperty(this.removeLeadingSlash(this._resourcePath), RESOURCE_OID);
        return resourceID;
    }

    protected synchronized String getFormattedTimestamp() {
        String sec;
        String min;
        String hour;
        String date;
        gmtCalendar.setTime(new Date(System.currentTimeMillis()));
        String year = String.valueOf(gmtCalendar.get(1));
        String month = String.valueOf(gmtCalendar.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((date = String.valueOf(gmtCalendar.get(5))).length() == 1) {
            date = "0" + date;
        }
        if ((hour = String.valueOf(gmtCalendar.get(11))).length() == 1) {
            hour = "0" + hour;
        }
        if ((min = String.valueOf(gmtCalendar.get(12))).length() == 1) {
            min = "0" + min;
        }
        if ((sec = String.valueOf(gmtCalendar.get(13))).length() == 1) {
            sec = "0" + sec;
        }
        return year + "_" + month + "_" + date + "_" + hour + "_" + min + "_" + sec + "_GMT";
    }

    protected void setDisplayName(String url, String displayName) throws PropagationException {
        this._propManager.setProperty(this.removeLeadingSlash(url), "DAV:", DAV.DISPLAYNAME.localName, displayName, "DAV:");
    }

    protected void closeVersionSet(String url) throws PropagationException {
        this._propManager.setProperty(this.removeLeadingSlash(url), VERSION_SET_STATE, VERSION_SET_STATE_CLOSED);
    }

    protected void openVersionSet(String url) throws PropagationException {
        this._propManager.setProperty(this.removeLeadingSlash(url), VERSION_SET_STATE, VERSION_SET_STATE_OPEN);
    }

    protected String removeLeadingSlash(String resourcePath) {
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    protected final IResponse performRequest(IRequest request) throws VcmFailure {
        IResponse response = null;
        IVersionedFileSystemManager vfsManager = this.getFileSystemManager();
        if (vfsManager != null) {
            response = DeltavCommand.execute((int)Command.getConnectionTemplateId((IVfsFolderItem)vfsManager.getRootFolder()), (IRequest)request);
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

