/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.Commands;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.ICommands;
import com.tssap.dtr.client.commandline.OptionName;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class NameConfig {
    private static final String NS = "com.tssap.dtr.client.commandline";
    private static final String OPTION = "option";
    private static final String COMMAND = "command";
    private static final String SHORT = "short";
    private static boolean _checkedDuplicatesCommandNames = false;
    private static boolean _commandNamesValid = true;
    private static boolean _checkedDuplicatesOptionNames = false;
    private static boolean _optionNamesValid = true;

    public static String getOption(OptionName option, boolean getShort) {
        String retVal = "";
        Properties names = CommandlineProperties.getProperties();
        if (_optionNamesValid && names != null) {
            if (!_checkedDuplicatesOptionNames) {
                _optionNamesValid = NameConfig.checkDuplicateOptions();
            }
            if (_optionNamesValid) {
                retVal = !getShort ? names.getProperty("com.tssap.dtr.client.commandline.option." + option.getIdentifier()) : names.getProperty("com.tssap.dtr.client.commandline.option.short." + option.getIdentifier());
            }
        }
        if (retVal == null || retVal.equals("")) {
            retVal = !getShort ? option.getName() : option.getShortName();
        }
        return retVal;
    }

    public static String getCommandName(CommandName commandName, boolean getShort) {
        String retVal = "";
        Properties names = CommandlineProperties.getProperties();
        if (_commandNamesValid && names != null) {
            if (!_checkedDuplicatesCommandNames) {
                _commandNamesValid = NameConfig.checkDuplicatesCommands();
            }
            if (_commandNamesValid) {
                retVal = !getShort ? names.getProperty("com.tssap.dtr.client.commandline.command." + commandName.getIdentifier()) : names.getProperty("com.tssap.dtr.client.commandline.command.short." + commandName.getIdentifier());
            }
        }
        if (retVal == null || retVal.equals("")) {
            retVal = !getShort ? commandName.getName() : commandName.getShortName();
        }
        return retVal;
    }

    private static boolean checkDuplicatesCommands() {
        _checkedDuplicatesCommandNames = true;
        Iterator it = CommandName._commandnamesColl.iterator();
        HashSet<String> tempNamesSet = new HashSet<String>();
        while (it.hasNext()) {
            CommandName name = (CommandName)it.next();
            int initialSize = tempNamesSet.size();
            tempNamesSet.add(NameConfig.getCommandName(name, false));
            if (initialSize == tempNamesSet.size()) {
                DTRClient.getOut().println("Command name " + NameConfig.getCommandName(name, false) + "(" + NS + "." + COMMAND + "." + name.getIdentifier() + ")" + " has been used for more than one command. Default names will be used");
                return false;
            }
            if (NameConfig.getCommandName(name, true).equals("")) continue;
            tempNamesSet.add(NameConfig.getCommandName(name, true));
            if (initialSize != tempNamesSet.size()) continue;
            DTRClient.getOut().println("Short command name " + NameConfig.getCommandName(name, true) + "(" + NS + "." + COMMAND + "." + SHORT + "." + name.getIdentifier() + ")" + " has been used for more than one command. Default names will be used");
            return false;
        }
        return true;
    }

    private static boolean checkDuplicateOptions() {
        _checkedDuplicatesOptionNames = true;
        ICommands commands = Commands.getCommands();
        Iterator it = commands.getAllCommands().iterator();
        while (it.hasNext()) {
            ICommand com = (ICommand)it.next();
            Iterator innerIt = com.getSupportedOptions().iterator();
            HashSet<String> tempOptionsSet = new HashSet<String>();
            while (innerIt.hasNext()) {
                OptionName name = (OptionName)innerIt.next();
                int initialSize = tempOptionsSet.size();
                tempOptionsSet.add(NameConfig.getOption(name, false));
                if (initialSize == tempOptionsSet.size()) {
                    DTRClient.getOut().println("Option " + NameConfig.getOption(name, false) + "(" + NS + "." + OPTION + "." + name.getIdentifier() + ")" + " has been used for more than one options in the same command. Default names will be used");
                    return false;
                }
                initialSize = tempOptionsSet.size();
                if (NameConfig.getOption(name, true).equals("")) continue;
                tempOptionsSet.add(NameConfig.getOption(name, true));
                if (initialSize != tempOptionsSet.size()) continue;
                DTRClient.getOut().println("Short option " + NameConfig.getOption(name, true) + "(" + NS + "." + OPTION + "." + SHORT + "." + name.getIdentifier() + ")" + " has been used for more than one options in the same command. Default names will be used");
                return false;
            }
            tempOptionsSet = null;
        }
        return true;
    }
}

