/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import java.util.ArrayList;
import java.util.Arrays;

public class MoveCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$MoveCommand == null ? (class$com$tssap$dtr$client$commandline$MoveCommand = MoveCommand.class$("com.tssap.dtr.client.commandline.MoveCommand")) : class$com$tssap$dtr$client$commandline$MoveCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$MoveCommand;

    public MoveCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public CommandName getCommandName() {
        return CommandName.MOVE;
    }

    public String getDescription() {
        return "moves a file/folder which is checked out to the given activity";
    }

    public boolean execute() {
        IVfsWorkspace workspace = null;
        IVfsActivity sourceActivity = null;
        IVfsActivity targetActivity = null;
        String wsBrowsePath = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            block36: {
                IVfsActivityRecordedFolderItem activityRecordedFolderItem;
                block35: {
                    IVfsFolderItem folderItem;
                    block39: {
                        block38: {
                            block37: {
                                if (this._resourcePaths[i] == null) break block36;
                                folderItem = this.getResource(this._resourcePaths[i]);
                                if (folderItem != null) break block37;
                                Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                                this._exitCode = 5;
                                break block36;
                            }
                            activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                            if (activityRecordedFolderItem != null) break block38;
                            this._exitCode = 88;
                            break block36;
                        }
                        VfsActionOnFolderItem[] actionsPoss = activityRecordedFolderItem.getActionsForCurrentState();
                        if (!Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.MOVE_INTO_ACTIVITY)) {
                            String mes = "";
                            if (activityRecordedFolderItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                                mes = "Folder item is not checked out. ";
                            }
                            Command.getOut().println(mes + "Cannot move : " + this._resourcePaths[i]);
                            this._exitCode = 92;
                        }
                        if (workspace != null) break block39;
                        if (activityRecordedFolderItem != null) {
                            workspace = activityRecordedFolderItem.getWorkspace();
                        }
                        if (workspace != null) break block35;
                        Command.getOut().println("Could not retrive workspace for folder item " + this._resourcePaths[i]);
                        this._exitCode = 22;
                        break block36;
                    }
                    try {
                        if (!folderItem.getBrowsePath().startsWith(wsBrowsePath)) {
                            Command.getOut().println("Folder item " + folderItem.getBrowsePath() + " does not belong to the workspace " + wsBrowsePath);
                            this._exitCode = 23;
                        }
                        break block35;
                    }
                    catch (VfsException exp) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred. Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                        Command.getOut().println("Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                    }
                    break block36;
                }
                try {
                    wsBrowsePath = workspace.getBrowsePath();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during getting workspace browse path.");
                    return false;
                }
                if (sourceActivity == null || targetActivity == null) {
                    IVfsActivity[] acts;
                    if (this._activityNames.length == 2) {
                        this._activityName = this._activityNames[0];
                        if (this._workspacePaths == null) {
                            this._workspacePaths = new String[1];
                        }
                        this._workspacePaths[0] = "/" + wsBrowsePath;
                        sourceActivity = this.getActivity(false, true);
                        acts = activityRecordedFolderItem.getOpenActivities();
                        if (sourceActivity == null && acts.length == 1) {
                            Command.getOut().println("Specified source activity not found. Correct source activity will be used");
                            sourceActivity = acts[0];
                        }
                        boolean found = false;
                        int j = 0;
                        while (j < acts.length) {
                            if (sourceActivity == acts[j]) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            if (acts.length == 1) {
                                Command.getOut().println("Specified folderitem does not belong to specified source activity. Correct source activity will be used");
                                sourceActivity = acts[0];
                            } else {
                                Command.getOut().println("Specified folderitem does not belong to specified source activity. Correct source activity could not be found");
                                sourceActivity = null;
                            }
                        }
                        if (sourceActivity != null) {
                            this._activityName = this._activityNames[1];
                            targetActivity = this.getActivity(false, true);
                        }
                    } else if (this._activityNames.length == 1) {
                        acts = activityRecordedFolderItem.getOpenActivities();
                        if (acts.length != 1) {
                            Command.getOut().println("Source activity not specified. Correct source activity could not be found");
                        } else {
                            sourceActivity = acts[0];
                        }
                        if (sourceActivity != null) {
                            this._activityName = this._activityNames[0];
                            if (this._workspacePaths == null) {
                                this._workspacePaths = new String[1];
                            }
                            this._workspacePaths[0] = "/" + wsBrowsePath;
                            targetActivity = this.getActivity(false, true);
                        }
                    } else {
                        acts = activityRecordedFolderItem.getOpenActivities();
                        if (acts.length != 1) {
                            Command.getOut().println("Source activity not specified. Correct source activity could not be found");
                        } else {
                            sourceActivity = acts[0];
                        }
                        if (sourceActivity != null) {
                            try {
                                targetActivity = this.getOrCreateActivity(workspace);
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred. Activity get/create failed.");
                                this._exitCode = 35;
                                Command.getOut().println("Activity get/create failed. " + e.getMessage());
                                return false;
                            }
                        }
                    }
                    if (sourceActivity == null || targetActivity == null) {
                        Command.getOut().println("Source/Target activity could not be retrieved/created");
                        this._exitCode = 32;
                        return false;
                    }
                    if (sourceActivity.getName().equals(targetActivity)) {
                        Command.getOut().println("Source & Target activities are the same");
                        this._exitCode = 91;
                        return false;
                    }
                }
                try {
                    activityRecordedFolderItem.move(sourceActivity, targetActivity);
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during moving folder item " + this._resourcePaths[i]);
                    Command.getOut().println("Could not move : " + this._resourcePaths[i] + ".");
                    this._exitCode = 93;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.MOVE, false) + " FolderItempath... [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " sourceActivityName ] " + NameConfig.getOption(OptionName.ACTIVITY, true) + " targetActivityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Move a file/folder checked out in source activity to the target activity", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument.Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "To specify the source activtiy where the file/folder(s) is checked out and the target activity to which they have to be moved. If the source activity is not specified and the folderitem is not checked out or is checkedout in more than one activities then nothing is done. If source activity is specified but the folderitem is not checked out in the given activity then: a. If folderitem is checked out in only one activity then that is used as source. b. If folderitem is not checked out or is checkedout in more than one activities then nothing is done. If the target activity does not exist it will be created", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the names of the activity(s) is(are) the display name(s) and not the actual name(s)", true);
        Command.getOut().println();
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new MoveCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

