/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FieldDescriptor;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import java.util.ArrayList;

class MountPointsCommand
extends Command {
    private static final FieldDescriptor LOCAL_PATH = new FieldDescriptor(MountPointsCommand.getFieldLength("LocalPath", 40), "LocalPath", "LP");
    private static final FieldDescriptor REMOTE_PATH = new FieldDescriptor(MountPointsCommand.getFieldLength("RemotePath", 39), "RemotePath", "RP");
    private static final FieldDescriptor BROWSE_PATH = new FieldDescriptor(MountPointsCommand.getFieldLength("BrowsePath", 40), "BrowsePath", "BP");
    private static final String ALL = "All";
    private boolean _fieldsSpecifiedInArgs;
    private ArrayList _displayFiledsOrdered;
    private boolean _sortSpecified;
    private Field _sortField;
    private int _sortKeyType;
    private boolean _descendingOrder;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new MountPointsCommand(arguments);
    }

    MountPointsCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FIELD);
        this.addSupportedOption(OptionName.SORT);
        this.addSupportedOption(OptionName.UNFORMATTED);
        this.addSupportedOption(OptionName.DESCENDING);
        this._displayFiledsOrdered = new ArrayList();
        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, MountPointsCommand.LOCAL_PATH.fieldName));
        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, MountPointsCommand.REMOTE_PATH.fieldName));
        this._fieldsSpecifiedInArgs = false;
        this._sortField = null;
        this._sortSpecified = false;
        this._descendingOrder = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "displays the mountpoints";
    }

    public CommandName getCommandName() {
        return CommandName.MOUNTPOINTS;
    }

    public boolean execute() {
        IVfsContext context = Command.getContext(this._clientName);
        String[] mpLocalPaths = context.getAbsoluteLocalPathsOfMountPoints();
        if (mpLocalPaths.length > 0) {
            this.displayHeader(this._displayFiledsOrdered);
        } else {
            this._exitCode = 66;
            Command.getOut().println("None of the remote paths is mounted on the local file system.");
        }
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(this._sortField, this._sortKeyType);
        int i = 0;
        while (i < mpLocalPaths.length) {
            this.displayMP(mpLocalPaths[i], dh);
            ++i;
        }
        dh.endDisplay(this._descendingOrder);
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.MOUNTPOINTS, false) + " [ " + NameConfig.getOption(OptionName.FIELD, true) + "fieldname... ] ");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Lists the mountpoints", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Using this option you can specify the properties of the folder item(s) that have to be displayed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Example:", false);
        this.printOptionHelp(OptionName.FIELD, 1, NameConfig.getCommandName(CommandName.MOUNTPOINTS, false) + " " + NameConfig.getOption(OptionName.FIELD, true) + "Localpath " + NameConfig.getOption(OptionName.FIELD, true) + "BrowsePath", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "The fields that can be specified are:", false);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "LocalPath/LP", "Absolute local path of the mountpoint", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "RemotePath/RP", "Absolute local remote of the mountpoint", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "BrowsePath/BP", "Browse path of the mountpoint", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, ALL, "Prints all the above fields", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "For more information on the use of " + NameConfig.getOption(OptionName.FIELD, true) + " option see usage", false);
        this.printOptionHelp(OptionName.FIELD, 1, "dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " Usage", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SORT, 1, "Using this option you can specify the field based on which sorting of the output has to be done. The fields that can be specified are the ones listed above. Sorting is in ascending order by default", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DESCENDING, 1, "Specify this option along with sort to sort output in descending order.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "If this is specified then the field values will not be truncated to fit into a given space. But it might lead to output that is not easy to read.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "It is recommended that this be used only for scripting.", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String descShort = NameConfig.getOption(OptionName.DESCENDING, true);
            String descLong = NameConfig.getOption(OptionName.DESCENDING, false);
            String fShort = NameConfig.getOption(OptionName.FIELD, true);
            String fLong = NameConfig.getOption(OptionName.FIELD, false);
            String sShort = NameConfig.getOption(OptionName.SORT, true);
            String sLong = NameConfig.getOption(OptionName.SORT, false);
            String unShort = NameConfig.getOption(OptionName.UNFORMATTED, true);
            String unLong = NameConfig.getOption(OptionName.UNFORMATTED, false);
            if (currArg != null) {
                String fieldName;
                String lowerCaseArg = currArg.toLowerCase();
                if (lowerCaseArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    fieldName = Command.getActualArgument(currArg, fShort, fLong).toLowerCase();
                    if (!this._fieldsSpecifiedInArgs) {
                        this._displayFiledsOrdered = null;
                        this._displayFiledsOrdered = new ArrayList();
                        this._fieldsSpecifiedInArgs = true;
                    }
                    if (LOCAL_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                    } else if (REMOTE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                    } else if (BROWSE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                    } else if (fieldName.startsWith(ALL.toLowerCase())) {
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(sShort) || lowerCaseArg.startsWith(sLong)) {
                    fieldName = Command.getActualArgument(currArg, sShort, sLong).toLowerCase();
                    if (!this._sortSpecified) {
                        if (LOCAL_PATH.matches(fieldName)) {
                            this._sortField = new Field(LOCAL_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (REMOTE_PATH.matches(fieldName)) {
                            this._sortField = new Field(REMOTE_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (BROWSE_PATH.matches(fieldName)) {
                            this._sortField = new Field(BROWSE_PATH, fieldName);
                            this._sortKeyType = 1;
                        }
                        if (this._sortField != null) {
                            this._sortSpecified = true;
                        }
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (unShort.equals(currArg) || unLong.equals(lowerCaseArg)) {
                    this._unformattedOutput = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (descShort.equals(lowerCaseArg) || descLong.equals(lowerCaseArg)) {
                    this._descendingOrder = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (this._displayFiledsOrdered.size() == 0) {
            this._displayFiledsOrdered.add(new Field(LOCAL_PATH, MountPointsCommand.LOCAL_PATH.fieldName));
            this._displayFiledsOrdered.add(new Field(REMOTE_PATH, MountPointsCommand.REMOTE_PATH.fieldName));
        }
        if (this._sortSpecified) {
            boolean sortFieldAdded = false;
            int i = 0;
            while (i < this._displayFiledsOrdered.size()) {
                if (this._sortField.isIt(((Field)this._displayFiledsOrdered.get((int)i)).fieldName)) {
                    sortFieldAdded = true;
                    break;
                }
                ++i;
            }
            if (!sortFieldAdded) {
                this._displayFiledsOrdered.add(this._sortField);
            }
        } else {
            this._sortField = (Field)this._displayFiledsOrdered.get(0);
            this._sortKeyType = 1;
        }
    }

    private void displayMP(String localPath, DisplayHelper displayHelper) {
        IVfsContext context = Command.getContext(this._clientName);
        DisplayHelper.Row row = displayHelper.newRow();
        int k = 0;
        while (k < this._displayFiledsOrdered.size()) {
            IVfsRemoteLocator locator;
            Field field = (Field)this._displayFiledsOrdered.get(k);
            if (field.isIt(MountPointsCommand.LOCAL_PATH.fieldName)) {
                row.addField(field, localPath);
            } else if (field.isIt(MountPointsCommand.REMOTE_PATH.fieldName)) {
                locator = context.getRemoteLocator(localPath);
                String remotePath = locator.getAbsoluteRemotePath();
                if (remotePath == null) {
                    remotePath = "";
                }
                row.addField(field, remotePath);
            } else if (field.isIt(MountPointsCommand.BROWSE_PATH.fieldName)) {
                locator = context.getRemoteLocator(localPath);
                String browsePath = context.getBrowsePath(locator);
                if (browsePath == null) {
                    browsePath = "";
                }
                row.addField(field, "/" + browsePath);
            }
            ++k;
        }
        row.end();
    }

    private static int getFieldLength(String field, int defVal) {
        return CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.field.mountpoint." + field.toLowerCase(), defVal);
    }

    public boolean requiresLogon() {
        return false;
    }
}

