/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.Workspace;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagationSource;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class MakePropagationListCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$MakePropagationListCommand == null ? (class$com$tssap$dtr$client$commandline$MakePropagationListCommand = MakePropagationListCommand.class$("com.tssap.dtr.client.commandline.MakePropagationListCommand")) : class$com$tssap$dtr$client$commandline$MakePropagationListCommand));
    private static final String PROPAGATION_LIST_PREFIX = "prop";
    private static final String TIME_PREFIX = "_t_";
    private static final String WORKSPACE_PREFIX = "_w_";
    private static final String USER_PREFIX = "_u_";
    private String _propagationListName;
    private String _lowerISN;
    private String _upperISN;
    private Date _dateFrom;
    private Date _dateTo;
    private boolean _isDateRange = true;
    private boolean _isValidArguments = true;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$MakePropagationListCommand;

    public MakePropagationListCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.INDRANGE);
        this.addSupportedOption(OptionName.PROPAGATION_LIST);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Creates, populates and closes the propagation list.";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            IVfsWorkspace workspace;
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            IVfsFolderItem workspaceFolderItem = this.getResource(this._workspacePaths[0]);
            if (workspaceFolderItem == null) {
                Command.getOut().println("Could not retrive folder item " + this._workspacePaths[0]);
            }
            if ((workspace = workspaceFolderItem.asWorkspace()) == null) {
                Command.getOut().println("Folder item " + this._workspacePaths[0] + " is not a workspace ");
            }
            String propListName = this.generateUniqueName(workspace, PROPAGATION_LIST_PREFIX);
            IPropagatable propagatable = null;
            if (this._isDateRange) {
                propagatable = this._propManager.createPropagatable(propListName, (IPropagationSource)new Workspace(workspace.getBrowsePath()), this._dateFrom, this._dateTo);
            } else if (this._lowerISN != null) {
                propagatable = this._upperISN != null ? this._propManager.createPropagatable(propListName, (IPropagationSource)new Workspace(workspace.getBrowsePath()), this.getInteger(this._lowerISN).intValue(), this.getInteger(this._upperISN).intValue()) : this._propManager.createPropagatable(propListName, (IPropagationSource)new Workspace(workspace.getBrowsePath()), this.getInteger(this._lowerISN).intValue());
            }
            String path = this.getPath(propagatable.getId());
            this.writeMessage("Created propagation list \"" + path + "\"");
            retVal = true;
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException during creation of propagation list.");
            this.writeMessage("Creation of propagation list falied" + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException during creation of propagation list.");
            this.writeMessage("Creation of propagation list falied" + ex.getMessage());
        }
        catch (VfsException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VfsException during creation of propagation list.");
            this.writeMessage("Creation of propagation list falied" + ex.getMessage());
        }
        return retVal;
    }

    private String generateUniqueName(IVfsWorkspace workspace, String prefix) {
        if (this._propagationListName == null) {
            this._propagationListName = prefix + WORKSPACE_PREFIX + workspace.getName() + USER_PREFIX + this._currentUserName + TIME_PREFIX + this.getFormattedTimestamp();
            this._propagationListName = this._propagationListName.replace(' ', '_');
            this._propagationListName = this._propagationListName.replace(':', '_');
        }
        return this._propagationListName;
    }

    public boolean validateArguments() {
        if (!this._isValidArguments) {
            return this._isValidArguments;
        }
        if (!this._isDateRange && this._lowerISN == null) {
            this.writeMessage("Must specify @isnlowerlimit.");
            this._isValidArguments = false;
        }
        if (this._workspacePaths.length == 0 || this._workspacePaths[0].length() == 0) {
            this._workspacePaths[0] = null;
            IVfsFolderItem folderItem = this.getResource("");
            IVfsWorkspace workspace = null;
            if (folderItem != null && (workspace = folderItem.asWorkspace()) == null && folderItem.asActivityRecordedFolderItem() != null) {
                workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
            }
            if (workspace != null) {
                this._workspacePaths[0] = "";
            }
        }
        if (this._displayName == null || this._displayName.length() == 0) {
            this.writeMessage("Must specify displayname.");
            this._isValidArguments = false;
        }
        if (this._workspacePaths.length != 1 || this._workspacePaths[0] == null) {
            this.writeMessage("Must specify workspace path.");
            this._isValidArguments = false;
        }
        if (!this._isValidArguments) {
            this.writeMessage("Try help for more information.");
        }
        return this._isValidArguments;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        String proplistShortOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, true);
        String proplistLongOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, false);
        String risnLong = NameConfig.getOption(OptionName.ISNRANGE, false);
        String rindLong = NameConfig.getOption(OptionName.INDRANGE, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (proplistShortOptName.compareToIgnoreCase(currentArg) == 0 || proplistLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._propagationListName = (String)listIterator.next();
                listIterator.remove();
                continue;
            }
            if (risnLong.compareToIgnoreCase(currentArg) == 0) {
                this.extractISNRange(listIterator);
                continue;
            }
            if (rindLong.compareToIgnoreCase(currentArg) != 0) continue;
            this.extractDateRange(listIterator);
        }
        super.setArguments(arguments);
    }

    private void extractISNRange(Iterator listIterator) {
        this._isDateRange = false;
        listIterator.remove();
        if (listIterator.hasNext()) {
            this._lowerISN = (String)listIterator.next();
            if (this._lowerISN.startsWith("@")) {
                this._lowerISN = this._lowerISN.substring(1);
                if (this.getInteger(this._lowerISN) != null) {
                    listIterator.remove();
                }
            }
        }
        if (listIterator.hasNext()) {
            this._upperISN = (String)listIterator.next();
            if (this._upperISN.startsWith("@")) {
                this._upperISN = this._upperISN.substring(1);
                if (this.getInteger(this._upperISN) != null) {
                    listIterator.remove();
                }
            }
        }
    }

    private void extractDateRange(Iterator listIterator) {
        this._isDateRange = true;
        listIterator.remove();
        String value = null;
        if (listIterator.hasNext() && (value = (String)listIterator.next()).startsWith("@")) {
            value = value.substring(1);
            this._dateFrom = this.getDate(value);
            if (this._dateFrom != null) {
                listIterator.remove();
            }
        }
        if (listIterator.hasNext() && (value = (String)listIterator.next()).startsWith("@")) {
            value = value.substring(1);
            this._dateTo = this.getDate(value);
            if (this._dateTo != null) {
                listIterator.remove();
            }
        }
    }

    private Date getDate(String value) {
        try {
            return Timestamp.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            Logger.traceUserError(LOCATION, ex, "IllegalArgumentException while getting date for date range.");
            this._isValidArguments = false;
            this.writeMessage("One of the dates in the date range not specified correctly. " + ex.getMessage() + ". Try help for more information.");
            return null;
        }
    }

    private Integer getInteger(String value) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException ex) {
            Logger.traceUserError(LOCATION, ex, "NumberFormatException while getting isn for isn range.");
            this._isValidArguments = false;
            this.writeMessage("One of the isn in the isn range not specified correctly \"" + ex.getMessage() + "\". Try help for more information.");
            return null;
        }
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.MKPROPLIST, false) + "\t[ " + NameConfig.getOption(OptionName.SILENT, true) + " " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"description\" " + NameConfig.getOption(OptionName.NAME, true) + " \"displayname\" " + NameConfig.getOption(OptionName.PROPAGATION_LIST, true) + " \"propagtionlist name\" ] " + NameConfig.getOption(OptionName.WORKSPACE, true) + " \"workspace path\" [ " + NameConfig.getOption(OptionName.INDRANGE, false) + " \"date range\" ]");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Creates, populates and closes a propagation list. The population of the propagation list can be done based on a time range.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.SILENT, 1, "Will suppress the popup window for changing propagation list description and display name", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.COMMENTS, 1, "If in non UI mode this will be used to set the description of the propagationlist", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.NAME, 1, "If in non UI mode this will be used to set the displayname of the propagationlist", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.PROPAGATION_LIST, 1, "Name of the propagationlist to be created. If none is specified then a name is generated based on the workspace, user and current time.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace path to specify the workspace for which the summarizing of changes will be done.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.WORKSPACE, 1, "If the workspace is not  specified an attempt will  be made to resolve the  workspace  from  the  current  working directory. If  it  is  not possible then it will be notified to the user", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ISNRANGE, 1, "This option should be specified if the propagtion list population has to be based on ISN.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ISNRANGE, 1, "The usage of the option to specify a range is as follows:", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ISNRANGE, 1, NameConfig.getOption(OptionName.ISNRANGE, false) + " @isnlowerlimit [@isnupperlimit]", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ISNRANGE, 1, "ex :" + NameConfig.getOption(OptionName.ISNRANGE, false) + " @3 @8", false);
        this.printOptionHelp(OptionName.ISNRANGE, 1, "Here a propagation list of all changes in the workspace between ISN 3 & 8 will be created.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ISNRANGE, 1, "ex :" + NameConfig.getOption(OptionName.ISNRANGE, false) + " @8", false);
        this.printOptionHelp(OptionName.ISNRANGE, 1, "Here a propagation list of all changes in the workspace after ISN 8 will be created.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.INDRANGE, 1, "This option should be specified if the propagtion list population has to be based on dates.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.INDRANGE, 1, "The usage of the option to specify a range is as follows:", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.INDRANGE, 1, NameConfig.getOption(OptionName.INDRANGE, false) + " @indlowerlimit [@indupperlimit]", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Both indlowerlimit & indupperlimit are timestamps", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "The format of the timestamp is:", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "yyyy-mm-dd hh:mm:ss", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.INDRANGE, 1, "ex :" + NameConfig.getOption(OptionName.INDRANGE, false) + " \"@2003-04-01 00:00:00\" \"@2003-05-01 00:00:00\"", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Here a propagation list of all changes in the workspace between 1st April 2003 & 1st May 2003 will be created.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.INDRANGE, 1, "ex :" + NameConfig.getOption(OptionName.INDRANGE, false) + " \"@2003-04-01 00:00:00\"", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Here a propagation list of all changes in the workspace after 1st April 2003 will be created.", false);
        this.writeMessage("");
    }

    public CommandName getCommandName() {
        return CommandName.MKPROPLIST;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new MakePropagationListCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

