/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class MakeDirectoryCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$MakeDirectoryCommand == null ? (class$com$tssap$dtr$client$commandline$MakeDirectoryCommand = MakeDirectoryCommand.class$("com.tssap.dtr.client.commandline.MakeDirectoryCommand")) : class$com$tssap$dtr$client$commandline$MakeDirectoryCommand));
    private final boolean _createRemote;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$MakeDirectoryCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new MakeDirectoryCommand(arguments, name.equals(NameConfig.getCommandName(CommandName.MKDIR, false)));
    }

    MakeDirectoryCommand(ArrayList arguments, boolean remote) {
        super(arguments);
        this._createRemote = remote;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "creates a folder locally" + (this._createRemote ? " as well as on the server" : "");
    }

    public CommandName getCommandName() {
        if (this._createRemote) {
            return CommandName.MKDIR;
        }
        return CommandName.MKLDIR;
    }

    public boolean execute() {
        String fullPathForCreation;
        if (this.getFileSystemManager() == null) {
            this._exitCode = 3;
            return false;
        }
        if (!this._resourcePaths[0].startsWith("//")) {
            String currentDirectory = Utilities.getCurrentDirectory();
            currentDirectory = PathUtilities.assureTrailingSeparator((String)currentDirectory, (IFileService)PathUtilities.REMOTE_FILESERVICE);
            if (this._resourcePaths[0].startsWith("/")) {
                this._resourcePaths[0] = this._resourcePaths[0].substring(1);
            }
            fullPathForCreation = currentDirectory.substring(1) + this._resourcePaths[0];
        } else {
            fullPathForCreation = this._resourcePaths[0].substring(1);
        }
        fullPathForCreation = PathUtilities.assureTrailingSeparator((String)fullPathForCreation, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        IVfsFolderItem baseFolderItem = null;
        try {
            baseFolderItem = Utilities.getAvailableFolderItemInPath(fullPathForCreation);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting existing folder item in path " + fullPathForCreation);
            Command.getOut().println("Getting existing folder item in path " + fullPathForCreation + "failed");
            this._exitCode = 5;
            return false;
        }
        if (baseFolderItem.getLocalPath() == null) {
            Command.getOut().println("The path is not mounted.");
            this._exitCode = 67;
            return false;
        }
        if (baseFolderItem.asActivityRecordedFolderItem() == null && baseFolderItem.asWorkspace() == null) {
            Command.getOut().println("The path is not under a workspace.");
            this._exitCode = 68;
            return false;
        }
        String baseFolderItemBP = null;
        try {
            baseFolderItemBP = baseFolderItem.getBrowsePath();
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting browse path of existing folder item " + baseFolderItem.getLocalPath());
            Command.getOut().println("getting browse path of existing folder item " + baseFolderItem.getLocalPath() + "failed");
            this._exitCode = 5;
            return false;
        }
        baseFolderItemBP = PathUtilities.assureTrailingSeparator((String)baseFolderItemBP, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        String relativePath = fullPathForCreation.substring(baseFolderItemBP.length());
        if ("".equals(relativePath)) {
            Command.getOut().println("The directory already exists on the server.");
            Command.getOut().println("Getting the folder to the local file system.");
            try {
                baseFolderItem.sync();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during sync of folder item.");
                Command.getOut().println("could not get the folder to the local file system.");
                this._exitCode = 9;
                return false;
            }
            return true;
        }
        relativePath = relativePath.replace('/', baseFolderItem.getLocalFile().getFileService().getSeparatorChar());
        String path = baseFolderItem.getLocalPath() + relativePath;
        IVfsFolder folder = null;
        File ioFolder = new File(path);
        String canonicalPath = "";
        try {
            canonicalPath = ioFolder.getCanonicalPath();
        }
        catch (IOException e) {
            Logger.traceSystemError(LOCATION, e, "IOException while getting canonical path of folder to create.");
            this._exitCode = 5;
            return false;
        }
        IVfsContext context = this.getActiveContext();
        boolean found = false;
        String[] pathsOfMountPoints = context.getAbsoluteLocalPathsOfMountPoints();
        int i = 0;
        while (i < pathsOfMountPoints.length) {
            if (canonicalPath.startsWith(pathsOfMountPoints[i])) {
                found = true;
                break;
            }
            ++i;
        }
        ioFolder = new File(canonicalPath);
        if (!found) {
            Command.getOut().println("The path is not mounted.");
            this._exitCode = 67;
            return false;
        }
        if (!ioFolder.exists()) {
            if (!ioFolder.mkdirs()) {
                Command.getOut().println("The directory cound not be created.");
                this._exitCode = 69;
                return false;
            }
            Command.getOut().println("The directory has been created locally.");
        } else {
            Command.getOut().println("The directory already exists locally.");
        }
        if (this._createRemote) {
            try {
                folder = this.getFileSystemManager().getFolderItem(canonicalPath).asFolder();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException while getting folder to create.");
            }
            if (folder == null) {
                Command.getOut().println("The folder could not be added to the server.");
                return false;
            }
            IVfsWorkspace workspace = folder.getWorkspace();
            if (workspace == null) {
                Command.getOut().println("The workspace for the folder could not be retrieved.");
                return false;
            }
            IVfsActivity activity = null;
            try {
                activity = this.getOrCreateActivity(workspace);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException while Add/Get activity");
            }
            if (activity == null) {
                Command.getOut().println("The activity could not be created/retrieved.");
                return false;
            }
            try {
                folder.createAndCheckout(activity);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException while adding folder.");
                Command.getOut().println("The folder could not be added to the server. " + e.getMessage());
                this._exitCode = 70;
                return false;
            }
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths.length == 1;
    }

    public void printHelpDescription() {
        if (this._createRemote) {
            Command.getOut().println();
            Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.MKDIR, false) + " [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "]] FolderPath");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Creates a directory locally and adds it to the server", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The folder is created only if the path is mounted. If the local directory already exist then it is added to the server", false);
        } else {
            Command.getOut().println();
            Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.MKLDIR, false) + "  FolderPath");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Creates a directory locally", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The folder is created only if the path is mounted and the local directory does not already exist", false);
        }
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the directory exists on the server but not locally the folder is synced to the local file system", false);
        if (this._createRemote) {
            Command.getOut().println();
            this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the folders will be checked out in the given activity. If not specified then the default activity for the workspace is used. If the specified activity does not exist then it will be created", true);
            Command.getOut().println();
            this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name. This is only in case to specify to use an already existing activity", true);
        }
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

