/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginParamsInput {
    String[] _input;

    public String[] getInput(String prompt, String userName, boolean pwdChange, boolean userModifiable) throws IOException {
        int fieldHeight = 25;
        int width = 300;
        int height = fieldHeight * 3;
        int rows = 2;
        ArrayList<JTextField> fileds = new ArrayList<JTextField>();
        JLabel lblUserName = new JLabel("User Name");
        JLabel lblPwd = new JLabel("Password");
        JLabel lblConfirmPwd = null;
        JTextField userNameField = new JTextField();
        if (userName != null && !userName.trim().equals("")) {
            userNameField.setText(userName);
        }
        fileds.add(userNameField);
        userNameField.setEditable(userModifiable);
        if (!userModifiable) {
            userNameField.addFocusListener(new UserNameFocusListener());
        }
        JPasswordField pwdField = new JPasswordField();
        JPasswordField pwdConfirmField = null;
        fileds.add(pwdField);
        pwdField.setEchoChar('*');
        JDialog dialog = new JDialog();
        if (pwdChange) {
            height += fieldHeight;
            pwdConfirmField = new JPasswordField();
            pwdConfirmField.setEchoChar('*');
            fileds.add(pwdConfirmField);
            lblConfirmPwd = new JLabel("Confirm Password");
            this._input = new String[3];
            ++rows;
        } else {
            this._input = new String[2];
        }
        ((Component)dialog).setSize(width, height);
        ((Component)dialog).setLocation(200, 200);
        dialog.getContentPane().setLayout(new GridLayout(rows, 2));
        dialog.getContentPane().add(lblUserName);
        dialog.getContentPane().add(userNameField);
        dialog.getContentPane().add(lblPwd);
        dialog.getContentPane().add(pwdField);
        if (pwdChange) {
            dialog.getContentPane().add(lblConfirmPwd);
            dialog.getContentPane().add(pwdConfirmField);
        }
        dialog.setTitle(prompt);
        dialog.setDefaultCloseOperation(0);
        MyLsitener myListener = new MyLsitener(fileds, dialog);
        dialog.addWindowListener(myListener);
        userNameField.addKeyListener(myListener);
        pwdField.addKeyListener(myListener);
        if (pwdChange) {
            pwdConfirmField.addKeyListener(myListener);
        }
        dialog.validate();
        dialog.setModal(true);
        dialog.show();
        return this._input;
    }

    private class UserNameFocusListener
    implements FocusListener {
        private UserNameFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            event.getComponent().transferFocus();
        }

        public void focusLost(FocusEvent arg0) {
        }
    }

    class MyLsitener
    extends WindowAdapter
    implements KeyListener {
        ArrayList _fields;
        JDialog _dialog;

        MyLsitener(ArrayList fields, JDialog dialog) {
            this._fields = fields;
            this._dialog = dialog;
        }

        public void windowClosing(WindowEvent we) {
            int i = 0;
            while (i < this._fields.size()) {
                Object field = this._fields.get(i);
                if (field instanceof JPasswordField) {
                    char[] input = ((JPasswordField)field).getPassword();
                    LoginParamsInput.this._input[i] = String.valueOf(input);
                } else {
                    LoginParamsInput.this._input[i] = ((JTextField)field).getText();
                }
                ++i;
            }
            this._dialog.hide();
            this._dialog.dispose();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.windowClosing(null);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void windowOpened(WindowEvent e) {
            this._dialog.toFront();
            super.windowOpened(e);
        }
    }
}

