/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class Logger {
    public static void traceInfo(Location loc, String msg) {
        loc.infoT(msg);
    }

    public static void traceDebug(Location loc, String msg) {
        loc.debugT(msg);
    }

    public static void traceExceptionWithStackDebug(Location loc, Exception e, String msg) {
        loc.debugT(msg + e.getMessage());
        loc.debugT(Logger.printStackTraceToString(e));
    }

    public static void traceUserError(Location loc, Exception e, String msg) {
        loc.infoT(msg + e.getMessage());
        loc.debugT(Logger.printStackTraceToString(e));
    }

    public static void traceInternalError(Location loc, Exception e, String msg) {
        loc.infoT(msg + e.getMessage());
        loc.infoT(Logger.printStackTraceToString(e));
    }

    public static void traceSystemError(Location loc, Exception e, String msg) {
        loc.infoT(msg + e.getMessage());
        loc.infoT(Logger.printStackTraceToString(e));
    }

    private static String printStackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

