/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FieldDescriptor;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityReport;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import java.net.MalformedURLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ListActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ListActivityCommand == null ? (class$com$tssap$dtr$client$commandline$ListActivityCommand = ListActivityCommand.class$("com.tssap.dtr.client.commandline.ListActivityCommand")) : class$com$tssap$dtr$client$commandline$ListActivityCommand));
    private Timestamp _indrUpper;
    private Timestamp _indrLower;
    private boolean _displayOnlyClosed;
    private boolean _displayOnlyOpen;
    private boolean _displayEmpty;
    private boolean _fieldsSpecifiedInArgs;
    private boolean _isnDisplayTrue;
    private long _isnrLower;
    private long _isnrUpper;
    private String _userName;
    private ArrayList _displayFiledsOrdered;
    private static final FieldDescriptor DISPLAY_NAME = new FieldDescriptor(ListActivityCommand.getFieldLength("DisplayName", 40), "DisplayName", "DN");
    private static final FieldDescriptor ACTUAL_NAME = new FieldDescriptor(ListActivityCommand.getFieldLength("ActualName", 70), "ActualName", "AN");
    private static final FieldDescriptor CREATED_ON = new FieldDescriptor(ListActivityCommand.getFieldLength("CreatedOn", 35), "CreatedOn", "COn");
    private static final FieldDescriptor CREATED_BY = new FieldDescriptor(ListActivityCommand.getFieldLength("CreatedBy", 20), "CreatedBy", "CBy");
    private static final FieldDescriptor STATE = new FieldDescriptor(ListActivityCommand.getFieldLength("State", 8), "State", "St");
    private static final FieldDescriptor CHECKIN_DATE = new FieldDescriptor(ListActivityCommand.getFieldLength("CheckinDate", 35), "CheckinDate", "CInD");
    private static final FieldDescriptor DESCRIPTION = new FieldDescriptor(ListActivityCommand.getFieldLength("Description", 40), "Description", "Des");
    private static final FieldDescriptor INTEGRATION_NUMBER = new FieldDescriptor(ListActivityCommand.getFieldLength("IntegrationNumber", 20), "IntegrationNumber", "IN");
    private static final FieldDescriptor IS_DEFAULT = new FieldDescriptor(ListActivityCommand.getFieldLength("IsDefault", 10), "IsDefault", "ID");
    private static final FieldDescriptor IS_EMPTY = new FieldDescriptor(ListActivityCommand.getFieldLength("IsEmpty", 10), "IsEmpty", "IE");
    private static final FieldDescriptor CREATOR_WORKSPACE = new FieldDescriptor(ListActivityCommand.getFieldLength("CreatorWorkspace", 50), "CreatorWorkspace", "CWS");
    private static final FieldDescriptor WORKSPACE = new FieldDescriptor(ListActivityCommand.getFieldLength("Workspace", 50), "Workspace", "WS");
    private static final FieldDescriptor ACTIVITYID = new FieldDescriptor(ListActivityCommand.getFieldLength("ActivityID", 50), "ActivityID", "ActID");
    private static final FieldDescriptor INTEGRATION_DATE = new FieldDescriptor(ListActivityCommand.getFieldLength("IntegrationDate", 35), "IntegrationDate", "IND");
    private static final String ALL = "all";
    private boolean _listAllWSs;
    private boolean _descendingOrder;
    private boolean _sortSpecified;
    private Field _sortField;
    private int _sortKeyType;
    private boolean _displayEmptyOnly;
    private boolean _displayPLOnly;
    private boolean _displayPL;
    private boolean _displayCreatedOnly;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ListActivityCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ListActivityCommand(arguments);
    }

    ListActivityCommand(ArrayList arguments) {
        super(arguments);
        this.removeSupportedOption(OptionName.COMMENTS);
        this.removeSupportedOption(OptionName.SILENT);
        this.addSupportedOption(OptionName.ALLWORKSPACES);
        this.addSupportedOption(OptionName.FIELD);
        this.addSupportedOption(OptionName.SORT);
        this.addSupportedOption(OptionName.UNFORMATTED);
        this.addSupportedOption(OptionName.DESCENDING);
        this.addSupportedOption(OptionName.EMPTY);
        this.addSupportedOption(OptionName.EMPTY_EX);
        this.addSupportedOption(OptionName.PROPAGATIONLISTS);
        this.addSupportedOption(OptionName.PROPAGATIONLISTS_EX);
        this.addSupportedOption(OptionName.ISNRANGE);
        this.addSupportedOption(OptionName.USER);
        this.addSupportedOption(OptionName.OPEN);
        this.addSupportedOption(OptionName.CLOSED);
        this.addSupportedOption(OptionName.CREATEDONLY);
        this._displayOnlyClosed = false;
        this._displayOnlyOpen = false;
        this._displayEmpty = false;
        this._displayEmptyOnly = false;
        this._displayPL = false;
        this._displayPLOnly = false;
        this._displayCreatedOnly = false;
        this._displayFiledsOrdered = new ArrayList();
        this._displayFiledsOrdered.add(new Field(ACTUAL_NAME, ListActivityCommand.ACTUAL_NAME.fieldName));
        this._displayFiledsOrdered.add(new Field(STATE, ListActivityCommand.STATE.fieldName));
        this._fieldsSpecifiedInArgs = false;
        this._isnDisplayTrue = false;
        this._listAllWSs = false;
        this._isnrLower = -1L;
        this._isnrUpper = -1L;
        this._userName = "";
        this._sortField = null;
        this._sortSpecified = false;
        this._descendingOrder = false;
        this.setArguments(arguments);
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i;
            String currArg;
            if ((currArg = (String)arguments.get(i = indexOfArgs--)) != null) {
                String fieldName;
                String upper;
                String lower;
                String lowerCaseArg = currArg.toLowerCase();
                String clShort = NameConfig.getOption(OptionName.CLOSED, true);
                String clLong = NameConfig.getOption(OptionName.CLOSED, false);
                String oShort = NameConfig.getOption(OptionName.OPEN, true);
                String oLong = NameConfig.getOption(OptionName.OPEN, false);
                String eShort = NameConfig.getOption(OptionName.EMPTY, true);
                String eLong = NameConfig.getOption(OptionName.EMPTY, false);
                String exShort = NameConfig.getOption(OptionName.EMPTY_EX, true);
                String exLong = NameConfig.getOption(OptionName.EMPTY_EX, false);
                String plShort = NameConfig.getOption(OptionName.PROPAGATIONLISTS, true);
                String plLong = NameConfig.getOption(OptionName.PROPAGATIONLISTS, false);
                String plxShort = NameConfig.getOption(OptionName.PROPAGATIONLISTS_EX, true);
                String plxLong = NameConfig.getOption(OptionName.PROPAGATIONLISTS_EX, false);
                String coShort = NameConfig.getOption(OptionName.CREATEDONLY, true);
                String coLong = NameConfig.getOption(OptionName.CREATEDONLY, false);
                String uShort = NameConfig.getOption(OptionName.USER, true);
                String uLong = NameConfig.getOption(OptionName.USER, false);
                String awsLong = NameConfig.getOption(OptionName.ALLWORKSPACES, false);
                String risnLong = NameConfig.getOption(OptionName.ISNRANGE, false);
                String rindLong = NameConfig.getOption(OptionName.INDRANGE, false);
                String descShort = NameConfig.getOption(OptionName.DESCENDING, true);
                String descLong = NameConfig.getOption(OptionName.DESCENDING, false);
                String fShort = NameConfig.getOption(OptionName.FIELD, true);
                String fLong = NameConfig.getOption(OptionName.FIELD, false);
                String sShort = NameConfig.getOption(OptionName.SORT, true);
                String sLong = NameConfig.getOption(OptionName.SORT, false);
                String unShort = NameConfig.getOption(OptionName.UNFORMATTED, true);
                String unLong = NameConfig.getOption(OptionName.UNFORMATTED, false);
                if (clShort.equals(lowerCaseArg) || clLong.equals(lowerCaseArg)) {
                    this._displayOnlyClosed = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (oShort.equals(lowerCaseArg) || oLong.equals(lowerCaseArg)) {
                    this._displayOnlyOpen = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (eShort.equals(lowerCaseArg) || eLong.equals(lowerCaseArg)) {
                    this._displayEmpty = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (exShort.equals(lowerCaseArg) || exLong.equals(lowerCaseArg)) {
                    this._displayEmpty = true;
                    this._displayEmptyOnly = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (plShort.equals(lowerCaseArg) || plLong.equals(lowerCaseArg)) {
                    this._displayPL = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (plxShort.equals(lowerCaseArg) || plxLong.equals(lowerCaseArg)) {
                    this._displayPLOnly = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (coShort.equals(lowerCaseArg) || coLong.equals(lowerCaseArg)) {
                    this._displayCreatedOnly = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (unShort.equals(currArg) || unLong.equals(lowerCaseArg)) {
                    this._unformattedOutput = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(uShort) || lowerCaseArg.startsWith(uLong)) {
                    String user = Command.getActualArgument(currArg, uShort, uLong);
                    if ("".equals(user) && arguments.size() > i + 1) {
                        user = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._userName = user;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (awsLong.equals(lowerCaseArg)) {
                    this._listAllWSs = true;
                    arguments.remove(i);
                } else if (lowerCaseArg.startsWith(risnLong)) {
                    lower = "-1";
                    upper = "-1";
                    if (arguments.size() > i + 1) {
                        lower = (String)arguments.get(i + 1);
                        if (lower.startsWith("@")) {
                            lower = lower.substring(1);
                            arguments.remove(i + 1);
                            if (arguments.size() > i + 1) {
                                upper = (String)arguments.get(i + 1);
                                if (upper.startsWith("@")) {
                                    arguments.remove(i + 1);
                                    upper = upper.substring(1);
                                } else {
                                    upper = "-1";
                                }
                            }
                        } else {
                            lower = "-1";
                        }
                    }
                    try {
                        this._isnrLower = Integer.parseInt(lower);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while parsing lower ISN in ISN range : " + lower);
                        this._isnrLower = -1L;
                    }
                    try {
                        this._isnrUpper = Integer.parseInt(upper);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while parsing upper ISN in ISN range : " + upper);
                        this._isnrUpper = -1L;
                    }
                    if (this._isnrLower <= 0L) {
                        this._isnrLower = -1L;
                    }
                    if (this._isnrUpper <= 0L) {
                        this._isnrUpper = -1L;
                    }
                    if (this._isnrLower != -1L || this._isnrUpper != -1L) {
                        this._isnDisplayTrue = true;
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(rindLong)) {
                    lower = "-1";
                    upper = "-1";
                    this._indrLower = null;
                    this._indrUpper = null;
                    if (arguments.size() > i + 1) {
                        lower = (String)arguments.get(i + 1);
                        if (lower.startsWith("@")) {
                            Timestamp timestamp;
                            lower = lower.substring(1);
                            try {
                                timestamp = Timestamp.valueOf(lower);
                            }
                            catch (IllegalArgumentException exp) {
                                Logger.traceUserError(LOCATION, exp, "IllegalArgumentException occurred while parsing lower Date in Date range : " + lower);
                                Command.getOut().println("The given date range is in an incorrect format.please see help for the correct format.");
                                break;
                            }
                            this._indrLower = timestamp;
                            arguments.remove(i + 1);
                            if (arguments.size() > i + 1) {
                                upper = (String)arguments.get(i + 1);
                                if (upper.startsWith("@")) {
                                    upper = upper.substring(1);
                                    try {
                                        timestamp = null;
                                        timestamp = Timestamp.valueOf(upper);
                                    }
                                    catch (IllegalArgumentException exp) {
                                        Logger.traceUserError(LOCATION, exp, "IllegalArgumentException occurred while parsing upper Date in Date range : " + upper);
                                        Command.getOut().println("The given date range is in an incorrect format.please see help for the correct format.");
                                        break;
                                    }
                                    this._indrUpper = timestamp;
                                    arguments.remove(i + 1);
                                } else {
                                    this._indrUpper = null;
                                }
                            }
                        } else {
                            this._indrLower = null;
                        }
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    fieldName = Command.getActualArgument(currArg, fShort, fLong).toLowerCase();
                    if ("".equals(fieldName) && i + 1 < arguments.size()) {
                        fieldName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    if (!"".equals(fieldName) && !this._fieldsSpecifiedInArgs) {
                        this._displayFiledsOrdered = null;
                        this._displayFiledsOrdered = new ArrayList();
                        this._fieldsSpecifiedInArgs = true;
                    }
                    if (DISPLAY_NAME.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, fieldName));
                    } else if (ACTUAL_NAME.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(ACTUAL_NAME, fieldName));
                    } else if (CREATED_ON.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CREATED_ON, fieldName));
                    } else if (CREATED_BY.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CREATED_BY, fieldName));
                    } else if (STATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(STATE, fieldName));
                    } else if (CHECKIN_DATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CHECKIN_DATE, fieldName));
                    } else if (DESCRIPTION.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(DESCRIPTION, fieldName));
                    } else if (INTEGRATION_DATE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(INTEGRATION_DATE, fieldName));
                    } else if (INTEGRATION_NUMBER.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(INTEGRATION_NUMBER, fieldName));
                        this._isnDisplayTrue = true;
                    } else if (IS_DEFAULT.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(IS_DEFAULT, fieldName));
                    } else if (IS_EMPTY.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(IS_EMPTY, fieldName));
                    } else if (WORKSPACE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(WORKSPACE, fieldName));
                    } else if (ACTIVITYID.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(ACTIVITYID, fieldName));
                    } else if (CREATOR_WORKSPACE.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(CREATOR_WORKSPACE, fieldName));
                    } else if (fieldName.startsWith(ALL.toLowerCase())) {
                        this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, fieldName));
                        this._displayFiledsOrdered.add(new Field(ACTUAL_NAME, fieldName));
                        this._displayFiledsOrdered.add(new Field(DESCRIPTION, fieldName));
                        this._displayFiledsOrdered.add(new Field(CREATED_BY, fieldName));
                        this._displayFiledsOrdered.add(new Field(CREATED_ON, fieldName));
                        this._displayFiledsOrdered.add(new Field(STATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(CHECKIN_DATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(INTEGRATION_NUMBER, fieldName));
                        this._displayFiledsOrdered.add(new Field(INTEGRATION_DATE, fieldName));
                        this._displayFiledsOrdered.add(new Field(IS_DEFAULT, fieldName));
                        this._displayFiledsOrdered.add(new Field(WORKSPACE, fieldName));
                        this._displayFiledsOrdered.add(new Field(CREATOR_WORKSPACE, fieldName));
                        this._displayFiledsOrdered.add(new Field(ACTIVITYID, fieldName));
                        this._isnDisplayTrue = true;
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(sShort) || lowerCaseArg.startsWith(sLong)) {
                    fieldName = Command.getActualArgument(currArg, sShort, sLong).toLowerCase();
                    if (!this._sortSpecified) {
                        if (DISPLAY_NAME.matches(fieldName)) {
                            this._sortField = new Field(DISPLAY_NAME, fieldName);
                            this._sortKeyType = 1;
                        } else if (ACTUAL_NAME.matches(fieldName)) {
                            this._sortField = new Field(ACTUAL_NAME, fieldName);
                            this._sortKeyType = 1;
                        } else if (CREATED_ON.matches(fieldName)) {
                            this._sortField = new Field(CREATED_ON, fieldName);
                            this._sortKeyType = 2;
                        } else if (CREATED_BY.matches(fieldName)) {
                            this._sortField = new Field(CREATED_BY, fieldName);
                            this._sortKeyType = 1;
                        } else if (STATE.matches(fieldName)) {
                            this._sortField = new Field(STATE, fieldName);
                            this._sortKeyType = 1;
                        } else if (CHECKIN_DATE.matches(fieldName)) {
                            this._sortField = new Field(CHECKIN_DATE, fieldName);
                            this._sortKeyType = 2;
                        } else if (DESCRIPTION.matches(fieldName)) {
                            this._sortField = new Field(DESCRIPTION, fieldName);
                            this._sortKeyType = 1;
                        } else if (INTEGRATION_DATE.matches(fieldName)) {
                            this._sortField = new Field(INTEGRATION_DATE, fieldName);
                            this._sortKeyType = 2;
                        } else if (INTEGRATION_NUMBER.matches(fieldName)) {
                            this._sortField = new Field(INTEGRATION_NUMBER, fieldName);
                            this._isnDisplayTrue = true;
                            this._sortKeyType = 0;
                        } else if (IS_DEFAULT.matches(fieldName)) {
                            this._sortField = new Field(IS_DEFAULT, fieldName);
                            this._sortKeyType = 1;
                        } else if (IS_EMPTY.matches(fieldName)) {
                            this._sortField = new Field(IS_EMPTY, fieldName);
                            this._sortKeyType = 1;
                        } else if (WORKSPACE.matches(fieldName)) {
                            this._sortField = new Field(WORKSPACE, fieldName);
                            this._sortKeyType = 1;
                        } else if (ACTIVITYID.matches(fieldName)) {
                            this._sortField = new Field(ACTIVITYID, fieldName);
                            this._sortKeyType = 1;
                        } else if (CREATOR_WORKSPACE.matches(fieldName)) {
                            this._sortField = new Field(CREATOR_WORKSPACE, fieldName);
                            this._sortKeyType = 1;
                        }
                        if (this._sortField != null) {
                            this._sortSpecified = true;
                        }
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (descShort.equals(lowerCaseArg) || descLong.equals(lowerCaseArg)) {
                    this._descendingOrder = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (this._displayFiledsOrdered.size() == 0) {
            this._displayFiledsOrdered.add(new Field(ACTUAL_NAME, ListActivityCommand.ACTUAL_NAME.fieldName));
            this._displayFiledsOrdered.add(new Field(STATE, ListActivityCommand.STATE.fieldName));
        }
        if (this._sortSpecified) {
            boolean sortFieldAdded = false;
            int i = 0;
            while (i < this._displayFiledsOrdered.size()) {
                if (this._sortField.isIt(((Field)this._displayFiledsOrdered.get((int)i)).fieldName)) {
                    sortFieldAdded = true;
                    break;
                }
                ++i;
            }
            if (!sortFieldAdded) {
                this._displayFiledsOrdered.add(this._sortField);
                if (this._sortField.isIt(ListActivityCommand.INTEGRATION_NUMBER.fieldName)) {
                    this._isnDisplayTrue = true;
                }
            }
        } else {
            this._sortField = (Field)this._displayFiledsOrdered.get(0);
            this._sortKeyType = 1;
        }
        super.setArguments(arguments);
    }

    public String getDescription() {
        return "lists and gives information about activities";
    }

    public CommandName getCommandName() {
        return CommandName.ACTIVITIES;
    }

    public boolean execute() {
        IVfsActivity[] activities;
        if (!"".equals(this._userName)) {
            return this.executeForUser();
        }
        boolean listingDone = false;
        if (this._workspacePaths.length == 1 && "".equals(this._workspacePaths[0])) {
            this._workspacePaths = null;
        }
        IVfsWorkspace sourceWorkspace = null;
        ArrayList<IVfsActivity> actArrList = new ArrayList<IVfsActivity>();
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        if (fileSystemManager == null) {
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
            this._exitCode = 3;
            return false;
        }
        if (this._activityISNs != null && this._activityISNs.length > 0) {
            if (this._workspacePaths == null) {
                this._workspacePaths = new String[1];
                this._workspacePaths[0] = "";
            }
            if ("".equals(this._workspacePaths[0])) {
                this._workspacePaths[0] = Utilities.getCurrentDirectory();
            }
            if ((sourceWorkspace = this.getWorkspace()) == null) {
                this._exitCode = 30;
                Command.getOut().println("Could not get the workspace " + this._workspacePaths[0]);
                return false;
            }
            listingDone = true;
            int[] isns = ActivityCommand.convertActivityISNsFromStringsToNumbers(this._activityISNs);
            ActivityCommand.ActivityPathIsnPair[] pairs = ActivityCommand.executeActISNReport(sourceWorkspace, isns);
            int i = 0;
            while (i < pairs.length) {
                IVfsActivity activity = null;
                if (pairs[i] != null) {
                    try {
                        activity = sourceWorkspace.getRepository().getActivityByUrl(Command.getWebLocator((IVfsFolderItem)sourceWorkspace) + pairs[i].activityPath);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting activity " + pairs[i].activityPath);
                    }
                    if (activity != null) {
                        actArrList.add(activity);
                    }
                }
                ++i;
            }
        }
        if (this._activityNames != null && this._activityNames.length > 0) {
            if (this._isnDisplayTrue) {
                if (this._workspacePaths == null) {
                    this._workspacePaths = new String[1];
                    this._workspacePaths[0] = "";
                }
                if ("".equals(this._workspacePaths[0])) {
                    this._workspacePaths[0] = Utilities.getCurrentDirectory();
                }
                if ((sourceWorkspace = this.getWorkspace()) == null) {
                    Command.getOut().println("Could not get the workspace " + this._workspacePaths[0]);
                    this._exitCode = 30;
                    return false;
                }
            }
            listingDone = true;
            int i = 0;
            while (i < this._activityNames.length) {
                this._activityName = this._activityNames[i];
                IVfsActivity activity = this.getActivity(true, true);
                if (activity != null) {
                    actArrList.add(activity);
                }
                ++i;
            }
        }
        if (actArrList.size() > 0) {
            this.displayHeader(this._displayFiledsOrdered);
            IVfsActivity[] activities2 = new IVfsActivity[actArrList.size()];
            actArrList.toArray(activities2);
            this.displayActivities(activities2, sourceWorkspace);
        }
        if (!(this._workspacePaths != null && this._workspacePaths.length != 0 || listingDone || this._listAllWSs)) {
            this._workspacePaths = null;
            this._workspacePaths = new String[1];
            this._workspacePaths[0] = Utilities.getCurrentDirectory();
            IVfsFolderItem folderItem = this.getResource(this._workspacePaths[0]);
            IVfsWorkspace workspace = null;
            if (folderItem != null && (workspace = folderItem.asWorkspace()) == null && folderItem.asActivityRecordedFolderItem() != null) {
                workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
            }
            if (workspace == null) {
                this._workspacePaths = null;
            } else {
                try {
                    this._workspacePaths[0] = "/" + workspace.getBrowsePath();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the browse path for workspace " + this._workspacePaths[0]);
                    this._workspacePaths = null;
                }
            }
        }
        if (this._workspacePaths != null && this._workspacePaths.length > 0 && !listingDone) {
            this.displayHeader(this._displayFiledsOrdered);
            listingDone = true;
            int i = 0;
            while (i < this._workspacePaths.length) {
                IVfsFolderItem folderItem = this.getResource(this._workspacePaths[i]);
                IVfsWorkspace workspace = null;
                if (folderItem != null) {
                    workspace = folderItem.asWorkspace();
                }
                if (workspace == null) {
                    Command.getOut().println("Could not get the workspace " + this._workspacePaths[i]);
                    this._exitCode = 30;
                } else {
                    if (!this._displayOnlyOpen && !this._displayOnlyClosed) {
                        this._displayOnlyClosed = true;
                        this._displayOnlyOpen = true;
                    }
                    ArrayList<IVfsActivity> acts = new ArrayList<IVfsActivity>();
                    if (this._displayOnlyOpen) {
                        activities = null;
                        try {
                            activities = workspace.getActivities(VfsActivityState.OPEN);
                        }
                        catch (VfsException exp) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting open activities for workspace " + this._workspacePaths[i]);
                            Command.getOut().println("Could not get open activities for workspace " + this._workspacePaths[i] + ". " + exp.getMessage());
                        }
                        if (activities != null) {
                            acts.addAll(Arrays.asList(activities));
                        }
                    }
                    if (this._displayOnlyClosed) {
                        activities = null;
                        try {
                            activities = workspace.getActivities(VfsActivityState.CLOSED);
                        }
                        catch (VfsException exp) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting closed activities for workspace " + this._workspacePaths[i]);
                            Command.getOut().println("Could not get closed activities for workspace " + this._workspacePaths[i] + ". " + exp.getMessage());
                        }
                        if (activities != null) {
                            acts.addAll(Arrays.asList(activities));
                        }
                    }
                    if (acts.size() > 0) {
                        activities = new IVfsActivity[acts.size()];
                        if ((activities = acts.toArray(activities)) != null) {
                            this.displayActivities(activities, workspace);
                        }
                    }
                }
                ++i;
            }
        }
        if (!listingDone) {
            this.displayHeader(this._displayFiledsOrdered);
            IVfsRepository[] repositories = fileSystemManager.getRepositories();
            if (repositories == null) {
                return false;
            }
            int i = 0;
            while (i < repositories.length) {
                block60: {
                    IVfsWorkspace[] workspaces = repositories[i].getWorkspaces();
                    if (workspaces != null) {
                        if (this._displayEmpty) {
                            try {
                                IVfsActivity[] activities3 = repositories[i].getEmptyActivities();
                                this.displayActivities(activities3, null);
                            }
                            catch (VfsException x) {
                                Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred while getting empty activities for repository " + repositories[i].getUrl());
                                Command.getOut().println(x.getMessage());
                                Command.getOut().println("Could not retrieve empty activities for repository" + repositories[i].getUrl());
                                break block60;
                            }
                        }
                        if (!this._displayEmptyOnly) {
                            int j = 0;
                            while (j < workspaces.length) {
                                if (!this._displayOnlyOpen && !this._displayOnlyClosed) {
                                    this._displayOnlyClosed = true;
                                    this._displayOnlyOpen = true;
                                }
                                if (this._displayOnlyOpen) {
                                    activities = null;
                                    try {
                                        activities = workspaces[j].getActivities(VfsActivityState.OPEN);
                                    }
                                    catch (VfsException x) {
                                        Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred while getting open activities for workspace " + this._workspacePaths[i]);
                                        Command.getOut().println("Could not get open activities for workspace " + workspaces[j].getLocalPath() + ". " + x.getMessage());
                                    }
                                    if (activities != null && activities.length > 0) {
                                        this.displayActivities(activities, workspaces[j]);
                                    }
                                }
                                if (this._displayOnlyClosed) {
                                    activities = null;
                                    try {
                                        activities = workspaces[j].getActivities(VfsActivityState.CLOSED);
                                    }
                                    catch (VfsException x) {
                                        Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred while getting closed activities for workspace " + this._workspacePaths[i]);
                                        Command.getOut().println("Could not get closed activities for workspace " + workspaces[j].getLocalPath() + ". " + x.getMessage());
                                    }
                                    if (activities != null && activities.length > 0) {
                                        this.displayActivities(activities, workspaces[j]);
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private boolean executeForUser() {
        boolean listingDone = false;
        if ((this._workspacePaths == null || this._workspacePaths.length == 0 || "".equals(this._workspacePaths[0])) && !this._listAllWSs) {
            if (this.getFileSystemManager() == null) {
                return false;
            }
            this._workspacePaths = null;
            this._workspacePaths = new String[1];
            this._workspacePaths[0] = Utilities.getCurrentDirectory();
            IVfsFolderItem folderItem = this.getResource(this._workspacePaths[0]);
            IVfsWorkspace workspace = null;
            if (folderItem != null && (workspace = folderItem.asWorkspace()) == null && folderItem.asActivityRecordedFolderItem() != null) {
                workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
            }
            if (workspace == null) {
                this._workspacePaths = null;
            } else {
                try {
                    this._workspacePaths[0] = "/" + workspace.getBrowsePath();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the browse path for workspace " + this._workspacePaths[0]);
                    this._workspacePaths = null;
                }
            }
        }
        if (this._workspacePaths != null && this._workspacePaths.length > 0) {
            this.displayHeader(this._displayFiledsOrdered);
            listingDone = true;
            IVfsWorkspace[] workspaces = new IVfsWorkspace[this._workspacePaths.length];
            int i = 0;
            while (i < this._workspacePaths.length) {
                IVfsFolderItem folderItem = this.getResource(this._workspacePaths[i]);
                if (folderItem != null) {
                    workspaces[i] = folderItem.asWorkspace();
                } else {
                    Command.getOut().println("Could not get the workspace " + this._workspacePaths[i]);
                }
                ++i;
            }
            this.fireActivityReportForWorkspaces(workspaces);
        }
        if (!listingDone) {
            this.displayHeader(this._displayFiledsOrdered);
            IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
            if (fileSystemManager == null) {
                Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
                this._exitCode = 3;
                return true;
            }
            IVfsRepository[] repositories = fileSystemManager.getRepositories();
            if (repositories == null) {
                return true;
            }
            int i = 0;
            while (i < repositories.length) {
                IVfsWorkspace[] workspaces;
                if (this._displayEmpty) {
                    this.fireActivityReportForRepository(repositories[i]);
                }
                if (!this._displayEmptyOnly && (workspaces = repositories[i].getWorkspaces()) != null) {
                    this.fireActivityReportForWorkspaces(workspaces);
                }
                ++i;
            }
        }
        return true;
    }

    private boolean fireActivityReportForRepository(IVfsRepository iVfsRepository) {
        ActivityReport activityReport = null;
        try {
            activityReport = new ActivityReport(new URL(iVfsRepository.getUrl()).getPath());
        }
        catch (MalformedURLException e) {
            Logger.traceInternalError(LOCATION, e, "MalformedURLException occurred while creating activity report because URL of repository was not correctly retrieved. URL " + iVfsRepository.getUrl());
        }
        if (activityReport == null) {
            this._exitCode = 58;
            return false;
        }
        if (!this._userName.equals("ALL")) {
            activityReport.addUserQuery(this._userName);
        }
        activityReport.addNamespace("DAV", "DAV:");
        activityReport.addNamespace(XCM.NAMESPACE_PREFIX, XCM.NAMESPACE_URI);
        activityReport.applyToEmptyActivitiesOnly();
        this.addPropertiesToReport(activityReport);
        IResponse response = null;
        try {
            IVfsRemoteLocator locator = this.getActiveContext().getRemoteLocatorFromUrl(iVfsRepository.getUrl());
            if (locator != null) {
                response = DeltavCommand.execute((int)locator.getConnectionTemplateId(), (IRequest)activityReport);
            }
        }
        catch (VcmFailure e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VcmFailure occurred while getting activities for repository " + iVfsRepository.getUrl() + " using activity report.");
            Command.getOut().println("Getting activties failed. " + e.getMessage());
        }
        if (response == null) {
            this._exitCode = 59;
            return true;
        }
        ActivityCommand.ActivityPathIsnPair[] pairs = new ActivityCommand.ActivityPathIsnPair[]{};
        HashMap<String, String> PathsToIsns = new HashMap<String, String>(pairs.length);
        int i = 0;
        while (i < pairs.length) {
            ActivityCommand.ActivityPathIsnPair pair = pairs[i];
            PathsToIsns.put(pair.activityPath, String.valueOf(pair.isn));
            ++i;
        }
        Iterator resources = activityReport.getResources();
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(this._sortField, this._sortKeyType);
        while (resources != null && resources.hasNext()) {
            ResourceElement elem = (ResourceElement)resources.next();
            if (elem == null) continue;
            this.displayActivityFromReport(elem, PathsToIsns, null, dh, false);
        }
        dh.endDisplay(this._descendingOrder);
        return true;
    }

    private void fireActivityReportForWorkspaces(IVfsWorkspace[] workspaces) {
        if (workspaces != null) {
            int i = 0;
            while (i < workspaces.length) {
                if (workspaces[i] != null) {
                    this.fireActivityReportForWorkspace(workspaces[i]);
                }
                ++i;
            }
        }
    }

    private void fireActivityReportForWorkspace(IVfsWorkspace workspace) {
        Iterator resources = null;
        ActivityCommand.ActivityPathIsnPair[] pairs = new ActivityCommand.ActivityPathIsnPair[]{};
        boolean useSourcevset = false;
        if (this.onlyNameAndOrISNAndOrWorkspaceRequired() && ("".equals(this._userName) || "ALL".equals(this._userName)) && !this._displayOnlyOpen && this._displayOnlyClosed) {
            Iterator[] ress = new Iterator[1];
            pairs = ActivityCommand.executeActISNReport(workspace, this._isnrLower, this._isnrUpper, ress);
            resources = ress[0];
            useSourcevset = true;
        } else {
            ActivityReport activityReport = null;
            try {
                activityReport = new ActivityReport(new URL(workspace.getRepository().getUrl()).getPath());
            }
            catch (MalformedURLException e) {
                Logger.traceInternalError(LOCATION, e, "MalformedURLException occurred while creating activity report because URL of repository was not correctly retrieved. URL " + workspace.getRepository().getUrl());
            }
            if (activityReport == null) {
                this._exitCode = 58;
                return;
            }
            if (!this._userName.equals("ALL")) {
                activityReport.addUserQuery(this._userName);
            }
            if (this._displayPL || this._displayPLOnly) {
                if (this._displayPLOnly) {
                    activityReport.applyToPropagationsOnly();
                } else if (this._displayPL) {
                    activityReport.applyToPropagations();
                }
            }
            if (this._displayCreatedOnly) {
                activityReport.applyToCreatedInWorkspaceOnly();
            }
            if (this._displayOnlyOpen ^ this._displayOnlyClosed) {
                if (this._displayOnlyOpen) {
                    activityReport.applyToOpenActivitiesOnly();
                } else if (this._displayOnlyClosed) {
                    activityReport.applyToClosedActivitiesOnly();
                }
            }
            if (this._isnrUpper != -1L || this._isnrLower != -1L) {
                if (this._isnrUpper == -1L && this._isnrLower != -1L) {
                    this._isnrUpper = Integer.MAX_VALUE;
                }
                activityReport.addIntegrationSequenceQuery((int)this._isnrLower, (int)this._isnrUpper);
            }
            if (this._indrUpper != null || this._indrLower != null) {
                if (this._indrUpper == null && this._indrLower != null) {
                    this._indrUpper = Timestamp.valueOf("9999-12-31 00:00:00");
                }
                activityReport.addIntegrationDateQuery(Converter.dateToHTTPDate((Date)this._indrLower), Converter.dateToHTTPDate((Date)this._indrUpper));
            }
            activityReport.addNamespace("DAV", "DAV:");
            activityReport.addNamespace(XCM.NAMESPACE_PREFIX, XCM.NAMESPACE_URI);
            ListActivityCommand.addWSToReport(activityReport, workspace);
            this.addPropertiesToReport(activityReport);
            IResponse response = null;
            try {
                response = DeltavCommand.execute((int)Command.getConnectionTemplateId((IVfsFolderItem)workspace), (IRequest)activityReport);
            }
            catch (VcmFailure e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VcmFailure occurred while getting activities for workspace " + workspace.getLocalPath() + " using activity report.");
                Command.getOut().println("Getting activties failed. " + e.getMessage());
            }
            if (response == null) {
                this._exitCode = 59;
                return;
            }
            if (this._isnDisplayTrue) {
                pairs = ListActivityCommand.getISNForActs(activityReport, workspace);
            }
            resources = activityReport.getResources();
        }
        HashMap<String, String> PathsToIsns = new HashMap<String, String>(pairs.length);
        int i = 0;
        while (i < pairs.length) {
            ActivityCommand.ActivityPathIsnPair pair = pairs[i];
            PathsToIsns.put(pair.activityPath, String.valueOf(pair.isn));
            ++i;
        }
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(this._sortField, this._sortKeyType);
        while (resources != null && resources.hasNext()) {
            ResourceElement elem = (ResourceElement)resources.next();
            if (elem == null) continue;
            this.displayActivityFromReport(elem, PathsToIsns, workspace, dh, useSourcevset);
        }
        dh.endDisplay(this._descendingOrder);
    }

    private boolean onlyNameAndOrISNAndOrWorkspaceRequired() {
        if (this._displayFiledsOrdered.size() > 3) {
            return false;
        }
        int i = 0;
        while (i < this._displayFiledsOrdered.size()) {
            if (!(((Field)this._displayFiledsOrdered.get(i)).isIt(ListActivityCommand.ACTUAL_NAME.fieldName) || ((Field)this._displayFiledsOrdered.get(i)).isIt(ListActivityCommand.INTEGRATION_NUMBER.fieldName) || ((Field)this._displayFiledsOrdered.get(i)).isIt(ListActivityCommand.WORKSPACE.fieldName))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ActivityCommand.ActivityPathIsnPair[] getISNForActs(ActivityReport activityReport, IVfsWorkspace workspace) {
        ArrayList<String> closedActivityPaths = new ArrayList<String>();
        Iterator resources = activityReport.getResources();
        while (resources != null && resources.hasNext()) {
            ResourceElement resourceElement = (ResourceElement)resources.next();
            String isClosed = resourceElement.getChildValue(XCM.VERSION_SET_STATE.localName, XCM.NAMESPACE_URI);
            if (!"closed".equalsIgnoreCase(isClosed)) continue;
            closedActivityPaths.add(resourceElement.getPath());
        }
        if (closedActivityPaths.size() > 0) {
            String[] activityPaths = closedActivityPaths.toArray(new String[closedActivityPaths.size()]);
            return ActivityCommand.executeActISNReport(workspace, activityPaths);
        }
        return new ActivityCommand.ActivityPathIsnPair[0];
    }

    private static void addWSToReport(ActivityReport activityReport, IVfsWorkspace workspace) {
        if (workspace != null) {
            try {
                activityReport.addWorkspaceQuery(workspace.getUrl());
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting url of workspace " + workspace.getLocalPath() + " for adding it to the activity query report.");
            }
        }
    }

    private void displayActivityFromReport(ResourceElement elem, Map PathsToIsns, IVfsWorkspace workspace, DisplayHelper displayHelper, boolean useSourcevset) {
        DisplayHelper.Row row = displayHelper.newRow();
        int j = 0;
        while (j < this._displayFiledsOrdered.size()) {
            String val;
            Field field = (Field)this._displayFiledsOrdered.get(j);
            if (field.isIt(ListActivityCommand.DISPLAY_NAME.fieldName)) {
                val = elem.getChildValue(DAV.DISPLAYNAME.localName, "DAV:");
                if (val == null) {
                    val = "";
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.ACTUAL_NAME.fieldName)) {
                val = "";
                val = useSourcevset ? elem.getChild("source-vset").firstChild().getValue() : elem.getPath();
                if ((val = PathUtil.getNameFromPath((String)Encoder.decodePath((String)val))) == null) {
                    val = "";
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.CREATED_BY.fieldName)) {
                val = elem.getChildValue(DAV.CREATOR_DISPLAYNAME.localName, "DAV:");
                if (val == null) {
                    val = "";
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.CREATED_ON.fieldName)) {
                val = elem.getChildValue(DAV.CREATIONDATE.localName, "DAV:");
                row.addDateField(field, val, this.getOutputDatePattern());
            } else if (field.isIt(ListActivityCommand.STATE.fieldName)) {
                val = elem.getChildValue(XCM.VERSION_SET_STATE.localName, XCM.NAMESPACE_URI);
                val = val == null ? "" : ("closed".equalsIgnoreCase(val) ? "Closed" : "Open");
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.CHECKIN_DATE.fieldName)) {
                val = elem.getChildValue(XCM.VERSION_SET_STATE.localName, XCM.NAMESPACE_URI);
                if ("closed".equalsIgnoreCase(val)) {
                    val = elem.getChildValue(DAV.GETLASTMODIFIED.localName, "DAV:");
                    if (val == null) {
                        val = "";
                    }
                } else {
                    val = "";
                }
                row.addDateField(field, val, this.getOutputDatePattern());
            } else if (field.isIt(ListActivityCommand.INTEGRATION_NUMBER.fieldName)) {
                val = "";
                val = useSourcevset ? elem.getChild("source-vset").firstChild().getValue() : elem.getPath();
                String isnVal = (String)PathsToIsns.get(val);
                if (isnVal == null) {
                    isnVal = "";
                }
                row.addField(field, isnVal);
            } else if (field.isIt(ListActivityCommand.INTEGRATION_DATE.fieldName)) {
                val = elem.getChildValue(XCM.VERSION_SET_STATE.localName, XCM.NAMESPACE_URI);
                if ("closed".equalsIgnoreCase(val) && workspace != null) {
                    PropertyElement cele = null;
                    cele = (PropertyElement)elem.getChild(XCM.INTEGRATION_SET.localName, XCM.NAMESPACE_URI);
                    Iterator children = cele.getExpandedResources();
                    while (children.hasNext()) {
                        Element element = (Element)children.next();
                        val = element.getChildValue(DAV.WORKSPACE.qualifiedName, "DAV:");
                        if (!"".equals(val = val.substring(val.indexOf(62) + 1))) {
                            val = val.substring(0, val.lastIndexOf(60));
                        }
                        if (!PathUtilities.preventTrailingSeparator((String)workspace.getAbsoluteRemotePath(), (IFileService)PathUtilities.REMOTE_FILESERVICE).equals(val)) continue;
                        val = element.getChildValue(DAV.CREATIONDATE.qualifiedName, "DAV:");
                        Date integrationDate = Converter.parseHTTPDate((String)val);
                        val = integrationDate.toString();
                        break;
                    }
                } else {
                    val = "";
                }
                row.addDateField(field, val, this.getOutputDatePattern());
            } else if (field.isIt(ListActivityCommand.IS_DEFAULT.fieldName)) {
                val = "";
                if (val == null) {
                    val = "";
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.IS_EMPTY.fieldName)) {
                Element celeopen;
                Element cele = elem.getChild(XCM.VERSION_SET.localName, XCM.NAMESPACE_URI);
                String value = cele != null && cele.countChildren() > 0 ? "False" : ((celeopen = elem.getChild(XCM.VERSION_SET.localName, XCM.NAMESPACE_URI)) != null && celeopen.countChildren() > 0 ? "False" : "True");
                row.addField(field, value);
            } else if (field.isIt(ListActivityCommand.CREATOR_WORKSPACE.fieldName)) {
                val = elem.getChildValue(DAV.WORKSPACE.localName, "DAV:");
                if (val == null) {
                    val = "";
                } else if (!"".equals(val = val.substring(val.indexOf(62) + 1))) {
                    val = val.substring(0, val.lastIndexOf(60));
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.WORKSPACE.fieldName)) {
                val = "";
                if (workspace != null) {
                    try {
                        val = "/" + workspace.getBrowsePath();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting field workspace.");
                        val = "<Could not retrieve workspace browse path>";
                    }
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.ACTIVITYID.fieldName)) {
                val = elem.getChildValue(XCM.OID.localName, XCM.NAMESPACE_URI);
                if (val == null) {
                    val = "";
                }
                row.addField(field, val);
            } else if (field.isIt(ListActivityCommand.DESCRIPTION.fieldName)) {
                val = elem.getChildValue(DAV.COMMENT.localName, "DAV:");
                if (val == null) {
                    val = "";
                }
                row.addField(field, val);
            }
            ++j;
        }
        row.end();
    }

    private void addPropertiesToReport(ActivityReport ar) {
        boolean propStateNotAdded = true;
        boolean propWSNotAdded = true;
        boolean atleastOnePropertyAdded = false;
        int j = 0;
        while (j < this._displayFiledsOrdered.size()) {
            Field field = (Field)this._displayFiledsOrdered.get(j);
            if (!field.isIt(ListActivityCommand.ACTUAL_NAME.fieldName)) {
                atleastOnePropertyAdded = true;
            }
            if (field.isIt(ListActivityCommand.DISPLAY_NAME.fieldName)) {
                ar.addSelectProperty(DAV.DISPLAYNAME.qualifiedName);
            } else if (field.isIt(ListActivityCommand.CREATED_BY.fieldName)) {
                ar.addSelectProperty(DAV.CREATOR_DISPLAYNAME.qualifiedName);
            } else if (field.isIt(ListActivityCommand.ACTIVITYID.fieldName)) {
                ar.addSelectProperty(XCM.OID.qualifiedName);
            } else if (field.isIt(ListActivityCommand.CREATED_ON.fieldName)) {
                ar.addSelectProperty(DAV.CREATIONDATE.qualifiedName);
            } else if (field.isIt(ListActivityCommand.STATE.fieldName)) {
                if (propStateNotAdded) {
                    ar.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
                    propStateNotAdded = false;
                }
            } else if (field.isIt(ListActivityCommand.CHECKIN_DATE.fieldName)) {
                ar.addSelectProperty(DAV.GETLASTMODIFIED.qualifiedName);
                if (propStateNotAdded) {
                    ar.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
                    propStateNotAdded = false;
                }
            } else if (field.isIt(ListActivityCommand.IS_EMPTY.fieldName)) {
                ar.addSelectProperty(XCM.VERSION_SET.qualifiedName);
                ar.addSelectProperty(DAV.ACTIVITY_CHECKOUT_SET.qualifiedName);
            } else if (field.isIt(ListActivityCommand.WORKSPACE.fieldName)) {
                if (propWSNotAdded) {
                    ar.addSelectProperty(DAV.WORKSPACE.qualifiedName);
                    propWSNotAdded = false;
                }
            } else if (field.isIt(ListActivityCommand.INTEGRATION_DATE.fieldName)) {
                if (propStateNotAdded) {
                    ar.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
                    propStateNotAdded = false;
                }
                ExpandPropertyDef intSet = ar.addPropertyExpand(XCM.INTEGRATION_SET.qualifiedName, XCM.NAMESPACE_URI, null);
                ar.addPropertyExpand(new ExpandPropertyDef(DAV.WORKSPACE.qualifiedName, "DAV:"), intSet);
                ar.addPropertyExpand(new ExpandPropertyDef(DAV.CREATIONDATE.qualifiedName, "DAV:"), intSet);
            } else if (field.isIt(ListActivityCommand.CREATOR_WORKSPACE.fieldName)) {
                if (propWSNotAdded) {
                    ar.addSelectProperty(DAV.WORKSPACE.qualifiedName);
                    propWSNotAdded = false;
                }
            } else if (field.isIt(ListActivityCommand.DESCRIPTION.fieldName)) {
                ar.addSelectProperty(DAV.COMMENT.qualifiedName);
            } else if (field.isIt(ListActivityCommand.INTEGRATION_NUMBER.fieldName)) {
                if (propWSNotAdded) {
                    ar.addSelectProperty(DAV.WORKSPACE.qualifiedName);
                    propWSNotAdded = false;
                }
                if (propStateNotAdded) {
                    ar.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
                    propStateNotAdded = false;
                }
            }
            ++j;
        }
        if (!atleastOnePropertyAdded) {
            ar.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
        }
    }

    private void displayActivities(IVfsActivity[] activities, IVfsWorkspace workspace) {
        int i;
        HashMap<String, Integer> absoluteRemotePathsToIsns = new HashMap<String, Integer>();
        if (this._isnDisplayTrue) {
            absoluteRemotePathsToIsns.clear();
            ArrayList<String> closedActivityPaths = new ArrayList<String>();
            i = 0;
            while (i < activities.length) {
                try {
                    if (!activities[i].isOpen()) {
                        closedActivityPaths.add(activities[i].getAbsoluteRemotePath());
                    }
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting activity remote path for activity " + activities[i].getUrl());
                }
                ++i;
            }
            if (closedActivityPaths.size() > 0) {
                String[] activityPaths = closedActivityPaths.toArray(new String[closedActivityPaths.size()]);
                ActivityCommand.ActivityPathIsnPair[] pairs = ActivityCommand.executeActISNReport(workspace, activityPaths);
                if (pairs.length != activityPaths.length) {
                    System.err.println("Warning: number of ISNs doesn't match number of requested activity paths!");
                }
                int i2 = 0;
                while (i2 < pairs.length) {
                    if (pairs[i2] != null) {
                        absoluteRemotePathsToIsns.put(Encoder.decodePath((String)pairs[i2].activityPath), new Integer(pairs[i2].isn));
                    }
                    ++i2;
                }
            }
        }
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(this._sortField, this._sortKeyType);
        i = 0;
        while (i < activities.length) {
            block55: {
                IVfsActivity activity;
                block56: {
                    activity = activities[i];
                    if (activity == null) break block55;
                    if (this._isnrLower == -1L && this._isnrUpper == -1L) break block56;
                    int isn = (Integer)absoluteRemotePathsToIsns.get(activity.getAbsoluteRemotePath());
                    if (this._isnrLower != -1L && (long)isn < this._isnrLower || this._isnrUpper != -1L && (long)isn > this._isnrUpper) break block55;
                }
                DisplayHelper.Row row = dh.newRow();
                int j = 0;
                while (j < this._displayFiledsOrdered.size()) {
                    Field field = (Field)this._displayFiledsOrdered.get(j);
                    try {
                        if (field.isIt(ListActivityCommand.DISPLAY_NAME.fieldName)) {
                            row.addField(field, activity.getDisplayName());
                        } else if (field.isIt(ListActivityCommand.ACTUAL_NAME.fieldName)) {
                            row.addField(field, activity.getName());
                        } else if (field.isIt(ListActivityCommand.CREATED_BY.fieldName)) {
                            row.addField(field, activity.getAuthor());
                        } else if (field.isIt(ListActivityCommand.CREATED_ON.fieldName)) {
                            row.addField(field, activity.getCreationDate(), this.getOutputDatePattern());
                        } else if (field.isIt(ListActivityCommand.STATE.fieldName)) {
                            boolean IsOpen = activity.isOpen();
                            if (IsOpen) {
                                row.addField(field, "Open");
                            } else {
                                row.addField(field, "Closed");
                            }
                        } else if (field.isIt(ListActivityCommand.CHECKIN_DATE.fieldName)) {
                            Date cindate = null;
                            if (!activity.isOpen()) {
                                cindate = activity.getCheckedInDate();
                            }
                            row.addField(field, cindate, this.getOutputDatePattern());
                        } else if (field.isIt(ListActivityCommand.INTEGRATION_NUMBER.fieldName)) {
                            Integer intNum = (Integer)absoluteRemotePathsToIsns.get(activity.getAbsoluteRemotePath());
                            if (intNum == null) {
                                row.addField(field, "");
                            } else {
                                row.addField(field, intNum.toString());
                            }
                        } else if (field.isIt(ListActivityCommand.IS_DEFAULT.fieldName)) {
                            boolean bIsDefault = activity.isDefaultActivity();
                            if (bIsDefault) {
                                row.addField(field, "True");
                            } else {
                                row.addField(field, "False");
                            }
                        } else if (field.isIt(ListActivityCommand.IS_EMPTY.fieldName)) {
                            boolean bIsEmpty = activity.isEmpty();
                            if (bIsEmpty) {
                                row.addField(field, "True");
                            } else {
                                row.addField(field, "False");
                            }
                        } else if (field.isIt(ListActivityCommand.CREATOR_WORKSPACE.fieldName)) {
                            IVfsRemoteLocator locator;
                            String creatorWorkspaceURL = activity.getWorkspaceUrl();
                            String remotePath = null;
                            if (creatorWorkspaceURL != null && !creatorWorkspaceURL.equals("") && (locator = Command.getContext(this._clientName).getRemoteLocatorFromUrl(creatorWorkspaceURL)) != null) {
                                remotePath = locator.getAbsoluteRemotePath();
                            }
                            if (remotePath == null) {
                                remotePath = "Could not retrieve creator workspace path";
                            }
                            row.addField(field, remotePath);
                        } else if (field.isIt(ListActivityCommand.WORKSPACE.fieldName)) {
                            String browsePath = "Could not retrieve workspace path";
                            if (workspace != null) {
                                browsePath = "/" + workspace.getBrowsePath();
                            }
                            row.addField(field, browsePath);
                        } else if (field.isIt(ListActivityCommand.ACTIVITYID.fieldName)) {
                            String actID = "Could not retrieve ID";
                            actID = activity.getObjectID();
                            row.addField(field, actID);
                        } else if (field.isIt(ListActivityCommand.INTEGRATION_DATE.fieldName)) {
                            row.addField(field, activity.getIntegrationDate(workspace), this.getOutputDatePattern());
                        } else if (field.isIt(ListActivityCommand.DESCRIPTION.fieldName)) {
                            String descStr = activity.getDescription();
                            if (descStr == null) {
                                descStr = "";
                            }
                            row.addField(field, descStr);
                        }
                    }
                    catch (VfsException exp) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting field " + field.fieldName);
                        row.addField(field, "<could not get " + field.fieldName + ">");
                    }
                    ++j;
                }
                row.end();
            }
            ++i;
        }
        dh.endDisplay(this._descendingOrder);
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.ACTIVITIES, false) + " [" + NameConfig.getOption(OptionName.USER, true) + " <user name>] " + "[" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName...] [" + NameConfig.getOption(OptionName.ISNRANGE, false) + " @isnlowerlimit [ @isnupperlimit ] ] [" + NameConfig.getOption(OptionName.ISN, true) + " isn..] [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " Workspacepath] [" + NameConfig.getOption(OptionName.FIELD, true) + "Fields] [" + NameConfig.getOption(OptionName.SORT, true) + " State] [" + NameConfig.getOption(OptionName.UNFORMATTED, true) + "]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Displays a list of activities", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "If specified the activity list will be restricted to the activities which belong to this workspace only. If a workspace is not specified and the current directory (in shell mode) of the user is under a workspace then the activities will be shown for only that workspace. If user is not under a workspace all activties will be shown ", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISNRANGE, 1, "This option whould be specified if the listing has to be restricted based on ISN's of the activity.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISNRANGE, 1, "The usage of the option to specify a range is as follows:", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISNRANGE, 1, NameConfig.getOption(OptionName.ISNRANGE, false) + " @isnlowerlimit [@isnupperlimit]", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISNRANGE, 1, "ex :" + NameConfig.getOption(OptionName.ISNRANGE, false) + " @3 @8", false);
        this.printOptionHelp(OptionName.ISNRANGE, 1, "Here activities will be listed whose ISN is between 3 & 8", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISNRANGE, 1, "ex :" + NameConfig.getOption(OptionName.ISNRANGE, false) + " @8", false);
        this.printOptionHelp(OptionName.ISNRANGE, 1, "Here activities will be listed whose ISN is greater than 8", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INDRANGE, 1, "This option whould be specified if the listing has to be restricted based on integration dates of the activity.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INDRANGE, 1, "The usage of the option to specify a range is as follows:", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INDRANGE, 1, NameConfig.getOption(OptionName.INDRANGE, false) + " @indlowerlimit [@indupperlimit]", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Both indlowerlimit & indupperlimit are timestamps", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "The format of the timestamp is:", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "yyyy-mm-dd hh:mm:ss", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INDRANGE, 1, "ex :" + NameConfig.getOption(OptionName.INDRANGE, false) + " \"@2003-04-01 00:00:00\" \"@2003-05-01 00:00:00\"", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Here activities will be listed which were integrated between 1st April 2003 & 1st May 2003", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.INDRANGE, 1, "ex :" + NameConfig.getOption(OptionName.INDRANGE, false) + " \"@2003-04-01 00:00:00\"", false);
        this.printOptionHelp(OptionName.INDRANGE, 1, "Here activities will be listed which were integrated after 1st April 2003", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ALLWORKSPACES, 1, "If the user is under a workspace and still wants to view all activities then this option has to be used.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the activity list will be restricted to the activities whose names are provided", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISN, 1, "If specified the activity list will be restricted to the activities whose isn's are provided", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISN, 1, "NOTE: If integration sequence numbers are specified then a workspace has to be specified as isn of an activity is dependent on the workspace", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If activities are specified using either " + NameConfig.getOption(OptionName.ACTIVITY, true) + " or " + NameConfig.getOption(OptionName.ISN, true) + " then the restriction " + "of " + NameConfig.getOption(OptionName.WORKSPACE, true) + " does not hold. That is all the activities of the workspace will " + "not be shown. Also none of the other restrictions specified using the options below will apply.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.OPEN, 1, "If specified the activity list will be restricted to the open activities", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.CLOSED, 1, "If specified the activity list will be restricted to the closed activities", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.EMPTY, 1, "If specified the activity list will also contain list of empty activities", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.EMPTY_EX, 1, "If specified the activity list will contain only a list of empty activities", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.EMPTY_EX, 1, "NOTE: The above 2 options for listing empty activities will not work if:", false);
        this.printOptionHelp(OptionName.EMPTY_EX, 1, "1. Specific workspaces are given", false);
        this.printOptionHelp(OptionName.EMPTY_EX, 1, "2. If the current directory ( in shell mode) is under a workspace and " + NameConfig.getOption(OptionName.ALLWORKSPACES, false) + " option is not specified", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.CREATEDONLY, 1, "If specified the activity list will contain list of activities created in the workspaces specified", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROPAGATIONLISTS, 1, "If specified the activity list will also contain list of propagation-lists", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROPAGATIONLISTS_EX, 1, "If specified the activity list will contain propagation-lists only", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "If specified the activity list will be restricted to the activities of the specified user", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "If the user name is given as \"ALL\" the activities of all users will be shown", false);
        this.printOptionHelp(OptionName.USER, 1, "Not all options work in conjugation with each other.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "There are 3 possibilities which are listed below also giving the restriction options that work with the corresponding possibility:", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "a. User not specified:", false);
        this.printOptionHelp(OptionName.USER, 1, "   " + NameConfig.getOption(OptionName.CLOSED, true) + "/" + NameConfig.getOption(OptionName.OPEN, true) + "/" + NameConfig.getOption(OptionName.ISNRANGE, false) + "/" + NameConfig.getOption(OptionName.EMPTY, true) + "/" + NameConfig.getOption(OptionName.EMPTY_EX, true), false);
        this.printOptionHelp(OptionName.USER, 1, "b. User specified:", false);
        this.printOptionHelp(OptionName.USER, 1, "(i).  Only ActualName (and,or) ISN (and,or) Workspace required for closed activities of all users", false);
        this.printOptionHelp(OptionName.USER, 1, "      " + NameConfig.getOption(OptionName.ISNRANGE, false), false);
        this.printOptionHelp(OptionName.USER, 1, "(ii). Other combinations", false);
        this.printOptionHelp(OptionName.USER, 1, "      " + NameConfig.getOption(OptionName.CLOSED, true) + "/" + NameConfig.getOption(OptionName.OPEN, true) + "/" + NameConfig.getOption(OptionName.ISNRANGE, false) + "/" + NameConfig.getOption(OptionName.INDRANGE, false) + "/" + NameConfig.getOption(OptionName.PROPAGATIONLISTS, true) + "/" + NameConfig.getOption(OptionName.PROPAGATIONLISTS_EX, true) + "/" + NameConfig.getOption(OptionName.CREATEDONLY, true) + "/" + NameConfig.getOption(OptionName.EMPTY, true) + "/" + NameConfig.getOption(OptionName.EMPTY_EX, true), false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Using this option you can specify the properties of the activities that have to be displayed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Example:", false);
        this.printOptionHelp(OptionName.FIELD, 1, "List " + NameConfig.getOption(OptionName.FIELD, true) + "DisplayName " + NameConfig.getOption(OptionName.FIELD, true) + "CheckInDate", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "The fields that can be specified are:", false);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "DisplayName/DN", "Gives display name of activity", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "ActualName/AN", "Gives actual name of activity. This is the name which has to be given as input where activity name has to be specified", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CreatedOn/COn", "Creation date of the activity", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CreatedBy/CBy", "Name of the user who created the activity", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "State/St", "Current state of the activity (Open/Closed)", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CheckinDate/CInD", "Date on which the activity was checked in", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "Description/Des", "Description associated with the activity", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "IntegrationNumber/IN ", "ISN of the activity", true);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "IntegrationNumber/IN", "NOTE: If integration numbers are to be displayed then a workspace has to be specified as isn of an activity is dependent on the workspace. This is only if " + NameConfig.getOption(OptionName.ACTIVITY, true) + " and/or " + NameConfig.getOption(OptionName.ISN, true) + " options are used.", false);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "IntegrationDate/IND", "The date of integration of the activity in the current workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "IsDefault/ID", "Gives whether given activity is the default activity for this workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "IsEmpty/IE", "Gives whether given activity is empty. Is very expensive to find so should be used with caution.", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "CreatorWorkspace/CWS", "Gives the workspace to which the activity is associated", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "Workspace/WS", "Gives current workspace based on which ISN is listed", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "ActivityID/ActID", "Gives the object id of the activity", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "All", "Prints all the above fields except IsEmpty", true);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "Dummy", "For more information on the use of " + NameConfig.getOption(OptionName.FIELD, true) + " option see usage", false);
        this.printOptionHelpEx(OptionName.FIELD, 1, "Dummy", "dtr Help Usage", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SORT, 1, "Using this option you can specify the field based on which sorting of the output has to be done. The fields that can be specified are the ones listed above. Sorting is in ascending order by default", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SORT, 1, "Note: Sorting of output activities will be per workspace", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DESCENDING, 1, "Specify this option along with sort to sort output in descending order.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "If this is specified then the field values will not be truncated to fit into a given space. But it might lead to output that is not easy to read.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "It is recommended that this be used only for scripting.", false);
        Command.getOut().println();
    }

    private static int getFieldLength(String field, int defVal) {
        return CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.field.activity." + field.toLowerCase(), defVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

