/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.deltavlib.xcm.EIntegrateOption;
import com.tssap.dtr.client.lib.propagation.clientapi.IIntegration;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsIntegrationMode;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;

class IntegrateCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$IntegrateCommand == null ? (class$com$tssap$dtr$client$commandline$IntegrateCommand = IntegrateCommand.class$("com.tssap.dtr.client.commandline.IntegrateCommand")) : class$com$tssap$dtr$client$commandline$IntegrateCommand));
    private VfsIntegrationMode _integrationMode;
    private boolean _testIntegrate;
    private boolean _testPresence;
    private boolean _isPropagationlist;
    protected String _propagationlistName;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$IntegrateCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new IntegrateCommand(arguments);
    }

    IntegrateCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this.addSupportedOption(OptionName.TEST);
        this.addSupportedOption(OptionName.TEST_INTEGRATE);
        this.addSupportedOption(OptionName.PROPAGATION_LIST);
        this._allowMultipleWSPaths = true;
        this._integrationMode = VfsIntegrationMode.KEEP_WORKSPACE_VERSION;
        this._testPresence = false;
        this._testIntegrate = false;
        this._isPropagationlist = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "integrates the activity into the given workspace";
    }

    public CommandName getCommandName() {
        return CommandName.INTEGRATE;
    }

    public boolean execute() {
        IVfsIntegrateCollision[] integrateCollisions;
        IVfsFolderItem folderItem;
        this._displayNameSpecified = false;
        if (this._workspacePaths.length < 2) {
            if (this.getFileSystemManager() == null) {
                return false;
            }
            String tmpWSPath = this._workspacePaths[0];
            this._workspacePaths = null;
            this._workspacePaths = new String[2];
            this._workspacePaths[0] = Utilities.getCurrentDirectory();
            this._workspacePaths[1] = tmpWSPath;
        }
        IVfsActivity activity = null;
        if (this._activityISN != -1) {
            IVfsWorkspace workspace = this.getWorkspace();
            if (workspace == null) {
                if (this._exitCode != 3) {
                    this._exitCode = 30;
                }
                Command.getOut().println("Could not find source workspace");
                return false;
            }
            int[] isns = ActivityCommand.convertActivityISNsFromStringsToNumbers(this._activityISNs);
            ActivityCommand.ActivityPathIsnPair[] actURLs = ActivityCommand.executeActISNReport(workspace, isns);
            if (actURLs.length == 0) {
                Command.getOut().println("Could not find the given activity");
                this._exitCode = 32;
                return false;
            }
            try {
                activity = workspace.getRepository().getActivityByUrl(Command.getWebLocator((IVfsFolderItem)workspace) + actURLs[0].activityPath);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException during retrieving activity with path " + actURLs[0].activityPath);
                this._exitCode = 32;
                return false;
            }
        } else if (!this._isPropagationlist && (activity = this.getActivity(true, false)) == null) {
            return false;
        }
        if ((folderItem = this.getResource(this._workspacePaths[1])) == null) {
            Command.getOut().println("Could not find target workspace");
            this._exitCode = 31;
            return false;
        }
        IVfsWorkspace workspace = folderItem.asWorkspace();
        if (workspace == null) {
            Command.getOut().println("Could not find target workspace");
            this._exitCode = 31;
            return false;
        }
        if (this._isPropagationlist) {
            return this.integratePropagationlist(workspace);
        }
        if (this._testPresence) {
            String activityPath;
            try {
                activityPath = new URL(activity.getUrl()).getPath();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.getMessage());
            }
            ActivityCommand.ActivityPathIsnPair[] isns = ActivityCommand.executeActISNReport(workspace, new String[]{activityPath});
            if (isns != null && isns.length > 0 && isns[0] != null && isns[0].isn > 0) {
                this._exitCode = 46;
                Command.getOut().println("The activity is already integrated");
                return true;
            }
            if (!this._testIntegrate) {
                this._exitCode = 47;
                Command.getOut().println("The activity is not integrated");
                return true;
            }
        }
        try {
            integrateCollisions = activity.integrate(workspace, this._integrationMode);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during integration of activity.");
            Command.getOut().println("Integration failed: " + e.getMessage());
            this._exitCode = 94;
            return false;
        }
        Command.getOut().println("The activity is successfully integrated");
        if (integrateCollisions != null && integrateCollisions.length > 0) {
            this._exitCode = 48;
            Command.getOut().println("Collsions are present after the integrate");
            int i = 0;
            while (i < integrateCollisions.length) {
                Command.getOut().println();
                IVfsIntegrateCollision integrateCollision = integrateCollisions[i];
                IVfsVersion version = integrateCollision.getValidSourceVersion();
                IVfsVersion collidingVersion = integrateCollision.getCollidingVersion();
                if (version != null) {
                    IVfsWorkspace workspaceOfActivity = activity.getWorkspace();
                    String remotePath = version.toString(workspace);
                    Command.getOut().println("Folder item is " + remotePath);
                    Command.getOut().println("Conflict type is " + integrateCollision.getCollisionType());
                    Command.getOut().println("Active version is " + remotePath + " @" + version.getBranchSequenceNumber());
                    if (!integrateCollision.getCollisionType().equals(VfsCollisionType.NAME_CLASH)) {
                        remotePath = collidingVersion.toString(workspaceOfActivity);
                        Command.getOut().println("Coflicting version is " + remotePath + " @" + collidingVersion.getBranchSequenceNumber());
                    }
                }
                ++i;
            }
            Command.getOut().println();
            if (!this._noUI) {
                this.resolveCollisions((IVfsCollision[])integrateCollisions, activity, workspace);
            }
        }
        return true;
    }

    public boolean validateArguments() {
        if (this._workspacePaths.length == 0) {
            return false;
        }
        if (this._isPropagationlist) {
            if (this._testPresence) {
                Command.getOut().println("Test option not supported for propagationlists.");
                return false;
            }
            if (this._propagationlistName == null || this._propagationlistName.trim().length() == 0) {
                Command.getOut().println("Must specify a propagation list name.");
                return false;
            }
        } else if ((this._activityName == null || this._activityName.length() == 0) && this._activityISN == -1) {
            Command.getOut().println("Must specify activity name or integration sequence number.");
            return false;
        }
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.INTEGRATE, false) + " " + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName " + NameConfig.getOption(OptionName.PROPAGATION_LIST, true) + " _propagationlistName " + NameConfig.getOption(OptionName.ISN, true) + " ISN [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " SourceWorkspacePath] " + NameConfig.getOption(OptionName.WORKSPACE, true) + " TargetWorkspacePath [ " + NameConfig.getOption(OptionName.FORCE, true) + " ] ");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Integrate an activity into another workspace", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name(Actual) of the activity to be integrated", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PROPAGATION_LIST, 1, "Name(Actual) of the propagationlist to be integrated", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISN, 1, "ISN of the activity can be specified.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "workspace path to specify the workspace to which the activity has to be integrated(target) and the workspace from which the activity has to be taken (source). Source workspace is required only if the ISN is specified. If source workspace is not specified then the current directory will be used to deduce it.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "Specifies the action to be taken in case of conflicts.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If not specified then the version of the target workspace remains active after the integrate and a conflict is reported.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If specified then the version being integrated becomes the active version after the integrate and a conflict is reported.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SILENT, 1, "Will suppress the prompting for conflict resolution", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TEST, 1, "If specified then it will check whether the activity has been integrated to the target workspace or not and output appropriate message.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TEST_INTEGRATE, 1, "If specified then it will check whether the activity has been integrated to the target workspace or not. It will give appropriate message if it has been integrated. If it has not been integrated yet it will integrate the activity to the target workspace.", true);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String fShort = NameConfig.getOption(OptionName.FORCE, true);
                String fLong = NameConfig.getOption(OptionName.FORCE, false);
                String tShort = NameConfig.getOption(OptionName.TEST, true);
                String tLong = NameConfig.getOption(OptionName.TEST, false);
                String tiShort = NameConfig.getOption(OptionName.TEST_INTEGRATE, true);
                String tiLong = NameConfig.getOption(OptionName.TEST_INTEGRATE, false);
                String pShort = NameConfig.getOption(OptionName.PROPAGATION_LIST, true);
                String pLong = NameConfig.getOption(OptionName.PROPAGATION_LIST, false);
                if (lowerCaseArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    this._integrationMode = VfsIntegrationMode.FORCE_INTEGRATE_VERSION;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(pShort) || lowerCaseArg.startsWith(pLong)) {
                    this._isPropagationlist = true;
                    String _propName = Command.getActualArgument(currArg, tShort, pLong);
                    if ("".equals(_propName) && i + 1 < arguments.size()) {
                        _propName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                    this._propagationlistName = _propName;
                } else if (lowerCaseArg.startsWith(tShort) || lowerCaseArg.startsWith(tLong)) {
                    this._testPresence = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.equals(tiShort) || lowerCaseArg.equals(tiLong)) {
                    this._testPresence = true;
                    this._testIntegrate = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    private boolean integratePropagationlist(IVfsWorkspace target) {
        PropgationlistIntegrate integrate = new PropgationlistIntegrate(target);
        return integrate.execute();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PropgationlistIntegrate
    extends PropagationCommand {
        private IVfsWorkspace _target;

        public PropgationlistIntegrate(IVfsWorkspace target) {
            super(null);
            this._target = target;
        }

        public boolean execute() {
            boolean retVal = false;
            if (!this.pingServer()) {
                return retVal;
            }
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            EIntegrateOption forceIntegrate = EIntegrateOption.KEEP_WORKSPACE_VERSION;
            if (IntegrateCommand.this._integrationMode == VfsIntegrationMode.FORCE_INTEGRATE_VERSION) {
                forceIntegrate = EIntegrateOption.FORCE_INTEGRATE_VERSION;
            }
            IIntegration integration = null;
            try {
                integration = this._propManager.integrate(this.removeLeadingSlash("/prop/" + IntegrateCommand.this._propagationlistName), this._target.getBrowsePath(), forceIntegrate);
            }
            catch (PropagationPreconditionException ex) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException occurred during integration of propagation list");
                this.writeMessage("Propagation list could not be integrated. " + ex.getMessage());
            }
            catch (PropagationException ex) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException occurred during integration of propagation list");
                this.writeMessage("Propagation list could not be integrated. " + ex.getMessage());
            }
            catch (VfsException ex) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VfsException occurred while retrieving browse path of target workspace.");
                this.writeMessage("Falied to retrieve the browse path of the target workspace. " + ex.getMessage());
            }
            try {
                if (integration.getCollisionCount() != 0) {
                    this.writeMessage("The propagationlist \"" + IntegrateCommand.this._propagationlistName + "\"  was integrated with " + integration.getCollisionCount() + " collisions");
                } else {
                    this.writeMessage("The propagationlist \"" + IntegrateCommand.this._propagationlistName + "\" was successfully integrated.");
                }
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex.toString());
            }
            retVal = true;
            return retVal;
        }

        public String getDescription() {
            return null;
        }

        public void printHelpDescription() {
        }

        public ICommand createCommand(String name, ArrayList arguments) {
            return null;
        }
    }
}

