/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.Workspace;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatable;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ImportCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ImportCommand == null ? (class$com$tssap$dtr$client$commandline$ImportCommand = ImportCommand.class$("com.tssap.dtr.client.commandline.ImportCommand")) : class$com$tssap$dtr$client$commandline$ImportCommand));
    private String _workspaceFolder;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ImportCommand;

    public ImportCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.IMPORTFILE);
        this.addSupportedOption(OptionName.WORKSPACEFOLDER);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "imports the contents of the blob into the repository";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        File file = new File(this._fileName);
        IPropagatable propagatable = null;
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            propagatable = this._workspaceFolder == null ? this._propManager.import_((InputStream)new FileInputStream(file), (byte)0, file.length()) : this._propManager.import_((InputStream)new FileInputStream(file), (byte)0, file.length(), new Workspace(this._workspaceFolder).getPath());
            this.writeMessage("imported \"" + this.getPath(propagatable.getId()) + "\"");
            retVal = true;
        }
        catch (FileNotFoundException ex) {
            Logger.traceUserError(LOCATION, ex, "FileNotFoundException occurred. File \"" + this._fileName + "\" not found or cannot be accessed");
            this.writeMessage("File \"" + this._fileName + "\" not found or cannot be accessed");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "Import failed.");
            this.writeMessage("Import failed. " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "Import failed.");
            this.writeMessage("Import failed. " + ex.getMessage());
        }
        return retVal;
    }

    public boolean validateArguments() {
        boolean isValidateArguments = true;
        if (this._resourcePath == null) {
            this._resourcePath = "/";
        }
        if (this._fileName == null) {
            this.writeMessage("Must specify file name.");
            isValidateArguments = false;
        } else {
            File file = new File(this._fileName);
            if (!file.exists() || file.isDirectory()) {
                this.writeMessage("File '" + file.getAbsolutePath() + "' does not exist.");
                isValidateArguments = false;
            }
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        String wsfShortOptName = NameConfig.getOption(OptionName.WORKSPACEFOLDER, true);
        String wsfLongOptName = NameConfig.getOption(OptionName.WORKSPACEFOLDER, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null || wsfShortOptName.compareToIgnoreCase(currentArg) != 0 && wsfLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._workspaceFolder = (String)listIterator.next();
            listIterator.remove();
        }
        super.setArguments(arguments);
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.IMPORT, false) + " " + NameConfig.getOption(OptionName.IMPORTFILE, true) + " \"file name\" [ " + NameConfig.getOption(OptionName.WORKSPACEFOLDER, true) + " \"workspace folder path\" ]");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Imports the contents of a blob into the repository and returns the imported url. In case a workspace was imported, then the workspace would be opened for modifications if the export mode was either RELOCATE WORKSPACE (8) or RELOCATE WORKSPACE INCL SNAPSHOTS (12). ", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTFILE, 1, "Name of the file which has the blob contents. Must be a valid blob file that was created with the EXPORT command.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.WORKSPACEFOLDER, 1, "The target workspace folder for the imported workspace. In case the blob file was created by the export mode RELOCATE WORKSPACE (8) or RELOCATE WORKSPACE INCL SNAPSHOTS (12) and access to the workspace is required under a different workspace folder, you can specify the new workspace folder for the workspace. The specified workspace folder must exist in the repository.", true);
    }

    public CommandName getCommandName() {
        return CommandName.IMPORT;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ImportCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

