/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.Commands;
import com.tssap.dtr.client.commandline.ExitCodes;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.ICommands;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

class HelpCommand
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$HelpCommand == null ? (class$com$tssap$dtr$client$commandline$HelpCommand = HelpCommand.class$("com.tssap.dtr.client.commandline.HelpCommand")) : class$com$tssap$dtr$client$commandline$HelpCommand));
    private ArrayList _helpArgs;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$HelpCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new HelpCommand(arguments);
    }

    HelpCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "prints the help message";
    }

    public CommandName getCommandName() {
        return CommandName.HELP;
    }

    public boolean execute() {
        ICommands commands = Commands.getCommands();
        if (this._helpArgs.size() == 0) {
            this.printHelpDescription();
        }
        while (this._helpArgs.size() > 0) {
            if ("simple".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                Command.getOut().println("Most common dtr commands");
                Command.getOut().println();
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.SYNC, false), new String[0]).getHelpText());
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.ADD, false), new String[0]).getHelpText());
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.EDIT, false), new String[0]).getHelpText());
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.DELETE, false), new String[0]).getHelpText());
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.REVERT, false), new String[0]).getHelpText());
                Command.getOut().println();
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.HISTORY, false), new String[0]).getHelpText());
                Command.getOut().println();
                Command.getOut().println(commands.getCommand(NameConfig.getCommandName(CommandName.CHECKIN, false), new String[0]).getHelpText());
            } else if ("commands".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                TreeSet sortedSet = new TreeSet(commands.getAllCommands());
                Iterator sortedCommands = sortedSet.iterator();
                Command.getOut().println("All dtr commands");
                Command.getOut().println();
                while (sortedCommands.hasNext()) {
                    ICommand command = (ICommand)sortedCommands.next();
                    if (command.isHidden()) continue;
                    String alias = command.getAlias();
                    String name = command.getName() + (alias != null && !alias.equals("") ? "/" + alias : "");
                    this.printOptionHelpEx(null, 0, name, command.getDescription(), true);
                }
                this.printOptionHelpEx(null, 0, "exit", "exits the shell", true);
                Command.getOut().println();
            } else if ("configure".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                this.printOptionHelp(null, 0, "Following is the list of properties which can be set in the properties file for commandline", false);
                Command.getOut().println("All properties have to start with");
                Command.getOut().println("com.tssap.dtr.client.commandline.");
                Command.getOut().println();
                Command.getOut().println("For settings console width");
                Command.getOut().println("consolewidth");
                Command.getOut().println();
                Command.getOut().println("For settings indent length");
                Command.getOut().println("indentlength");
                Command.getOut().println();
                Command.getOut().println("For settings separator string when output is unformatted");
                Command.getOut().println("separatorchar");
                Command.getOut().println();
                Command.getOut().println("For more on setting default field widths for listing commands use");
                Command.getOut().println(NameConfig.getCommandName(CommandName.HELP, false) + " usage");
                Command.getOut().println();
                Command.getOut().println("For settings command names");
                Command.getOut().println("All properties to set command names have to start with");
                Command.getOut().println("For command names : com.tssap.dtr.client.commandline.command.");
                Command.getOut().println("For aliases       : com.tssap.dtr.client.commandline.command.short.");
                Command.getOut().println();
                this.printOptionHelpEx(null, 0, "Name", "Command to", true);
                Command.getOut().println();
                Iterator iter = CommandName._commandnamesColl.iterator();
                while (iter.hasNext()) {
                    CommandName element = (CommandName)iter.next();
                    this.printOptionHelpEx(null, 0, element.getIdentifier(), element.getComment(), true);
                }
                Command.getOut().println();
                Command.getOut().println("For settings options");
                Command.getOut().println("All properties to set options have to start with");
                Command.getOut().println("For options       : com.tssap.dtr.client.commandline.option.");
                Command.getOut().println("For short options : com.tssap.dtr.client.commandline.option.short.");
                Command.getOut().println();
                this.printOptionHelpEx(null, 0, "Name", "Option used to", true);
                Command.getOut().println();
                Iterator iter2 = OptionName._optionsColl.iterator();
                while (iter2.hasNext()) {
                    OptionName element = (OptionName)iter2.next();
                    this.printOptionHelpEx(null, 0, element.getIdentifier(), element.getComment(), true);
                }
                Command.getOut().println();
            } else if ("options".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                int index = 1;
                while (index < this._helpArgs.size()) {
                    String nextArg = (String)this._helpArgs.get(index);
                    ICommand command = commands.getCommand(nextArg.toLowerCase(), new String[0]);
                    if (command != null) {
                        Command.getOut().println("Options supported by command \"" + command.getName() + "\"");
                        Command.getOut().println();
                        this._helpArgs.remove(index);
                        ++index;
                        Iterator iter = command.getSupportedOptions().iterator();
                        while (iter.hasNext()) {
                            OptionName element = (OptionName)iter.next();
                            String name = NameConfig.getOption(element, false);
                            if (!NameConfig.getOption(element, true).equals("")) {
                                name = name + "/" + NameConfig.getOption(element, true);
                            }
                            this.printOptionHelpEx(null, 0, name, element.getComment(), true);
                        }
                        continue;
                    }
                    break;
                }
            } else if ("exitcodes".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                Map exMap = ExitCodes.getExitCodesMap();
                int code = -1;
                Command.getOut().println("Dtr exit codes and there interpretation");
                this.printOptionHelpEx(null, 0, "Codes", "Interpretation", true);
                if (this._helpArgs.size() > 1) {
                    try {
                        code = Integer.parseInt((String)this._helpArgs.get(1));
                    }
                    catch (NumberFormatException e) {
                        Logger.traceUserError(LOCATION, e, "NumberFormatException occurred. Code not specified correctly.");
                        code = -1;
                    }
                }
                if (code != -1) {
                    String text = (String)exMap.get(new Integer(code));
                    if (text != null) {
                        this._helpArgs.remove(1);
                        this.printOptionHelpEx(null, 0, "" + code, text, true);
                    }
                } else {
                    int index = 0;
                    while (index < exMap.size()) {
                        String text = (String)exMap.get(new Integer(index));
                        if (text != null) {
                            this.printOptionHelpEx(null, 0, "" + index, text, true);
                        }
                        ++index;
                    }
                }
                Command.getOut().println();
            } else if ("usage".equalsIgnoreCase((String)this._helpArgs.get(0))) {
                Command.getOut().println();
                Command.getOut().println("dtr is DTR's client tool for the command line.");
                Command.getOut().println();
                Command.getOut().println("Below is the list of the common options that can be specified to the tool");
                Command.getOut().println();
                this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the files will be checked out in the", true);
                this.printOptionHelp(OptionName.ACTIVITY, 1, "(Edit/Delete/Upload/DownloadActivity...)", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.WORKSPACE, 1, "The path ofthe workspace to work with. Unless specified in the help of a command the path could be", true);
                Command.getOut().println();
                this.printOptionHelp(OptionName.WORKSPACE, 1, "absolute local path", false);
                this.printOptionHelp(OptionName.WORKSPACE, 1, "relative local path", false);
                this.printOptionHelp(OptionName.WORKSPACE, 1, "browse path", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "The name of the property which has to be displayed. The name of the field should follow the option without any spaces in between", true);
                this.printOptionHelp(OptionName.FIELD, 1, "Example", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "List " + NameConfig.getOption(OptionName.FIELD, true) + "CheckInDate", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "It can additionally be specified the max no of characters that should be used to output the field", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "Example", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "List " + NameConfig.getOption(OptionName.FIELD, true) + "CheckInDate10", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "The CheckInDate will then be printed in a space of 10 characters. If the field exceeds this size it will be truncated to fit the size", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "For setting the default no of characters to be used to display a field the properties file for commandline can be used. The property names for the same are as follows. ", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.FIELD, 1, "They all must start with:", false);
                this.printOptionHelp(OptionName.FIELD, 1, "'com.tssap.dtr.client.commandline.field.'", false);
                this.printOptionHelp(OptionName.FIELD, 1, "This should be followed by the resource to which the field belongs:", false);
                this.printOptionHelp(OptionName.FIELD, 1, "1. activity.", false);
                this.printOptionHelp(OptionName.FIELD, 1, "2. workspace.", false);
                this.printOptionHelp(OptionName.FIELD, 1, "3. resource.", false);
                this.printOptionHelp(OptionName.FIELD, 1, "4. mountpoint.", false);
                this.printOptionHelp(OptionName.FIELD, 1, "This should be followed by the long name of the field. for example 'checkindate'", false);
                this.printOptionHelp(OptionName.FIELD, 1, "Examples:", false);
                this.printOptionHelp(OptionName.FIELD, 1, "'com.tssap.dtr.client.commandline.field.workspace.displayname'", false);
                this.printOptionHelp(OptionName.FIELD, 1, "'com.tssap.dtr.client.commandline.field.activity.checkindate'", false);
                Command.getOut().println();
                this.printOptionHelp(OptionName.CURR_ACT, 1, "To specify that current activity has to be used where required", true);
                Command.getOut().println();
                this.printOptionHelp(null, 1, "FolderItem Paths: Unless specified in the help of a command the path could be", false);
                Command.getOut().println();
                this.printOptionHelp(null, 1, "absolute local path", false);
                this.printOptionHelp(null, 1, "relative local path", false);
                this.printOptionHelp(null, 1, "browse path", false);
                Command.getOut().println();
                this.printOptionHelp(null, 1, "browse path will not be allowed to have wildchars", false);
                Command.getOut().println();
                this.printOptionHelp(null, 1, "Some of the commonly used terms in help/error messages", false);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "Folder item", "Files/Folders that are stored in the DTR Server. Some times it can also represent workspaces or workspace folders depending on the context", true);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "Client", "A user can connect to more than one logical system from his/her machine. Each client on the user machine represents a client for one logical system and defines mappings between remote and local folders i.e. mount points.", true);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "System", "For each client the system gives information regarding the servers identified by their URL. The technical aspects of a server such as timeouts are defined in the the 'servers.xml' . Additionally the client contains filters that restrict the remote view to certain folders /subtrees.", true);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "Mountpoint", "Remote folders (present on the server) can be mounted at different paths on the client using mountpoints. Each mountpoint specifies the remote folder being mounted and the local folder onto which the remote folder is mounted. Mountpoints cannot overlap within a client - neither remotely nor locally.", true);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "ISN", "Integration sequence number", true);
                Command.getOut().println();
                this.printOptionHelpEx(null, 1, "Predecessors", "All activities, which are not integrated in the workspace and contain predecessor versions of the versions in the given activity", true);
                Command.getOut().println();
            } else {
                ICommand command = commands.getCommand(((String)this._helpArgs.get(0)).toLowerCase(), new String[0]);
                if (command != null) {
                    Command.getOut().println(command.getHelpText());
                    command.printHelpDescription();
                } else {
                    Command.getOut().println("no help for " + (String)this._helpArgs.get(0));
                }
            }
            this._helpArgs.remove(0);
        }
        Command.getOut().println();
        Command.getOut().println("Commandline client Version : 1.60");
        Command.getOut().println();
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr is DTR's client tool for the command line.");
        Command.getOut().println("It can be used in 2 modes");
        Command.getOut().println("- As a simple command line client");
        Command.getOut().println("- As a shell");
        Command.getOut().println();
        Command.getOut().println("The shell can be started using dtrshell");
        Command.getOut().println();
        Command.getOut().println("In both these modes the user will require to logon through a popup unless the commands being used do not connect to the DTR server(Exa: help command).");
        Command.getOut().println("If it is required that the login popup does not appear then one of the following should be true.");
        Command.getOut().println("1. The vfs config folder should have a user.xml file.");
        Command.getOut().println("2. The username & password should be specified using the following commandline options:");
        Command.getOut().println("    a. --username/-un <username>");
        Command.getOut().println("    b. --password/-pwd <pwd>");
        Command.getOut().println();
        Command.getOut().println("Note that if only the user name is specified as commandline argument even then the user will be asked for the password via a popup.");
        Command.getOut().println();
        Command.getOut().println("using the " + NameConfig.getOption(OptionName.CLIENTDEF, false) + " option the client to be used can be specified");
        Command.getOut().println();
        Command.getOut().println("Once in the shell all commands can be used without using dtr before them");
        Command.getOut().println();
        Command.getOut().println("Try:");
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " simple         list most common commands");
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " commands       list all commands");
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " command        help on a specific command");
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " usage          generic command line arguments");
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " configure      lists properties to cinfigure commands/options");
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        this._helpArgs = new ArrayList();
        this._helpArgs.addAll(arguments);
        ((AbstractCollection)arguments).removeAll(arguments);
    }

    public boolean requiresLogon() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

