/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.xcm.AdminOperationRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class GarbageCollectionCommand
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$GarbageCollectionCommand == null ? (class$com$tssap$dtr$client$commandline$GarbageCollectionCommand = GarbageCollectionCommand.class$("com.tssap.dtr.client.commandline.GarbageCollectionCommand")) : class$com$tssap$dtr$client$commandline$GarbageCollectionCommand));
    private static final int GC_ACTIVITIES = 1;
    private static final int GC_PROPAGATIONLISTS = 2;
    private static final int GC_VERSIONEDRESOURCES = 4;
    private int _currentOption = 0;
    private String _comments;
    private boolean _isPreview = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$GarbageCollectionCommand;

    public GarbageCollectionCommand(ArrayList arguments) {
        super(arguments);
        this.removeSupportedOption(OptionName.ACTIVITY);
        this.addSupportedOption(OptionName.ACTIVITIES);
        this.addSupportedOption(OptionName.PROPAGATIONLISTS);
        this.addSupportedOption(OptionName.VERSIONEDRESOURCES);
        this.addSupportedOption(OptionName.ADMNPREVIEW);
        this.addSupportedOption(OptionName.COMMENTS);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Garbage collects activities, propagationlists and versioned resources";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            if (this._currentOption == 0) {
                this._currentOption = 7;
            }
            String previewMsg = "[PREVIEW MODE] ";
            if (!this._isPreview) {
                previewMsg = "";
            }
            if ((this._currentOption & 1) == 1) {
                this.writeMessage(previewMsg + "Garbage collecting activities...");
                this.doGarbageCollection(AdminOperationRequest.ResourceType.ACTIVITIES);
                this.writeMessage("");
            }
            if ((this._currentOption & 2) == 2) {
                this.writeMessage(previewMsg + "Garbage collecting propagationlists...");
                this.doGarbageCollection(AdminOperationRequest.ResourceType.PROPAGATION_LISTS);
                this.writeMessage("");
            }
            if ((this._currentOption & 4) == 4) {
                this.writeMessage(previewMsg + "Garbage collecting versioned resources...");
                this.doGarbageCollection(AdminOperationRequest.ResourceType.VERSIONED_RESOURCES);
                this.writeMessage("");
            }
            this.writeMessage(previewMsg + "Garbage collection finished successfully.");
            retVal = true;
        }
        catch (VcmFailure ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VcmFailure occurred during garbage collection");
            this.writeMessage("Garbage collection failed" + ex.getMessage());
        }
        return retVal;
    }

    private boolean pingServer() {
        return this.getFileSystemManager() != null;
    }

    private void doGarbageCollection(AdminOperationRequest.ResourceType resourceType) throws VcmFailure {
        AdminOperationRequest request = this.createRequest(resourceType);
        this.performRequest((IRequest)request);
        this.displayGarbageCollectedResources(request);
    }

    private AdminOperationRequest createRequest(AdminOperationRequest.ResourceType resourceType) {
        AdminOperationRequest request = new AdminOperationRequest();
        if (this._isPreview) {
            request.setPreviewOnly(this._isPreview);
        }
        request.setComments(this._comments);
        request.setResourceType(resourceType);
        return request;
    }

    private void displayGarbageCollectedResources(AdminOperationRequest request) {
        if (request.getResponse().getStatus() == 207) {
            Iterator it = request.getResources();
            while (it.hasNext()) {
                ResourceElement res = (ResourceElement)it.next();
                this.writeMessage(Encoder.decodePath((String)((PropertyElement)res.getChild("path")).getValue()));
            }
        }
    }

    private IResponse performRequest(IRequest request) throws VcmFailure {
        IResponse response = null;
        IVersionedFileSystemManager vfsManager = this.getFileSystemManager();
        if (vfsManager != null) {
            response = DeltavCommand.execute((int)Command.getConnectionTemplateId((IVfsFolderItem)vfsManager.getRootFolder()), (IRequest)request);
        }
        return response;
    }

    private void writeMessage(String message) {
        Command.getOut().println(message);
    }

    public boolean validateArguments() {
        return true;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        Iterator listIterator = ((AbstractList)arguments).iterator();
        String activitiesShortOptName = NameConfig.getOption(OptionName.ACTIVITIES, true);
        String activitiesLongOptName = NameConfig.getOption(OptionName.ACTIVITIES, false);
        String plShortOptName = NameConfig.getOption(OptionName.PROPAGATIONLISTS, true);
        String plLongOptName = NameConfig.getOption(OptionName.PROPAGATIONLISTS, false);
        String resourcesShortOptName = NameConfig.getOption(OptionName.VERSIONEDRESOURCES, true);
        String resourcesLongOptName = NameConfig.getOption(OptionName.VERSIONEDRESOURCES, false);
        String commentsShortOptName = NameConfig.getOption(OptionName.COMMENTS, true);
        String commentsWSLongOptName = NameConfig.getOption(OptionName.COMMENTS, false);
        String previewShortOptName = NameConfig.getOption(OptionName.ADMNPREVIEW, true);
        String previewWSLongOptName = NameConfig.getOption(OptionName.ADMNPREVIEW, false);
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (activitiesShortOptName.compareToIgnoreCase(currentArg) == 0 || activitiesLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._currentOption |= 1;
                continue;
            }
            if (plShortOptName.compareToIgnoreCase(currentArg) == 0 || plLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._currentOption |= 2;
                continue;
            }
            if (resourcesShortOptName.compareToIgnoreCase(currentArg) == 0 || resourcesLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._currentOption |= 4;
                continue;
            }
            if (commentsShortOptName.compareToIgnoreCase(currentArg) == 0 || commentsWSLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._comments = (String)listIterator.next();
                listIterator.remove();
                continue;
            }
            if (previewShortOptName.compareToIgnoreCase(currentArg) != 0 && previewWSLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._isPreview = true;
        }
        super.setArguments(arguments);
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.GARBAGECOLLECT, false) + " [ " + NameConfig.getOption(OptionName.ACTIVITIES, true) + " ] [ " + NameConfig.getOption(OptionName.PROPAGATIONLISTS, true) + " ] [ " + NameConfig.getOption(OptionName.VERSIONEDRESOURCES, true) + " ] [ " + NameConfig.getOption(OptionName.ADMNPREVIEW, false) + " ] [ " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"comments\"] ");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Performs garbage collection on activities, propagationlists and versioned resources. Removes all objects that are not a part of any workspace. The list of activities, propagationlists and (or) versioned resources that were garbage collected is displayed.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ACTIVITIES, 1, "Removes all activities that are not integrated into any workspace.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.PROPAGATIONLISTS, 1, "Removes all propagationlists that are not integrated into any workspace.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.VERSIONEDRESOURCES, 1, "Removes all versioned objects that are not a part of any activity, propagationlist and workspace.", true);
        this.writeMessage("");
        this.printOptionHelp(null, 1, "If none of the above options are specified, then the action is to garbage collect all.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.ADMNPREVIEW, 1, "Specifies that a preview of the garbage collection is required. If thisoption is specified then the list of activities, propagationlists and (or) versioned resources that will be garbage collected is displayed.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.COMMENTS, 1, "A short note specifying why the action was performed.", true);
        this.writeMessage("");
    }

    public CommandName getCommandName() {
        return CommandName.GARBAGECOLLECT;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new GarbageCollectionCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

