/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.Utilities;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

class FileCommands
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$FileCommands == null ? (class$com$tssap$dtr$client$commandline$FileCommands = FileCommands.class$("com.tssap.dtr.client.commandline.FileCommands")) : class$com$tssap$dtr$client$commandline$FileCommands));
    private String _fileName;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$FileCommands;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new FileCommands(arguments);
    }

    FileCommands(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.SETTINGS);
        this.addSupportedOption(OptionName.SYSTEM);
        this.addSupportedOption(OptionName.CLIENTS);
        this.addSupportedOption(OptionName.USERS);
        this._fileName = null;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "opens the configuration files for editing";
    }

    public CommandName getCommandName() {
        return CommandName.CONFIG;
    }

    public boolean execute() {
        File file = new File(this.getCacheConfiguration().getConfigFolder().getAbsolutePath(), this._fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Logger.traceSystemError(LOCATION, e, "IOException occurred during creation of file " + file.getAbsolutePath());
            }
        }
        final String clientDefFilename = file.getAbsolutePath();
        String editToolPath = this.getCacheConfiguration().getSettings().getEditToolPath();
        boolean failedEdit = true;
        if (editToolPath != null && editToolPath.length() != 0) {
            failedEdit = false;
            String[] args = new String[]{editToolPath, clientDefFilename};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(args);
            }
            catch (IOException exp) {
                Logger.traceSystemError(LOCATION, exp, "IOException occurred during starting editor process.");
                Command.getOut().println(exp.getMessage());
                Command.getOut().println("Could not start editor. Using default editor..");
                this._exitCode = 63;
                failedEdit = true;
            }
            if (!failedEdit) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException exp) {
                    Logger.traceSystemError(LOCATION, exp, "The editor process was interupted.");
                }
            }
        }
        if (failedEdit) {
            try {
                final JEditorPane editorPane = new JEditorPane("file:///" + clientDefFilename);
                JScrollPane scrollPane2 = new JScrollPane(editorPane);
                final JDialog dialog = new JDialog();
                ((Component)dialog).setSize(600, 600);
                dialog.getContentPane().add(scrollPane2);
                dialog.setTitle(clientDefFilename);
                dialog.setDefaultCloseOperation(0);
                dialog.addWindowListener(new WindowAdapter(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void windowClosing(WindowEvent we) {
                        int exitCode = 0;
                        try {
                            try {
                                FileWriter writer = new FileWriter(clientDefFilename);
                                editorPane.write(writer);
                                dialog.hide();
                                dialog.dispose();
                            }
                            catch (IOException x) {
                                Logger.traceSystemError(LOCATION, x, "IOException occurred during close of editor window.");
                                exitCode = 96;
                                Object var5_6 = null;
                                if (Utilities.isInShell()) return;
                                System.exit(exitCode);
                                return;
                            }
                            Object var5_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            if (Utilities.isInShell()) throw throwable;
                            System.exit(exitCode);
                            throw throwable;
                        }
                        if (Utilities.isInShell()) return;
                        System.exit(exitCode);
                    }
                });
                dialog.addWindowListener(new MyLsitener(dialog));
                dialog.setModal(true);
                dialog.show();
            }
            catch (IOException x) {
                Logger.traceSystemError(LOCATION, x, "IOException occurred during starting editor window.");
                this._exitCode = 96;
                return false;
            }
        }
        return true;
    }

    public boolean validateArguments() {
        return this._fileName != null && this._fileName.length() != 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.CONFIG, false) + " [ " + NameConfig.getOption(OptionName.CLIENTS, true) + " " + NameConfig.getOption(OptionName.SETTINGS, true) + " " + NameConfig.getOption(OptionName.USERS, true) + " " + NameConfig.getOption(OptionName.SYSTEM, true) + " SystemName ] ");
        Command.getOut().println();
        Command.getOut().println("    Open a configuration file ");
        Command.getOut().println();
        this.printOptionHelp(OptionName.SETTINGS, 1, "Open the settings file", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.CLIENTS, 1, "Open the clients file", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USERS, 1, "Open the users file", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SYSTEM, 1, "Open the system file", true);
        this.printOptionHelp(OptionName.SYSTEM, 1, "The available systems can be listed using the systems command", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SYSTEM, 1, "dtr " + NameConfig.getCommandName(CommandName.SYSTEMS, false), false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String stShort = NameConfig.getOption(OptionName.SETTINGS, true);
                String stLong = NameConfig.getOption(OptionName.SETTINGS, false);
                String syShort = NameConfig.getOption(OptionName.SYSTEM, true);
                String syLong = NameConfig.getOption(OptionName.SYSTEM, false);
                String cShort = NameConfig.getOption(OptionName.CLIENTS, true);
                String cLong = NameConfig.getOption(OptionName.CLIENTS, false);
                String uShort = NameConfig.getOption(OptionName.USERS, true);
                String uLong = NameConfig.getOption(OptionName.USERS, false);
                if (lowerCaseArg.startsWith(stShort) || lowerCaseArg.startsWith(stLong)) {
                    if (this._fileName == null) {
                        // empty if block
                    }
                    this._fileName = "settings.xml";
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(syShort) || lowerCaseArg.startsWith(syLong)) {
                    String systemFN = Command.getActualArgument(currArg, syShort, syLong);
                    if ("".equals(systemFN) && i + 1 < arguments.size() && !(systemFN = (String)arguments.get(i + 1)).startsWith("-")) {
                        arguments.remove(i + 1);
                    }
                    if (!"".equals(systemFN)) {
                        arguments.remove(i);
                        --indexOfArgs;
                        this._fileName = systemFN + ".system";
                    }
                } else if (lowerCaseArg.startsWith(cShort) || lowerCaseArg.startsWith(cLong)) {
                    if (this._fileName == null) {
                        // empty if block
                    }
                    this._fileName = "clients.xml";
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(uShort) || lowerCaseArg.startsWith(uLong)) {
                    if (this._fileName == null) {
                        // empty if block
                    }
                    this._fileName = "user.xml";
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    public boolean requiresLogon() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyLsitener
    extends WindowAdapter {
        JDialog _dialog;

        MyLsitener(JDialog dialog) {
            this._dialog = dialog;
        }

        public void windowOpened(WindowEvent e) {
            this._dialog.toFront();
            super.windowOpened(e);
        }
    }
}

