/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.util.PathUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ExportCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ExportCommand == null ? (class$com$tssap$dtr$client$commandline$ExportCommand = ExportCommand.class$("com.tssap.dtr.client.commandline.ExportCommand")) : class$com$tssap$dtr$client$commandline$ExportCommand));
    private Integer _exportMode;
    private String _targetRepositoryID;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ExportCommand;

    public ExportCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.RELOCATEWS);
        this.addSupportedOption(OptionName.EXPORTMODE);
        this.addSupportedOption(OptionName.EXPORTFILE);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "exports the contents of activities, workspaces, propagationlists and snapshots";
    }

    public boolean execute() {
        boolean retVal = false;
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            String resourceID = this.getResourceID();
            InputStream in = null;
            in = this._exportMode == null ? this._propManager.export(resourceID).getContents() : (this._targetRepositoryID != null ? this._propManager.exportForRelocation(resourceID, this._targetRepositoryID, this._exportMode.intValue()).getContents() : this._propManager.export(resourceID, this._exportMode.intValue()).getContents());
            OutputStream out = this.getOutputStream(resourceID);
            this.writeContentsToStream(in, out);
            if (this._fileName != null) {
                out.close();
            }
            retVal = true;
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException occurred during export.");
            String message = ex.getPrecondition();
            this.writeMessage("Export Failed. " + message + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException occurred during export.");
            this.writeMessage("Export Failed. " + ex.getMessage());
        }
        catch (IOException ex) {
            Logger.traceSystemError(LOCATION, ex, "IOException occurred during export.");
            this.writeMessage("Export Failed. " + ex.getMessage());
        }
        if (retVal && this._fileName != null) {
            this.writeMessage("wrote contents to file \"" + this._fileName + "\"");
        }
        return retVal;
    }

    private OutputStream getOutputStream(String resourceID) throws IOException {
        OutputStream out = null;
        if (this._fileName != null) {
            File file = new File(this._fileName);
            this._fileName = file.getAbsolutePath();
            if (file.isDirectory()) {
                this._fileName = this._fileName + PathUtilities.LOCAL_SEPARATOR + "export_" + resourceID + ".pgn";
            }
            out = new FileOutputStream(this._fileName);
        } else {
            out = Command.getOut();
        }
        return out;
    }

    private void writeContentsToStream(InputStream in, OutputStream out) throws IOException {
        byte[] contents = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = in.read(contents)) != -1) {
            out.write(contents, 0, bytesRead);
        }
    }

    public boolean validateArguments() {
        int expMode;
        boolean isValidateArguments = super.validateArguments();
        if (this._resourcePath == null) {
            this.writeMessage("Must specify url.");
            isValidateArguments = false;
        }
        if (isValidateArguments && this._exportMode != null && ((expMode = this._exportMode.intValue()) & 8) == 8 && this._targetRepositoryID == null) {
            this.writeMessage("Must specify target repository id.");
            isValidateArguments = false;
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        if (arguments.size() == 0) {
            return;
        }
        String exportModeShortOptName = NameConfig.getOption(OptionName.EXPORTMODE, true);
        String exportModeLongOptName = NameConfig.getOption(OptionName.EXPORTMODE, false);
        String relocateWSShortOptName = NameConfig.getOption(OptionName.RELOCATEWS, true);
        String relocateWSLongOptName = NameConfig.getOption(OptionName.RELOCATEWS, false);
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (relocateWSShortOptName.compareToIgnoreCase(currentArg) == 0 || relocateWSLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._targetRepositoryID = (String)listIterator.next();
                listIterator.remove();
                continue;
            }
            if (exportModeShortOptName.compareToIgnoreCase(currentArg) != 0 && exportModeLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            String mode = (String)listIterator.next();
            try {
                if (mode != null) {
                    this._exportMode = new Integer(mode);
                }
                listIterator.remove();
            }
            catch (NumberFormatException ex) {
                Logger.traceUserError(LOCATION, ex, "NumberFormatException occurred. Export mode not specified correctly.");
                this.writeMessage("Export mode is not specified correctly.");
                break;
            }
        }
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.EXPORT, false) + " url [ " + NameConfig.getOption(OptionName.EXPORTFILE, true) + " \"file name\" ] [ " + NameConfig.getOption(OptionName.EXPORTMODE, true) + " \"export mode\" ] [ " + NameConfig.getOption(OptionName.RELOCATEWS, true) + " \"target repository id\" ]");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "exports the contents of an activity, propagationlist or a workspace.", false);
        this.writeMessage("");
        this.printOptionHelp(null, 1, "URL is the absolute remote path of the resource that needs to be exported.", false);
        this.printOptionHelp(null, 1, " Ex: In order to export an activity named 'testActivity', the url specified should be '/act/testActivity' ", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTFILE, 1, "Name of the file in which the contents of the export will be stored. In case this option is not specified, then the contents are written to the standard output.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTFILE, 1, "If a directory is specified instead of a file, then a file with the name \"export_<resourceID>.pgn\" will be created.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "The export mode that needs to be used to perform the export. Following is the list of export modes with its usage. Use the number given in the brackets for specifying the export mode.", true);
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "1. NORMAL (1) <default export mode>", false);
        this.printOptionHelp(OptionName.EXPORTMODE, 2, "Exports the contents of the given activity, propagationlist or snapshot. Cannot be used for workspace resources.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "2. WITH HISTORY (2)", false);
        this.printOptionHelp(OptionName.EXPORTMODE, 2, "Exports the contents of all versions of all objects of the given propagationlist or workspace. In case of workspaces, exports all the actvities and propagation lists that were integrated into this workspace. Cannot be used for activities and snapshots.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "3. INCL SNAPSHOTS (4)", false);
        this.printOptionHelp(OptionName.EXPORTMODE, 2, "Same as WITH HISTORY but includes all snapshots that were integrated into the workspace. Cannot be used for activities, propagationlists and snapshots.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "4. RELOCATE WORKSPACE (8)", false);
        this.printOptionHelp(OptionName.EXPORTMODE, 2, "Relocates the workspace, i.e. transfers the ownership of the workspace to another repository and then performs the export in mode WITH HISTORY. Cannot be used for activities, propagationlists and snapshots.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.EXPORTMODE, 1, "5. RELOCATE WORKSPACE INCL SNAPSHOTS (12)", false);
        this.printOptionHelp(OptionName.EXPORTMODE, 2, "Relocates the workspace, i.e. transfers the ownership of the workspace to another repository and then performs the export in mode INCL SNAPSHOTS. Cannot be used for activities, propagationlists and snapshots.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.RELOCATEWS, 1, "In case the export mode is RELOCATE WORKSPACE (8) or RELOCATE WORKSPACE INCL SNAPSHOTS (12) then this option specifies the repository id of the repository to which the workspace needs to be relocated.", true);
    }

    public CommandName getCommandName() {
        return CommandName.EXPORT;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ExportCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

