/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.EditAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class EditCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$EditCommand == null ? (class$com$tssap$dtr$client$commandline$EditCommand = EditCommand.class$("com.tssap.dtr.client.commandline.EditCommand")) : class$com$tssap$dtr$client$commandline$EditCommand));
    private int _recurseDepth;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$EditCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new EditCommand(arguments);
    }

    EditCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.RECURSE);
        this._recurseDepth = 0;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "checks out a file/folder for editing";
    }

    public CommandName getCommandName() {
        return CommandName.EDIT;
    }

    public boolean execute() {
        IVfsWorkspace workspace = null;
        IVfsActivity activity = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            block32: {
                IVfsActivityRecordedFolderItem activityRecordedFolderItem;
                block31: {
                    IVfsFolderItem folderItem;
                    block34: {
                        block35: {
                            block33: {
                                if (this._resourcePaths[i] == null) break block32;
                                folderItem = this.getResource(this._resourcePaths[i]);
                                if (folderItem != null) break block33;
                                Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                                this._exitCode = 5;
                                break block32;
                            }
                            activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                            if (workspace != null) break block34;
                            if (activityRecordedFolderItem != null) break block35;
                            this._exitCode = 88;
                            break block32;
                        }
                        workspace = activityRecordedFolderItem.getWorkspace();
                        if (workspace != null) break block31;
                        Command.getOut().println("Could not retrive workspace for folder item " + this._resourcePaths[i]);
                        this._exitCode = 22;
                        break block32;
                    }
                    try {
                        if (!folderItem.getBrowsePath().startsWith(workspace.getBrowsePath())) {
                            Command.getOut().println("Folder item " + folderItem.getBrowsePath() + " does not belong to the workspace " + workspace.getBrowsePath());
                            this._exitCode = 23;
                        }
                        break block31;
                    }
                    catch (VfsException exp) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred. Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                        Command.getOut().println("Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                    }
                    break block32;
                }
                if (activity == null) {
                    try {
                        activity = this.getOrCreateActivity(workspace);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred. Activity get/create failed.");
                        Command.getOut().println("Could not get/create activity. " + e.getMessage());
                        this._exitCode = 35;
                        return false;
                    }
                }
                if (activityRecordedFolderItem != null) {
                    VfsActionOnFolderItem[] actionsPoss = activityRecordedFolderItem.getActionsForCurrentState();
                    if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT) || Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_1) || Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.CHECKOUT_FOR_EDIT_INF)) {
                        if (-1 == this._resourceBranchSeqNums[i]) {
                            try {
                                if (activityRecordedFolderItem.asFolder() != null) {
                                    EditAction ea = new EditAction(activityRecordedFolderItem.asFolder(), activity, this._recurseDepth);
                                    ea.execute();
                                    Iterator it = VfsActionRecorder.getRecorder().getActionEntries(VfsActionType.ADD, VfsActionStatus.ERROR_LOG, -1, Long.MIN_VALUE, Long.MAX_VALUE);
                                    if (it.hasNext()) {
                                        this._exitCode = 83;
                                    }
                                    break block32;
                                }
                                activityRecordedFolderItem.checkOutForEdit(activity);
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during check out of folder item " + this._resourcePaths[i]);
                                this._exitCode = 13;
                            }
                        } else {
                            IVfsFile file = activityRecordedFolderItem.asFile();
                            if (file == null) {
                                Command.getOut().println("Could not sync to given version. Folderitem is not a file.");
                                this._exitCode = 28;
                            } else {
                                try {
                                    file.syncToBranchSequenceNumber(this._resourceBranchSeqNums[i].intValue());
                                }
                                catch (VfsException e) {
                                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during sync of folder item " + this._resourcePaths[i] + " to sequence number " + this._resourceBranchSeqNums[i]);
                                    Command.getOut().println("Could not sync to given version. " + e.getMessage());
                                    this._exitCode = 28;
                                    break block32;
                                }
                                try {
                                    activityRecordedFolderItem.checkOutForEdit(activity);
                                }
                                catch (VfsException e) {
                                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during check out of folder item " + this._resourcePaths[i]);
                                    Command.getOut().println("Could not check out : " + this._resourcePaths[i] + " for Edit.");
                                    this._exitCode = 13;
                                }
                            }
                        }
                    } else {
                        String mes = "";
                        if (activityRecordedFolderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                            mes = "Folder item is checked out. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is local only. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                            mes = "Folder item is not synced. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                            mes = "Folder item is not in sync. ";
                        }
                        Command.getOut().println(mes + "Cannot check out : " + this._resourcePaths[i] + " for Edit.");
                        this._exitCode = 12;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String rShort = NameConfig.getOption(OptionName.RECURSE, true);
                String rLong = NameConfig.getOption(OptionName.RECURSE, false);
                if (lowerCaseArg.startsWith(rShort) || lowerCaseArg.startsWith(rLong)) {
                    String suffix = Command.getActualArgument(currArg, rShort, rLong);
                    try {
                        this._recurseDepth = Integer.parseInt(suffix);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred. Recurse depth for edit not specified correctly.");
                        this._recurseDepth = 0;
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.EDIT, false) + "  [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "] [" + NameConfig.getOption(OptionName.RECURSE, true) + "depth] ] FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Checks out the specified folder items for editing", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument.Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the files will be checked out in the given activity. If the activity is not specified then the default activity for the workspace is used. If the specified activity does not exist then it will be created", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name. This is only in case to specify to use an already existing activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "If this option is specified and one of the path(s) is a folder then the items under the folder will be edited recursively till the depth specified(number)", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "Usage", false);
        this.printOptionHelp(OptionName.RECURSE, 1, "dtr " + NameConfig.getCommandName(CommandName.EDIT, false) + " FolderPath " + NameConfig.getOption(OptionName.RECURSE, true) + "10", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "There should be no space between the option and the number", false);
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

