/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class EditActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$EditActivityCommand == null ? (class$com$tssap$dtr$client$commandline$EditActivityCommand = EditActivityCommand.class$("com.tssap.dtr.client.commandline.EditActivityCommand")) : class$com$tssap$dtr$client$commandline$EditActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$EditActivityCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new EditActivityCommand(arguments);
    }

    EditActivityCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "edits the description of an activity";
    }

    public String getName() {
        return "editactivity";
    }

    public boolean execute() {
        IVfsActivity activity = this.getActivity(true, true);
        if (activity == null) {
            Command.getOut().println("Cannot find activity");
            return false;
        }
        try {
            if (!activity.isOpen()) {
                Command.getOut().println("Cannot edit a closed activity");
                this._exitCode = 38;
                return false;
            }
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during determining activity state before editing.");
            Command.getOut().println("Cannot determine the state of the activity. " + exp.getMessage());
            this._exitCode = 98;
            return false;
        }
        Command.getOut().println("Editing the activity....");
        if (this._noUI) {
            this.performNonUIEdit(activity, false);
        } else {
            this.performUIEdit(activity, false);
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr EditActivity [ -s -c \"description\" -n displayname ] -a _activityName ");
        Command.getOut().println();
        Command.getOut().println("\tAllows editing of the description/display name of an activity ");
        Command.getOut().println();
        Command.getOut().println("\t-a / --activity \t: Name(Actual) of the acivity to be edited");
        Command.getOut().println();
        Command.getOut().println("\t-s / --silent \t: Will supress the popup window for changing");
        Command.getOut().println("\tactivity description and display name");
        Command.getOut().println();
        Command.getOut().println("\t-c / --comment \t: If in non UI mode this will be used to set");
        Command.getOut().println("\tthe description of the activity");
        Command.getOut().println();
        Command.getOut().println("\t-n / --name \t: If in non UI mode this will be used to set");
        Command.getOut().println("\tthe displayname of the activity");
        Command.getOut().println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

