/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;

class DownloadCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DownloadCommand == null ? (class$com$tssap$dtr$client$commandline$DownloadCommand = DownloadCommand.class$("com.tssap.dtr.client.commandline.DownloadCommand")) : class$com$tssap$dtr$client$commandline$DownloadCommand));
    private boolean _forceDownload;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DownloadCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DownloadCommand(arguments);
    }

    DownloadCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this._forceDownload = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "downloads the content of a checked out file from the server";
    }

    public CommandName getCommandName() {
        return CommandName.DOWNLOAD;
    }

    public boolean execute() {
        IVfsFile vfsfile = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            block12: {
                if (this._resourcePaths[i] != null) {
                    IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                    if (folderItem == null) {
                        Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                    } else {
                        vfsfile = folderItem.asFile();
                        if (vfsfile != null) {
                            VfsActionOnFolderItem[] allowedActions = vfsfile.getActionsForCurrentState();
                            try {
                                if (this._forceDownload) {
                                    if (Arrays.asList(allowedActions).contains(VfsActionOnFolderItem.FORCE_DOWNLOAD)) {
                                        vfsfile.forceDownload();
                                    } else {
                                        this._exitCode = 18;
                                    }
                                    break block12;
                                }
                                if (Arrays.asList(allowedActions).contains(VfsActionOnFolderItem.DOWNLOAD)) {
                                    vfsfile.download();
                                    break block12;
                                }
                                this._exitCode = 18;
                            }
                            catch (VfsException e) {
                                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred when trying to download folder item " + this._resourcePaths[i]);
                                Command.getOut().println("Could not download folder item " + this._resourcePaths[i]);
                                this._exitCode = 19;
                            }
                        } else {
                            Command.getOut().println("Folder item " + this._resourcePaths[i] + " is not activity recorded");
                            this._exitCode = 88;
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null && this._resourcePaths.length != 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.DOWNLOAD, false) + " [" + NameConfig.getOption(OptionName.FORCE, true) + "] FolderPath(s)");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "downloads the file to the server", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If this option is specified the file is downloaded even if the  local file is  changed after the last upload", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the option is  not specified the file will be downloaded only if it was changed on the server  since it was last uploaded or the file does not exist locally", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            if (currArg != null && (fShort.equals(lowerCaseArg = currArg.toLowerCase()) || fLong.equals(lowerCaseArg))) {
                this._forceDownload = true;
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

