/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;

class DownloadActCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DownloadActCommand == null ? (class$com$tssap$dtr$client$commandline$DownloadActCommand = DownloadActCommand.class$("com.tssap.dtr.client.commandline.DownloadActCommand")) : class$com$tssap$dtr$client$commandline$DownloadActCommand));
    private boolean _forceDownload;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DownloadActCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DownloadActCommand(arguments);
    }

    DownloadActCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this._forceDownload = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return null;
    }

    public String getName() {
        return null;
    }

    public boolean execute() {
        IVfsActivity activity = this.getActivity(false, true);
        if (activity == null) {
            return true;
        }
        try {
            VfsActionOnActivity[] allowedActions = activity.getActionsForCurrentState();
            if (this._forceDownload) {
                if (Arrays.asList(allowedActions).contains(VfsActionOnActivity.FORCE_DOWNLOAD)) {
                    activity.forceDownload();
                } else {
                    this._exitCode = 39;
                }
            } else if (Arrays.asList(allowedActions).contains(VfsActionOnActivity.DOWNLOAD)) {
                activity.download();
            } else {
                this._exitCode = 39;
            }
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred when trying to download activity contents");
            Command.getOut().println("Downloading activity failed. " + e.getMessage());
            this._exitCode = 40;
            return false;
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            if (currArg != null && (fShort.equals(lowerCaseArg = currArg.toLowerCase()) || fLong.equals(lowerCaseArg))) {
                this._forceDownload = true;
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

