/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class DisplayHelper {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DisplayHelper == null ? (class$com$tssap$dtr$client$commandline$DisplayHelper = DisplayHelper.class$("com.tssap.dtr.client.commandline.DisplayHelper")) : class$com$tssap$dtr$client$commandline$DisplayHelper));
    static final int KEY_TYPE_INT = 0;
    static final int KEY_TYPE_STRING = 1;
    static final int KEY_TYPE_DATE = 2;
    private Rows _rows;
    private Field _keyField;
    private int _keyType;
    private final boolean _unformattedOutput;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DisplayHelper;

    public DisplayHelper(boolean unformattedOutput) {
        this._unformattedOutput = unformattedOutput;
    }

    Row newRow() {
        return new Row(this._rows, this._keyField, this._keyType, this._unformattedOutput);
    }

    void startDisplay() {
        this._rows = new Rows();
    }

    void endDisplay(boolean ascend) {
        this._rows.print(ascend);
    }

    void setKeyField(Field field, int type) {
        this._keyType = type;
        this._keyField = field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DateFormatter {
        private static ThreadLocal _dateFormats = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return DateFormat.getDateTimeInstance();
            }
        };

        protected static SimpleDateFormat getDateFormater() {
            return (SimpleDateFormat)_dateFormats.get();
        }

        public static String getFormattedDate(Date date, String datePattern) {
            SimpleDateFormat df = DateFormatter.getDateFormater();
            df.applyPattern(datePattern);
            return df.format(date);
        }
    }

    static class Rows {
        final SortedMap mapOfSetOfRows = new TreeMap();

        Rows() {
        }

        void addRow(Row row) {
            HashSet<Row> setOfRows = (HashSet<Row>)this.mapOfSetOfRows.get(row.key());
            if (setOfRows == null) {
                setOfRows = new HashSet<Row>();
                this.mapOfSetOfRows.put(row.key(), setOfRows);
            }
            setOfRows.add(row);
        }

        void print(boolean ascend) {
            Set[] arrSet = new Set[this.mapOfSetOfRows.size()];
            arrSet = this.mapOfSetOfRows.values().toArray(arrSet);
            int inrdcr = 1;
            int index = 0;
            int counter = 0;
            if (ascend) {
                index = arrSet.length - 1;
                inrdcr = -1;
            }
            while (counter < arrSet.length) {
                ++counter;
                Set setOfRows = arrSet[index];
                Row[] arrRow = new Row[setOfRows.size()];
                arrRow = setOfRows.toArray(arrRow);
                int indexInt = 0;
                int inrdcrInt = 1;
                int counterInt = 0;
                if (ascend) {
                    indexInt = arrRow.length - 1;
                    inrdcrInt = -1;
                }
                while (counterInt < arrRow.length) {
                    ++counterInt;
                    Row row = arrRow[indexInt];
                    row.print();
                    DTRClient.getOut().println();
                    indexInt += inrdcrInt;
                }
                index += inrdcr;
            }
        }
    }

    static class Row {
        final Rows parentRows;
        final Field keyField;
        final int keyType;
        Object key;
        String[] fieldVals;
        Field[] fields;
        final ArrayList fieldsList;
        final ArrayList fieldValsList;
        private final boolean unformattedOutput;

        private Row(Rows parent, Field keyField, int keyType, boolean unformattedOutput) {
            this.keyField = keyField;
            this.keyType = keyType;
            this.parentRows = parent;
            this.fieldsList = new ArrayList();
            this.fieldValsList = new ArrayList();
            this.unformattedOutput = unformattedOutput;
        }

        void addDateField(Field field, String date, String datePattern) {
            Date unformattedDate = null;
            if (date != null) {
                unformattedDate = Converter.parseHTTPDate((String)date);
            }
            this.addField(field, unformattedDate, datePattern);
        }

        void addField(Field field, Date date, String datePattern) {
            String val = "";
            if (date != null) {
                val = DateFormatter.getFormattedDate(date, datePattern);
            }
            this.setKeyField(field, val, date);
            this._addField(field, val);
        }

        void addField(Field field, String val) {
            if (val == null) {
                val = "";
            }
            this.setKeyField(field, val, null);
            this._addField(field, val);
        }

        void _addField(Field field, String val) {
            this.fieldsList.add(field);
            this.fieldValsList.add(val);
        }

        private void setKeyField(Field field, String val, Date date) {
            if (field.isIt(this.keyField.fieldName)) {
                switch (this.keyType) {
                    case 0: {
                        try {
                            this.key = Integer.valueOf(val);
                        }
                        catch (NumberFormatException exp) {
                            Logger.traceInternalError(LOCATION, exp, "NumberFormatException occurred during setting key filed for row.");
                            this.key = Integer.valueOf("0");
                        }
                        break;
                    }
                    case 1: {
                        this.key = val;
                        break;
                    }
                    case 2: {
                        this.key = date != null ? date : new Date();
                    }
                }
            }
        }

        void end() {
            this.parentRows.addRow(this);
            this.fieldVals = new String[this.fieldValsList.size()];
            this.fieldVals = this.fieldValsList.toArray(this.fieldVals);
            this.fields = new Field[this.fieldsList.size()];
            this.fields = this.fieldsList.toArray(this.fields);
        }

        Object key() {
            return this.key;
        }

        void print() {
            int i = 0;
            while (i < this.fields.length) {
                this.printField(this.fields[i].length, this.fieldVals[i]);
                ++i;
            }
        }

        void printField(int fieldLength, String field) {
            if (this.unformattedOutput) {
                field = field + Command.getSeparatorString();
                fieldLength = field.length();
            }
            if (field.length() > fieldLength) {
                field = field.substring(0, fieldLength - 2);
                field = field + "..";
            }
            DTRClient.getOut().print(field);
            this.printSpaces(fieldLength - field.length());
        }

        void printSpaces(int numberOfSpaces) {
            char[] spaces = new char[numberOfSpaces];
            Arrays.fill(spaces, ' ');
            DTRClient.getOut().print(spaces);
        }
    }
}

