/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FieldDescriptor;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagatableHeaderInfo;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class DisplayExportBlobMetaInformationCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DisplayExportBlobMetaInformationCommand == null ? (class$com$tssap$dtr$client$commandline$DisplayExportBlobMetaInformationCommand = DisplayExportBlobMetaInformationCommand.class$("com.tssap.dtr.client.commandline.DisplayExportBlobMetaInformationCommand")) : class$com$tssap$dtr$client$commandline$DisplayExportBlobMetaInformationCommand));
    private static final FieldDescriptor META_INF_KEY = new FieldDescriptor(20, "Meta Information Key", "key");
    private static final FieldDescriptor META_INF_VALUE = new FieldDescriptor(60, "Value", "val");
    private static final Field META_INF_KEY_FIELD = new Field(META_INF_KEY, DisplayExportBlobMetaInformationCommand.META_INF_KEY.fieldName);
    private static final Field META_INF_VALUE_FIELD = new Field(META_INF_VALUE, DisplayExportBlobMetaInformationCommand.META_INF_VALUE.fieldName);
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DisplayExportBlobMetaInformationCommand;

    public DisplayExportBlobMetaInformationCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.IMPORTFILE);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Displays the meta-information of propagatable blob (obtained by performing an export)";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        File file = new File(this._fileName);
        Object propagatable = null;
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            FileInputStream stream = new FileInputStream(file);
            IPropagatableHeaderInfo headerInfo = this._propManager.extractHeaderInformation((InputStream)stream);
            this.printHeaderInformation(headerInfo);
            stream.close();
            retVal = true;
        }
        catch (FileNotFoundException ex) {
            Logger.traceUserError(LOCATION, ex, "FileNotFoundException occurred. File \"" + this._fileName + "\" not found or cannot be accessed");
            this.writeMessage("File \"" + this._fileName + "\" not found or cannot be accessed");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "Extraction of meta-information of blob failed.");
            this.writeMessage("Extraction of meta-information of blob failed. " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "Extraction of meta-information of blob failed.");
            this.writeMessage("Extraction of meta-information of blob failed. " + ex.getMessage());
        }
        catch (IOException ex) {
            Logger.traceUserError(LOCATION, ex, "IOException occurred while closing the file \"" + this._fileName + "\"");
            this.writeMessage("IOException occurred while closing the file \"" + this._fileName + "\"");
        }
        return retVal;
    }

    private void printHeaderInformation(IPropagatableHeaderInfo headerInfo) {
        DisplayHelper dh = new DisplayHelper(this._unformattedOutput);
        dh.startDisplay();
        dh.setKeyField(META_INF_KEY_FIELD, 1);
        DisplayHelper.Row repName = dh.newRow();
        repName.addField(META_INF_KEY_FIELD, "Repository Name");
        repName.addField(META_INF_VALUE_FIELD, headerInfo.getRepositoryName());
        repName.end();
        DisplayHelper.Row repID = dh.newRow();
        repID.addField(META_INF_KEY_FIELD, "Repository ID");
        repID.addField(META_INF_VALUE_FIELD, headerInfo.getRepositoryID());
        repID.end();
        DisplayHelper.Row propagatableID = dh.newRow();
        propagatableID.addField(META_INF_KEY_FIELD, "Propagatable ID");
        propagatableID.addField(META_INF_VALUE_FIELD, headerInfo.getPropagatableID());
        propagatableID.end();
        DisplayHelper.Row formatVersion = dh.newRow();
        formatVersion.addField(META_INF_KEY_FIELD, "Format Version");
        formatVersion.addField(META_INF_VALUE_FIELD, headerInfo.getFormatVersion());
        formatVersion.end();
        DisplayHelper.Row creationDate = dh.newRow();
        creationDate.addField(META_INF_KEY_FIELD, "Creation Date");
        creationDate.addDateField(META_INF_VALUE_FIELD, headerInfo.getCreationDate(), this.getOutputDatePattern());
        creationDate.end();
        dh.endDisplay(true);
    }

    public boolean validateArguments() {
        boolean isValidateArguments = true;
        if (this._fileName == null) {
            this.writeMessage("Must specify file name.");
            isValidateArguments = false;
        } else {
            File file = new File(this._fileName);
            if (!file.exists() || file.isDirectory()) {
                this.writeMessage("File '" + file.getAbsolutePath() + "' does not exist.");
                isValidateArguments = false;
            }
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.DISPLAYBLOBMETADATA, false) + " " + NameConfig.getOption(OptionName.IMPORTFILE, true) + " \"file name\" ");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Extracts and dispays the meta-information of the propagatable blob.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.IMPORTFILE, 1, "Name of the file which has the blob contents. Must be a valid blob file that was created with the EXPORT command.", true);
    }

    public CommandName getCommandName() {
        return CommandName.DISPLAYBLOBMETADATA;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DisplayExportBlobMetaInformationCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

