/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersionGraph;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.impl.VfsVersionGraph;
import java.io.IOException;
import java.util.ArrayList;

class DiffCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DiffCommand == null ? (class$com$tssap$dtr$client$commandline$DiffCommand = DiffCommand.class$("com.tssap.dtr.client.commandline.DiffCommand")) : class$com$tssap$dtr$client$commandline$DiffCommand));
    private int _revNumber;
    private int _workspacesSpecified;
    private final String[] _workSpaces;
    private final int[] _revNums;
    private static final int ORIGINATING_VERSION = 0;
    private static final int LOCAL_FILE = -1;
    private static final int WRONG_SPEC = -2;
    private static final int LAST_REV_CURR_WS = -3;
    private static final int LAST_REV_SPEC_WS = -4;
    private static final int NOT_SPEC = -1;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DiffCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DiffCommand(arguments);
    }

    DiffCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.SEQ_NUM);
        this.addSupportedOption(OptionName.WORKSPACE);
        this._revNumber = -1;
        this._workspacesSpecified = 0;
        this._workSpaces = new String[2];
        this._revNums = new int[2];
        this._revNums[0] = -1;
        this._revNums[1] = -1;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "diffs two versions of a file";
    }

    public boolean execute() {
        Process process;
        IVfsVersion version;
        String diffToolPath = this.getCacheConfiguration().getSettings().getDiffToolPath();
        if ("".equals(diffToolPath)) {
            Command.getOut().println(" Diff tool not specified. Please use dtr settings to set the diff tool path");
            this._exitCode = 65;
            return false;
        }
        IVfsFolderItem folderItem = this.getResource(this._resourcePaths[0]);
        if (folderItem == null) {
            Command.getOut().println("Could not rertieve folder item " + this._resourcePaths[0]);
            return false;
        }
        IVfsFile file = folderItem.asFile();
        if (file == null) {
            Command.getOut().println("Folder item " + this._resourcePaths[0] + " is not a file");
            this._exitCode = 24;
            return false;
        }
        try {
            version = file.refreshAndGetVersion();
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting version for file " + this._resourcePaths[0]);
            Command.getOut().println(exp.getMessage());
            this._exitCode = 29;
            return false;
        }
        if (version == null) {
            Command.getOut().println("Folder item " + this._resourcePaths[0] + " has not been checked in yet");
            this._exitCode = 25;
            return true;
        }
        IVfsWorkspace workspace = file.getWorkspace();
        if (workspace == null) {
            Command.getOut().println("Workspace for folder item " + this._resourcePaths[0] + " could not be found");
            this._exitCode = 22;
            return false;
        }
        String filePath1 = "";
        String filePath2 = "";
        this._revNums[0] = this._resourceBranchSeqNums[0];
        this._revNums[1] = this._revNumber;
        String wsBrowsePath = null;
        try {
            wsBrowsePath = workspace.getBrowsePath();
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting browse path for workspace for folder item " + this._resourcePaths[0]);
            Command.getOut().println("Getting workspace browse path for folder item " + this._resourcePaths[0] + " failed.");
            this._exitCode = 22;
            return false;
        }
        if (wsBrowsePath == null || wsBrowsePath.equals("")) {
            Command.getOut().println("Getting workspace browse path for folder item " + this._resourcePaths[0] + " failed.");
            this._exitCode = 22;
            return false;
        }
        if (this._workspacesSpecified == 0) {
            this._workSpaces[0] = this.getRemotePathFromBrowsePath(wsBrowsePath);
            this._workSpaces[1] = this.getRemotePathFromBrowsePath(wsBrowsePath);
            if (this._revNums[0] == 0 && this._revNums[1] == 0) {
                this._revNums[0] = 0;
                this._revNums[1] = -3;
            } else if (this._revNums[0] == -1 && this._revNums[1] == -1) {
                this._revNums[1] = -3;
            }
        } else if (this._workspacesSpecified == 1) {
            this._workSpaces[0] = this.getRemotePathFromBrowsePath(this._workSpaces[0].substring(1));
            this._workSpaces[1] = this.getRemotePathFromBrowsePath(wsBrowsePath);
            if (0 == this._workSpaces[0].compareTo(this._workSpaces[1])) {
                if (this._revNums[0] == 0 && this._revNums[1] == 0) {
                    this._revNums[0] = 0;
                    this._revNums[1] = -3;
                } else if (this._revNums[0] == -1 && this._revNums[1] == -1) {
                    this._revNums[1] = -3;
                }
            } else if (this._revNums[1] == -1) {
                this._revNums[1] = -4;
            }
        } else {
            this._workSpaces[0] = this.getRemotePathFromBrowsePath(this._workSpaces[0].substring(1));
            this._workSpaces[1] = this.getRemotePathFromBrowsePath(this._workSpaces[1].substring(1));
            String currWSRP = "";
            currWSRP = this.getRemotePathFromBrowsePath(wsBrowsePath);
            if (0 == this._workSpaces[0].compareTo(currWSRP) && 0 == this._workSpaces[1].compareTo(currWSRP)) {
                if (this._revNums[0] == 0 && this._revNums[1] == 0) {
                    this._revNums[0] = 0;
                    this._revNums[1] = -3;
                } else if (this._revNums[0] == -1 && this._revNums[1] == -1) {
                    this._revNums[1] = -3;
                }
            } else if (0 == this._workSpaces[0].compareTo(currWSRP) || 0 == this._workSpaces[1].compareTo(currWSRP)) {
                if (0 == this._workSpaces[0].compareTo(currWSRP)) {
                    if (this._revNums[0] == -1) {
                        this._revNums[0] = -3;
                    }
                    if (this._revNums[1] == -1) {
                        this._revNums[1] = -4;
                    }
                } else {
                    if (this._revNums[1] == -1) {
                        this._revNums[1] = -3;
                    }
                    if (this._revNums[0] == -1) {
                        this._revNums[0] = -4;
                    }
                }
            } else {
                if (this._revNums[0] == -1) {
                    this._revNums[0] = -4;
                }
                if (this._revNums[1] == -1) {
                    this._revNums[1] = -4;
                }
            }
        }
        if (this._revNums[0] == -1) {
            filePath1 = folderItem.getLocalPath();
        } else {
            if (this._revNums[0] == 0) {
                try {
                    filePath1 = Command.getTempFileForVer(folderItem.asActivityRecordedFolderItem().refreshAndGetVersion());
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the originating version for the folder item " + this._resourcePaths[0]);
                    Command.getOut().println("Could not get the version which was synced last for folder item " + this._resourcePaths[0] + ". Diff will terminate.");
                    this._exitCode = 29;
                    return false;
                }
            }
            if (this._revNums[0] == -3) {
                try {
                    filePath1 = Command.getTempFileForVer(folderItem.asActivityRecordedFolderItem().getActiveVersion());
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the active version for the folder item " + this._resourcePaths[0]);
                    Command.getOut().println("Could not get the active version for folder item " + this._resourcePaths[0] + ". Diff will terminate.");
                    this._exitCode = 29;
                    return false;
                }
            }
        }
        if (this._revNums[1] == -1) {
            filePath2 = folderItem.getLocalPath();
        } else {
            if (this._revNums[1] == 0) {
                try {
                    filePath2 = Command.getTempFileForVer(folderItem.asActivityRecordedFolderItem().refreshAndGetVersion());
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the originating version of the folder item " + this._resourcePaths[0]);
                    Command.getOut().println("Could not get the version which was synced last for folder item " + this._resourcePaths[0] + ". Diff will terminate.");
                    this._exitCode = 29;
                    return false;
                }
            }
            if (this._revNums[1] == -3) {
                try {
                    filePath2 = Command.getTempFileForVer(folderItem.asActivityRecordedFolderItem().getActiveVersion());
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting the active version for the folder item " + this._resourcePaths[0]);
                    Command.getOut().println("Could not get the active version for folder item " + this._resourcePaths[0] + ". Diff will terminate.");
                    this._exitCode = 29;
                    return false;
                }
            }
        }
        if ("".equals(filePath1) || "".equals(filePath2)) {
            IVfsVersionGraph.IVfsLineOfDescent lineOfDecent;
            IVfsVersionHistory versionHistory = version.getVersionHistory();
            VfsVersionGraph versionGraph = new VfsVersionGraph(versionHistory);
            if ("".equals(this._workSpaces[0]) || "".equals(this._workSpaces[1])) {
                Command.getOut().println("One of the workspaces specified is not correct.Please check and try again.");
                this._exitCode = 80;
                return false;
            }
            if ("".equals(filePath1)) {
                if (!this._workSpaces[0].startsWith("/")) {
                    this._workSpaces[0] = "/" + this._workSpaces[0];
                }
                if (this._workSpaces[0].endsWith("/")) {
                    this._workSpaces[0] = this._workSpaces[0].substring(0, this._workSpaces[0].length() - 1);
                }
                if ((lineOfDecent = versionGraph.getDescentLine(this._workSpaces[0])) == null) {
                    Command.getOut().println("The specified file " + this._resourcePaths[0] + " was never versioned in the workspace " + this._workSpaces[0]);
                    this._exitCode = 80;
                    return false;
                }
                filePath1 = DiffCommand.filePathForSeqNum(lineOfDecent, this._revNums[0]);
                if (filePath1 == null) {
                    Command.getOut().println("The specified branch sequence number " + this._revNums[0] + " does not exist for file " + this._resourcePaths[0] + " in the workspace " + this._workSpaces[0]);
                    this._exitCode = 29;
                    return false;
                }
            }
            if ("".equals(filePath2)) {
                if (!this._workSpaces[1].startsWith("/")) {
                    this._workSpaces[1] = "/" + this._workSpaces[1];
                }
                if (this._workSpaces[1].endsWith("/")) {
                    this._workSpaces[1] = this._workSpaces[1].substring(0, this._workSpaces[1].length() - 1);
                }
                if ((lineOfDecent = versionGraph.getDescentLine(this._workSpaces[1])) == null) {
                    Command.getOut().println("The specified file " + this._resourcePaths[0] + " was never versioned in the workspace " + this._workSpaces[1]);
                    this._exitCode = 80;
                    return false;
                }
                filePath2 = DiffCommand.filePathForSeqNum(lineOfDecent, this._revNums[1]);
                if (filePath2 == null) {
                    Command.getOut().println("The specified branch sequence number " + this._revNums[1] + " does not exist for file " + this._resourcePaths[0] + " in the workspace " + this._workSpaces[1]);
                    this._exitCode = 29;
                    return false;
                }
            }
        }
        String[] args = new String[]{diffToolPath, filePath1, filePath2};
        try {
            process = Runtime.getRuntime().exec(args);
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while starting the diff tool " + diffToolPath);
            Command.getOut().println(exp.getMessage());
            Command.getOut().println("Could not start the diff tool. Please check the settings file");
            this._exitCode = 64;
            return false;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException exp) {
            Logger.traceSystemError(LOCATION, exp, "The Diff Tool process was interupted.");
            Command.getOut().println("Diff Tool process was interupted" + exp.getMessage());
        }
        return true;
    }

    public boolean validateArguments() {
        if (this._resourcePaths == null) {
            return false;
        }
        if (this._resourcePaths.length > 1) {
            Command.getOut().println("Command can accept only one file at a time");
            return false;
        }
        if (-2 == this._revNumber) {
            Command.getOut().println("The Revision number specified is incorrect");
            return false;
        }
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.DIFF, false) + " FolderItempath@rev1 [ -@rev2 ] [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " workspace1] [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " workspace2]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Diffs two versions of a file", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. rev1 & rev2 should be either not specified or be valid branch sequence numbers or be 0(as explained below)", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If both rev1 and rev2 are specified then a diff between rev1 and rev2 will be shown", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If only one of rev1 and rev2 is specified a diff between rev1/rev2 and the file on the local system will be shown", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If neither rev1 nor rev2 is specified then a diff between the active workspace version and the file on the local system will be shown", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If either rev1 or rev2 is specified as 0 then a diff between the version that was synced last will be done with the other specified version", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If only rev1 or rev2 is specified as 0 then a diff between the version that was synced last will be done with the local file", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "The " + NameConfig.getOption(OptionName.WORKSPACE, true) + " option can be used to specify the workspace if " + "it is required to diff versions which are in other " + "workspaces.", true);
        this.printOptionHelp(null, 1, "The first workspace is associated with rev1", false);
        this.printOptionHelp(null, 1, "The second workspace is associated with rev2", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i;
            String currArg;
            if ((currArg = (String)arguments.get(i = indexOfArgs--)) != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String seqnum = NameConfig.getOption(OptionName.SEQ_NUM, false);
                String wsShort = NameConfig.getOption(OptionName.WORKSPACE, true);
                String wsLong = NameConfig.getOption(OptionName.WORKSPACE, false);
                if (lowerCaseArg.startsWith(seqnum)) {
                    if (-1 == this._revNumber) {
                        String revNum = Command.getActualArgument(currArg, seqnum, seqnum);
                        arguments.remove(i);
                        try {
                            this._revNumber = Integer.parseInt(revNum);
                        }
                        catch (NumberFormatException exp) {
                            Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while getting the revision number.");
                            this._revNumber = -2;
                        }
                    }
                } else if (lowerCaseArg.startsWith(wsShort) || lowerCaseArg.startsWith(wsLong)) {
                    if (this._workspacesSpecified > 2) break;
                    String wsName = Command.getActualArgument(currArg, wsShort, wsLong);
                    if ("".equals(wsName) && i + 1 < arguments.size()) {
                        wsName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._workSpaces[this._workspacesSpecified] = wsName;
                    ++this._workspacesSpecified;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        super.setArguments(arguments);
    }

    private static String filePathForSeqNum(IVfsVersionGraph.IVfsLineOfDescent lineOD, int seqNum) {
        IVfsVersionGraph.IVfsVersionElement ele = lineOD.getRootElements()[0];
        int startSeq = 1;
        while (startSeq != seqNum && ele.getLineSuccessors().size() != 0) {
            ele = (IVfsVersionGraph.IVfsVersionElement)ele.getLineSuccessors().get(0);
            ++startSeq;
        }
        if (startSeq != seqNum) {
            return null;
        }
        IVfsVersion ver = ele.getVersion();
        return Command.getTempFileForVer(ver);
    }

    public CommandName getCommandName() {
        return CommandName.DIFF;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

