/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.deltavlib.PathUtil;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.properties.Converter;
import com.tssap.dtr.client.lib.deltavlib.properties.DAV;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.requests.xcm.ActivityReport;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

class DescribeActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DescribeActivityCommand == null ? (class$com$tssap$dtr$client$commandline$DescribeActivityCommand = DescribeActivityCommand.class$("com.tssap.dtr.client.commandline.DescribeActivityCommand")) : class$com$tssap$dtr$client$commandline$DescribeActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DescribeActivityCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DescribeActivityCommand(arguments);
    }

    DescribeActivityCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "describes an activity";
    }

    private IVfsActivity getActivity() {
        IVfsActivity activity;
        if (this.getFileSystemManager() == null) {
            return null;
        }
        if (this._activityISN != -1) {
            IVfsWorkspace workspace;
            if ("".equals(this._workspacePaths[0])) {
                this._workspacePaths[0] = Utilities.getCurrentDirectory();
            }
            if ((workspace = this.getWorkspace()) == null) {
                Command.getOut().println("Could not find source workspace");
                this._exitCode = 30;
                return null;
            }
            int[] isns = ActivityCommand.convertActivityISNsFromStringsToNumbers(this._activityISNs);
            ActivityCommand.ActivityPathIsnPair[] pairs = ActivityCommand.executeActISNReport(workspace, isns);
            if (pairs.length == 0) {
                Command.getOut().println("Could not find the given activity");
                this._exitCode = 32;
                return null;
            }
            try {
                activity = workspace.getRepository().getActivityByUrl(Command.getWebLocator((IVfsFolderItem)workspace) + pairs[0].activityPath);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException during retrieving activity with path " + pairs[0].activityPath);
                Command.getOut().println("Could not find the given activity");
                this._exitCode = 32;
                return null;
            }
        } else {
            activity = this.getActivity(true, true);
        }
        return activity;
    }

    public boolean execute() {
        if (!this._workspacePaths[0].startsWith("URL:")) {
            boolean isOpen;
            IVfsActivity activity = this.getActivity();
            if (activity == null) {
                return false;
            }
            String displayName = "";
            try {
                displayName = activity.getDisplayName();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving display name.");
                displayName = "<getting display name failed>";
            }
            Command.getOut().println();
            Command.getOut().println("Activity Name   : " + displayName);
            Command.getOut().println("Actual Name     : " + activity.getName());
            IVfsActivityRecordedFolderItem[] activityRecordedFolderItems = null;
            IVfsVersion[] versions = null;
            try {
                isOpen = activity.isOpen();
                if (isOpen) {
                    Command.getOut().println("Activity State  : Open");
                    activityRecordedFolderItems = activity.getElementsFromOpenActivity();
                } else {
                    Command.getOut().println("Activity State  : Closed");
                    versions = activity.getElementsFromClosedActivity();
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving activity items.");
                Command.getOut().println(exp.getMessage());
                Command.getOut().println("Could not get the items in the activity. Please try again");
                this._exitCode = 45;
                return false;
            }
            String description = "";
            try {
                description = activity.getDescription();
                if (description == null) {
                    description = "<no description specified>";
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving description.");
                description = "<getting description failed>";
            }
            String author = "";
            try {
                author = activity.getAuthor();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving author.");
                author = "<getting author failed>";
            }
            Command.getOut().println("Author          : " + author);
            if (!isOpen) {
                Date cInD = null;
                try {
                    cInD = activity.getCheckedInDate();
                }
                catch (VfsException exp) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving checkin date.");
                    cInD = null;
                }
                if (cInD != null) {
                    Command.getOut().println("Checked In Date : " + this.getFormattedDate(cInD));
                } else {
                    Command.getOut().println("Checked In Date : <getting Checked In Date failed>");
                }
            } else {
                Date cD = null;
                try {
                    cD = activity.getCreationDate();
                }
                catch (VfsException exp) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving creation date.");
                    cD = null;
                }
                if (cD != null) {
                    Command.getOut().println("Created On      : " + this.getFormattedDate(cD));
                } else {
                    Command.getOut().println("Created On      : <getting Created On Date failed>");
                }
            }
            Command.getOut().println();
            Command.getOut().println("\t" + description);
            if (activityRecordedFolderItems == null && versions == null) {
                Command.getOut().println("Could not get the items in the activity. Please try again");
                this._exitCode = 45;
                return false;
            }
            if (isOpen) {
                if (activityRecordedFolderItems.length == 0) {
                    Command.getOut().println();
                    Command.getOut().println("The given activity is empty");
                    return true;
                }
                Command.getOut().println();
                Command.getOut().println("Affected FolderItems....");
                Command.getOut().println();
                int i = 0;
                while (i < activityRecordedFolderItems.length) {
                    IVfsActivityRecordedFolderItem activityRecordedFolderItem = activityRecordedFolderItems[i];
                    if (activityRecordedFolderItem != null) {
                        String browsePath;
                        try {
                            IVfsVersion version;
                            browsePath = "/" + activityRecordedFolderItem.getBrowsePath();
                            if (activityRecordedFolderItem.asFolder() != null && (version = activityRecordedFolderItem.refreshAndGetVersion()) != null) {
                                browsePath = browsePath + "@" + version.getBranchSequenceNumber();
                            }
                        }
                        catch (VfsException exp) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving browse path.");
                            browsePath = "<getting browse path failed>";
                        }
                        Command.getOut().print(browsePath);
                        Command.getOut().print("    ");
                        Command.getOut().println(activityRecordedFolderItem.getActivityState().toString());
                    }
                    ++i;
                }
            } else {
                if (versions.length == 0) {
                    Command.getOut().println();
                    Command.getOut().println("The given activity is empty");
                    return true;
                }
                Command.getOut().println();
                Command.getOut().println("Affected FolderItems....");
                Command.getOut().println();
                int i = 0;
                while (i < versions.length) {
                    IVfsVersion version = versions[i];
                    if (version != null) {
                        String workspaceRelativePath = version.getWorkspaceRelativePath();
                        IVfsWorkspace workspace = activity.getWorkspace();
                        try {
                            String versionString = workspace != null ? workspace.getBrowsePath() + workspaceRelativePath + "@" + version.getBranchSequenceNumber() : workspaceRelativePath + "@" + version.getBranchSequenceNumber() + " in workspace " + activity.getWorkspaceDescription();
                            Command.getOut().println(versionString);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during computation of workspace path:" + e.getMessage());
                            Command.getOut().println("Could not access the workspace of the activity.");
                            this._exitCode = 45;
                            return false;
                        }
                    }
                    ++i;
                }
            }
        } else if (this._activityISN != -1) {
            IResponse response;
            String basePath;
            int[] isns = ActivityCommand.convertActivityISNsFromStringsToNumbers(this._activityISNs);
            String wsURL = this._workspacePaths[0].substring(4);
            if (Command.getContext(this._clientName) == null) {
                Command.getOut().println("Client specified is not correct or no active client present.");
                return false;
            }
            if (Command.getContext(this._clientName).getRemoteLocatorFromUrl(wsURL) == null) {
                Command.getOut().println("Could not find source workspace");
                this._exitCode = 30;
                return false;
            }
            try {
                basePath = Command.getConnectionTemplate(Command.getConnectionTemplateId(wsURL, this._clientName)).getBasePath();
            }
            catch (InvalidTemplateIDException invalidTemplateID) {
                LogUtil.logException((Location)LOCATION, (Throwable)invalidTemplateID);
                throw new IllegalStateException(invalidTemplateID.getMessage());
            }
            ActivityReport activityReport = new ActivityReport(basePath);
            if (activityReport == null) {
                this._exitCode = 58;
                return false;
            }
            int pingTries = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.pingtries", 2);
            int pingWaitTime = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.pingwaittime", 2000);
            IClient client = this.getCacheConfiguration().getClient(this._clientName);
            IRepositoryServer server = client.getLogicalSystem().getRepositoryServer(Command.getConnectionTemplateId(wsURL, this._clientName));
            try {
                server.httpPing(pingTries, pingWaitTime);
            }
            catch (ConfigurationException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Unable to ping server.");
                Command.getOut().println("The server " + server.getUrl() + " is unavailable");
                Command.getOut().println("Unable to ping server. " + e.getMessage());
                this._exitCode = 3;
                return false;
            }
            activityReport.applyToPropagations();
            activityReport.addIntegrationSequenceQuery(isns[0]);
            activityReport.addNamespace("DAV", "DAV:");
            activityReport.addNamespace(XCM.NAMESPACE_PREFIX, XCM.NAMESPACE_URI);
            activityReport.addWorkspaceQuery(wsURL);
            activityReport.addSelectProperty(DAV.DISPLAYNAME.qualifiedName);
            activityReport.addSelectProperty(DAV.CREATOR_DISPLAYNAME.qualifiedName);
            activityReport.addSelectProperty(XCM.VERSION_SET_STATE.qualifiedName);
            activityReport.addSelectProperty(DAV.GETLASTMODIFIED.qualifiedName);
            activityReport.addSelectProperty(DAV.CREATIONDATE.qualifiedName);
            activityReport.addSelectProperty(DAV.COMMENT.qualifiedName);
            ExpandPropertyDef verSet = activityReport.addPropertyExpand(XCM.VERSION_SET.qualifiedName, XCM.NAMESPACE_URI, null);
            activityReport.addPropertyExpand(new ExpandPropertyDef(XCM.PATH.qualifiedName, XCM.NAMESPACE_URI), verSet);
            activityReport.addPropertyExpand(new ExpandPropertyDef(XCM.SEQUENCE_NUMBER.qualifiedName, XCM.NAMESPACE_URI), verSet);
            try {
                response = DeltavCommand.execute((int)Command.getConnectionTemplateId(wsURL, this._clientName), (IRequest)activityReport);
            }
            catch (VcmFailure e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VcmFailure occurred during firing of actvity report.");
                Command.getOut().println("Could not find the given activity");
                this._exitCode = 32;
                return false;
            }
            if (response == null) {
                this._exitCode = 59;
                return false;
            }
            Iterator resources = activityReport.getResources();
            if (resources != null && resources.hasNext()) {
                String des;
                String createdOn;
                String author;
                ResourceElement elem = (ResourceElement)resources.next();
                String displayName = elem.getChildValue(DAV.DISPLAYNAME.localName, "DAV:");
                if (displayName == null) {
                    displayName = "";
                }
                if ((author = elem.getChildValue(DAV.CREATOR_DISPLAYNAME.localName, "DAV:")) == null) {
                    author = "";
                }
                String state = elem.getChildValue(XCM.VERSION_SET_STATE.localName, XCM.NAMESPACE_URI);
                boolean bOpen = false;
                if (state == null) {
                    state = "";
                } else if ("closed".equalsIgnoreCase(state)) {
                    state = "Closed";
                    bOpen = false;
                } else {
                    state = "Open";
                    bOpen = true;
                }
                String cind = "";
                if (!bOpen) {
                    cind = elem.getChildValue(DAV.GETLASTMODIFIED.localName, "DAV:");
                    if (cind == null) {
                        cind = "";
                    } else {
                        Date date = Converter.parseHTTPDate((String)cind);
                        cind = date.toString();
                    }
                }
                if ((createdOn = elem.getChildValue(DAV.CREATIONDATE.localName, "DAV:")) == null) {
                    createdOn = "";
                }
                String actualName = elem.getPath();
                if ((actualName = PathUtil.getNameFromPath((String)Encoder.decodePath((String)actualName))) == null) {
                    actualName = "";
                }
                if ((des = elem.getChildValue(DAV.COMMENT.localName, "DAV:")) == null) {
                    des = "";
                }
                PropertyElement cele = !bOpen ? (PropertyElement)elem.getChild(XCM.VERSION_SET.localName, XCM.NAMESPACE_URI) : (PropertyElement)elem.getChild(XCM.VERSION_SET.localName, XCM.NAMESPACE_URI);
                Command.getOut().println();
                Command.getOut().println("Activity Name   : " + displayName);
                Command.getOut().println("Actual Name     : " + actualName);
                Command.getOut().println("Activity State  : " + state);
                Command.getOut().println("Author          : " + author);
                if (!bOpen) {
                    Command.getOut().println("Checked In Date : " + cind);
                } else {
                    Command.getOut().println("Created On      : " + createdOn);
                }
                if (des == null || des.equals("")) {
                    des = "<no description specified>";
                }
                Command.getOut().println();
                Command.getOut().println("\t" + des);
                Command.getOut().println();
                Command.getOut().println("Affected FolderItems....");
                Iterator children = cele.getExpandedResources();
                IVfsRemoteLocator wsRemoteLocator = Command.getContext(this._clientName).getRemoteLocatorFromUrl(wsURL);
                String prefix = wsRemoteLocator != null ? this.getBrowsePath(wsRemoteLocator) : wsURL.substring(Command.getWebLocator(wsURL, this._clientName).length());
                Command.getOut().println();
                while (children != null && children.hasNext()) {
                    Element child = (Element)children.next();
                    String path = "/" + prefix + child.getChildValue(XCM.PATH.qualifiedName, XCM.NAMESPACE_URI);
                    String seqNum = child.getChildValue(XCM.SEQUENCE_NUMBER.qualifiedName, XCM.NAMESPACE_URI);
                    if (seqNum == null) {
                        seqNum = "";
                    }
                    Command.getOut().println(path + "@" + seqNum);
                }
            } else {
                Command.getOut().println("Could not find the given activity");
                this._exitCode = 32;
                return false;
            }
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
    }

    public String getName() {
        return null;
    }

    public CommandName getCommandName() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

