/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.requests.xcm.AdminOperationRequest;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DeleteWSCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DeleteWSCommand == null ? (class$com$tssap$dtr$client$commandline$DeleteWSCommand = DeleteWSCommand.class$("com.tssap.dtr.client.commandline.DeleteWSCommand")) : class$com$tssap$dtr$client$commandline$DeleteWSCommand));
    private String _comments;
    private boolean _isPreview;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DeleteWSCommand;

    public DeleteWSCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.WORKSPACE);
        this.addSupportedOption(OptionName.ADMNPREVIEW);
        this.addSupportedOption(OptionName.COMMENTS);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Delete the given workspace";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            IVfsFolderItem workspaceFolderItem = this.getResource(this._workspacePaths[0]);
            if (workspaceFolderItem == null) {
                Command.getOut().println("Could not retrive folder item " + this._workspacePaths[0]);
                return false;
            }
            IVfsWorkspace workspace = workspaceFolderItem.asWorkspace();
            if (workspace == null) {
                Command.getOut().println("Folder item " + this._workspacePaths[0] + " is not a workspace ");
                return false;
            }
            AdminOperationRequest request = new AdminOperationRequest();
            request.setWorkspaceToDelete(workspace.getAbsoluteRemotePath());
            if (this._isPreview) {
                request.setPreviewOnly(this._isPreview);
            }
            request.setComments(this._comments);
            this.performRequest((IRequest)request);
            this.writeMessage("Deleted workspace " + this._workspacePaths[0]);
        }
        catch (VcmFailure ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VcmFailure during deletion of workspace " + this._workspacePaths[0]);
            this.writeMessage("Could not delete workspace" + ex.getMessage());
        }
        return retVal;
    }

    public boolean validateArguments() {
        boolean isValidateArguments = true;
        if (this._workspacePaths[0] == null || this._workspacePaths[0].trim().length() == 0) {
            this.writeMessage("Must specify workspace path.");
            isValidateArguments = false;
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        this.setSuperArguments(arguments);
        String commentsShortOptName = NameConfig.getOption(OptionName.COMMENTS, true);
        String commentsWSLongOptName = NameConfig.getOption(OptionName.COMMENTS, false);
        String previewShortOptName = NameConfig.getOption(OptionName.PREVIEW, true);
        String previewWSLongOptName = NameConfig.getOption(OptionName.PREVIEW, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null) continue;
            if (commentsShortOptName.compareToIgnoreCase(currentArg) == 0 || commentsWSLongOptName.compareToIgnoreCase(currentArg) == 0) {
                listIterator.remove();
                this._comments = (String)listIterator.next();
                listIterator.remove();
                continue;
            }
            if (previewShortOptName.compareToIgnoreCase(currentArg) != 0 && previewWSLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._isPreview = true;
        }
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.DELETEWS, false) + " " + NameConfig.getOption(OptionName.WORKSPACE, true) + " \"workspace path\" " + " [ " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"comments\"] ");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Deletes the given workspaces.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.COMMENTS, 1, "A short note specifying why the action was performed.", true);
        this.writeMessage("");
    }

    public CommandName getCommandName() {
        return CommandName.DELETEWS;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DeleteWSCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

