/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.ImmediateDeleteAction;
import java.util.ArrayList;
import java.util.Arrays;

class DeleteCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DeleteCommand == null ? (class$com$tssap$dtr$client$commandline$DeleteCommand = DeleteCommand.class$("com.tssap.dtr.client.commandline.DeleteCommand")) : class$com$tssap$dtr$client$commandline$DeleteCommand));
    private boolean _recurce;
    private boolean _sure;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DeleteCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DeleteCommand(arguments);
    }

    DeleteCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.RECURSE);
        this.addSupportedOption(OptionName.SURE);
        this._recurce = false;
        this._sure = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "checks out a file/folder for deletion";
    }

    public boolean execute() {
        IVfsWorkspace workspace = null;
        IVfsActivity activity = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            block28: {
                IVfsActivityRecordedFolderItem activityRecordedFolderItem;
                block32: {
                    block27: {
                        IVfsFolderItem folderItem;
                        block33: {
                            block34: {
                                block31: {
                                    block30: {
                                        block29: {
                                            if (this._resourcePaths[i] == null) break block28;
                                            folderItem = this.getResource(this._resourcePaths[i]);
                                            if (folderItem != null) break block29;
                                            Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                                            break block28;
                                        }
                                        activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                                        if (activityRecordedFolderItem != null) break block30;
                                        if (folderItem.asWorkspace() != null || folderItem.asWorkspaceFolder() != null) {
                                            Command.getOut().println("Folder item \"" + this._resourcePaths[i] + "\" is not activity recorded");
                                            Command.getOut().println("Try \"" + CommandName.DELETEWS.getName() + "\" command for deleting workspaces.");
                                        } else {
                                            Command.getOut().println("Delete not supported for this resource \"" + this._resourcePaths[i] + "\"");
                                        }
                                        this._exitCode = 88;
                                        break block28;
                                    }
                                    if (activityRecordedFolderItem.asFolder() == null || !this._recurce || !this._sure) break block31;
                                    Command.getOut().println("Deleting subtree starting from " + this._resourcePaths[i]);
                                    break block32;
                                }
                                if (workspace != null) break block33;
                                if (activityRecordedFolderItem != null) break block34;
                                Command.getOut().println("Folder item " + this._resourcePaths[i] + " is not activity recorded");
                                this._exitCode = 88;
                                break block28;
                            }
                            workspace = activityRecordedFolderItem.getWorkspace();
                            if (workspace != null) break block27;
                            Command.getOut().println("Could not retrive workspace for folder item " + this._resourcePaths[i]);
                            this._exitCode = 22;
                            break block28;
                        }
                        try {
                            if (!folderItem.getBrowsePath().startsWith(workspace.getBrowsePath())) {
                                Command.getOut().println("Folder item " + folderItem.getBrowsePath() + " does not belong to the workspace " + workspace.getBrowsePath());
                                this._exitCode = 23;
                            }
                            break block27;
                        }
                        catch (VfsException x) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred. Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                            Command.getOut().println("Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                        }
                        break block28;
                    }
                    if (activity == null) {
                        try {
                            activity = this.getOrCreateActivity(workspace);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred. Activity get/create failed.");
                            this._exitCode = 35;
                            Command.getOut().println("Activity get/create failed. " + e.getMessage());
                            return false;
                        }
                    }
                }
                if (activityRecordedFolderItem != null) {
                    VfsActionOnFolderItem[] actionsPoss = activityRecordedFolderItem.getActionsForCurrentState();
                    if (activityRecordedFolderItem.asFolder() != null && this._recurce && this._sure && Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.DEPRECATED_IMMEDIATE_CHECKOUT_AND_DELETE)) {
                        ImmediateDeleteAction action = new ImmediateDeleteAction((IVfsActivityRecordedFolderItem)activityRecordedFolderItem.asFolder());
                        try {
                            action.execute();
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred when trying do delete heirarchy of folder " + this._resourcePaths[i]);
                            Command.getOut().println(e.getMessage());
                            Command.getOut().println("Could not delete folder : " + this._resourcePaths[i]);
                            this._exitCode = 11;
                            return false;
                        }
                    } else if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.CHECKOUT_AND_DELETE)) {
                        try {
                            activityRecordedFolderItem.checkOutAndDelete(activity);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred when trying do delete folderitem " + this._resourcePaths[i]);
                            Command.getOut().println(e.getMessage());
                            Command.getOut().println("Could not check out file : " + this._resourcePaths[i] + " For Delete.");
                            this._exitCode = 11;
                            return false;
                        }
                    } else {
                        String mes = "";
                        if (activityRecordedFolderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                            mes = "Folder item is checked out. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is local only. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.SERVER_ONLY) {
                            mes = "Folder item is not synced. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                        } else if (activityRecordedFolderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                            mes = "Folder item is not in sync. ";
                        }
                        Command.getOut().println(mes + "Cannot check out file : " + this._resourcePaths[i] + " For Delete.");
                        this._exitCode = 10;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.DELETE, false) + "\t[" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "] ] FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Checks out the specified folder items for deletion", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the files will be checked out in the given activity. If the activity is not specified then the default activity for the workspace is used. If the specified activity does not exist then it will be created", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name. This is only in case to specify to use an already existing activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "To specify that the whole subtree starting from the given folder has to be deleted.", true);
        this.printOptionHelp(OptionName.RECURSE, 1, "NOTE(IMP) : This is an irreversible operation.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SURE, 1, "When specifying option " + NameConfig.getOption(OptionName.RECURSE, false) + " above " + "this option has to be specifed to indicate that you are sure of the operation being performed. " + "This is because the operation of deleting a subtree is irreversible.", true);
        Command.getOut().println();
    }

    public CommandName getCommandName() {
        return CommandName.DELETE;
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String rShort = NameConfig.getOption(OptionName.RECURSE, true);
                String rLong = NameConfig.getOption(OptionName.RECURSE, false);
                String sShort = NameConfig.getOption(OptionName.SURE, true);
                String sLong = NameConfig.getOption(OptionName.SURE, false);
                if (lowerCaseArg.equals(rShort) || lowerCaseArg.compareToIgnoreCase(rLong) == 0) {
                    this._recurce = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.equals(sShort) || lowerCaseArg.compareToIgnoreCase(sLong) == 0) {
                    this._sure = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

