/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class DeleteActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DeleteActivityCommand == null ? (class$com$tssap$dtr$client$commandline$DeleteActivityCommand = DeleteActivityCommand.class$("com.tssap.dtr.client.commandline.DeleteActivityCommand")) : class$com$tssap$dtr$client$commandline$DeleteActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DeleteActivityCommand;

    public DeleteActivityCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getName() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public boolean execute() {
        IVfsActivity activity;
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        if (fileSystemManager == null) {
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
            return false;
        }
        IVfsRepository[] repositories = fileSystemManager.getRepositories();
        ArrayList<IVfsActivity> actlist = new ArrayList<IVfsActivity>();
        int i = 0;
        while (i < repositories.length) {
            IVfsActivity[] activities = Command.getEmptyActivitiesByName(repositories[i], this._activityName, this._displayNameSpecified);
            int j = 0;
            while (j < activities.length) {
                if (activities[j] != null) {
                    actlist.add(activities[j]);
                }
                ++j;
            }
            ++i;
        }
        if (actlist.size() == 0) {
            Command.getOut().println("No activity found with name " + this._activityName);
            this._exitCode = 32;
            return true;
        }
        if (actlist.size() == 1) {
            activity = (IVfsActivity)actlist.get(0);
        } else {
            IVfsActivity[] activities = new IVfsActivity[actlist.size()];
            activity = this.getUserSelectedActivity(activities = actlist.toArray(activities), this.getOutputDatePattern());
            if (activity == null) {
                Command.getOut().println("You have cancelled the process");
                this._exitCode = 50;
                return true;
            }
        }
        try {
            activity.delete();
            Command.getOut().println("Activity \"" + this._activityName + "\" deleted");
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during deletion of activity.");
            Command.getOut().println("Could not delete activity. " + e.getMessage());
            this._exitCode = 34;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._activityName != null && this._activityName.length() > 0;
    }

    public void printHelpDescription() {
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new DeleteActivityCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

