/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Cache;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class DTRShell {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DTRShell == null ? (class$com$tssap$dtr$client$commandline$DTRShell = DTRShell.class$("com.tssap.dtr.client.commandline.DTRShell")) : class$com$tssap$dtr$client$commandline$DTRShell));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DTRShell;

    public static void main(String[] args) {
        IClient actCli;
        Utilities.setIsInShell(true);
        String defName = "";
        String userName = null;
        String pwd = null;
        int i = 0;
        while (i < args.length) {
            int argLength;
            String lowerCaseArg = args[i].toLowerCase();
            if (args[i].startsWith("-def")) {
                defName = args[i].substring(4);
                if ("".equals(defName) && args.length > i + 1) {
                    defName = args[i + 1];
                }
            } else if (args[i].startsWith("-un") || lowerCaseArg.startsWith("--username")) {
                argLength = 0;
                argLength = args[i].startsWith("-un") ? 3 : 10;
                userName = args[i].substring(argLength);
                if ("".equals(userName) && args.length > i + 1) {
                    userName = args[i + 1];
                }
                if (userName.equals("")) {
                    userName = null;
                }
            } else if (args[i].startsWith("-pwd") || lowerCaseArg.startsWith("--password")) {
                argLength = 0;
                argLength = args[i].startsWith("-pwd") ? 4 : 10;
                pwd = args[i].substring(argLength);
                if ("".equals(pwd) && args.length > i + 1) {
                    pwd = args[i + 1];
                }
            }
            ++i;
        }
        DTRClient.getOut().println(">Initializing...");
        IConfiguration config = Cache.getCache().getConfiguration();
        if ("".equals(defName) && (actCli = config.getActiveClient()) != null) {
            defName = actCli.getName();
        }
        Logger.traceInfo(LOCATION, "Initializing DTR Shell for client \"" + defName + (userName == null ? "\"" : "\" for user " + userName));
        DTRClient.doLogin(config, userName, pwd);
        DTRClient.getOut().println(">This may take a few seconds. Please wait...");
        DTRClient.getOut().println(">Connecting to client \"" + defName + "\"");
        Cache cache = Cache.getCache(defName);
        if (cache.getFileSystemManager() != null) {
            DTRClient.getOut().println(">Initialization Complete.");
            Logger.traceInfo(LOCATION, "Initializing DTR Shell for client \"" + defName + "\" succeeded.");
        } else {
            DTRClient.getOut().println(">Initialization Failed.");
            Logger.traceInfo(LOCATION, "Initializing DTR Shell for client \"" + defName + "\" failed.");
        }
        DTRShell.executeCommands(DTRClient.getIn());
        System.exit(0);
    }

    private static String[] convertStringToArgs(String input) {
        ArrayList<String> args = new ArrayList<String>();
        while (true) {
            String tempAddStr;
            int index = input.indexOf(" ");
            int indexQuote = input.indexOf("\"");
            if (input.startsWith("\"")) {
                indexQuote = input.indexOf("\"", 1);
                if (-1 != indexQuote) {
                    tempAddStr = input.substring(1, indexQuote).trim();
                    if (!"".equals(tempAddStr)) {
                        args.add(tempAddStr);
                    }
                    input = input.substring(indexQuote + 1).trim();
                    continue;
                }
            } else if (indexQuote != -1 && indexQuote < index && -1 != input.indexOf("\"", indexQuote + 1)) {
                index = indexQuote;
            }
            if (-1 == index) {
                if (input.trim().length() <= 0) break;
                args.add(input.trim());
                break;
            }
            tempAddStr = input.substring(0, index).trim();
            if (!"".equals(tempAddStr)) {
                args.add(tempAddStr);
            }
            input = input.substring(index).trim();
        }
        String[] strArgs = new String[args.size()];
        strArgs = args.toArray(strArgs);
        return strArgs;
    }

    public static void executeCommands(InputStream is) {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        while (true) {
            String input = null;
            try {
                DTRClient.getOut().print(">");
                input = br.readLine();
            }
            catch (IOException x) {
                Logger.traceSystemError(LOCATION, x, "IOException occurred during reading command.");
                DTRClient.getOut().println(">" + x.getMessage());
                DTRClient.getOut().println(">IOException Occured");
            }
            if (input == null) break;
            if ("exit".equalsIgnoreCase(input)) {
                Logger.traceInfo(LOCATION, "Exiting DTR Shell" + input);
                break;
            }
            if ("".equals(input)) {
                DTRClient.getOut().println();
                continue;
            }
            Logger.traceInfo(LOCATION, "Running command :: " + input);
            String[] arguments = DTRShell.convertStringToArgs(input);
            try {
                DTRClient.executeCommand(arguments);
            }
            catch (Exception x) {
                Logger.traceInternalError(LOCATION, x, "Unexpected exception occurred during executing command.");
                DTRClient.getOut().println(">Unexpected problem occurred during executing command." + x.getMessage());
                x.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

