/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Cache;
import com.tssap.dtr.client.commandline.CommandLine;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.LoginParamsInput;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import com.tssap.dtr.client.lib.vfs.config.impl.SessionContextBag;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class DTRClient {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$DTRClient == null ? (class$com$tssap$dtr$client$commandline$DTRClient = DTRClient.class$("com.tssap.dtr.client.commandline.DTRClient")) : class$com$tssap$dtr$client$commandline$DTRClient));
    private static String _pwd;
    private static String _userName;
    public static final String VERSION = "1.60";
    static boolean _callExit;
    static int _exitCode;
    private static PrintStream OUT;
    private static final InputStream IN;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$DTRClient;

    public static void main(String[] args) {
        _callExit = true;
        String[] newArgs = DTRClient.parseCommandlineForGenericArgs(args);
        String arguments = "";
        int i = 0;
        while (i < newArgs.length) {
            arguments = arguments + newArgs[i] + " ";
            ++i;
        }
        Cache.getCache().getConfiguration();
        Logger.traceInfo(LOCATION, "Running command :: " + arguments);
        DTRClient.executeCommand(newArgs);
        if (_callExit) {
            System.exit(_exitCode);
        }
    }

    private static String[] parseCommandlineForGenericArgs(String[] args) {
        _userName = null;
        _pwd = null;
        ArrayList<String> newArgs = new ArrayList<String>();
        boolean skipNext = false;
        int i = 0;
        while (i < args.length) {
            if (skipNext) {
                skipNext = false;
            } else {
                int argLength;
                String lowerCaseArg = args[i].toLowerCase();
                if (args[i].startsWith("-un") || lowerCaseArg.startsWith("--username")) {
                    argLength = 0;
                    argLength = args[i].startsWith("-un") ? 3 : 10;
                    _userName = args[i].substring(argLength);
                    if ("".equals(_userName) && args.length > i + 1) {
                        _userName = args[i + 1];
                        skipNext = true;
                    }
                    if (_userName.equals("")) {
                        _userName = null;
                    }
                } else if (args[i].startsWith("-pwd") || lowerCaseArg.startsWith("--password")) {
                    argLength = 0;
                    argLength = args[i].startsWith("-pwd") ? 4 : 10;
                    _pwd = args[i].substring(argLength);
                    if ("".equals(_pwd) && args.length > i + 1) {
                        _pwd = args[i + 1];
                        skipNext = true;
                    }
                } else {
                    newArgs.add(args[i]);
                }
            }
            ++i;
        }
        String[] newArgsArray = new String[newArgs.size()];
        newArgsArray = newArgs.toArray(newArgsArray);
        return newArgsArray;
    }

    public static PrintStream getOut() {
        return OUT;
    }

    public static void setOut(PrintStream newOut) {
        OUT = newOut;
    }

    public static InputStream getIn() {
        return IN;
    }

    public static boolean executeCommand(String[] args) {
        _exitCode = 0;
        CommandLine commandLine = new CommandLine();
        commandLine.parseCommandLine(args);
        ICommand command = commandLine.getCommand();
        if (command == null) {
            _exitCode = 1;
            return false;
        }
        if (!command.checkForExtraArgumnets()) {
            _exitCode = 2;
            return false;
        }
        if (!command.validateArguments()) {
            DTRClient.getOut().println("Arguments specified are not valid. Please check and try again.");
            _exitCode = 2;
            return false;
        }
        if (!Utilities.isInShell() && command.requiresLogon()) {
            Logger.traceDebug(LOCATION, "Logging on to DTR for client \"" + command.getClientName() + (_userName == null ? "\"" : "\" for user " + _userName));
            DTRClient.doLogin(Cache.getCache().getConfiguration(), _userName, _pwd);
        }
        boolean retVal = command.execute();
        _exitCode = command.getExitCode();
        return retVal;
    }

    public static boolean doLogin(IConfiguration config, String userName, String pwd) {
        SessionContextBag sessionContexts = ((Configuration)config).getSessionContexts();
        Iterator iter = sessionContexts.sessionContexts();
        boolean foundSessionContext = false;
        while (iter.hasNext()) {
            ISessionContext sessionContext = (ISessionContext)iter.next();
            String user = sessionContext.getUser();
            if (user == null || user.trim().equals("")) continue;
            foundSessionContext = true;
        }
        if (foundSessionContext) {
            return true;
        }
        String[] userNameAndPwds = null;
        try {
            if (userName == null || pwd == null) {
                if (userName == null) {
                    userNameAndPwds = new LoginParamsInput().getInput("Login", "", false, true);
                    Logger.traceDebug(LOCATION, "Logging in for user " + userNameAndPwds[0]);
                } else {
                    userNameAndPwds = new LoginParamsInput().getInput("Login", userName, false, false);
                }
            } else {
                userNameAndPwds = new String[]{userName, pwd};
            }
        }
        catch (IOException e) {
            Logger.traceSystemError(LOCATION, e, "IOException occurred during getting user & password from user.");
            return false;
        }
        if (userNameAndPwds == null || userNameAndPwds.length != 2 || userNameAndPwds[0].trim().equals("")) {
            return false;
        }
        config.setMasterLogin(userNameAndPwds[0], userNameAndPwds[1]);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _callExit = true;
        OUT = System.out;
        IN = System.in;
    }
}

