/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class CreateActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$CreateActivityCommand == null ? (class$com$tssap$dtr$client$commandline$CreateActivityCommand = CreateActivityCommand.class$("com.tssap.dtr.client.commandline.CreateActivityCommand")) : class$com$tssap$dtr$client$commandline$CreateActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$CreateActivityCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new CreateActivityCommand(arguments);
    }

    CreateActivityCommand(ArrayList arguments) {
        super(arguments);
        this._allowMultipleWSPaths = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "creates an empty activity";
    }

    public boolean execute() {
        IVfsActivity activity;
        IVfsWorkspace workspace;
        IVfsFolderItem folderItem = this.getResource(this.getCorrectWSPath(this._workspacePaths[0]));
        if (folderItem == null) {
            Command.getOut().println("The workspace for the activity cannot be resolved correctly. Please provide the correct workspace.");
            if (this._exitCode != 3) {
                this._exitCode = 30;
            }
            return false;
        }
        if (folderItem.asWorkspace() != null) {
            workspace = folderItem.asWorkspace();
        } else if (folderItem.asActivityRecordedFolderItem() != null) {
            workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
        } else {
            Command.getOut().println("The workspace for the activity cannot be resolved correctly. Please provide the correct workspace.");
            this._exitCode = 30;
            return false;
        }
        try {
            Command.getOut().println("Creating the requested activity....");
            activity = workspace.createActivity(this._activityName);
            if (activity == null) {
                Command.getOut().println("Could not create the requested activity.");
                this._exitCode = 33;
                return false;
            }
        }
        catch (VfsException x) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred during creation of activity.");
            Command.getOut().println("Could not create the requested activity." + x.getMessage());
            this._exitCode = 33;
            return false;
        }
        Command.getOut().println("Created the requested activity.");
        Command.getOut().println("Editing the activity....");
        if (this._noUI) {
            this.performNonUIEdit(activity, false);
        } else {
            this.performUIEdit(activity, false);
        }
        return true;
    }

    public boolean validateArguments() {
        return this._activityName != null && !"".equals(this._activityName);
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.MKACT, false) + "\t[ " + NameConfig.getOption(OptionName.SILENT, true) + " " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"description\" " + NameConfig.getOption(OptionName.NAME, true) + " displayname ] " + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName " + NameConfig.getOption(OptionName.WORKSPACE, true) + " WorkspacePath");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Creates an empty activity which can be used later", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name of the activity to be created", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace  path  to  specify  the  workspace under which the activity has to be created", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the workspace is not  specified an attempt will  be made to resolve the  workspace  from  the  current  working directory. If  it  is  not possible then it will be notified to the user", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SILENT, 1, "Will suppress the popup window for changing activity description and display name", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.COMMENTS, 1, "If in non UI mode this will be used to set the description of the activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.NAME, 1, "If in non UI mode this will be used to set the displayname of the activity", true);
        Command.getOut().println();
    }

    public CommandName getCommandName() {
        return CommandName.MKACT;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

