/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CommandlineProperties {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$CommandlineProperties == null ? (class$com$tssap$dtr$client$commandline$CommandlineProperties = CommandlineProperties.class$("com.tssap.dtr.client.commandline.CommandlineProperties")) : class$com$tssap$dtr$client$commandline$CommandlineProperties));
    private static final String DEFAULT_PROP_FILENAME = "commandline.properties";
    protected static Properties _properties = null;
    private static boolean _propertiesFileLoaded;
    private static boolean _propertiesFileValid;
    private static File _propFile;
    private static String _propFilePath;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$CommandlineProperties;

    private static void loadPropertiesFile() {
        if (_propertiesFileLoaded || !_propertiesFileValid) {
            return;
        }
        _properties = new Properties();
        FileInputStream propStream = null;
        try {
            propStream = new FileInputStream(_propFile);
        }
        catch (FileNotFoundException e) {
            Logger.traceSystemError(LOCATION, e, "Properties file " + _propFile.getAbsolutePath() + " not found.");
            _properties = null;
            _propertiesFileValid = false;
            DTRClient.getOut().println("Could not load commandline properties file. " + e.getMessage());
        }
        try {
            _properties.load(propStream);
            _propertiesFileLoaded = true;
        }
        catch (IOException e) {
            Logger.traceSystemError(LOCATION, e, "IOException during reading properties file " + _propFile.getAbsolutePath());
            _properties = null;
            _propertiesFileValid = false;
            DTRClient.getOut().println("Could not load commandline properties file. " + e.getMessage());
        }
    }

    static Properties getProperties() {
        CommandlineProperties.loadPropertiesFile();
        return _properties;
    }

    static String getProperty(String propertyName, String defVal) {
        CommandlineProperties.loadPropertiesFile();
        if (_properties == null) {
            return defVal;
        }
        return _properties.getProperty(propertyName, defVal);
    }

    static int getIntProperty(String propertyName, int defVal) {
        CommandlineProperties.loadPropertiesFile();
        if (_properties == null) {
            return defVal;
        }
        String propVal = _properties.getProperty(propertyName, String.valueOf(defVal));
        int val = -1;
        try {
            val = Integer.parseInt(propVal);
        }
        catch (NumberFormatException e) {
            Logger.traceUserError(LOCATION, e, "NumberFormatException occured. Property " + propertyName + " is supposed to be a integer.");
            val = defVal;
        }
        return val;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _propFilePath = System.getProperty(DEFAULT_PROP_FILENAME, DEFAULT_PROP_FILENAME);
        _propFile = new File(_propFilePath);
        _propertiesFileValid = false;
        if (_propFile.exists()) {
            _propertiesFileValid = true;
        }
    }
}

