/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Cache;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FileNameFilterImpl;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.ICommandFactory;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;

abstract class Command
implements ICommand,
ICommandFactory,
Comparable {
    protected boolean _expertMode = false;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$Command == null ? (class$com$tssap$dtr$client$commandline$Command = Command.class$("com.tssap.dtr.client.commandline.Command")) : class$com$tssap$dtr$client$commandline$Command));
    private final ArrayList _currentArguments;
    String _activityName;
    int _activityISN = -1;
    private IVersionedFileSystemManager _fileSystemManager;
    protected String _clientName = "";
    private IVfsContext _activeContext;
    private IConfiguration _configuration;
    boolean _useCurrentActivity;
    boolean _displayNameSpecified;
    boolean _unformattedOutput;
    String[] _activityNames = new String[0];
    String[] _activityISNs = new String[0];
    String[] _workspacePaths = new String[]{""};
    int _exitCode = 0;
    Set _optionsSupported = new TreeSet();
    static int CONSOLEWIDTH = -1;
    static int INDENTLENGTH = -1;
    static String SEPARATORCHAR = "-";
    private static final int DEFAULT_CONSOLE_WIDTH = 79;
    private static final int MIN_CONSOLE_WIDTH = 60;
    private static final int DEFAULT_INDENT_LENGTH = 4;
    private static final int MIN_INDENT_LENGTH = 2;
    private static final String DEFAULT_SEPARATOR_STRING = "\t";
    private static final String HTTP_DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final String DEFAULT_DATE_FORMAT_KEY = "com.tssap.dtr.client.commandline.outputdateformat";
    protected String _currentDatePattern;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$Command;

    Command(ArrayList arguments) {
        this._currentArguments = arguments;
        this.addSupportedOption(OptionName.ACTIVITY);
        this.addSupportedOption(OptionName.ISN);
        this.addSupportedOption(OptionName.DISPLAY_NAME);
        this.addSupportedOption(OptionName.CLIENTDEF);
        this.addSupportedOption(OptionName.CURR_ACT);
        this.addSupportedOption(OptionName.EXPERT);
    }

    protected void addSupportedOption(OptionName option) {
        if (!this._optionsSupported.contains(option)) {
            this._optionsSupported.add(option);
        }
    }

    protected void removeSupportedOption(OptionName option) {
        if (this._optionsSupported.contains(option)) {
            this._optionsSupported.remove(option);
        }
    }

    static PrintStream getOut() {
        return DTRClient.getOut();
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        ArrayList<String> actNames = new ArrayList<String>();
        ArrayList<String> actISNs = new ArrayList<String>();
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs--;
            String currArg = (String)arguments.get(i);
            String epShort = NameConfig.getOption(OptionName.EXPERT, true);
            String epLong = NameConfig.getOption(OptionName.EXPERT, false);
            String aShort = NameConfig.getOption(OptionName.ACTIVITY, true);
            String aLong = NameConfig.getOption(OptionName.ACTIVITY, false);
            String iShort = NameConfig.getOption(OptionName.ISN, true);
            String iLong = NameConfig.getOption(OptionName.ISN, false);
            String dnShort = NameConfig.getOption(OptionName.DISPLAY_NAME, true);
            String dnLong = NameConfig.getOption(OptionName.DISPLAY_NAME, false);
            String def = NameConfig.getOption(OptionName.CLIENTDEF, false);
            String currAct = NameConfig.getOption(OptionName.CURR_ACT, false);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                if (lowerCaseArg.startsWith(aShort) || lowerCaseArg.startsWith(aLong)) {
                    String actName = Command.getActualArgument(currArg, aShort, aLong);
                    if ("".equals(actName) && i + 1 < arguments.size()) {
                        actName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._activityName = actName;
                    actNames.add(actName);
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (iShort.equals(lowerCaseArg) || iLong.equals(lowerCaseArg)) {
                    String actISN = "";
                    if ("".equals(actISN) && i + 1 < arguments.size()) {
                        actISN = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    try {
                        this._activityISN = Integer.parseInt(actISN);
                        if (this._activityISN < 0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while parsing activity ISN " + actISN);
                        Command.getOut().println("The ISN specified is incorrect");
                        break;
                    }
                    actISNs.add(actISN);
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currAct.equals(lowerCaseArg)) {
                    this._useCurrentActivity = true;
                    arguments.remove(i);
                } else if (epShort.equals(lowerCaseArg) || epLong.equals(lowerCaseArg)) {
                    this._expertMode = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(dnShort) || lowerCaseArg.startsWith(dnLong)) {
                    this._displayNameSpecified = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (lowerCaseArg.startsWith(def)) {
                    String defName = Command.getActualArgument(currArg, def, def);
                    if ("".equals(defName) && i + 1 < arguments.size()) {
                        defName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._clientName = defName;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (actNames.size() > 0) {
            this._activityNames = null;
            this._activityNames = new String[actNames.size()];
            actNames.toArray(this._activityNames);
        }
        if (actISNs.size() > 0) {
            this._activityISNs = null;
            this._activityISNs = new String[actISNs.size()];
            actISNs.toArray(this._activityISNs);
        }
        if ("".equals(this._clientName)) {
            if (Utilities.isInShell()) {
                this._clientName = this.getActiveContext().getClientName();
            } else {
                IClient actCli = this.getCacheConfiguration().getActiveClient();
                if (actCli != null) {
                    this._clientName = actCli.getName();
                }
            }
        }
    }

    IVersionedFileSystemManager getFileSystemManager() {
        if (this._fileSystemManager == null) {
            try {
                this._fileSystemManager = Cache.getCache(this._clientName).getFileSystemManager();
            }
            catch (IllegalStateException exp) {
                Logger.traceUserError(LOCATION, exp, "Getting file system manager failed.");
                Command.getOut().println(exp.getMessage());
            }
        }
        if (this._fileSystemManager == null) {
            this._exitCode = 3;
        }
        return this._fileSystemManager;
    }

    IVfsContext getActiveContext() {
        if (this._activeContext == null) {
            this._activeContext = Cache.getCache(this._clientName).getContext();
        }
        return this._activeContext;
    }

    IVfsFolderItem getResource(String path) {
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        IVfsFolderItem folderItem = null;
        if (fileSystemManager != null) {
            if (path.startsWith("//")) {
                try {
                    folderItem = fileSystemManager.getFolderItemByBrowsePath(path.substring(1));
                    if (folderItem == null) {
                        folderItem = Utilities.getLocalMountedFolderItemForBrowsePath(path.substring(1));
                    }
                }
                catch (VfsException exp) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting folder item for path " + path);
                    Command.getOut().println(exp.getMessage());
                }
            } else {
                IVfsRemoteLocator remoteLocator;
                String absolutePath = Command.getAbsolutePath(path);
                if (new File(absolutePath).exists()) {
                    try {
                        folderItem = fileSystemManager.getFolderItem(absolutePath);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting folder item for path " + absolutePath);
                        folderItem = null;
                    }
                }
                if (folderItem == null && (remoteLocator = this.getActiveContext().getRemoteLocator(absolutePath)) != null && this.getActiveContext().getBrowsePath(remoteLocator) != null) {
                    try {
                        folderItem = fileSystemManager.getFolderItemByBrowsePath(this.getActiveContext().getBrowsePath(remoteLocator));
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting folder item for path " + this.getActiveContext().getBrowsePath(remoteLocator));
                        folderItem = null;
                    }
                }
                if (folderItem == null) {
                    String currDir;
                    String tempPath = path;
                    if (tempPath.startsWith("/")) {
                        tempPath = tempPath.substring(1);
                    }
                    if ((currDir = Utilities.getCurrentDirectory().substring(1)).endsWith("/")) {
                        currDir = currDir.substring(0, currDir.length() - 1);
                    }
                    try {
                        folderItem = fileSystemManager.getFolderItemByBrowsePath(currDir + "/" + tempPath);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting folder item for path " + currDir + "/" + tempPath);
                        Command.getOut().println(e.getMessage());
                    }
                }
            }
            if (folderItem == null) {
                this._exitCode = 5;
            }
        } else {
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
        }
        return folderItem;
    }

    public boolean checkForExtraArgumnets() {
        boolean foundExtraArgument = false;
        if (this._currentArguments.size() > 0) {
            foundExtraArgument = true;
        }
        if (!foundExtraArgument) {
            return true;
        }
        Command.getOut().println("Following extra or incorrect arguments found");
        int i = 0;
        while (i < this._currentArguments.size()) {
            if (this._currentArguments.get(i) != null) {
                Command.getOut().println((String)this._currentArguments.get(i));
            }
            ++i;
        }
        Command.getOut().println();
        Command.getOut().println("Please check and retry");
        return false;
    }

    static String getActualArgument(String completeArgument, String argumentPrefixShort, String argumentPrefixLong) {
        String lowerCaseArg = completeArgument.toLowerCase();
        if (lowerCaseArg.indexOf(argumentPrefixLong) == 0) {
            return completeArgument.substring(argumentPrefixLong.length());
        }
        return completeArgument.substring(argumentPrefixShort.length());
    }

    static String getAbsolutePath(String path) {
        String absolutePath;
        String currDir = Utilities.getCurrentLocalPath();
        if (path.equalsIgnoreCase("*")) {
            absolutePath = currDir;
        } else {
            File file = new File(path);
            absolutePath = file.getAbsolutePath();
        }
        return absolutePath;
    }

    void printField(int fieldLength, String field) {
        if (this._unformattedOutput) {
            field = field + Command.getSeparatorString();
            fieldLength = field.length();
        }
        if (field.length() > fieldLength) {
            field = field.substring(0, fieldLength - 2);
            field = field + "..";
        }
        Command.getOut().print(field);
        Command.printSpaces(fieldLength - field.length());
    }

    private static void printSpaces(int numberOfSpaces) {
        char[] spaces = new char[numberOfSpaces];
        Arrays.fill(spaces, ' ');
        Command.getOut().print(spaces);
    }

    void displayHeader(ArrayList displayFiledsOrdered) {
        int j = 0;
        while (j < displayFiledsOrdered.size()) {
            Field field = (Field)displayFiledsOrdered.get(j);
            this.printField(field.length, field.fieldName);
            ++j;
        }
        Command.getOut().println();
    }

    IConfiguration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = Cache.getCache(this._clientName).getConfiguration();
        }
        return this._configuration;
    }

    IConfiguration getCacheConfiguration() {
        return Cache.getCache().getConfiguration();
    }

    String[] getResourcePathsUsingFilter(String curDir, String filterStr, boolean local, boolean remote) {
        IVfsFolderItem folderItem;
        IVersionedFileSystemManager manager = this.getFileSystemManager();
        if (manager == null) {
            return new String[0];
        }
        curDir = curDir.substring(1);
        try {
            folderItem = manager.getFolderItemByBrowsePath(curDir);
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting folder item " + curDir);
            Command.getOut().println(exp.getMessage());
            return new String[0];
        }
        FileNameFilterImpl filter = new FileNameFilterImpl(filterStr);
        if (folderItem == null) {
            try {
                folderItem = Utilities.getLocalMountedFolderItemForBrowsePath(curDir);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting folder item " + curDir);
                Command.getOut().println(e.getMessage());
                return new String[0];
            }
        }
        if (folderItem != null) {
            IVfsFolderItem[] folderItems;
            try {
                folderItems = folderItem.asGenericFolder().getFolderItems();
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting children of folder item " + curDir);
                folderItems = new IVfsFolderItem[]{};
            }
            ArrayList<String> arrNames = new ArrayList<String>();
            int i = 0;
            while (i < folderItems.length) {
                block19: {
                    String fiBrowsePath = null;
                    try {
                        fiBrowsePath = folderItems[i].getBrowsePath();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting browse path of one of the returned children of folder item " + curDir + ". Continuing to the next item");
                        break block19;
                    }
                    if (fiBrowsePath != null && filter.accept(null, folderItems[i].getName())) {
                        if (local && remote) {
                            arrNames.add("/" + fiBrowsePath);
                        } else if (local) {
                            File newFile;
                            String localPath = folderItems[i].getLocalPath();
                            if (localPath != null && (newFile = new File(localPath)).exists()) {
                                arrNames.add("/" + fiBrowsePath);
                            }
                        } else if (remote && folderItems[i].getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                            arrNames.add("/" + fiBrowsePath);
                        }
                    }
                }
                ++i;
            }
            return arrNames.toArray(new String[arrNames.size()]);
        }
        return new String[0];
    }

    String getRemotePathFromBrowsePath(String browsePath) {
        IVfsFolderItem folderItem = null;
        try {
            folderItem = this.getFileSystemManager().getFolderItemByBrowsePath(browsePath);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting remote path for folder " + browsePath);
        }
        if (folderItem == null) {
            return "";
        }
        String remotePath = folderItem.getAbsoluteRemotePath();
        return remotePath;
    }

    static void refresh(String clDef) {
        Cache.getCache().refresh(clDef);
    }

    static String getTempFileForVer(IVfsVersion version) {
        File tempFile;
        try {
            tempFile = File.createTempFile("tmp", version.getDisplayName() + "_Rev" + version.getBranchSequenceNumber() + ".tmp");
            tempFile.deleteOnExit();
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while creating temp file for version " + version.getDisplayName());
            Command.getOut().println("Could not create temp file for version " + version.getDisplayName() + ". " + exp.getMessage());
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(tempFile);
            version.getContent((OutputStream)fos);
            fos.close();
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while creating temp file for version " + version.getDisplayName());
            Command.getOut().println("Could not create temp file for version " + version.getDisplayName() + ". " + exp.getMessage());
            return null;
        }
        return tempFile.getAbsolutePath();
    }

    private IVfsActivity getActivityByDisplayName(IVfsWorkspace workspace, boolean closed, boolean open) {
        IVfsActivity activity;
        IVfsActivity[] activities = null;
        if (open && closed) {
            try {
                activities = workspace.getOpenActivities(this._activityName);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException while getting open actvity " + this._activityName + " for workspace " + workspace.getName());
            }
        } else if (!closed && open) {
            try {
                activities = workspace.getOpenActivities(this._activityName);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException while getting open actvity " + this._activityName + " for workspace " + workspace.getName());
            }
        }
        if (activities == null) {
            activities = new IVfsActivity[]{};
        }
        if (activities.length == 0) {
            activities = Command.getEmptyActivitiesByName(workspace.getRepository(), this._activityName, true);
        } else {
            ArrayList<IVfsActivity> actList = new ArrayList<IVfsActivity>();
            actList.addAll(Arrays.asList(activities));
            actList.addAll(Arrays.asList(Command.getEmptyActivitiesByName(workspace.getRepository(), this._activityName, true)));
            activities = actList.toArray(new IVfsActivity[actList.size()]);
        }
        if (activities.length == 1) {
            activity = activities[0];
        } else if (activities.length == 0) {
            activity = null;
        } else {
            activity = this.getUserSelectedActivity(activities, this.getOutputDatePattern());
            if (activity == null) {
                Command.getOut().println("The operation has been canceled by you.");
                return null;
            }
        }
        return activity;
    }

    static IVfsActivity[] getEmptyActivitiesByName(IVfsRepository iVfsRepository, String activityName, boolean isDisplayName) {
        IVfsActivity[] activities = null;
        try {
            activities = iVfsRepository.getEmptyActivities();
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting empty activities for repository " + iVfsRepository.getUrl());
        }
        if (activities == null) {
            return new IVfsActivity[0];
        }
        ArrayList<IVfsActivity> actsList = new ArrayList<IVfsActivity>();
        int i = 0;
        while (i < activities.length) {
            if (isDisplayName) {
                try {
                    if (activities[i].getDisplayName().equals(activityName)) {
                        actsList.add(activities[i]);
                    }
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting display name of activity " + activities[i].getUrl());
                }
            } else if (activities[i].getName().equals(activityName)) {
                actsList.add(activities[i]);
                break;
            }
            ++i;
        }
        if (actsList.size() > 0) {
            IVfsActivity[] actsArr = new IVfsActivity[actsList.size()];
            actsArr = actsList.toArray(actsArr);
            return actsArr;
        }
        return new IVfsActivity[0];
    }

    IVfsActivity getUserSelectedActivity(IVfsActivity[] activities, String outputDatePattern) {
        Command.getOut().println("More than one activity exists.");
        Command.getOut().println("Please select one of the options and input the number corresponding to the option");
        Command.getOut().println();
        Command.getOut().println("Option : 0");
        Command.getOut().println("Cancel");
        int i = 0;
        while (i < activities.length) {
            block26: {
                Command.getOut().println();
                Command.getOut().println("Option : " + String.valueOf(i + 1));
                Command.getOut().println("Actual Name : " + activities[i].getName());
                String description = null;
                try {
                    description = activities[i].getDescription();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during retrieving description.");
                    description = "<getting description failed>";
                }
                if (description == null) {
                    description = "<no description specified>";
                }
                Command.getOut().println("Description : " + description);
                String author = null;
                try {
                    author = activities[i].getAuthor();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during retrieving author.");
                    description = "<getting author failed>";
                }
                Command.getOut().println("Author\t\t: " + author);
                try {
                    boolean isOpen = activities[i].isOpen();
                    if (!isOpen) {
                        Date cInD = null;
                        try {
                            cInD = activities[i].getCheckedInDate();
                        }
                        catch (VfsException exp) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving checkin date.");
                            cInD = null;
                        }
                        if (cInD != null) {
                            Command.getOut().println("Checked In Date : " + Command.getFormattedDate(cInD, outputDatePattern));
                        } else {
                            Command.getOut().println("Checked In Date : <getting Checked In Date failed>");
                        }
                        break block26;
                    }
                    Date cD = null;
                    try {
                        cD = activities[i].getCreationDate();
                    }
                    catch (VfsException exp) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred during retrieving creation date.");
                        cD = null;
                    }
                    if (cD != null) {
                        Command.getOut().println("Created On      : " + Command.getFormattedDate(cD, outputDatePattern));
                    } else {
                        Command.getOut().println("Created On      : <getting Created On Date failed>");
                    }
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred during retrieving author.");
                    description = "<getting author failed>";
                }
            }
            Command.getOut().println();
            ++i;
        }
        Command.getOut().println();
        Command.getOut().print("Select Option : ");
        InputStreamReader isr = new InputStreamReader(DTRClient.getIn());
        BufferedReader br = new BufferedReader(isr);
        int option = 0;
        int tries = 0;
        block15: while (true) {
            try {
                while (true) {
                    boolean illegal = false;
                    String input = br.readLine();
                    if (input == null) {
                        option = 0;
                        break block15;
                    }
                    try {
                        option = Integer.parseInt(input);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while parsing option " + input);
                        illegal = true;
                    }
                    if (option > activities.length || option < 0) {
                        illegal = true;
                    }
                    if (!illegal) break block15;
                    if (++tries >= 3) break;
                    Command.getOut().println("Illegal Number Entered.Please enter again.");
                    Command.getOut().println("Select Option : ");
                }
                option = 0;
                Command.getOut().println("Cancelling operation.");
            }
            catch (IOException exp) {
                Logger.traceSystemError(LOCATION, exp, "IOException occurred while getting user input for selecting activity.");
                Command.getOut().println(">" + exp.getMessage());
                Command.getOut().println(">IOException Occured");
                continue;
            }
            break;
        }
        if (option == 0) {
            return null;
        }
        return activities[option - 1];
    }

    IVfsActivity getOrCreateActivity(IVfsWorkspace workspace) throws VfsException {
        IVfsActivity activity = null;
        if (this._activityName == null) {
            if (this._useCurrentActivity && (activity = workspace.getCurrentActivity()) == null) {
                Command.getOut().println("Current activity not set. Using default activity.");
            }
            if (activity == null) {
                activity = workspace.getDefaultActivity();
            }
        } else {
            IVfsActivity[] activities;
            activity = this._displayNameSpecified ? this.getActivityByDisplayName(workspace, false, true) : workspace.getActivityByName(this._activityName);
            if (activity == null && (activities = Command.getEmptyActivitiesByName(workspace.getRepository(), this._activityName, false)) != null && activities.length > 0) {
                activity = activities[0];
            }
            if (activity == null) {
                activity = workspace.createActivity(this._activityName);
            }
        }
        return activity;
    }

    static String formatHelpText(String commandname, String description) {
        String BLANK = "                  ";
        while (commandname.length() > BLANK.length()) {
            BLANK = BLANK + "         ";
        }
        return commandname + BLANK.substring(commandname.length()) + description;
    }

    public String getHelpText() {
        String alias = this.getAlias();
        return Command.formatHelpText(this.getName() + (alias != null && !alias.equals("") ? "/" + alias : ""), this.getDescription());
    }

    public String getAlias() {
        return NameConfig.getCommandName(this.getCommandName(), true);
    }

    public String getName() {
        return NameConfig.getCommandName(this.getCommandName(), false);
    }

    public CommandName getCommandName() {
        return null;
    }

    public int compareTo(Object o) {
        if (o instanceof Command) {
            o = ((Command)o).getName();
        }
        return this.getName().compareTo(o);
    }

    IVfsActivity getActivity(boolean closed, boolean open) {
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        if (fileSystemManager == null) {
            this._exitCode = 3;
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
            return null;
        }
        IVfsActivity activity = null;
        if (this._workspacePaths == null) {
            this._workspacePaths = new String[]{""};
        }
        if (this._displayNameSpecified && this._activityName != null) {
            IVfsWorkspace workspace;
            if ("".equals(this._workspacePaths[0])) {
                this._workspacePaths[0] = Utilities.getCurrentDirectory();
            }
            if ((workspace = this.getWorkspace()) == null) {
                this._exitCode = 30;
                return null;
            }
            activity = this.getActivityByDisplayName(workspace, closed, open);
        } else if (this._activityName != null) {
            try {
                IVfsActivity[] acts;
                IVfsWorkspace workspace;
                activity = fileSystemManager.getActivityByName(this._activityName);
                if (activity == null && open && (workspace = this.getWorkspace()) != null && (acts = Command.getEmptyActivitiesByName(workspace.getRepository(), this._activityName, false)) != null && acts.length == 1) {
                    activity = acts[0];
                }
                if (activity != null && closed && !open && activity.isOpen()) {
                    this._exitCode = 86;
                    Command.getOut().println("The specified activity is not a closed activity.");
                    return null;
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting activity with name " + this._activityName);
                Command.getOut().println(exp.getMessage());
                activity = null;
            }
        } else if (open) {
            IVfsWorkspace workspace = this.getWorkspace();
            if (workspace == null) {
                this._exitCode = 30;
                return null;
            }
            if (this._useCurrentActivity && (activity = workspace.getCurrentActivity()) == null) {
                Command.getOut().println("Current activity not set. Using default activity.");
            }
            try {
                if (activity == null && workspace.doesDefaultActivityExist()) {
                    activity = workspace.getDefaultActivity();
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting the default activity of the workspace.");
                Command.getOut().println(exp.getMessage());
                this._exitCode = 32;
                return null;
            }
        }
        if (activity == null) {
            this._exitCode = 32;
            Command.getOut().println("The specified activity does not exist. Please check and try again.");
        }
        return activity;
    }

    String getCorrectWSPath(String wsPath) {
        if (!"".equals(wsPath)) {
            return wsPath;
        }
        this.getFileSystemManager();
        return Utilities.getCurrentDirectory();
    }

    IVfsWorkspace getWorkspace() {
        IVfsFolderItem folderItem = this.getResource(this.getCorrectWSPath(this._workspacePaths[0]));
        IVfsWorkspace workspace = null;
        if (folderItem != null) {
            workspace = folderItem.asWorkspace();
        }
        if (workspace == null && folderItem != null && folderItem.asActivityRecordedFolderItem() != null) {
            workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
        }
        if (workspace == null) {
            Command.getOut().println("The workspace cannot be resolved correctly. Please provide the correct workspace.");
            return null;
        }
        return workspace;
    }

    public boolean isHidden() {
        return false;
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public Set getSupportedOptions() {
        return this._optionsSupported;
    }

    protected void printOptionHelp(OptionName option, int indents, String helpText, boolean printOption) {
        Command.getConsoleWidth();
        Command.getIndentLength();
        String remainingText = helpText;
        int optionLength = 0;
        if (option != null) {
            String optionText = "";
            if (!NameConfig.getOption(option, true).equals("")) {
                optionText = optionText + NameConfig.getOption(option, true) + " / ";
            }
            optionText = optionText + NameConfig.getOption(option, false);
            optionLength = optionText.length();
            if ((optionLength = (optionLength / 5 + (optionLength % 5 == 0 ? 0 : 1)) * 5) < 15) {
                optionLength = 15;
            } else if (optionLength > 35) {
                optionLength = 35;
                if (printOption) {
                    optionText = optionText.substring(0, optionLength - 2);
                    optionText = optionText + "..";
                }
            }
            if (printOption) {
                remainingText = this.printFirstLineOfOptionHelp(indents * INDENTLENGTH, optionText, optionLength, helpText, true);
            }
        }
        int lineLength = CONSOLEWIDTH - (indents * INDENTLENGTH + optionLength + (optionLength == 0 ? 0 : 2));
        String[] remainingTextLines = this.getMulLinesForText(remainingText, lineLength);
        int i = 0;
        while (i < remainingTextLines.length) {
            this.printLineOfOptionHelp(remainingTextLines[i], lineLength, remainingTextLines.length == i + 1);
            ++i;
        }
    }

    protected static int getIndentLength() {
        if (INDENTLENGTH == -1 && (INDENTLENGTH = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.indentlength", 4)) < 2) {
            INDENTLENGTH = 2;
        }
        return INDENTLENGTH;
    }

    protected static int getConsoleWidth() {
        if (CONSOLEWIDTH == -1 && (CONSOLEWIDTH = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.consolewidth", 79)) < 60) {
            CONSOLEWIDTH = 60;
        }
        return CONSOLEWIDTH;
    }

    protected static String getSeparatorString() {
        if (SEPARATORCHAR.equals("-")) {
            SEPARATORCHAR = CommandlineProperties.getProperty("com.tssap.dtr.client.commandline.separatorchar", DEFAULT_SEPARATOR_STRING);
        }
        return SEPARATORCHAR;
    }

    protected void printOptionHelpEx(OptionName option, int indents, String option2, String helpText, boolean printOption2) {
        Command.getConsoleWidth();
        Command.getIndentLength();
        String remainingText = helpText;
        int optionLength = 0;
        if (option != null) {
            String optionText = "";
            if (!NameConfig.getOption(option, true).equals("")) {
                optionText = optionText + NameConfig.getOption(option, true) + " / ";
            }
            optionText = optionText + NameConfig.getOption(option, false);
            optionLength = optionText.length();
            if ((optionLength = (optionLength / 5 + (optionLength % 5 == 0 ? 0 : 1)) * 5) < 15) {
                optionLength = 15;
            } else if (optionLength > 35) {
                optionLength = 35;
            }
        }
        int option2Length = 0;
        if (!option2.equals("")) {
            option2Length = option2.length();
            if ((option2Length = (option2Length / 5 + (option2Length % 5 == 0 ? 0 : 1)) * 5) < 20) {
                option2Length = 20;
            } else if (option2Length > 25) {
                option2Length = 25;
            }
        }
        int noOfSpaces = indents * INDENTLENGTH + optionLength + (optionLength == 0 ? 0 : 2);
        if (printOption2) {
            remainingText = this.printFirstLineOfOptionHelp(noOfSpaces, option2, option2Length, helpText, false);
        }
        int lineLength = CONSOLEWIDTH - (noOfSpaces + option2Length);
        String[] remainingTextLines = this.getMulLinesForText(remainingText, lineLength);
        int i = 0;
        while (i < remainingTextLines.length) {
            this.printLineOfOptionHelp(remainingTextLines[i], lineLength, remainingTextLines.length == i + 1);
            ++i;
        }
    }

    private void printLineOfOptionHelp(String helpText, int lineLength, boolean isLastLine) {
        if (!isLastLine) {
            helpText = this.getFormattedStringForLength(helpText, lineLength);
        }
        Command.printSpaces(CONSOLEWIDTH - lineLength);
        Command.getOut().println(helpText);
    }

    private String[] getMulLinesForText(String helpText, int lengthPerLine) {
        ArrayList<String> strs = new ArrayList<String>();
        while (!helpText.equals("")) {
            String[] retVal = this.getLineAndRemainingText(helpText, lengthPerLine);
            strs.add(retVal[0]);
            helpText = retVal[1];
        }
        String[] retVals = new String[strs.size()];
        retVals = strs.toArray(retVals);
        return retVals;
    }

    private String printFirstLineOfOptionHelp(int noOfStartingSpaces, String optionText, int optionLength, String helpText, boolean printColon) {
        int firstLineHelpLength = CONSOLEWIDTH - (noOfStartingSpaces + optionLength + (printColon ? 2 : 0));
        String[] retVal = this.getLineAndRemainingText(helpText, firstLineHelpLength);
        helpText = retVal[0];
        String retString = retVal[1];
        Command.printSpaces(noOfStartingSpaces);
        this.printField(optionLength, optionText);
        if (printColon) {
            Command.getOut().print(": ");
        }
        if (!retString.equals("")) {
            helpText = this.getFormattedStringForLength(helpText, firstLineHelpLength);
        }
        Command.getOut().println(helpText);
        return retString;
    }

    private String[] getLineAndRemainingText(String helpText, int lineLength) {
        String[] retVal = new String[2];
        if (lineLength < helpText.length()) {
            if (helpText.charAt(lineLength) == ' ') {
                retVal[0] = helpText.substring(0, lineLength);
                retVal[1] = helpText.substring(lineLength + 1);
            } else {
                int index = helpText.lastIndexOf(" ", lineLength);
                if (index == -1) {
                    retVal[0] = helpText;
                    retVal[1] = "";
                } else {
                    retVal[0] = helpText.substring(0, index);
                    retVal[1] = helpText.substring(index + 1);
                }
            }
        } else {
            retVal[0] = helpText;
            retVal[1] = "";
        }
        return retVal;
    }

    private String getFormattedStringForLength(String helpText, int helpLength) {
        if ((helpText = helpText.trim()).length() == helpLength) {
            return helpText;
        }
        int noOfSpacesToAdd = helpLength - helpText.length();
        int spacesPresent = this.getNoOfSpacesPresent(helpText);
        if (spacesPresent == 0) {
            return helpText;
        }
        int extraSpaces = noOfSpacesToAdd % spacesPresent;
        int spacePerSpace = noOfSpacesToAdd / spacesPresent;
        char[] oldString = helpText.toCharArray();
        char[] newString = new char[oldString.length + noOfSpacesToAdd];
        int index = 0;
        int i = 0;
        while (i < oldString.length) {
            newString[index] = oldString[i];
            ++index;
            if (oldString[i] == ' ') {
                while (oldString[i + 1] == ' ') {
                    newString[index] = oldString[++i];
                    ++index;
                }
                int j = 0;
                while (j < spacePerSpace) {
                    newString[index] = 32;
                    ++index;
                    ++j;
                }
                if (extraSpaces != 0) {
                    newString[index] = 32;
                    ++index;
                    --extraSpaces;
                }
            }
            ++i;
        }
        return String.valueOf(newString);
    }

    private int getNoOfSpacesPresent(String helpText) {
        helpText = helpText.trim();
        int c = 32;
        int counter = 0;
        while (helpText.indexOf(c) != -1) {
            ++counter;
            helpText = helpText.substring(helpText.indexOf(c) + 1).trim();
        }
        return counter;
    }

    protected String getBrowsePath(IVfsRemoteLocator locator) {
        IVfsRemoteLocator[] rootLocators = this.getActiveContext().getBrowseRootRemoteLocators();
        int i = 0;
        while (i < rootLocators.length) {
            IVfsRemoteLocator rootLocator = rootLocators[i];
            if (rootLocator.getConnectionTemplateId() == locator.getConnectionTemplateId() && locator.getAbsoluteRemotePath().startsWith(rootLocator.getAbsoluteRemotePath())) {
                return locator.getAbsoluteRemotePath().substring(rootLocator.getAbsoluteRemotePath().length() - 1);
            }
            ++i;
        }
        return null;
    }

    protected String getOutputDatePattern() {
        if (this._currentDatePattern == null) {
            this._currentDatePattern = CommandlineProperties.getProperty(DEFAULT_DATE_FORMAT_KEY, HTTP_DATE_FORMAT);
            if (this._currentDatePattern.trim().length() == 0) {
                this._currentDatePattern = HTTP_DATE_FORMAT;
            }
            if (!Command.validateDateFormat(this._currentDatePattern, true)) {
                System.err.println(" Switching date pattern to 'EEE MMM dd HH:mm:ss zzz yyyy'.");
                this._currentDatePattern = HTTP_DATE_FORMAT;
            }
        }
        return this._currentDatePattern;
    }

    public static boolean validateDateFormat(String datePattern) {
        return Command.validateDateFormat(datePattern, false);
    }

    private static boolean validateDateFormat(String datePattern, boolean printWarning) {
        boolean validateDateFormat = true;
        try {
            DisplayHelper.DateFormatter.getFormattedDate(new Date(), datePattern);
        }
        catch (IllegalArgumentException ex) {
            Logger.traceUserError(LOCATION, ex, "IllegalArgumentException occurred while getting the formatted date for pattern " + datePattern);
            if (printWarning) {
                System.err.print("WARNING: " + ex.getMessage() + " in date pattern '" + datePattern + "'.");
            }
            validateDateFormat = false;
        }
        return validateDateFormat;
    }

    public static String getFormattedDate(Date date, String dateFormatPattern) {
        return DisplayHelper.DateFormatter.getFormattedDate(date, dateFormatPattern);
    }

    public String getFormattedDate(Date date) {
        return Command.getFormattedDate(date, this.getOutputDatePattern());
    }

    static IVfsContext getContext(String clientName) {
        return com.tssap.dtr.client.lib.vfs.config.Configuration.getConfiguration().getClient(clientName).getContext();
    }

    static String getWebLocator(IVfsFolderItem folderItem) {
        return folderItem.getContext().getWebLocator(Command.getConnectionTemplateId(folderItem));
    }

    static String getWebLocator(String folderItemURL, String clientName) {
        return Command.getContext(clientName).getWebLocator(Command.getConnectionTemplateId(folderItemURL, clientName));
    }

    static int getConnectionTemplateId(IVfsFolderItem folderItem) {
        try {
            return folderItem.getContext().getRemoteLocatorFromUrl(folderItem.getUrl()).getConnectionTemplateId();
        }
        catch (Exception e) {
            Logger.traceInternalError(LOCATION, e, "Exception occurred while getting connection template ID for folder item " + folderItem.getName());
            throw new IllegalArgumentException("Getting connection template ID failed.");
        }
    }

    static int getConnectionTemplateId(String folderItemURL, String clientName) {
        try {
            return Command.getContext(clientName).getRemoteLocatorFromUrl(folderItemURL).getConnectionTemplateId();
        }
        catch (Exception e) {
            Logger.traceInternalError(LOCATION, e, "Exception occurred while getting connection template ID for folder item " + folderItemURL);
            throw new IllegalArgumentException("Getting connection template ID failed.");
        }
    }

    static IConnectionTemplate getConnectionTemplate(int connectionTemplateId) throws InvalidTemplateIDException {
        return Configuration.getTemplateProvider().getConnectionTemplate(connectionTemplateId);
    }

    public boolean requiresLogon() {
        return true;
    }

    public String getClientName() {
        return this._clientName;
    }

    protected String[] getResourcesForWildCardArgument(String Argument) {
        String filterStr;
        String curDir;
        int indexOfSeparator = Argument.lastIndexOf(File.separatorChar);
        if (-1 != indexOfSeparator) {
            String path = Argument.substring(0, indexOfSeparator);
            String tempCurDir = Utilities.getCurrentDirectory();
            curDir = Utilities.getCurrentDirectory();
            filterStr = !Utilities.setCurrentDirectory(curDir + path) ? (Utilities.setCurrentDirectory(path) ? Argument.substring(indexOfSeparator + 1) : Argument) : Argument.substring(indexOfSeparator + 1);
            curDir = Utilities.getCurrentDirectory();
            Utilities.setCurrentDirectory(tempCurDir);
        } else {
            this.getFileSystemManager();
            curDir = Utilities.getCurrentDirectory();
            filterStr = Argument;
        }
        String[] arrPaths = this.getResourcePathsUsingFilter(curDir, filterStr, true, true);
        return arrPaths;
    }

    public abstract void printHelpDescription();

    public abstract boolean validateArguments();

    public abstract boolean execute();

    public abstract String getDescription();

    public abstract ICommand createCommand(String var1, ArrayList var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

