/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.CloseCommand;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import java.util.ArrayList;

public class CloseWSCommand
extends CloseCommand {
    public CloseWSCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Closes the given workspace";
    }

    public boolean validateArguments() {
        boolean isValidateArguments = true;
        if (this._workspacePaths.length != 1 || this._workspacePaths[0].trim().length() == 0) {
            this.writeMessage("Must specify workspace path.");
            isValidateArguments = false;
        }
        if (this._description.trim().length() == 0) {
            this.writeMessage("Must specify a reason for closing the workspace.");
            isValidateArguments = false;
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.CLOSEWS, false) + " " + NameConfig.getOption(OptionName.WORKSPACE, true) + " \"workspace path\" " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"comments\"");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "closes the given workspace.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace path of the workspace that needs to be closed.", true);
        this.writeMessage("");
        this.printOptionHelp(OptionName.COMMENTS, 1, "A short note specifying why the action was performed.", true);
        this.writeMessage("");
    }

    public CommandName getCommandName() {
        return CommandName.CLOSEWS;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new CloseWSCommand(arguments);
    }

    protected void closeVersionSet(String url) throws PropagationException {
        this._propManager.closeWorkspace(this.removeLeadingSlash(url), this._description);
    }
}

