/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class CloseCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$CloseCommand == null ? (class$com$tssap$dtr$client$commandline$CloseCommand = CloseCommand.class$("com.tssap.dtr.client.commandline.CloseCommand")) : class$com$tssap$dtr$client$commandline$CloseCommand));
    protected String _propagationListName;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$CloseCommand;

    public CloseCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.PROPAGATION_LIST);
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        try {
            String resourceID = null;
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            if (this._propagationListName != null) {
                this._resourcePath = "/prop/" + this._propagationListName;
                resourceID = this.getResourceID();
            } else {
                IVfsFolderItem folderItem = this.getResource(this._workspacePaths[0]);
                if (folderItem == null) {
                    Command.getOut().println("Could not retrive folder item " + this._workspacePaths[0]);
                    return false;
                }
                IVfsWorkspace workspace = folderItem.asWorkspace();
                if (workspace == null) {
                    Command.getOut().println("Folder item " + this._workspacePaths[0] + " is not a workspace ");
                    return false;
                }
                try {
                    resourceID = workspace.getObjectID();
                }
                catch (VfsException ex) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "VfsException occured during retrieving workspaceID.");
                    this.writeMessage("Could not retrieve workspaceID. " + ex.getMessage());
                }
            }
            this.closeVersionSet("/nonvresbyid/" + resourceID);
            String url = this._propagationListName == null ? this._workspacePaths[0] : this._propagationListName;
            this.writeMessage("Closed \"" + url + "\"");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "PropagationPreconditionException occured during closing of workspace.");
            this.writeMessage("Could not close workspace. " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "PropagationException occured during closing of workspace.");
            this.writeMessage("Could not close workspace. " + ex.getMessage());
        }
        return retVal;
    }

    public void setArguments(ArrayList arguments) {
        if (arguments.size() == 0) {
            return;
        }
        String proplistShortOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, true);
        String proplistLongOptName = NameConfig.getOption(OptionName.PROPAGATION_LIST, false);
        Iterator listIterator = ((AbstractList)arguments).iterator();
        while (listIterator.hasNext()) {
            String currentArg = (String)listIterator.next();
            if (currentArg == null || proplistShortOptName.compareToIgnoreCase(currentArg) != 0 && proplistLongOptName.compareToIgnoreCase(currentArg) != 0) continue;
            listIterator.remove();
            this._propagationListName = (String)listIterator.next();
            listIterator.remove();
        }
        super.setArguments(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

