/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import java.util.ArrayList;
import java.util.Iterator;

class ClientDefsCommand
extends Command {
    public ICommand createCommand(String name, ArrayList arguments) {
        return new ClientDefsCommand(arguments);
    }

    ClientDefsCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "displays all available clients";
    }

    public boolean execute() {
        IVersionedFileSystemManager manager = this.getFileSystemManager();
        String currentClientName = "";
        if (manager != null) {
            currentClientName = manager.getCurrentContext().getClientName();
        }
        Iterator clients = this.getCacheConfiguration().clients();
        IClient activeClient = this.getConfiguration().getActiveClient();
        if (!clients.hasNext()) {
            return true;
        }
        Command.getOut().println();
        while (clients.hasNext()) {
            IClient client = (IClient)clients.next();
            ILogicalSystem system = client.getLogicalSystem();
            String systemName = system.getName();
            String addStr = "";
            if (client.equals(activeClient)) {
                addStr = addStr + " \"Active\"  ";
            }
            if (client.getName().equals(currentClientName)) {
                addStr = addStr + " \"Current\" ";
            }
            Command.getOut().println(client.getName() + "  " + addStr + " ; System : " + systemName);
        }
        Command.getOut().println();
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.CLIENTS, false));
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Lists the available client definitions which can be used as parameter to start the shell or as a parameter to refresh call in the shell", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, NameConfig.getCommandName(CommandName.REFRESH, false) + " <Client name>", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "For more information on the use of " + NameConfig.getCommandName(CommandName.REFRESH, false) + " command give", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " " + NameConfig.getCommandName(CommandName.REFRESH, false), false);
        Command.getOut().println();
    }

    public CommandName getCommandName() {
        return CommandName.CLIENTS;
    }

    public boolean requiresLogon() {
        return false;
    }
}

