/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.LoginParamsInput;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CheckInActivityCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$CheckInActivityCommand == null ? (class$com$tssap$dtr$client$commandline$CheckInActivityCommand = CheckInActivityCommand.class$("com.tssap.dtr.client.commandline.CheckInActivityCommand")) : class$com$tssap$dtr$client$commandline$CheckInActivityCommand));
    private String _userName;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$CheckInActivityCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new CheckInActivityCommand(arguments);
    }

    CheckInActivityCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this._allowMultipleWSPaths = false;
        this._userName = "";
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "checks in an activity";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() {
        IVfsActivity activity = this.getActivity(false, true);
        if (activity == null) {
            return false;
        }
        if (this._userName != "") {
            int connectionTemplateID = -1;
            IVfsRemoteLocator locator = this.getActiveContext().getRemoteLocatorFromUrl(activity.getUrl());
            if (locator != null) {
                connectionTemplateID = locator.getConnectionTemplateId();
            }
            if (connectionTemplateID == -1) {
                Command.getOut().println("Error occured while trying to get exsisting user. Connection for server could not be retreved");
                return false;
            }
            boolean problem = false;
            try {
                Iterator iter3;
                ISessionContext ctxIn2;
                IConnection connIn2;
                Throwable throwable2;
                Cookie jSessionCookie;
                String oldPwd;
                String oldUser;
                ISessionContext ctx;
                block23: {
                    IConnection conn = ConnectionPool.getInstance().acquireConnection(connectionTemplateID);
                    ctx = conn.getSessionContext();
                    oldUser = ctx.getUser();
                    oldPwd = ctx.getPassword();
                    String pwd = this.getPasswordForUser(this._userName);
                    if (pwd == null) {
                        return false;
                    }
                    List cookies = ctx.cookies().getCookies();
                    jSessionCookie = null;
                    Iterator iter2 = cookies.iterator();
                    while (iter2.hasNext()) {
                        Cookie element = (Cookie)iter2.next();
                        if (!element.getName().equals("JSESSIONID")) continue;
                        jSessionCookie = element;
                        break;
                    }
                    if (jSessionCookie != null) {
                        ctx.cookies().removeCookie(jSessionCookie);
                    } else {
                        ctx.closeSession();
                    }
                    try {
                        ctx.setUser(this._userName);
                        ctx.setPassword(pwd);
                        problem = true;
                        ConnectionPool.getInstance().releaseConnection(conn, false);
                        Command.getOut().println("Editing the activity....");
                        if (this._noUI) {
                            this.performNonUIEdit(activity, true);
                        } else {
                            this.performUIEdit(activity, true);
                        }
                        Object var15_18 = null;
                        if (oldUser == null) return true;
                        if (oldPwd == null) return true;
                    }
                    catch (Throwable throwable2) {
                        Object var15_19 = null;
                        if (oldUser == null) throw throwable2;
                        if (oldPwd == null) throw throwable2;
                        connIn2 = ConnectionPool.getInstance().acquireConnection(connectionTemplateID);
                        if (connIn2 == null) throw throwable2;
                        ctxIn2 = connIn2.getSessionContext();
                        cookies = ctx.cookies().getCookies();
                        jSessionCookie = null;
                        iter3 = cookies.iterator();
                        break block23;
                    }
                    IConnection connIn2 = ConnectionPool.getInstance().acquireConnection(connectionTemplateID);
                    if (connIn2 == null) return true;
                    ISessionContext ctxIn2 = connIn2.getSessionContext();
                    cookies = ctx.cookies().getCookies();
                    jSessionCookie = null;
                    Iterator iter3 = cookies.iterator();
                    while (iter3.hasNext()) {
                        Cookie element = (Cookie)iter3.next();
                        if (!element.getName().equals("JSESSIONID")) continue;
                        jSessionCookie = element;
                        break;
                    }
                    if (jSessionCookie != null) {
                        ctx.cookies().removeCookie(jSessionCookie);
                    } else {
                        ctx.closeSession();
                    }
                    ctxIn2.setUser(oldUser);
                    ctxIn2.setPassword(oldPwd);
                    ConnectionPool.getInstance().releaseConnection(connIn2, false);
                    return true;
                }
                while (iter3.hasNext()) {
                    Cookie element = (Cookie)iter3.next();
                    if (!element.getName().equals("JSESSIONID")) continue;
                    jSessionCookie = element;
                    break;
                }
                if (jSessionCookie != null) {
                    ctx.cookies().removeCookie(jSessionCookie);
                } else {
                    ctx.closeSession();
                }
                ctxIn2.setUser(oldUser);
                ctxIn2.setPassword(oldPwd);
                ConnectionPool.getInstance().releaseConnection(connIn2, false);
                problem = false;
                throw throwable2;
            }
            catch (Exception e) {
                Logger.traceInternalError(LOCATION, e, "Exception occured during checking in activity by other user. ");
                Command.getOut().println("Exception occured during checking in activity by other user. " + e.getMessage());
                if (!problem) return true;
                if (!Utilities.isInShell()) return true;
                Command.getOut().println("The shell will terminate now. Please press enter to terminate the shell...");
                InputStreamReader isr = new InputStreamReader(DTRClient.getIn());
                BufferedReader br = new BufferedReader(isr);
                try {
                    br.readLine();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                System.exit(36);
                return true;
            }
        }
        Command.getOut().println("Editing the activity....");
        if (this._noUI) {
            this.performNonUIEdit(activity, true);
            return true;
        }
        this.performUIEdit(activity, true);
        return true;
    }

    private String getPasswordForUser(String userName) {
        try {
            String[] input = new LoginParamsInput().getInput("Checkin Login", userName, false, false);
            if (input != null && input.length == 2) {
                return input[1];
            }
            return null;
        }
        catch (IOException e) {
            Logger.traceSystemError(LOCATION, e, "Could not get password due to IOException.");
            Command.getOut().println("Could not get password. " + e.getMessage());
            this._exitCode = 96;
            return null;
        }
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.CHECKIN, false) + "\t[ " + NameConfig.getOption(OptionName.SILENT, true) + " " + NameConfig.getOption(OptionName.COMMENTS, true) + " \"description\" " + NameConfig.getOption(OptionName.NAME, true) + " displayname " + NameConfig.getOption(OptionName.USER, true) + " username " + NameConfig.getOption(OptionName.WORKSPACE, true) + " WorkspacePath] " + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Check in an activity ", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name of the activity to be checked in", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SILENT, 1, "Will suppress the popup window for changing activity description and display name", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If this option is specified then the activity will be checked in w/o uploading the files to the server", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.COMMENTS, 1, "If in non UI mode this will be used to set the description of the activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.NAME, 1, "If in non UI mode this will be used to set the displayname of the activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Workspace path to specify the workspace under which the activity exists. To be given if activity name is not specified or the displayname of the activity is specified. Will  check in the default activity of the workspace if no name is given", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.USER, 1, "Username to be used in case the checkin is required to be done as another user. The user will be prompted for a password if this option is used. The old user will be restored after the checkin operation.", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the workspace is not specified an attempt will be made to resolve the workspace from the current working directory or the folderitem being worked on. If it is not possible then the user will be notified", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String lowerCaseArg = currArg.toLowerCase();
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            String uShort = NameConfig.getOption(OptionName.USER, true);
            String uLong = NameConfig.getOption(OptionName.USER, false);
            if (currArg != null) {
                if (fShort.equals(lowerCaseArg) || fLong.equals(lowerCaseArg)) {
                    this._forceCheckin = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(uShort) || lowerCaseArg.startsWith(uLong)) {
                    String user = Command.getActualArgument(currArg, uShort, uLong);
                    if ("".equals(user) && arguments.size() > i + 1) {
                        user = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._userName = user;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    public CommandName getCommandName() {
        return CommandName.CHECKIN;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

