/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;

class Cache {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$Cache == null ? (class$com$tssap$dtr$client$commandline$Cache = Cache.class$("com.tssap.dtr.client.commandline.Cache")) : class$com$tssap$dtr$client$commandline$Cache));
    private IVersionedFileSystemManager _fileSystemManager;
    private IVfsContext _context;
    private IConfiguration _configuration;
    private static final Cache CACHE = new Cache();
    private boolean _initialized = false;
    private String _clientName = "";
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$Cache;

    private Cache() {
    }

    private void initialize(String clientName) {
        this.getConfiguration();
        this._clientName = clientName;
        if (this.getContext() != null) {
            this.getFileSystemManager();
            this._initialized = true;
        }
    }

    public static Cache getCache(String clDef) {
        if (!Cache.CACHE._initialized) {
            CACHE.initialize(clDef);
        }
        return CACHE;
    }

    public static Cache getCache() {
        return CACHE;
    }

    public void refresh(String clientName) {
        boolean reset = false;
        if (!"".equals(clientName)) {
            if (!this._clientName.equals(clientName)) {
                reset = true;
            }
            this._clientName = clientName;
        }
        this._configuration = null;
        if (this._initialized && this._fileSystemManager != null && VersionedFileSystemFactory.hasVersionedFileSystemManager((IVfsContext)this._context)) {
            VersionedFileSystemFactory.releaseVersionedFileSystemManager((IVersionedFileSystemManager)this._fileSystemManager);
        }
        this._context = null;
        this._fileSystemManager = null;
        this._initialized = false;
        this.initialize(this._clientName);
        if (reset) {
            Utilities.setCurrentDirectory("//");
        }
    }

    public IVersionedFileSystemManager getFileSystemManager() {
        if (this._fileSystemManager == null) {
            if (this._context == null) {
                this.getContext();
            }
            if (this._context != null) {
                try {
                    this._fileSystemManager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this._context);
                }
                catch (VfsException exp) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "Could not get filesystem manager.");
                    DTRClient.getOut().println(exp.getMessage());
                    this._fileSystemManager = null;
                }
            }
        }
        return this._fileSystemManager;
    }

    public IVfsContext getContext() {
        if (this._context == null) {
            IClient client;
            if (!"".equals(this._clientName) && (client = this.getConfiguration().getClient(this._clientName)) != null) {
                this._context = client.getContext();
            }
            if (this._context == null) {
                throw new IllegalStateException("The client specified is not correct or there is no active client present");
            }
        }
        return this._context;
    }

    public IConfiguration getConfiguration() {
        if (this._configuration == null) {
            this._configuration = Configuration.getConfiguration();
        }
        return this._configuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

