/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionRecorder;
import com.tssap.dtr.client.lib.vfs.VfsActionStatus;
import com.tssap.dtr.client.lib.vfs.VfsActionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class AddCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$AddCommand == null ? (class$com$tssap$dtr$client$commandline$AddCommand = AddCommand.class$("com.tssap.dtr.client.commandline.AddCommand")) : class$com$tssap$dtr$client$commandline$AddCommand));
    private int _recurseDepth = 0;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$AddCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new AddCommand(arguments);
    }

    AddCommand(ArrayList Arguments) {
        super(Arguments);
        this.addSupportedOption(OptionName.RECURSE);
        this.setArguments(Arguments);
    }

    public String getDescription() {
        return "adds a file/folder to an activity for later checkin";
    }

    public boolean execute() {
        IVfsWorkspace workspace = null;
        IVfsActivity activity = null;
        int i = 0;
        while (i < this._resourcePaths.length) {
            block19: {
                IVfsFolder folder;
                IVfsFile file;
                IVfsFolderItem folderItem;
                block18: {
                    block21: {
                        block22: {
                            block20: {
                                if (this._resourcePaths[i] == null) break block19;
                                folderItem = this.getResource(this._resourcePaths[i]);
                                if (folderItem != null) break block20;
                                Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                                break block19;
                            }
                            file = folderItem.asFile();
                            if (workspace != null) break block21;
                            if (folderItem.asActivityRecordedFolderItem() != null) break block22;
                            this._exitCode = 88;
                            Command.getOut().println("Folder item " + this._resourcePaths[i] + " is not activity recorded");
                            break block19;
                        }
                        workspace = folderItem.asActivityRecordedFolderItem().getWorkspace();
                        if (workspace != null) break block18;
                        this._exitCode = 22;
                        Command.getOut().println("Could not retrive workspace for folder item " + this._resourcePaths[i]);
                        break block19;
                    }
                    try {
                        if (!folderItem.getBrowsePath().startsWith(workspace.getBrowsePath())) {
                            this._exitCode = 23;
                            Command.getOut().println("Folder item " + folderItem.getBrowsePath() + " does not belong to the workspace " + workspace.getBrowsePath());
                        }
                        break block18;
                    }
                    catch (VfsException x) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred. Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                        Command.getOut().println("Could not verify if folder item " + this._resourcePaths[i] + " belongs to the workspace to which other folderitems belong to.");
                    }
                    break block19;
                }
                if (activity == null) {
                    try {
                        activity = this.getOrCreateActivity(workspace);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred. Activity get/create failed.");
                        this._exitCode = 35;
                        Command.getOut().println("Activity get/create failed. " + e.getMessage());
                        return false;
                    }
                }
                if ((folder = folderItem.asFolder()) != null) {
                    AddAction aa = new AddAction(folder, activity, this._recurseDepth);
                    aa.execute();
                    Iterator it = VfsActionRecorder.getRecorder().getActionEntries(VfsActionType.ADD, VfsActionStatus.ERROR_LOG, -1, Long.MIN_VALUE, Long.MAX_VALUE);
                    if (it.hasNext()) {
                        this._exitCode = 82;
                    }
                } else if (file != null) {
                    VfsActionOnFolderItem[] actionsPoss = file.getActionsForCurrentState();
                    if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.CREATE_AND_CHECKOUT)) {
                        try {
                            file.createAndCheckout(activity);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Could not add folder item : " + this._resourcePaths[i]);
                            this._exitCode = 7;
                            Command.getOut().println("Could not add folder item : " + this._resourcePaths[i] + e.getMessage());
                        }
                    } else {
                        String mes = "";
                        if (file.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                        } else if (file.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is in the repository. ";
                        }
                        this._exitCode = 6;
                        Command.getOut().println(mes + "Cannot add file : " + this._resourcePaths[i]);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.ADD, false) + "  [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "] [" + NameConfig.getOption(OptionName.RECURSE, true) + "depth] ] FolderItempath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Adds specified folder items to the workspace", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument.Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the files will be checked out in the given activity. If the activity is not specified then the default activity for the workspace is used. If the specified activity does not exist then it will be created", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name. This is only in case to specify to use an already existing activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "If this option is specified and one of the path(s) is a folder then the items under the folder will be added recursively till the depth specified(number)", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "Usage", false);
        this.printOptionHelp(OptionName.RECURSE, 1, "dtr " + NameConfig.getCommandName(CommandName.ADD, false) + " FolderPath " + NameConfig.getOption(OptionName.RECURSE, true) + "10", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.RECURSE, 1, "There should be no space between the option and the number", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String rShort = NameConfig.getOption(OptionName.RECURSE, true);
            String rLong = NameConfig.getOption(OptionName.RECURSE, false);
            if (currArg != null && ((lowerCaseArg = currArg.toLowerCase()).startsWith(rShort) || lowerCaseArg.startsWith(rLong))) {
                String suffix = Command.getActualArgument(currArg, rShort, rLong);
                try {
                    this._recurseDepth = Integer.parseInt(suffix);
                }
                catch (NumberFormatException exp) {
                    Logger.traceUserError(LOCATION, exp, "Recurse depth not specified properly.");
                    this._recurseDepth = 0;
                }
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    public CommandName getCommandName() {
        return CommandName.ADD;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

