/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import java.util.ArrayList;

class ActivityIntersectionReportCommand
extends PropagationCommand {
    private int _maxLevel = 0;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ActivityIntersectionReportCommand == null ? (class$com$tssap$dtr$client$commandline$ActivityIntersectionReportCommand = ActivityIntersectionReportCommand.class$("com.tssap.dtr.client.commandline.ActivityIntersectionReportCommand")) : class$com$tssap$dtr$client$commandline$ActivityIntersectionReportCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ActivityIntersectionReportCommand;

    public ActivityIntersectionReportCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.MAX_LEVEL);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Gives a list of activities which should be consolidated into given workspace before given activity can be safely consolidated";
    }

    public boolean execute() {
        String[] paths;
        String requestURI;
        IVfsContext activeContext;
        String targetWSURL;
        String sourceWSURL;
        if (this._workspacePaths.length < 2) {
            if (this.getFileSystemManager() == null) {
                Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
                return false;
            }
            String tmpWSPath = this._workspacePaths[0];
            this._workspacePaths = null;
            this._workspacePaths = new String[2];
            this._workspacePaths[0] = Utilities.getCurrentDirectory();
            this._workspacePaths[1] = tmpWSPath;
        }
        boolean pathsAreURLs = false;
        if (this._workspacePaths[0].startsWith("URL:") && this._workspacePaths[1].startsWith("URL:")) {
            pathsAreURLs = true;
            this._workspacePaths[0] = this._workspacePaths[0].substring(4);
            this._workspacePaths[1] = this._workspacePaths[1].substring(4);
        }
        IVfsWorkspace workspace = null;
        IVfsWorkspace targetWorkspace = null;
        if (!pathsAreURLs) {
            workspace = this.getWorkspace();
            if (workspace == null) {
                Command.getOut().println("Could not find source workspace");
                this._exitCode = 30;
                return false;
            }
            try {
                sourceWSURL = workspace.getUrl();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Exception while retrieving source workspace URL.");
                this._exitCode = 56;
                Command.getOut().println("Could not get the predecessors. " + e.getMessage());
                return false;
            }
            IVfsFolderItem folderItem = this.getResource(this._workspacePaths[1]);
            if (folderItem == null) {
                Command.getOut().println("Could not find target workspace");
                this._exitCode = 31;
                return false;
            }
            targetWorkspace = folderItem.asWorkspace();
            if (targetWorkspace == null) {
                Command.getOut().println("Could not find target workspace");
                this._exitCode = 31;
                return false;
            }
            try {
                targetWSURL = targetWorkspace.getUrl();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Exception while retrieving target workspace URL.");
                this._exitCode = 56;
                Command.getOut().println("Could not get the predecessors. " + e.getMessage());
                return false;
            }
        }
        sourceWSURL = this._workspacePaths[0];
        targetWSURL = this._workspacePaths[1];
        sourceWSURL = PathUtilities.assureTrailingSeparator((String)sourceWSURL, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        targetWSURL = PathUtilities.assureTrailingSeparator((String)targetWSURL, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        if (!pathsAreURLs) {
            activeContext = this.getActiveContext();
            IVfsRemoteLocator locator = activeContext.getRemoteLocatorFromUrl(targetWorkspace.getRepository().getUrl());
            if (locator == null) {
                Command.getOut().println("Could not find target workspace");
                this._exitCode = 31;
                return false;
            }
            requestURI = locator.getAbsoluteRemotePath();
        } else {
            activeContext = Command.getContext(this._clientName);
            if (activeContext == null) {
                Command.getOut().println("Client specified is not correct or no active client present.");
                return false;
            }
            if (activeContext.getRemoteLocatorFromUrl(sourceWSURL) == null) {
                Command.getOut().println("Could not find source workspace");
                this._exitCode = 30;
                return false;
            }
            if (activeContext.getRemoteLocatorFromUrl(targetWSURL) == null) {
                Command.getOut().println("Could not find target workspace");
                this._exitCode = 31;
                return false;
            }
            try {
                requestURI = Command.getConnectionTemplate(Command.getConnectionTemplateId(sourceWSURL, this._clientName)).getBasePath();
            }
            catch (InvalidTemplateIDException invalidTemplateID) {
                LogUtil.logException((Location)LOCATION, (Throwable)invalidTemplateID);
                throw new IllegalStateException(invalidTemplateID.getMessage());
            }
            int pingTries = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.pingtries", 2);
            int pingWaitTime = CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.pingwaittime", 2000);
            IClient client = this.getCacheConfiguration().getClient(this._clientName);
            IRepositoryServer server = client.getLogicalSystem().getRepositoryServer(Command.getConnectionTemplateId(sourceWSURL, this._clientName));
            try {
                server.httpPing(pingTries, pingWaitTime);
            }
            catch (ConfigurationException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Unable to ping server.");
                Command.getOut().println("The server " + server.getUrl() + " is unavailable");
                Command.getOut().println("Unable to ping server. " + e.getMessage());
                this._exitCode = 3;
                return false;
            }
        }
        if (requestURI == null) {
            this._exitCode = 56;
            Command.getOut().println("Could not get the predecessors.");
            return false;
        }
        int index = 0;
        String[] actPaths = null;
        int count = this._activityNames.length;
        if (this._activityISNs != null && this._activityISNs.length > 0) {
            int[] isns = ActivityCommand.convertActivityISNsFromStringsToNumbers(this._activityISNs);
            ActivityCommand.ActivityPathIsnPair[] pairs = !pathsAreURLs ? ActivityCommand.executeActISNReport(workspace, isns) : ActivityCommand.executeActISNReport(sourceWSURL, isns, this._clientName);
            actPaths = new String[count += pairs.length];
            int i = 0;
            while (i < pairs.length) {
                if (pairs[i] != null) {
                    actPaths[index++] = pairs[i].activityPath;
                }
                ++i;
            }
        }
        if (actPaths == null) {
            actPaths = new String[count];
        }
        int i = 0;
        while (i < this._activityNames.length) {
            IVfsRemoteLocator locator;
            this._activityName = this._activityNames[i];
            this._displayNameSpecified = false;
            IVfsActivity activity = this.getActivity(true, false);
            if (activity != null && (locator = activeContext.getRemoteLocatorFromUrl(activity.getUrl())) != null) {
                actPaths[index++] = locator.getAbsoluteRemotePath();
            }
            ++i;
        }
        int level = this._maxLevel;
        if (this._maxLevel == 0) {
            level = 1;
        }
        if (!this.initializePropagationManager()) {
            Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
            return false;
        }
        IVfsRemoteLocator sourceLocator = activeContext.getRemoteLocatorFromUrl(sourceWSURL);
        IVfsRemoteLocator targetLocator = activeContext.getRemoteLocatorFromUrl(targetWSURL);
        if (sourceLocator == null || targetLocator == null) {
            this._exitCode = 56;
            Command.getOut().println("Could not get the predecessors. ");
            return false;
        }
        try {
            paths = this._propManager.getPredecessors(sourceLocator.getAbsoluteRemotePath(), targetLocator.getAbsoluteRemotePath(), actPaths, level, false);
        }
        catch (PropagationPreconditionException e) {
            Logger.traceUserError(LOCATION, (Exception)((Object)e), "Could not get predecessors.");
            this._exitCode = 56;
            Command.getOut().println("Could not get the predecessors. " + e.getMessage());
            return false;
        }
        catch (PropagationException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "Could not get predecessors.");
            this._exitCode = 56;
            Command.getOut().println("Could not get the predecessors. " + e.getMessage());
            return false;
        }
        ActivityCommand.ActivityPathIsnPair[] pairs = null;
        if (paths.length > 0) {
            pairs = !pathsAreURLs ? ActivityCommand.executeActISNReport(workspace, paths) : ActivityCommand.executeActISNReport(sourceWSURL, paths, this._clientName);
        }
        if (paths.length > 0 && pairs.length != paths.length) {
            System.err.println("Warning: number of activity paths doesn't match number of ISNs!");
        }
        int noOfItems = pairs == null ? 0 : pairs.length;
        int i2 = 0;
        while (i2 < noOfItems) {
            Command.getOut().println(pairs[i2].isn + " " + Encoder.decodePath((String)pairs[i2].activityPath.substring(pairs[i2].activityPath.lastIndexOf("/act/") + 5)));
            ++i2;
        }
        return true;
    }

    public boolean validateArguments() {
        if (!(this._activityISNs != null && this._activityISNs.length != 0 || this._activityNames != null && this._activityNames.length != 0)) {
            return false;
        }
        return this._workspacePaths != null && this._workspacePaths.length != 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.PREDECESSORS, false) + " " + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName... " + NameConfig.getOption(OptionName.ISN, true) + " isn.. " + NameConfig.getOption(OptionName.WORKSPACE, true) + " SourceWorkspacepath " + NameConfig.getOption(OptionName.WORKSPACE, true) + " TargetWorkspacepath [" + NameConfig.getOption(OptionName.MAX_LEVEL, true) + " max level]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Displays a list of activities which are logical predessesors to the specified activities for a particular workspace but are not present in the target workspace.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name of the activity whose predecessors have to be retrieved", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISN, 1, "ISN of the activity whose predecessors have to be retrieved", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "To specify the workspace where the logical predecessors of the specified activities have to be found (target). The source workspace path also has to be specified. If it is not specified then the current directory will be used to deduce the source", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "NOTE : If both the workspaces are spcified as complete URL's in the format " + NameConfig.getOption(OptionName.WORKSPACE, true) + " URL:http://........ then no " + "calls will be made to VFS and hence better performance " + "can be expected when not used in shell mode.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.MAX_LEVEL, 1, "To specify the level till which the search of predecessors has to be done.[default infinite]", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "As output the command will list all such predecessor activities one in each line. The listing will have the ISN of the activity in the source workspace followed by a space and then the actual name of the activity.", false);
        Command.getOut().println();
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ActivityIntersectionReportCommand(arguments);
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String mlShort = NameConfig.getOption(OptionName.MAX_LEVEL, true);
            String mlLong = NameConfig.getOption(OptionName.MAX_LEVEL, false);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                if (currArg.startsWith(mlShort) || lowerCaseArg.startsWith(mlLong)) {
                    String mLevel = Command.getActualArgument(currArg, mlShort, mlLong);
                    if ("".equals(mLevel) && i + 1 < arguments.size()) {
                        mLevel = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    try {
                        this._maxLevel = Integer.parseInt(mLevel);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "Max level is not correctly entered.");
                        this._maxLevel = 0;
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    public CommandName getCommandName() {
        return CommandName.PREDECESSORS;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

