/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.DTRClient;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.deltavlib.VcmFailure;
import com.tssap.dtr.client.lib.deltavlib.impl.DeltavCommand;
import com.tssap.dtr.client.lib.deltavlib.xcm.XCM;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.requests.xcm.IntegrationReport;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsCollisionType;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IVirtualFile;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

abstract class ActivityCommand
extends Command {
    private static final int TOTALOPTIONS = 7;
    private static final int UNDODISCARDACT = 7;
    private static final int UNDODISCARDCOLL = 6;
    private static final int REVERTMERGEVER = 5;
    private static final int MARKASRESOLVED = 4;
    private static final int MERGEINTERACTIVE = 3;
    private static final int ACCEPTACTVER = 2;
    private static final int ACCEPTCOLLVER = 1;
    private static final int CANCEL = 0;
    private static final String[] _optionStrings = new String[]{"Cancel", "Accept Colliding Version", "Accept Active Version", "Merge Interactive", "Mark As Resolved", "Revert Merge Version", "Undo Discard Colliding Version", "Undo Discard Active Version"};
    boolean _noUI = false;
    protected String _displayName = "";
    protected String _description = "";
    boolean _allowMultipleWSPaths = true;
    boolean _forceCheckin;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ActivityCommand == null ? (class$com$tssap$dtr$client$commandline$ActivityCommand = ActivityCommand.class$("com.tssap.dtr.client.commandline.ActivityCommand")) : class$com$tssap$dtr$client$commandline$ActivityCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ActivityCommand;

    ActivityCommand(ArrayList arguments) {
        super(arguments);
        this._useCurrentActivity = false;
        this.addSupportedOption(OptionName.WORKSPACE);
        this.addSupportedOption(OptionName.SILENT);
        this.addSupportedOption(OptionName.COMMENTS);
        this.addSupportedOption(OptionName.NAME);
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        ArrayList<String> arrWorkspacePaths = new ArrayList<String>();
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String wsShort = NameConfig.getOption(OptionName.WORKSPACE, true);
                String wsLong = NameConfig.getOption(OptionName.WORKSPACE, false);
                String cmtShort = NameConfig.getOption(OptionName.COMMENTS, true);
                String cmtLong = NameConfig.getOption(OptionName.COMMENTS, false);
                String nmShort = NameConfig.getOption(OptionName.NAME, true);
                String nmLong = NameConfig.getOption(OptionName.NAME, false);
                String sntShort = NameConfig.getOption(OptionName.SILENT, true);
                String sntLong = NameConfig.getOption(OptionName.SILENT, false);
                if (lowerCaseArg.startsWith(wsShort) || lowerCaseArg.startsWith(wsLong)) {
                    if (this._allowMultipleWSPaths || arrWorkspacePaths.size() == 0) {
                        String wsName = Command.getActualArgument(currArg, wsShort, wsLong);
                        if ("".equals(wsName) && i + 1 < arguments.size()) {
                            wsName = (String)arguments.get(i + 1);
                            arguments.remove(i + 1);
                        }
                        arguments.remove(i);
                        --indexOfArgs;
                        arrWorkspacePaths.add(wsName);
                    }
                } else if (lowerCaseArg.startsWith(cmtShort) || lowerCaseArg.startsWith(cmtLong)) {
                    String desc = Command.getActualArgument(currArg, cmtShort, cmtLong);
                    if ("".equals(desc) && i + 1 < arguments.size()) {
                        desc = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                    this._description = desc;
                } else if (lowerCaseArg.startsWith(nmShort) || lowerCaseArg.startsWith(nmLong)) {
                    String dName = Command.getActualArgument(currArg, nmShort, nmLong);
                    if ("".equals(dName) && i + 1 < arguments.size()) {
                        dName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                    this._displayName = dName;
                } else if (sntShort.equals(lowerCaseArg) || sntLong.equals(lowerCaseArg)) {
                    this._noUI = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (arrWorkspacePaths.size() > 0) {
            this._workspacePaths = null;
            this._workspacePaths = new String[arrWorkspacePaths.size()];
            arrWorkspacePaths.toArray(this._workspacePaths);
        }
    }

    void performNonUIEdit(IVfsActivity activity, boolean checkIn) {
        this.editActivity(activity);
        if (checkIn) {
            this.checkIn(activity);
        }
    }

    void performUIEdit(IVfsActivity activity, boolean checkIn) {
        StringBuffer initText = new StringBuffer();
        initText.append("DisplayName : ");
        try {
            initText.append(activity.getDisplayName());
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting activity display name.");
            initText.append("<getting display name failed>");
        }
        initText.append("\n");
        initText.append("Description : ");
        try {
            String description = activity.getDescription();
            if (description != null) {
                initText.append(description);
            }
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting activity description.");
            initText.append("<getting description failed>");
        }
        String editToolPath = this.getConfiguration().getSettings().getEditToolPath();
        if (editToolPath == null || "".equals(editToolPath)) {
            DTRClient._callExit = false;
            this.editUsingSwingDialog(activity, checkIn, initText.toString());
        } else {
            this.editUsingEditTool(activity, checkIn, initText.toString(), editToolPath);
        }
    }

    private void checkIn(IVfsActivity activity) {
        IVfsCheckinCollision[] checkinCollisions;
        try {
            Command.getOut().println("Checking In activity....");
            if (this._forceCheckin) {
                checkinCollisions = activity.checkInWithoutUpload();
            } else {
                activity.upload();
                checkinCollisions = activity.checkInWithoutUpload();
            }
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while checking in activity.");
            Command.getOut().println(exp.getMessage());
            Command.getOut().println("Could not check in the activity.");
            this._exitCode = 36;
            return;
        }
        if (checkinCollisions != null && checkinCollisions.length > 0) {
            this._exitCode = 37;
            Command.getOut().println("Could not check in the activity. There are conflicts which have to be resolved.");
            int i = 0;
            while (i < checkinCollisions.length) {
                Command.getOut().println();
                IVfsCheckinCollision checkinCollision = checkinCollisions[i];
                IVfsVersion version = checkinCollision.getValidSourceVersion();
                if (version != null) {
                    IVfsWorkspace workspaceOfActivity = activity.getWorkspace();
                    String remotePath = version.toString(workspaceOfActivity);
                    Command.getOut().println("Folder item " + remotePath + " must be resolved before check in.");
                    Command.getOut().println("Active version is " + remotePath + " @" + version.getBranchSequenceNumber());
                }
                ++i;
            }
            if (checkinCollisions.length > 0 && !this._noUI) {
                Command.getOut().println();
                this.resolveCollisions((IVfsCollision[])checkinCollisions, activity, activity.getWorkspace());
            }
            return;
        }
        try {
            if (VfsActivityState.CLOSED == activity.getState()) {
                Command.getOut().println("Checked In the activity.");
            } else {
                Command.getOut().println("Not sure why check in failed. Please check");
            }
            return;
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting activity state after checkin.");
            Command.getOut().println(exp.getMessage());
            Command.getOut().println("Not sure if checked in the activity. Please check");
            return;
        }
    }

    private void editActivity(IVfsActivity activity) {
        if (!"".equals(this._displayName)) {
            try {
                activity.setDisplayName(this._displayName);
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while setting display name of activity to " + this._displayName);
                Command.getOut().println(exp.getMessage());
                Command.getOut().println("Could not edit the display name.");
            }
        }
        if (!"".equals(this._description)) {
            try {
                activity.setDescription(this._description);
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while setting description of activity to " + this._description);
                Command.getOut().println(exp.getMessage());
                Command.getOut().println("Could not edit the description.");
            }
        }
        Command.getOut().println("Edited the activity.");
    }

    private boolean parseText(String totalText, StringBuffer failedParam) {
        int index = totalText.indexOf("DisplayName");
        if (-1 == index) {
            failedParam.append("Name");
            return false;
        }
        this._displayName = (index = (totalText = totalText.substring(index + 11)).indexOf(":")) != -1 ? totalText.substring(0, index).trim() : "wrong";
        if (!"".equals(this._displayName)) {
            failedParam.append("Name");
            return false;
        }
        if (-1 == (index = (totalText = totalText.substring(index + 1)).indexOf("Description"))) {
            failedParam.append("Description");
            return false;
        }
        this._displayName = totalText.substring(0, index).trim();
        index = (totalText = totalText.substring(totalText.indexOf("Description") + 11)).indexOf(":");
        this._description = index != -1 ? totalText.substring(0, index).trim() : "wrong";
        if (!"".equals(this._description)) {
            failedParam.append("Description");
            return false;
        }
        totalText = totalText.substring(index + 1);
        this._description = totalText.trim();
        return true;
    }

    private void editUsingEditTool(IVfsActivity activity, boolean checkIn, String initText, String editToolPath) {
        File tempFile;
        try {
            tempFile = File.createTempFile("tmp", "ActivitySettings.tmp");
            tempFile.deleteOnExit();
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while creating temp file to take user input for editing activity.");
            Command.getOut().println("Could not create temp file. " + exp.getMessage() + ". Aborting..");
            this._exitCode = 60;
            return;
        }
        boolean done = false;
        String[] args = new String[]{editToolPath, tempFile.getAbsolutePath()};
        String text = "";
        int noOfTries = 0;
        while (!done) {
            FileReader fileReader;
            Process process;
            if (!ActivityCommand.writeToTempFile(tempFile, text = text + initText)) {
                this._exitCode = 61;
                return;
            }
            try {
                process = Runtime.getRuntime().exec(args);
            }
            catch (IOException exp) {
                Logger.traceSystemError(LOCATION, exp, "IOException occurred while starting editor to take user input for editing activity.");
                Command.getOut().println(exp.getMessage());
                Command.getOut().println("Could not start editor. Aborting..");
                this._exitCode = 63;
                return;
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException exp) {
                Logger.traceSystemError(LOCATION, exp, "Editor to take user input for editing activity was interupted.");
            }
            try {
                fileReader = new FileReader(tempFile);
            }
            catch (FileNotFoundException exp) {
                Logger.traceSystemError(LOCATION, exp, "FileNotFoundException occurred while reading temp file containing user input for editing activity.");
                Command.getOut().println("Could not read temp file. File was not found. " + exp.getMessage());
                this._exitCode = 62;
                return;
            }
            int length = (int)tempFile.length();
            char[] input = new char[length];
            try {
                fileReader.read(input);
            }
            catch (IOException exp) {
                Logger.traceSystemError(LOCATION, exp, "IOException occurred while reading temp file containing user input for editing activity.");
                Command.getOut().println("Could not read temp file. " + exp.getMessage());
                this._exitCode = 62;
                return;
            }
            String totalText = new String(input);
            StringBuffer failedParam = new StringBuffer();
            boolean parsed = this.parseText(totalText, failedParam);
            if (!parsed) {
                if (++noOfTries >= 3) {
                    Command.getOut().println("Giving up!! Edit not completed.");
                    this._exitCode = 49;
                    break;
                }
                text = failedParam.substring(0) + " not correctly specified. Please specify correctly \n";
                continue;
            }
            this.performNonUIEdit(activity, checkIn);
            done = true;
        }
        tempFile.delete();
    }

    private static boolean writeToTempFile(File file, String text) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while writing to temp file to get user input for editing activity.");
            Command.getOut().println("Could not write to temp file. " + exp.getMessage());
            return false;
        }
        try {
            while (true) {
                int index;
                if (-1 == (index = text.indexOf(10))) {
                    index = text.length();
                }
                bufferedWriter.write(text.substring(0, index));
                bufferedWriter.newLine();
                if (index == text.length()) break;
                text = text.substring(index + 1);
            }
            bufferedWriter.close();
        }
        catch (IOException exp) {
            Logger.traceSystemError(LOCATION, exp, "IOException occurred while writing to temp file to get user input for editing activity.");
            Command.getOut().println("Could not write to temp file. " + exp.getMessage());
            return false;
        }
        return true;
    }

    private void editUsingSwingDialog(IVfsActivity activity, boolean checkIn, final String initText) {
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setText(initText);
        JScrollPane scrollPane2 = new JScrollPane(editorPane);
        final JDialog dialog = new JDialog();
        ((Component)dialog).setSize(500, 200);
        dialog.getContentPane().add(scrollPane2);
        dialog.setTitle("Activity Settings");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){
            int noOfTimesVisited = 0;

            private void exitIfExceededTries() {
                ++this.noOfTimesVisited;
                if (3 == this.noOfTimesVisited) {
                    Command.getOut().println("Giving up!! Edit not completed.");
                    ActivityCommand.this._exitCode = 49;
                    this.exitNow();
                }
            }

            private void exitNow() {
                dialog.hide();
                dialog.dispose();
            }

            private void failedEdit(String cause, String initializationText) {
                this.exitIfExceededTries();
                String text = cause + " not correctly specified. Please specify correctly \n" + initializationText;
                editorPane.setText(text);
            }

            public void windowOpened(WindowEvent e) {
                dialog.toFront();
                super.windowOpened(e);
            }

            public void windowClosing(WindowEvent we) {
                StringBuffer failedParam;
                ActivityCommand.this._displayName = "";
                ActivityCommand.this._description = "";
                String totalText = editorPane.getText();
                boolean parsed = ActivityCommand.this.parseText(totalText, failedParam = new StringBuffer());
                if (!parsed) {
                    this.failedEdit(failedParam.substring(0), initText);
                    return;
                }
                this.exitNow();
            }
        });
        dialog.setModal(true);
        dialog.show();
        if (this._exitCode != 49) {
            this.performNonUIEdit(activity, checkIn);
        }
    }

    private IVfsActivity getActivityForCollResolution(IVfsWorkspace workspace, BufferedReader bufferedReader) throws VfsException {
        String activityNameOld = this._activityName;
        IVfsActivity activity = null;
        try {
            this._activityName = this.getActivityNameForCollResolution(bufferedReader);
            if ("".equals(this._activityName)) {
                this._activityName = null;
            }
            activity = this.getOrCreateActivity(workspace);
            Object var6_5 = null;
            this._activityName = activityNameOld;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._activityName = activityNameOld;
            throw throwable;
        }
        return activity;
    }

    private String getActivityNameForCollResolution(BufferedReader bufferedReader) {
        String actName = "";
        int noOfTries = 0;
        this._displayNameSpecified = false;
        while ("".equals(actName)) {
            String input;
            Command.getOut().println("Please give the name of the activity to be used for resolution.");
            Command.getOut().println("Format of input:");
            Command.getOut().println("_activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + "]");
            Command.getOut().println();
            Command.getOut().println("specify " + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + " if the name of the activity specified is the display name and not the actualname");
            Command.getOut().println("If activity by this name does not exist it will be created.");
            Command.getOut().println("If activity to be used is default please input \"D\"");
            Command.getOut().println();
            try {
                input = bufferedReader.readLine();
            }
            catch (IOException e) {
                Logger.traceSystemError(LOCATION, e, "IOException occurred while getting user input for activity name.");
                Command.getOut().println("Problem during getting activity name. " + e.getMessage());
                break;
            }
            if ("".equals(input) && noOfTries < 3) {
                Command.getOut().println("Incorrect format. Please specify again.");
                ++noOfTries;
                continue;
            }
            if (!"".equals(input)) {
                if (input.equals("D")) break;
                input.trim();
                int indexOfDN = input.indexOf(NameConfig.getOption(OptionName.DISPLAY_NAME, true));
                if (indexOfDN == -1) {
                    actName = input;
                } else {
                    actName = input.substring(0, indexOfDN - 1);
                    this._displayNameSpecified = true;
                }
                actName.trim();
                break;
            }
            Command.getOut().println("Exceeded tries. Default activity will be used.");
            break;
        }
        return actName;
    }

    static int[] convertActivityISNsFromStringsToNumbers(String[] activityIsns) {
        int[] isns = new int[activityIsns.length];
        int i = 0;
        while (i < activityIsns.length) {
            try {
                isns[i] = Integer.parseInt(activityIsns[i]);
            }
            catch (NumberFormatException e) {
                Logger.traceInternalError(LOCATION, e, "NumberFormatException occurred while parsing the ISN " + activityIsns[i]);
                isns[i] = -1;
            }
            ++i;
        }
        return isns;
    }

    private static IntegrationReport createActivitySequenceNumberReport(IVfsWorkspace workspace) throws VfsException {
        String webLocator = Command.getWebLocator((IVfsFolderItem)workspace);
        IntegrationReport report = new IntegrationReport(workspace.getRepository().getUrl().substring(webLocator.length()), workspace.getUrl().substring(webLocator.length()));
        report.addSelectProperty(XCM.NAMESPACE_PREFIX + ":isn", XCM.NAMESPACE_URI);
        report.addSelectProperty(XCM.NAMESPACE_PREFIX + ":source-vset", XCM.NAMESPACE_URI);
        return report;
    }

    private static IntegrationReport createActivitySequenceNumberReport(String workspaceURL, String clientName) {
        String basePath = null;
        try {
            basePath = Command.getConnectionTemplate(Command.getConnectionTemplateId(workspaceURL, clientName)).getBasePath();
        }
        catch (InvalidTemplateIDException invalidTemplateID) {
            LogUtil.logException((Location)LOCATION, (Throwable)invalidTemplateID);
            throw new IllegalStateException(invalidTemplateID.getMessage());
        }
        String webLocator = Command.getWebLocator(workspaceURL, clientName);
        IntegrationReport report = new IntegrationReport(basePath, workspaceURL.substring(webLocator.length()));
        report.addSelectProperty(XCM.NAMESPACE_PREFIX + ":isn", XCM.NAMESPACE_URI);
        report.addSelectProperty(XCM.NAMESPACE_PREFIX + ":source-vset", XCM.NAMESPACE_URI);
        return report;
    }

    static ActivityPathIsnPair[] executeActISNReport(IVfsWorkspace workspace, String[] activityPaths) {
        IntegrationReport report;
        try {
            report = ActivityCommand.createActivitySequenceNumberReport(workspace);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while creating integration report.");
            return new ActivityPathIsnPair[0];
        }
        report.addActivityQuery(activityPaths);
        return ActivityCommand.extractActivityPathIsnPairs(report, Command.getConnectionTemplateId((IVfsFolderItem)workspace));
    }

    static ActivityPathIsnPair[] executeActISNReport(IVfsWorkspace workspace, long from, long to, Iterator[] resources) {
        IntegrationReport report;
        try {
            report = ActivityCommand.createActivitySequenceNumberReport(workspace);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while creating integration report.");
            return new ActivityPathIsnPair[0];
        }
        if (to != -1L || from != -1L) {
            if (to == -1L && from != -1L) {
                to = Integer.MAX_VALUE;
            }
        } else {
            from = 1L;
            to = Integer.MAX_VALUE;
        }
        report.addSequenceNumberRangeQuery((int)from, (int)to);
        ActivityPathIsnPair[] temp = ActivityCommand.extractActivityPathIsnPairs(report, Command.getConnectionTemplateId((IVfsFolderItem)workspace));
        resources[0] = report.getResources();
        return temp;
    }

    static ActivityPathIsnPair[] executeActISNReport(IVfsWorkspace workspace, int[] isns) {
        IntegrationReport report;
        try {
            report = ActivityCommand.createActivitySequenceNumberReport(workspace);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while creating integration report.");
            return new ActivityPathIsnPair[0];
        }
        report.addSequenceNumberQuery(isns);
        return ActivityCommand.extractActivityPathIsnPairs(report, Command.getConnectionTemplateId((IVfsFolderItem)workspace));
    }

    static ActivityPathIsnPair[] executeActISNReport(String workspaceURL, int[] isns, String clientName) {
        IntegrationReport report = ActivityCommand.createActivitySequenceNumberReport(workspaceURL, clientName);
        report.addSequenceNumberQuery(isns);
        return ActivityCommand.extractActivityPathIsnPairs(report, Command.getConnectionTemplateId(workspaceURL, clientName));
    }

    static ActivityPathIsnPair[] executeActISNReport(String workspaceURL, String[] activityPaths, String clientname) {
        IntegrationReport report = ActivityCommand.createActivitySequenceNumberReport(workspaceURL, clientname);
        report.addActivityQuery(activityPaths);
        return ActivityCommand.extractActivityPathIsnPairs(report, Command.getConnectionTemplateId(workspaceURL, clientname));
    }

    private static ActivityPathIsnPair[] extractActivityPathIsnPairs(IntegrationReport report, int connectionTemplateId) {
        IResponse response = null;
        try {
            response = DeltavCommand.execute((int)connectionTemplateId, (IRequest)report);
        }
        catch (VcmFailure e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VcmFailure occurred while firing integration report.");
            Command.getOut().println(e.getMessage());
        }
        if (response != null && response.isMultiStatus()) {
            Iterator resources = report.getResources();
            ArrayList<ActivityPathIsnPair> activityPairs = new ArrayList<ActivityPathIsnPair>();
            if (resources != null) {
                while (resources.hasNext()) {
                    ResourceElement resourceElement = (ResourceElement)resources.next();
                    try {
                        activityPairs.add(new ActivityPathIsnPair(resourceElement.getChild("source-vset").firstChild().getValue(), Integer.parseInt(resourceElement.getChild("isn").getValue())));
                    }
                    catch (NumberFormatException e) {
                        Logger.traceInternalError(LOCATION, e, "NumberFormatException occurred while reading isn from integration report responce. source-vset : " + resourceElement.getChild("source-vset").firstChild().getValue() + " ISN : " + resourceElement.getChild("isn").getValue());
                        Command.getOut().println("Error when reading isn from integration report responce. source-vset : " + resourceElement.getChild("source-vset").firstChild().getValue() + " ISN : " + resourceElement.getChild("isn").getValue());
                    }
                }
            }
            return activityPairs.toArray(new ActivityPathIsnPair[activityPairs.size()]);
        }
        return new ActivityPathIsnPair[0];
    }

    void resolveCollisions(IVfsCollision[] collisions, IVfsActivity activity, IVfsWorkspace workspace) {
        InputStreamReader inputStreamReader = new InputStreamReader(DTRClient.getIn());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int i = 0;
        while (i < collisions.length) {
            block7: {
                String remotePath;
                IVfsVersion activeVersion;
                IVfsCollision collision;
                block8: {
                    block6: {
                        String inputString = "";
                        Command.getOut().println("Press 'x'/'X' to cancel or any other key to continue with conflict resolution...");
                        try {
                            inputString = bufferedReader.readLine();
                        }
                        catch (IOException e) {
                            Logger.traceSystemError(LOCATION, e, "IOException occurred while getting input from user for collision resolution.");
                            Command.getOut().println("Error occurred on reading input. Continuing to next collision. " + e.getMessage());
                        }
                        if (inputString.equals("x") || inputString.equals("X")) break;
                        Command.getOut().println();
                        collision = collisions[i];
                        if (collision.getAsCheckinCollision() == null) break block6;
                        activeVersion = collision.getValidSourceVersion();
                        if (activeVersion == null) break block7;
                        IVfsWorkspace workspaceOfActivity = activity.getWorkspace();
                        remotePath = activeVersion.toString(workspaceOfActivity);
                        Command.getOut().println("Folder item " + remotePath + " must be resolved before check in.");
                        break block8;
                    }
                    activeVersion = collision.getAsIntegrateCollision().getActiveVersion();
                    IVfsVersion collidingVersion = collision.getAsIntegrateCollision().getCollidingVersion();
                    if (!collision.getAsIntegrateCollision().getCollisionType().equals(VfsCollisionType.NAME_CLASH)) {
                        Command.getOut().println("Conflicting version is " + collidingVersion.getDisplayName() + "@" + collidingVersion.getBranchSequenceNumber());
                    }
                    remotePath = activeVersion.toString(workspace);
                }
                Command.getOut().println("Active version is " + remotePath + "@" + activeVersion.getBranchSequenceNumber());
                IVfsVersion commonAncestorVersion = collision.getCommonAncestor();
                if (commonAncestorVersion != null && collision.getAsCheckinCollision() != null) {
                    Command.getOut().println("Common Ansestor is Version @ " + commonAncestorVersion.getBranchSequenceNumber());
                }
                String mergeToolPath = this.getCacheConfiguration().getSettings().getMergeToolPath();
                boolean mergeToolAvail = false;
                if (mergeToolPath != null && mergeToolPath.length() > 0) {
                    mergeToolAvail = true;
                }
                String[] optionsStr = ActivityCommand.calculateMergeOptions(true, mergeToolAvail, collision);
                int option = ActivityCommand.getMergeOption(optionsStr, bufferedReader);
                this.performMerge(option, collision, activeVersion, commonAncestorVersion, mergeToolPath, bufferedReader, workspace);
            }
            ++i;
        }
    }

    private static String[] calculateMergeOptions(boolean allowInteractive, boolean mergeToolSpecified, IVfsCollision collision) {
        String[] returnArray = new String[7];
        int i = 0;
        while (i < returnArray.length) {
            returnArray[i] = null;
            ++i;
        }
        returnArray[0] = _optionStrings[0];
        if (collision.getAsCheckinCollision() == null) {
            IVfsIntegrateCollision integrateCollision = collision.getAsIntegrateCollision();
            if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN)) {
                if (integrateCollision.getDiscardTargets() == IVfsIntegrateCollision.VfsDiscardTargetVersion.ACTIVE_VERSION) {
                    returnArray[7] = _optionStrings[7];
                } else if (integrateCollision.getDiscardTargets() == IVfsIntegrateCollision.VfsDiscardTargetVersion.COLLIDING_VERSION) {
                    returnArray[6] = _optionStrings[6];
                }
            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT)) {
                if (allowInteractive) {
                    returnArray[1] = _optionStrings[1] + "<Merge version(open version) will be overwritten with the contents from conflicting version. Any changes will be lost>";
                    returnArray[2] = _optionStrings[2] + "<Merge version(open version) will be overwritten with the contents from active version. Any changes will be lost>";
                }
                returnArray[4] = _optionStrings[4];
            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_ARROW_DRAWN)) {
                returnArray[5] = _optionStrings[5];
            } else if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.OPEN)) {
                returnArray[1] = _optionStrings[1];
                returnArray[2] = _optionStrings[2];
                returnArray[3] = _optionStrings[3];
                if (!mergeToolSpecified) {
                    returnArray[3] = returnArray[3] + "<merge tool not specified>";
                }
            }
        } else {
            returnArray[1] = _optionStrings[1];
            if (!allowInteractive) {
                returnArray[1] = returnArray[1] + "<merged version>";
            }
            returnArray[2] = _optionStrings[2];
            if (allowInteractive) {
                returnArray[3] = _optionStrings[3];
                if (!mergeToolSpecified) {
                    returnArray[3] = returnArray[3] + "<merge tool not specified>";
                }
            }
        }
        return returnArray;
    }

    private static int getMergeOption(String[] optionsStr, BufferedReader br) {
        Command.getOut().println();
        Command.getOut().println("Please select one of the options and input the number corresponding to the option");
        Command.getOut().println();
        int optionsAvailable = 0;
        int i = 0;
        while (i < optionsStr.length) {
            if (optionsStr[i] != null) {
                Command.getOut().print("Option : " + optionsAvailable + " ");
                Command.getOut().println(optionsStr[i]);
                ++optionsAvailable;
            }
            ++i;
        }
        int option = 0;
        int tries = 0;
        block5: while (true) {
            try {
                while (true) {
                    boolean illegal = false;
                    String inputLine = br.readLine();
                    if (inputLine == null) {
                        option = 0;
                        break block5;
                    }
                    try {
                        option = Integer.parseInt(inputLine);
                    }
                    catch (NumberFormatException exp) {
                        Logger.traceUserError(LOCATION, exp, "NumberFormatException occurred while parsing the merge option " + inputLine);
                        illegal = true;
                    }
                    if (option > optionsAvailable || option < 0) {
                        illegal = true;
                    }
                    if (!illegal) break block5;
                    if (++tries >= 3) break;
                    Command.getOut().println("Illegal Number Entered.Please enter again.");
                    Command.getOut().println("Select Option : ");
                }
                option = 0;
                Command.getOut().println("Cancelling operation.");
            }
            catch (IOException exp) {
                Logger.traceSystemError(LOCATION, exp, "IOException occurred while getting option for merge.");
                Command.getOut().println(">" + exp.getMessage());
                Command.getOut().println(">IOException Occured");
                continue;
            }
            break;
        }
        int i2 = 0;
        while (i2 < optionsStr.length) {
            if (optionsStr[i2] != null) {
                --option;
            }
            if (option < 0) break;
            ++i2;
        }
        return i2;
    }

    private void performMerge(int option, IVfsCollision collision, IVfsVersion activeVersion, IVfsVersion commonAncestorVersion, String mergeToolPath, BufferedReader bufferedReader, IVfsWorkspace workspace) {
        switch (option) {
            case 0: {
                break;
            }
            case 1: {
                if (collision.getAsCheckinCollision() != null) {
                    try {
                        collision.getAsCheckinCollision().acceptCollidingVersion();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. \"Accept colliding version\" failed");
                        Command.getOut().println("\"Accept colliding version\" failed.");
                        Command.getOut().println(">" + e.getMessage());
                    }
                    break;
                }
                IVfsIntegrateCollision integrateCollision = collision.getAsIntegrateCollision();
                IVfsVersion collidingVersion = integrateCollision.getCollidingVersion();
                this.acceptVersion(collidingVersion, integrateCollision, workspace, bufferedReader);
                break;
            }
            case 2: {
                if (collision.getAsCheckinCollision() != null) {
                    try {
                        collision.getAsCheckinCollision().acceptActiveVersion();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. \"Accept active version\" failed");
                        Command.getOut().println("\"Accept active version\" failed. " + e.getMessage());
                    }
                    break;
                }
                IVfsIntegrateCollision integrateCollision = collision.getAsIntegrateCollision();
                activeVersion = integrateCollision.getActiveVersion();
                this.acceptVersion(activeVersion, integrateCollision, workspace, bufferedReader);
                break;
            }
            case 3: {
                Process process;
                String[] args;
                boolean isIntegrateColl;
                String filePath2 = Command.getTempFileForVer(activeVersion);
                boolean bl = isIntegrateColl = collision.getAsCheckinCollision() == null;
                if (!isIntegrateColl) {
                    args = new String[4];
                    String filePath3 = collision.getAsCheckinCollision().getFolderItemForCollidingVersion().getLocalPath();
                    String filePath1 = Command.getTempFileForVer(commonAncestorVersion);
                    args[0] = mergeToolPath;
                    args[1] = filePath1;
                    args[2] = filePath2;
                    args[3] = filePath3;
                } else {
                    String filePath3;
                    args = new String[3];
                    try {
                        IVfsActivity activity = this.getActivityForCollResolution(workspace, bufferedReader);
                        filePath3 = collision.getAsIntegrateCollision().createMergeVersion(activity, workspace).getLocalFile().getAbsolutePath();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. Creating merge version failed");
                        Command.getOut().println("Could not create merge version. " + e.getMessage());
                        break;
                    }
                    args[0] = mergeToolPath;
                    args[1] = filePath2;
                    args[2] = filePath3;
                }
                try {
                    process = Runtime.getRuntime().exec(args);
                }
                catch (IOException exp) {
                    Logger.traceSystemError(LOCATION, exp, "IOException while starting merge tool " + mergeToolPath);
                    Command.getOut().println(exp.getMessage());
                    Command.getOut().println("Could not start the merge tool. Please check the settings file");
                    break;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException exp) {
                    Logger.traceSystemError(LOCATION, exp, "InterruptedException while running merge tool " + mergeToolPath);
                    Command.getOut().println("Merge tool stopped. " + exp.getMessage());
                }
                String[] optionsStr = ActivityCommand.calculateMergeOptions(false, !"".equals(mergeToolPath), collision);
                option = ActivityCommand.getMergeOption(optionsStr, bufferedReader);
                this.performMerge(option, collision, activeVersion, commonAncestorVersion, mergeToolPath, bufferedReader, workspace);
                break;
            }
            case 4: {
                try {
                    collision.getAsIntegrateCollision().markAsResolved();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. Accepting merged version failed");
                    Command.getOut().println("Error during accepting merged version. " + e.getMessage());
                    break;
                }
                Command.getOut().println("Merged version accepted.");
                break;
            }
            case 5: {
                try {
                    collision.getAsIntegrateCollision().revertMergeVersion();
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. Reverting merge version failed");
                    Command.getOut().println("Error during reverting merged version. " + e.getMessage());
                    break;
                }
                Command.getOut().println("Merged version reverted.");
                break;
            }
            case 6: {
                IVfsIntegrateCollision integrateCollision = collision.getAsIntegrateCollision();
                if (!integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) || integrateCollision.getDiscardTargets() != IVfsIntegrateCollision.VfsDiscardTargetVersion.COLLIDING_VERSION) break;
                Command.getOut().println("Undo discard is currently not supported");
                break;
            }
            case 7: {
                IVfsIntegrateCollision integrateCollision = collision.getAsIntegrateCollision();
                if (!integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) || integrateCollision.getDiscardTargets() != IVfsIntegrateCollision.VfsDiscardTargetVersion.ACTIVE_VERSION) break;
                Command.getOut().println("Undo discard is currently not supported");
            }
        }
    }

    private void acceptVersion(IVfsVersion versionToAccept, IVfsIntegrateCollision integrateCollision, IVfsWorkspace workspace, BufferedReader bufferedReader) {
        IVfsMergeVersion mergeVersion;
        if (integrateCollision.getInternalState().equals(IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.MERGE_VERSION_PRESENT)) {
            mergeVersion = integrateCollision.getMergeVersion();
        } else {
            try {
                IVfsActivity activity = this.getActivityForCollResolution(workspace, bufferedReader);
                mergeVersion = integrateCollision.createMergeVersion(activity, workspace);
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. Creating merge version failed");
                Command.getOut().println("Could not create merge version. " + e.getMessage());
                return;
            }
        }
        IVirtualFile mergeVersionFile = mergeVersion.getLocalFile();
        if (mergeVersionFile.canWrite(true)) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(mergeVersionFile.getAbsolutePath());
                versionToAccept.getContent((OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (FileNotFoundException e) {
                Logger.traceSystemError(LOCATION, e, "FileNotFoundException occurred while setting contents of merge version.");
                Command.getOut().println("Error occured while setting contents of merge version : " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                Logger.traceSystemError(LOCATION, e, "IOException occurred while closing merged file.");
                Command.getOut().println("Error occured while closing merged file : " + e.getLocalizedMessage());
            }
        } else {
            Command.getOut().println("Application cannot write into the merged file");
        }
        try {
            integrateCollision.markAsResolved();
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while merge resolution. Accepting merged version failed");
            Command.getOut().println("Error during accepting merged version. " + e.getMessage());
        }
        Command.getOut().println("Merged version accepted.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ActivityPathIsnPair {
        final String activityPath;
        final int isn;

        ActivityPathIsnPair(String activityPath, int isn) {
            this.activityPath = activityPath;
            this.isn = isn;
        }
    }
}

