/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.DeleteActivityCommand;
import com.tssap.dtr.client.commandline.DescribeActivityCommand;
import com.tssap.dtr.client.commandline.DownloadActCommand;
import com.tssap.dtr.client.commandline.EditActivityCommand;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.UncheckoutActCommand;
import com.tssap.dtr.client.commandline.UploadActCommand;
import java.util.ArrayList;
import java.util.Iterator;

class ActivityCmdsDispatherCommand
extends ActivityCommand {
    private CommandType _commandType;
    private ArrayList _argsToPass;
    private ICommand _command;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ActivityCmdsDispatherCommand(arguments);
    }

    ActivityCmdsDispatherCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.ACT_DELETE);
        this.addSupportedOption(OptionName.ACT_EDIT);
        this.addSupportedOption(OptionName.ACT_UNCO);
        this.addSupportedOption(OptionName.ACT_UPLOAD);
        this.addSupportedOption(OptionName.ACT_DOWNLOAD);
        this._commandType = CommandType.DESCRIBE_ACTIVITY_COMMAND;
        this.setArguments(arguments);
        Iterator it = this._command.getSupportedOptions().iterator();
        while (it.hasNext()) {
            this.addSupportedOption((OptionName)it.next());
        }
    }

    public String getDescription() {
        return "describes/edits/uploads/uncheckouts given activity";
    }

    public boolean execute() {
        if (this._command != null) {
            boolean retVal = this._command.execute();
            this._exitCode = this._command.getExitCode();
            return retVal;
        }
        return false;
    }

    public boolean validateArguments() {
        if (this._command != null) {
            return this._command.validateArguments();
        }
        return false;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.ACTIVITY, false) + " " + NameConfig.getOption(OptionName.ACTIVITY, true) + " _activityName [" + NameConfig.getOption(OptionName.DISPLAY_NAME, true) + " ] " + NameConfig.getOption(OptionName.ISN, true) + " isn [" + NameConfig.getOption(OptionName.WORKSPACE, true) + " workspace] [ " + NameConfig.getOption(OptionName.ACT_UPLOAD, true) + " [" + NameConfig.getOption(OptionName.FORCE, true) + "] " + NameConfig.getOption(OptionName.ACT_DOWNLOAD, true) + " [" + NameConfig.getOption(OptionName.FORCE, true) + "] " + NameConfig.getOption(OptionName.ACT_UNCO, true) + " [" + NameConfig.getOption(OptionName.ACT_UNCO_UNCHANGED_ONLY, true) + "] " + " " + NameConfig.getOption(OptionName.ACT_EDIT, true) + " " + NameConfig.getOption(OptionName.SILENT, true) + " " + NameConfig.getOption(OptionName.ACT_DELETE, true) + " " + NameConfig.getOption(OptionName.COMMENTS, true) + " description " + NameConfig.getOption(OptionName.NAME, true) + " displayname ]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Describes/Edits/Uploads/Uncheckouts an activity", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_EDIT, 1, "Specifies that the activity has to be edited.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_UPLOAD, 1, "Specifies that the files checked out in the activity have to be uploaded.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_DOWNLOAD, 1, "Specifies that the files checked out in the activity have to be downloaded.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_DELETE, 1, "Specifies that the activity has to be deleted. Activity has to be empty.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "In case of options " + NameConfig.getOption(OptionName.ACT_UPLOAD, true) + "/" + NameConfig.getOption(OptionName.ACT_DOWNLOAD, true) + " if specifies that upload/download have to be done even if not required.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_UNCO, 1, "Specifies that the files checked out in the activity have to be reverted.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACT_UNCO_UNCHANGED_ONLY, 1, "In case of option " + NameConfig.getOption(OptionName.ACT_UNCO, true) + " specifies that the files checked out in the activity that have not been changed have to be reverted.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "Name of the activity to be described/edited", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DISPLAY_NAME, 1, "Specified if the name of the activity given is the display name and not the actual name.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ISN, 1, "ISN of the activity can be specified in case where a closed activity has to be described.", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "In case of no option is specified the activity is described", false);
        this.printOptionHelp(null, 1, "In case of an edit the following options can be used", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SILENT, 1, "Will suppress the popup window for changing activity description and display name", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.COMMENTS, 1, "If in non UI mode this will be used to set the description of the activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.NAME, 1, "If in non UI mode this will be used to set the displayname of the activity", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "workspace path to specify the workspace under which the activity exists. To be given if activity name is not specified or the displayname of the activity is specified or the isn of the activity is specified (only describe possible). Will work with the default activity of the workspace if no name is given", true);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the workspace is not specified an attempt will be made to resolve the workspace from the current working directory or the folderitem being worked on. If it is not possible then the user will be notified.", false);
        this.printOptionHelp(null, 1, "NOTE : In case of describing the activity if the workspace is specified as complete URL in the format " + NameConfig.getOption(OptionName.WORKSPACE, true) + " URL:http://........ and the activity " + "ISN is specified then no calls will be made to VFS and hence better " + "performance can be expected when not used in shell mode.", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                String eShort = NameConfig.getOption(OptionName.ACT_EDIT, true);
                String eLong = NameConfig.getOption(OptionName.ACT_EDIT, false);
                String upShort = NameConfig.getOption(OptionName.ACT_UPLOAD, true);
                String upLong = NameConfig.getOption(OptionName.ACT_UPLOAD, false);
                String dnShort = NameConfig.getOption(OptionName.ACT_DOWNLOAD, true);
                String dnLong = NameConfig.getOption(OptionName.ACT_DOWNLOAD, false);
                String delShort = NameConfig.getOption(OptionName.ACT_DELETE, true);
                String delLong = NameConfig.getOption(OptionName.ACT_DELETE, false);
                String unShort = NameConfig.getOption(OptionName.ACT_UNCO, true);
                String unLong = NameConfig.getOption(OptionName.ACT_UNCO, false);
                if (eShort.equals(lowerCaseArg) || eLong.equals(lowerCaseArg)) {
                    this._commandType = CommandType.EDIT_ACTIVITY_COMMAND;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (upShort.equals(currArg) || upLong.equals(lowerCaseArg)) {
                    this._commandType = CommandType.UPLOAD_COMMAND;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (dnShort.equals(currArg) || dnLong.equals(lowerCaseArg)) {
                    this._commandType = CommandType.DOWNLOAD_COMMAND;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (delShort.equals(currArg) || delLong.equals(lowerCaseArg)) {
                    this._commandType = CommandType.DELETE_COMMAND;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (unShort.equals(currArg) || unLong.equals(lowerCaseArg)) {
                    this._commandType = CommandType.UNCHECKOUT_COMMAND;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        this._argsToPass = new ArrayList(arguments);
        arguments.clear();
        this._command = null;
        if (this._commandType == CommandType.DESCRIBE_ACTIVITY_COMMAND) {
            this._command = new DescribeActivityCommand(this._argsToPass);
        } else if (this._commandType == CommandType.EDIT_ACTIVITY_COMMAND) {
            this._command = new EditActivityCommand(this._argsToPass);
        } else if (this._commandType == CommandType.UNCHECKOUT_COMMAND) {
            this._command = new UncheckoutActCommand(this._argsToPass);
        } else if (this._commandType == CommandType.UPLOAD_COMMAND) {
            this._command = new UploadActCommand(this._argsToPass);
        } else if (this._commandType == CommandType.DOWNLOAD_COMMAND) {
            this._command = new DownloadActCommand(this._argsToPass);
        } else if (this._commandType == CommandType.DELETE_COMMAND) {
            this._command = new DeleteActivityCommand(this._argsToPass);
        } else {
            throw new UnsupportedOperationException("Unknown activity command");
        }
    }

    public boolean checkForExtraArgumnets() {
        return this._command.checkForExtraArgumnets();
    }

    public CommandName getCommandName() {
        return CommandName.ACTIVITY;
    }

    private static final class CommandType {
        static final CommandType EDIT_ACTIVITY_COMMAND = new CommandType();
        static final CommandType DESCRIBE_ACTIVITY_COMMAND = new CommandType();
        static final CommandType UPLOAD_COMMAND = new CommandType();
        static final CommandType UNCHECKOUT_COMMAND = new CommandType();
        static final CommandType DOWNLOAD_COMMAND = new CommandType();
        static final CommandType DELETE_COMMAND = new CommandType();

        private CommandType() {
        }
    }
}

